/* Generated by GOB (v2.0.11) on Thu Nov 25 01:42:09 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "mn-imap-mailbox.h"

#include "mn-imap-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 36 "mn-imap-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-util.h"
#ifdef WITH_MIME
#include "mn-message-mime.h"
#endif

#define HAS_CURRENT_TAG(response, priv)	(! strcmp((response)->tag, (priv)->tag))
#define IS(response, token)		(! strcmp((response)->response, (token)))
#define IS_OK(response)			IS(response, "OK")
#define IS_NO(response)			IS(response, "NO")
#define IS_BAD(response)		IS(response, "BAD")
#define IS_BYE(response)		IS(response, "BYE")

#define REMOVED(self)			(g_atomic_int_get(&(self)->_priv->removed))

  enum
  {
    STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
    STATE_CAPABILITY,
#ifdef WITH_SSL
    STATE_STARTTLS,
#endif
#ifdef WITH_SASL
    STATE_AUTHENTICATE,
#endif
    STATE_LOGIN,
    STATE_EXAMINE,
    STATE_SEARCH,
#ifdef WITH_MIME
    STATE_FETCH,
#else /* WITH_MIME */
    STATE_STATUS,
#endif
    STATE_IDLE,
    STATE_LOGOUT
  };
  
  enum
  {
    RESULT_ERROR_LOGOUT		= -1, /* server reported an error, logout normally */
    RESULT_ERROR_END		= -2, /* server reported an error, close the connection */
    RESULT_DEFAULT_HANDLER	= -3  /* invoke the default response handler */
  };

  typedef enum
  {
    IDLE_STATE_NORMAL,
    IDLE_STATE_IDLING,
    IDLE_STATE_WAS_IDLING
  } IdleState;

  struct _MNClientSessionPrivate
  {
    MNMailbox			*mailbox;
    MNAuthenticatedMailbox	*authenticated_mailbox;
    MNIMAPMailbox		*self;
    MNClientSession		*session;

    int				numeric_tag;
    char			tag[5];

    char			**capabilities;
    GSList			*auth_mechanisms;
    gboolean			authenticated;

    gboolean			search_received;
    GSList			*fetch_numbers;
    char			*fetch_set;

#ifdef WITH_MIME
    GSList			*received_numbers;
    GSList			*messages;
#else /* WITH_MIME */
    gboolean			status_received;
#endif

#ifdef WITH_SSL
    gboolean			starttls_completed;
#endif
#ifdef WITH_SASL
    const char			*sasl_mechanism;
#endif

    IdleState			idle_state;
    gboolean			could_idle;	/* could idle at least once */
  };
  
  struct _MNClientSessionResponse
  {
    char		*continuation;
    char		*tag;
    char		*response;
    char		*code;
    char		*arguments;
  };

#line 132 "mn-imap-mailbox.c"
/* self casting macros */
#define SELF(x) MN_IMAP_MAILBOX(x)
#define SELF_CONST(x) MN_IMAP_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_IMAP_MAILBOX(x)
#define TYPE_SELF MN_TYPE_IMAP_MAILBOX
#define SELF_CLASS(x) MN_IMAP_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_IMAP_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNIMAPMailbox Self;
typedef MNIMAPMailboxClass SelfClass;

/* here are local prototypes */
static void mn_imap_mailbox_init (MNIMAPMailbox * o) G_GNUC_UNUSED;
static void mn_imap_mailbox_class_init (MNIMAPMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_imap_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_imap_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static void ___4_mn_imap_mailbox_removed (MNMailbox * mailbox) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static const char * mn_imap_mailbox_sasl_get_username_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static const char * mn_imap_mailbox_sasl_get_password_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_search_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_search_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_status_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_status_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void ___1c_mn_imap_mailbox_impl_check (MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_imap_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_handle_capability_code (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_login) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_check_mail (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static char * mn_imap_mailbox_quote (const char * str) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_imap_mailbox_handle_greeting_cb
#define self_enter_capability_cb mn_imap_mailbox_enter_capability_cb
#define self_handle_capability_cb mn_imap_mailbox_handle_capability_cb
#define self_enter_starttls_cb mn_imap_mailbox_enter_starttls_cb
#define self_handle_starttls_cb mn_imap_mailbox_handle_starttls_cb
#define self_sasl_get_username_cb mn_imap_mailbox_sasl_get_username_cb
#define self_sasl_get_password_cb mn_imap_mailbox_sasl_get_password_cb
#define self_enter_authenticate_cb mn_imap_mailbox_enter_authenticate_cb
#define self_handle_authenticate_cb mn_imap_mailbox_handle_authenticate_cb
#define self_enter_login_cb mn_imap_mailbox_enter_login_cb
#define self_handle_login_cb mn_imap_mailbox_handle_login_cb
#define self_enter_examine_cb mn_imap_mailbox_enter_examine_cb
#define self_handle_examine_cb mn_imap_mailbox_handle_examine_cb
#define self_enter_search_cb mn_imap_mailbox_enter_search_cb
#define self_handle_search_cb mn_imap_mailbox_handle_search_cb
#define self_enter_fetch_cb mn_imap_mailbox_enter_fetch_cb
#define self_handle_fetch_cb mn_imap_mailbox_handle_fetch_cb
#define self_enter_idle_cb mn_imap_mailbox_enter_idle_cb
#define self_handle_idle_cb mn_imap_mailbox_handle_idle_cb
#define self_enter_status_cb mn_imap_mailbox_enter_status_cb
#define self_handle_status_cb mn_imap_mailbox_handle_status_cb
#define self_enter_logout_cb mn_imap_mailbox_enter_logout_cb
#define self_handle_logout_cb mn_imap_mailbox_handle_logout_cb
#define self_notice_cb mn_imap_mailbox_notice_cb
#define self_response_new_cb mn_imap_mailbox_response_new_cb
#define self_response_free_cb mn_imap_mailbox_response_free_cb
#define self_custom_handler_cb mn_imap_mailbox_custom_handler_cb
#define self_pre_read_cb mn_imap_mailbox_pre_read_cb
#define self_post_read_cb mn_imap_mailbox_post_read_cb
#define self_session_set_error_from_arguments mn_imap_mailbox_session_set_error_from_arguments
#define self_session_write mn_imap_mailbox_session_write
#define self_handle_capability_code mn_imap_mailbox_handle_capability_code
#define self_session_parse_capabilities mn_imap_mailbox_session_parse_capabilities
#define self_session_has_capability mn_imap_mailbox_session_has_capability
#define self_session_after_capability mn_imap_mailbox_session_after_capability
#define self_session_authenticate mn_imap_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_imap_mailbox_session_authenticate_fallback
#define self_session_check_mail mn_imap_mailbox_session_check_mail
#define self_quote mn_imap_mailbox_quote
GType
mn_imap_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNIMAPMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_imap_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNIMAPMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_imap_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNIMAPMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNIMAPMailbox *)g_object_new(mn_imap_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNIMAPMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNIMAPMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNIMAPMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNIMAPMailbox *)g_object_new_valist (mn_imap_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::finalize"
	MNIMAPMailbox *self G_GNUC_UNUSED = MN_IMAP_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 148 "mn-imap-mailbox.gob"
	if(self->_priv->idle_session_mutex) { g_mutex_free ((gpointer) self->_priv->idle_session_mutex); self->_priv->idle_session_mutex = NULL; }
#line 289 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_imap_mailbox_init (MNIMAPMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNIMAPMailboxPrivate);
#line 148 "mn-imap-mailbox.gob"
	o->_priv->idle_session_mutex = g_mutex_new();
#line 300 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__
#line 150 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_class_init (MNIMAPMailboxClass * class G_GNUC_UNUSED)
#line 306 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNIMAPMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 155 "mn-imap-mailbox.gob"
	g_object_class->constructor = ___2_mn_imap_mailbox_constructor;
#line 172 "mn-imap-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_imap_mailbox_impl_is;
#line 178 "mn-imap-mailbox.gob"
	mn_mailbox_class->removed = ___4_mn_imap_mailbox_removed;
#line 878 "mn-imap-mailbox.gob"
	mn_mailbox_class->impl_check = ___1c_mn_imap_mailbox_impl_check;
#line 324 "mn-imap-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 151 "mn-imap-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "IMAP";
  
#line 331 "mn-imap-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 155 "mn-imap-mailbox.gob"
static GObject * 
___2_mn_imap_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 341 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::constructor"
{
#line 157 "mn-imap-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);

#ifndef WITH_SSL
    if (MN_URI_IS_SSL(mailbox->uri) || MN_URI_IS_INBAND_SSL(mailbox->uri))
      mn_mailbox_set_init_error(mailbox, _("SSL/TLS support has not been compiled in"));
#endif /* WITH_SSL */

    return object;
  }}
#line 364 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 172 "mn-imap-mailbox.gob"
static gboolean 
___3_mn_imap_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 371 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::impl_is"
#line 172 "mn-imap-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 172 "mn-imap-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 382 "mn-imap-mailbox.c"
{
#line 174 "mn-imap-mailbox.gob"
	
    return MN_URI_IS_IMAP(uri);
  }}
#line 388 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 178 "mn-imap-mailbox.gob"
static void 
___4_mn_imap_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 395 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::removed"
#line 178 "mn-imap-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 178 "mn-imap-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 405 "mn-imap-mailbox.c"
{
#line 180 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);

    g_atomic_int_inc(&selfp->removed);

    g_mutex_lock(selfp->idle_session_mutex);
    if (selfp->idle_session)
      {
	mn_client_session_write(selfp->idle_session->session, "DONE");
	selfp->idle_session->idle_state = IDLE_STATE_WAS_IDLING;
      }
    g_mutex_unlock(selfp->idle_session_mutex);

    PARENT_HANDLER(mailbox);
  }}
#line 423 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 196 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 430 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_greeting_cb"
#line 196 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 196 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 196 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 439 "mn-imap-mailbox.c"
{
#line 200 "mn-imap-mailbox.gob"
	
    priv->session = session;

    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (! response->tag && IS_OK(response))
      {
	return self_handle_capability_code(priv, response)
	  ? self_session_after_capability(priv)
	  : STATE_CAPABILITY;
      }
    else if (! response->tag && IS(response, "PREAUTH"))
      {
	priv->authenticated = TRUE;
	return self_handle_capability_code(priv, response)
	  ? self_session_after_capability(priv)
	  : STATE_CAPABILITY;
      }
    else if (! response->tag && IS_BYE(response))
      return RESULT_ERROR_END;
    else
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
  }}
#line 465 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 224 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 471 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_capability_cb"
#line 224 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 224 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 478 "mn-imap-mailbox.c"
{
#line 227 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "CAPABILITY");
  }}
#line 484 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 231 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 490 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_cb"
#line 231 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 231 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 231 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 499 "mn-imap-mailbox.c"
{
#line 235 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		return priv->capabilities
		  ? self_session_after_capability(priv)
		  : mn_client_session_error(session, _("server did not send capabilities"));
	      }
	    else if (IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "CAPABILITY"))
      {
	self_session_parse_capabilities(priv, response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }
    
    return RESULT_DEFAULT_HANDLER;
  }}
#line 529 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 263 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 535 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_starttls_cb"
#line 263 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 263 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 542 "mn-imap-mailbox.c"
{
#line 266 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    return self_session_write(priv, "STARTTLS");
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 552 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 274 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 558 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_starttls_cb"
#line 274 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 274 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 274 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 567 "mn-imap-mailbox.c"
{
#line 278 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->starttls_completed = TRUE;
		return mn_client_session_enable_ssl(session)
		  ? STATE_CAPABILITY
		  : RESULT_ERROR_END;
	      }
	    else if (IS_BAD(response))
	      return self_session_authenticate(priv);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return RESULT_DEFAULT_HANDLER;
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 597 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 306 "mn-imap-mailbox.gob"
static const char * 
mn_imap_mailbox_sasl_get_username_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 603 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::sasl_get_username_cb"
#line 306 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (const char * )0);
#line 306 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (const char * )0);
#line 610 "mn-imap-mailbox.c"
{
#line 309 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    return priv->mailbox->uri->username;
#else
    g_return_val_if_reached(NULL);
#endif /* WITH_SASL */
  }}
#line 620 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 317 "mn-imap-mailbox.gob"
static const char * 
mn_imap_mailbox_sasl_get_password_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 626 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::sasl_get_password_cb"
#line 317 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (const char * )0);
#line 317 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (const char * )0);
#line 633 "mn-imap-mailbox.c"
{
#line 320 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    mn_authenticated_mailbox_fill_password(priv->authenticated_mailbox);
    return priv->authenticated_mailbox->password;
#else
    g_return_val_if_reached(NULL);
#endif /* WITH_SASL */
  }}
#line 644 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 329 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 650 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_authenticate_cb"
#line 329 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 329 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 657 "mn-imap-mailbox.c"
{
#line 332 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    if (mn_client_session_sasl_authentication_start(priv->session,
						    "imap",
						    priv->auth_mechanisms,
						    priv->mailbox->uri->authmech,
						    &priv->sasl_mechanism,
						    FALSE /* [1] */))
      return self_session_write(priv, "AUTHENTICATE %s", priv->sasl_mechanism);
    else
      return priv->authenticated_mailbox->cancelled
	? STATE_LOGOUT
	: self_session_authenticate_fallback(priv, FALSE);

    /*
     * [1] RFC 3501 6.2.2 specifies that the IMAP protocol does not
     * support the initial client response feature of SASL.
     */
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 682 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 355 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 688 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_authenticate_cb"
#line 355 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 355 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 355 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 697 "mn-imap-mailbox.c"
{
#line 359 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (mn_client_session_sasl_authentication_done(session))
		  {
		    priv->authenticated = TRUE;

		    /*
		     * RFC 3501 2.2.2:
		     *
		     * A server MAY include a CAPABILITY response code
		     * in the tagged OK response of a successful
		     * AUTHENTICATE command in order to send
		     * capabilities automatically.  It is unnecessary
		     * for a client to send a separate CAPABILITY
		     * command if it recognizes these automatic
		     * capabilities.  This should only be done if a
		     * security layer was not negotiated by the
		     * AUTHENTICATE command, because the tagged OK
		     * response as part of an AUTHENTICATE command is
		     * not protected by encryption/integrity checking.
		     * [SASL] requires the client to re-issue a
		     * CAPABILITY command in this case.
		     */
		    return self_handle_capability_code(priv, response) && mn_client_session_sasl_get_ssf(session)
		      ? self_session_check_mail(priv)
		      : STATE_CAPABILITY;
		  }
		else
		  return MN_CLIENT_SESSION_RESULT_END;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return priv->authenticated_mailbox->cancelled
		? STATE_LOGOUT
		: self_session_authenticate_fallback(priv, FALSE);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (response->continuation)
      return mn_client_session_sasl_authentication_step(session, response->continuation);
    
    return RESULT_DEFAULT_HANDLER;
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 752 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 412 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 758 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_login_cb"
#line 412 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 412 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 765 "mn-imap-mailbox.c"
{
#line 415 "mn-imap-mailbox.gob"
	
    if (self_session_has_capability(priv, "LOGINDISABLED"))
      {
	mn_client_session_notice(session, _("server advertised LOGINDISABLED, not using LOGIN authentication"));
	mn_client_session_error(session, _("unable to login"));
	return STATE_LOGOUT;
      }
    else
      {
	char *quoted_username;
	char *quoted_password;
	int result;

	mn_authenticated_mailbox_fill_password(priv->authenticated_mailbox);
	if (! priv->authenticated_mailbox->password)
	  return STATE_LOGOUT;

	quoted_username = self_quote(priv->mailbox->uri->username);
	quoted_password = self_quote(priv->authenticated_mailbox->password);
	result = self_session_write(priv, "LOGIN %s %s", quoted_username, quoted_password);
	g_free(quoted_username);
	g_free(quoted_password);

	return result;
      }
  }}
#line 794 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 442 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 800 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_login_cb"
#line 442 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 442 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 442 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 809 "mn-imap-mailbox.c"
{
#line 446 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->authenticated = TRUE;
		return self_handle_capability_code(priv, response)
		  ? self_session_check_mail(priv)
		  : STATE_CAPABILITY;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return self_session_authenticate_fallback(priv, TRUE);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    
    return RESULT_DEFAULT_HANDLER;
  }}
#line 835 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 470 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 841 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_examine_cb"
#line 470 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 470 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 848 "mn-imap-mailbox.c"
{
#line 473 "mn-imap-mailbox.gob"
	
    char *quoted_mailbox;
    int result;

    quoted_mailbox = self_quote(priv->mailbox->uri->path);
    result = self_session_write(priv, "EXAMINE %s", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
  }}
#line 861 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 484 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 867 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_examine_cb"
#line 484 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 484 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 484 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 876 "mn-imap-mailbox.c"
{
#line 488 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      return STATE_SEARCH;
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 897 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 507 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_search_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 903 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_search_cb"
#line 507 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 507 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 910 "mn-imap-mailbox.c"
{
#line 510 "mn-imap-mailbox.gob"
	
    priv->search_received = FALSE;

    g_slist_free(priv->fetch_numbers);
    priv->fetch_numbers = NULL;

    g_free(priv->fetch_set);
    priv->fetch_set = NULL;
    
    return self_session_write(priv, "SEARCH UNSEEN");
  }}
#line 924 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 522 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_search_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 930 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_search_cb"
#line 522 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 522 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 522 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 939 "mn-imap-mailbox.c"
{
#line 526 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->search_received)
		  {
		    if (priv->fetch_set)
		      {
#ifdef WITH_MIME
			return STATE_FETCH;
#else
			GDK_THREADS_ENTER();
			mn_mailbox_set_has_new(priv->mailbox, TRUE);
			gdk_flush();
			GDK_THREADS_LEAVE();

			/*
			 * We are here and not in STATE_STATUS because
			 * the IDLE capability has already been
			 * tested, so proceed.
			 */
			return STATE_IDLE;
#endif /* WITH_MIME */
		      }
		    else
		      {
			GDK_THREADS_ENTER();
			mn_mailbox_set_has_new(priv->mailbox, FALSE);
#ifdef WITH_MIME
			mn_mailbox_set_messages(priv->mailbox, NULL);
#endif
			gdk_flush();
			GDK_THREADS_LEAVE();

			return self_session_has_capability(priv, "IDLE") && ! mn_uri_has_query(priv->mailbox->uri, "noidle")
			  ? STATE_IDLE
			  : STATE_LOGOUT;
		      }
		  }
		else		/* compliance error */
		  return mn_client_session_error(session, _("server did not send search results"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "SEARCH"))
      {
	if (response->arguments)
	  {
	    char **numbers;
	    GString *string;
	    int i;

	    numbers = g_strsplit(response->arguments, " ", 0);
	    string = g_string_new(NULL);

	    for (i = 0; numbers[i]; i++)
	      if (mn_str_isnumeric(numbers[i]))
		{
		  int n = atoi(numbers[i]);

		  if (*string->str)
		    g_string_append_c(string, ',');
		  g_string_append(string, numbers[i]);

		  priv->fetch_numbers = g_slist_append(priv->fetch_numbers, GINT_TO_POINTER(n));
		}

	    g_strfreev(numbers);
	    priv->fetch_set = g_string_free(string, FALSE);
	  }

	priv->search_received = TRUE;
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 1028 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 613 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1034 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_fetch_cb"
#line 613 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 613 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1041 "mn-imap-mailbox.c"
{
#line 616 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    g_return_val_if_fail(priv->fetch_set != NULL, 0);

    g_slist_free(priv->received_numbers);
    priv->received_numbers = NULL;

    mn_g_object_slist_free(priv->messages);
    priv->messages = NULL;

    return self_session_write(priv, "FETCH %s BODY[HEADER]", priv->fetch_set);
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1059 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 632 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1065 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_fetch_cb"
#line 632 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 632 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 632 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1074 "mn-imap-mailbox.c"
{
#line 636 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		GSList *l;

		MN_LIST_FOREACH(l, priv->fetch_numbers)
		  if (! g_slist_find(priv->received_numbers, l->data))
		    /* compliance error */
		    return mn_client_session_error(session, _("server did not send all the messages we requested"));
		    
		GDK_THREADS_ENTER();
		mn_mailbox_set_has_new(priv->mailbox, priv->messages != NULL);
		mn_mailbox_set_messages(priv->mailbox, priv->messages);
		gdk_flush();
		GDK_THREADS_LEAVE();
		
		return self_session_has_capability(priv, "IDLE") && ! mn_uri_has_query(priv->mailbox->uri, "noidle")
		  ? STATE_IDLE
		  : STATE_LOGOUT;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (mn_str_isnumeric(response->response)
	     && response->arguments
	     && g_str_has_prefix(response->arguments, "FETCH (BODY[HEADER]"))
      {
	int n = atoi(response->response);

	if (g_slist_find(priv->fetch_numbers, GINT_TO_POINTER(n)))
	  {
	    char *p;
	    int len;

	    priv->received_numbers = g_slist_append(priv->received_numbers, GINT_TO_POINTER(n));

	    /* we assume the header string will be in literal form */

	    p = strrchr(response->arguments, '{');
	    if (p && sscanf(p, "{%d}", &len) == 1 && len >= 0)
	      {
		gconstpointer buf;
		
		buf = mn_client_session_read(session, len);
		if (! buf)
		  return MN_CLIENT_SESSION_RESULT_END;
		
		priv->messages = g_slist_append(priv->messages, mn_message_new_from_buffer(priv->mailbox->uri, buf, len));
		
		/* read end of line (after literal) */
		if (! mn_client_session_read_line(session))
		  return MN_CLIENT_SESSION_RESULT_END;
	      }
	    else
	      priv->messages = g_slist_append(priv->messages, mn_message_new_from_error(priv->mailbox->uri, _("unable to fetch message")));

	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
      }
	
    return RESULT_DEFAULT_HANDLER;
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1152 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 712 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1158 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_idle_cb"
#line 712 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 712 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1165 "mn-imap-mailbox.c"
{
#line 715 "mn-imap-mailbox.gob"
	
    priv->idle_state = IDLE_STATE_NORMAL;
    return REMOVED(priv->self) ? STATE_LOGOUT : self_session_write(priv, "IDLE");
  }}
#line 1172 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 720 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1178 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_idle_cb"
#line 720 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 720 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 720 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1187 "mn-imap-mailbox.c"
{
#line 724 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	if (response->continuation || response->tag)
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;

	priv->idle_state = IDLE_STATE_WAS_IDLING;

	if (IS_BYE(response))
	  return MN_CLIENT_SESSION_RESULT_END; /* we'll reconnect */
	else
	  /* any other response wakes us up */
	  return mn_client_session_write(session, "DONE");
      }
    else
      {
	if (response->continuation)
	  {
	    if (priv->idle_state == IDLE_STATE_WAS_IDLING)
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	    else
	      {
		/* we're now in the idle loop */
		priv->idle_state = IDLE_STATE_IDLING;
		priv->could_idle = TRUE;
		
		GDK_THREADS_ENTER();
		mn_mailbox_set_must_poll(priv->mailbox, FALSE);
		gdk_flush();
		GDK_THREADS_LEAVE();

		return MN_CLIENT_SESSION_RESULT_CONTINUE;
	      }
	  }
	else if (response->tag)
	  {
	    if (HAS_CURRENT_TAG(response, priv))
	      {
		if (IS_OK(response))
		  return REMOVED(priv->self) ? STATE_LOGOUT : STATE_SEARCH;
		else if (IS_NO(response) || IS_BAD(response))
		  /*
		   * The server advertised IDLE but does not actually
		   * support it.
		   *
		   * Although strictly speaking this can be considered
		   * a compliance fault, we'll be tolerant and just
		   * logout without setting an error.
		   */
		  return STATE_LOGOUT;
		else
		  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	      }
	  }
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 1248 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 783 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_status_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1254 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_status_cb"
#line 783 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 783 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1261 "mn-imap-mailbox.c"
{
#line 786 "mn-imap-mailbox.gob"
	
#ifndef WITH_MIME
    char *quoted_mailbox;
    int result;

    quoted_mailbox = self_quote(priv->mailbox->uri->path);
    result = self_session_write(priv, "STATUS %s (UNSEEN)", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1278 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 801 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_status_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1284 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_status_cb"
#line 801 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 801 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 801 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1293 "mn-imap-mailbox.c"
{
#line 805 "mn-imap-mailbox.gob"
	
#ifndef WITH_MIME
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->status_received)
		  return STATE_LOGOUT;
		else		/* compliance error */
		  return mn_client_session_error(session, _("server did not send status"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "STATUS"))
      {
	int count;
	
	if (response->arguments && sscanf(response->arguments, "%*s (UNSEEN %i)", &count) == 1)
	  {
	    priv->status_received = TRUE;
	    
	    GDK_THREADS_ENTER();
	    mn_mailbox_set_has_new(priv->mailbox, count != 0);
	    gdk_flush();
	    GDK_THREADS_LEAVE();
	    
	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    
    return RESULT_DEFAULT_HANDLER;
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1341 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 851 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1347 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_logout_cb"
#line 851 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 851 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1354 "mn-imap-mailbox.c"
{
#line 854 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "LOGOUT");
  }}
#line 1360 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 858 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1366 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_logout_cb"
#line 858 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 858 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 858 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1375 "mn-imap-mailbox.c"
{
#line 862 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag && HAS_CURRENT_TAG(response, priv))
      {
	if (IS_OK(response))
	  return MN_CLIENT_SESSION_RESULT_END;
	else if (IS_BAD(response))
	  return RESULT_ERROR_END;
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    else
      return MN_CLIENT_SESSION_RESULT_CONTINUE;
  }}
#line 1393 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 878 "mn-imap-mailbox.gob"
static void 
___1c_mn_imap_mailbox_impl_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 1399 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::impl_check"
#line 878 "mn-imap-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 878 "mn-imap-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1409 "mn-imap-mailbox.c"
{
#line 880 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,				self_handle_greeting_cb },
      { STATE_CAPABILITY,	self_enter_capability_cb,	self_handle_capability_cb },
#ifdef WITH_SSL
      { STATE_STARTTLS,		self_enter_starttls_cb,		self_handle_starttls_cb },
#endif
#ifdef WITH_SASL
      { STATE_AUTHENTICATE,	self_enter_authenticate_cb,	self_handle_authenticate_cb },
#endif
      { STATE_LOGIN,		self_enter_login_cb,		self_handle_login_cb },
      { STATE_EXAMINE,		self_enter_examine_cb,		self_handle_examine_cb },
      { STATE_SEARCH,		self_enter_search_cb,		self_handle_search_cb },
#ifdef WITH_MIME
      { STATE_FETCH,		self_enter_fetch_cb,		self_handle_fetch_cb },
#else
      { STATE_STATUS,		self_enter_status_cb,		self_handle_status_cb },
#endif
      { STATE_IDLE,		self_enter_idle_cb,		self_handle_idle_cb },
      { STATE_LOGOUT,		self_enter_logout_cb,		self_handle_logout_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_custom_handler_cb,
      self_pre_read_cb,
      self_post_read_cb,
#ifdef WITH_SASL
      self_sasl_get_username_cb,
      self_sasl_get_password_cb,
#endif
    };
    MNClientSessionPrivate priv;
    gboolean status;
    GError *err = NULL;

    PARENT_HANDLER(mailbox);

    do
      {
	memset(&priv, 0, sizeof(priv));
	priv.mailbox = mailbox;
	priv.authenticated_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);
	priv.self = self;
    
	status = mn_client_session_run(states,
				       &callbacks,
#ifdef WITH_SSL
				       MN_URI_IS_SSL(mailbox->uri),
#endif
				       mailbox->uri->hostname,
				       mailbox->uri->port,
				       &priv,
				       &err);
    
	g_strfreev(priv.capabilities);
	eel_g_slist_free_deep(priv.auth_mechanisms);

	g_slist_free(priv.fetch_numbers);
	g_free(priv.fetch_set);

#ifdef WITH_MIME
	g_slist_free(priv.received_numbers);
	mn_g_object_slist_free(priv.messages);
#endif
      }
    while (status && priv.could_idle && ! REMOVED(self));

    GDK_THREADS_ENTER();

    mn_mailbox_set_must_poll(mailbox, TRUE);
    if (! status)
      {
	mn_mailbox_set_error(mailbox, "%s", err->message);
	g_error_free(err);
      }
    mn_mailbox_end_check(mailbox);

    gdk_flush();
    GDK_THREADS_LEAVE();
  }}
#line 1497 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 966 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 1504 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::notice_cb"
#line 966 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 966 "mn-imap-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 966 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1513 "mn-imap-mailbox.c"
{
#line 970 "mn-imap-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", str);
  }}
#line 1519 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 974 "mn-imap-mailbox.gob"
static MNClientSessionResponse * 
mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1525 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_new_cb"
#line 974 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (MNClientSessionResponse * )0);
#line 974 "mn-imap-mailbox.gob"
	g_return_val_if_fail (input != NULL, (MNClientSessionResponse * )0);
#line 974 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (MNClientSessionResponse * )0);
#line 1534 "mn-imap-mailbox.c"
{
#line 978 "mn-imap-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    if (g_str_has_prefix(input, "+ "))
      {
	response = g_new0(MNClientSessionResponse, 1);
	response->continuation = g_strdup(input + 2);
      }
    else
      {
	char **tokens;
	
	tokens = g_strsplit(input, " ", 3);
	if (tokens[0] && tokens[1])
	  {
	    if (tokens[2] && tokens[2][0] == '[')
	      {
		char *code_start;
		char *code_end;
		
		code_start = tokens[2] + 1;
		code_end = strchr(code_start, ']');
		if (code_end)
		  {
		    response = g_new0(MNClientSessionResponse, 1);
		    response->code = g_strndup(code_start, code_end - code_start);
		    response->arguments = code_end[1] ? g_strdup(code_end + 2) : NULL;
		  }
	      }
	    else
	      {
		response = g_new0(MNClientSessionResponse, 1);
		response->arguments = g_strdup(tokens[2]);
	      }
	    
	    if (response)
	      {
		response->tag = ! strcmp(tokens[0], "*") ? NULL : g_strdup(tokens[0]);
		response->response = g_strdup(tokens[1]);
	      }
	  }
	g_strfreev(tokens);
      }
    
    return response;
  }}
#line 1583 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1025 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1589 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_free_cb"
#line 1025 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1025 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1025 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1598 "mn-imap-mailbox.c"
{
#line 1029 "mn-imap-mailbox.gob"
	
    g_free(response->continuation);
    g_free(response->tag);
    g_free(response->response);
    g_free(response->code);
    g_free(response->arguments);
    g_free(response);
  }}
#line 1609 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1038 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv)
#line 1615 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::custom_handler_cb"
#line 1038 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 1038 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 1038 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1624 "mn-imap-mailbox.c"
{
#line 1043 "mn-imap-mailbox.gob"
	
    switch (result)
      {
      case RESULT_ERROR_LOGOUT:
	self_session_set_error_from_arguments(priv, response);
	return STATE_LOGOUT;

      case RESULT_ERROR_END:
	self_session_set_error_from_arguments(priv, response);
	return MN_CLIENT_SESSION_RESULT_END;

      case RESULT_DEFAULT_HANDLER:
	if (! response->tag && IS_BYE(response))
	  return RESULT_ERROR_END;
	else
	  return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	g_return_val_if_reached(0);
      }
  }}
#line 1648 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1065 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1654 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::pre_read_cb"
#line 1065 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1065 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1661 "mn-imap-mailbox.c"
{
#line 1068 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	g_mutex_lock(priv->self->_priv->idle_session_mutex);
	priv->self->_priv->idle_session = priv;
	g_mutex_unlock(priv->self->_priv->idle_session_mutex);
      }
  }}
#line 1672 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1077 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1678 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::post_read_cb"
#line 1077 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1077 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1685 "mn-imap-mailbox.c"
{
#line 1080 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	g_mutex_lock(priv->self->_priv->idle_session_mutex);
	priv->self->_priv->idle_session = NULL;
	g_mutex_unlock(priv->self->_priv->idle_session_mutex);
      }
  }}
#line 1696 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1089 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1702 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_set_error_from_arguments"
#line 1089 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1089 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1709 "mn-imap-mailbox.c"
{
#line 1092 "mn-imap-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, _("unknown server error"));
  }}
#line 1718 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1099 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...)
#line 1724 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_write"
#line 1099 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1099 "mn-imap-mailbox.gob"
	g_return_val_if_fail (format != NULL, (int )0);
#line 1731 "mn-imap-mailbox.c"
{
#line 1103 "mn-imap-mailbox.gob"
	
    va_list args;
    char *command;
    int result;

    va_start(args, format);
    command = g_strdup_vprintf(format, args);
    va_end(args);
    
    if (priv->numeric_tag == 1000)
      priv->numeric_tag = 0;
    sprintf(priv->tag, "a%03i", priv->numeric_tag++);

    result = mn_client_session_write(priv->session, "%s %s", priv->tag, command);
    g_free(command);

    return result;
  }}
#line 1752 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1122 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_handle_capability_code (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1758 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_code"
#line 1122 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (gboolean )0);
#line 1122 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (gboolean )0);
#line 1765 "mn-imap-mailbox.c"
{
#line 1125 "mn-imap-mailbox.gob"
	
    if (response->code)
      {
	if (! strcmp(response->code, "CAPABILITY"))
	  {
	    self_session_parse_capabilities(priv, NULL);
	    return TRUE;
	  }
	else if (g_str_has_prefix(response->code, "CAPABILITY "))
	  {
	    self_session_parse_capabilities(priv, response->code + 11);
	    return TRUE;
	  }
      }

    return FALSE;
  }}
#line 1785 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1143 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities)
#line 1791 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_parse_capabilities"
#line 1143 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1796 "mn-imap-mailbox.c"
{
#line 1146 "mn-imap-mailbox.gob"
	
    g_strfreev(priv->capabilities);
    priv->capabilities = NULL;

    eel_g_slist_free_deep(priv->auth_mechanisms);
    priv->auth_mechanisms = NULL;

    if (capabilities)
      {
	int i;
	
	priv->capabilities = g_strsplit(capabilities, " ", 0);
	
	for (i = 0; priv->capabilities[i]; i++)
	  if (g_str_has_prefix(priv->capabilities[i], "AUTH="))
	    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(priv->capabilities[i] + 5));
      }
    else
      priv->capabilities = g_new0(char *, 1);
  }}
#line 1819 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1167 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability)
#line 1825 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_has_capability"
#line 1167 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (gboolean )0);
#line 1167 "mn-imap-mailbox.gob"
	g_return_val_if_fail (capability != NULL, (gboolean )0);
#line 1832 "mn-imap-mailbox.c"
{
#line 1170 "mn-imap-mailbox.gob"
	
    int i;

    g_return_val_if_fail(priv->capabilities != NULL, FALSE);

    for (i = 0; priv->capabilities[i]; i++)
      if (! strcmp(priv->capabilities[i], capability))
	return TRUE;
    
    return FALSE;
  }}
#line 1846 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1182 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv)
#line 1852 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_after_capability"
#line 1182 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1857 "mn-imap-mailbox.c"
{
#line 1184 "mn-imap-mailbox.gob"
	
    if (priv->authenticated)
      return self_session_check_mail(priv);
    else
      {
#ifdef WITH_SSL
	if (MN_URI_IS_INBAND_SSL(priv->mailbox->uri)
	    && ! MN_URI_IS_SSL(priv->mailbox->uri)
	    && ! priv->starttls_completed)
	  {
	    if (self_session_has_capability(priv, "STARTTLS"))
	      return STATE_STARTTLS;
	    else
	      {
		mn_client_session_error(priv->session, _("server does not support in-band SSL/TLS"));
		return STATE_LOGOUT;
	      }
	  }
#endif /* WITH_SSL */
	return self_session_authenticate(priv);
      }
  }}
#line 1882 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1207 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1888 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate"
#line 1207 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1893 "mn-imap-mailbox.c"
{
#line 1209 "mn-imap-mailbox.gob"
	
    if (priv->mailbox->uri->authmech)
      {
	if (*priv->mailbox->uri->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTHENTICATE;
#else
	    return mn_client_session_error(priv->session, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->mailbox->uri->authmech, "+LOGIN"))
	      return STATE_LOGIN;
	    else
	      return mn_client_session_error(priv->session, _("unknown authentication mechanism \"%s\""), priv->mailbox->uri->authmech);
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->auth_mechanisms)
	  return STATE_AUTHENTICATE;
#endif /* WITH_SASL */
	return STATE_LOGIN;
      }
  }}
#line 1924 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1238 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_login)
#line 1930 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate_fallback"
#line 1238 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1935 "mn-imap-mailbox.c"
{
#line 1241 "mn-imap-mailbox.gob"
	
    if (! priv->mailbox->uri->authmech)
      {
	if (! tried_login)
	  {
	    mn_client_session_notice(priv->session, _("falling back to IMAP LOGIN authentication"));
	    return STATE_LOGIN;
	  }
      }

    if (! priv->mailbox->uri->password)
      {
	mn_authenticated_mailbox_authentication_failed(priv->authenticated_mailbox);
	return self_session_authenticate(priv);
      }
    else
      return mn_client_session_error(priv->session, _("authentication failed"));
  }}
#line 1956 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1260 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_check_mail (MNClientSessionPrivate * priv)
#line 1962 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_check_mail"
#line 1260 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1967 "mn-imap-mailbox.c"
{
#line 1262 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    return STATE_EXAMINE;
#else
    return self_session_has_capability(priv, "IDLE") && ! mn_uri_has_query(priv->mailbox->uri, "noidle")
      ? STATE_EXAMINE
      : STATE_STATUS;
#endif /* WITH_MIME */
  }}
#line 1979 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_imap_mailbox_quote:
 * @str: the string to quote
 *
 * Quotes a string using RFC 3501 BNF rules.
 *
 * Return value: the quoted string.
 **/
#line 1280 "mn-imap-mailbox.gob"
static char * 
mn_imap_mailbox_quote (const char * str)
#line 1993 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::quote"
#line 1280 "mn-imap-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 1998 "mn-imap-mailbox.c"
{
#line 1282 "mn-imap-mailbox.gob"
	
    GString *quoted;
    int i;

    quoted = g_string_new("\"");
    for (i = 0; str[i]; i++)
      if (str[i] == '"' || str[i] == '\\') /* quoted-specials in BNF */
	g_string_append_printf(quoted, "\\%c", str[i]);
      else
	g_string_append_c(quoted, str[i]);
    g_string_append_c(quoted, '"');

    return g_string_free(quoted, FALSE);
  }}
#line 2015 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
