#! /bin/sh

# file fig2pstex.sh
# This file is part of LyX, the document processor.
# Licence details can be found in the file COPYING.
#
# author Angus Leeming
#
# Full author contact details are available in file CREDITS


# This script converts an XFIG image to something that latex can process
# into high quality PostScript.

# Usage: sh fig2pstex.sh ${input} ${output}
# to generate the pstex_t file ${output}.
# In turn this file will \includegraphics{${output_base}}.
# The necessary ${output_base}.eps is also generated by this script.
#
# Thereafter, you need only '\input{${output}}' in your latex document.

# We expect two args, the names of the input and output files.
test $# -eq 2 || exit 1

# Can we find fig2dev?
type fig2dev > /dev/null || exit 1

input=$1
output=$2

# Fail silently if the file doesn't exist
test -r $input || exit 0

# Strip the extension from ${output}
outbase=`echo ${output} | sed 's/[.][^.]*$//'`

# Generate the EPS file
outeps=${outbase}.eps
fig2dev -Lpstex ${input} ${outeps}

# Generate the PSTEX_T file
fig2dev -Lpstex_t -p${outbase} ${input} ${output}

# The end
