// -*- C++ -*-
/**
 * \file xformsBC.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Allan Rae
 * \author Angus Leeming
 * \author Baruch Even
 *
 * Full author contact details are available in file CREDITS.
 */

#ifndef XFORMSBC_H
#define XFORMSBC_H

#include "forms_fwd.h"

#include "BCView.h"
#include "gettext.h"

namespace lyx {
namespace frontend {

class xformsBC : public GuiBC<FL_OBJECT, FL_OBJECT> {
public:
	///
	xformsBC(ButtonController const &,
		 std::string const & = _("Cancel"), std::string const & = _("Close"));

private:
	/// Updates the button sensitivity (enabled/disabled)
	void setButtonEnabled(FL_OBJECT *, bool enabled) const;

	/// Updates the widget sensitivity (enabled/disabled)
	void setWidgetEnabled(FL_OBJECT *, bool enabled) const;

	/// Set the label on the button
	void setButtonLabel(FL_OBJECT *, std::string const & label) const;
};

} // namespace frontend
} // namespace lyx

#endif // XFORMSBC_H
