// -*- C++ -*-
/**
 * \file FormGraphics.h
 * Copyright 2000-2001 the LyX Team
 * Read the file COPYING
 *
 * \author Baruch Even, baruch.even@writeme.com
 * \author Herbert Voss, voss@lyx.org
 */

#ifndef FORMGRAPHICS_H
#define FORMGRAPHICS_H

#include <boost/smart_ptr.hpp>

#ifdef __GNUG__
#pragma interface
#endif

#include "FormBase.h"
#include "RadioButtonGroup.h"
#include <vector>

class ControlGraphics;
struct FD_form_graphics;
struct FD_form_file;
struct FD_form_lyxview;
struct FD_form_size;
struct FD_form_bbox;
struct FD_form_special;

/** This class provides an XForms implementation of the Graphics Dialog.
 */
class FormGraphics : public FormCB<ControlGraphics, FormDB<FD_form_graphics> > {
public:
	///
	FormGraphics(ControlGraphics &);

private:

	/** Redraw the form (on receipt of a Signal indicating, for example,
	    that the xforms colours have been re-mapped). */
	virtual void redraw();
	/// Set the Params variable for the Controller.
	virtual void apply();
	/// Build the dialog.
	virtual void build();
	/// Update dialog before/whilst showing it.
	virtual void update();
	/// Update the BoundingBox info.
	void updateBB(string const & filename, string const & bb_inset); 
	/// Filter the inputs on callback from xforms
	virtual ButtonPolicy::SMInput input(FL_OBJECT *, long);

	/// Fdesign generated method
	FD_form_graphics * build_graphics();
	///
	FD_form_file * build_file();
	///
	FD_form_lyxview * build_lyxview();
	///
	FD_form_size * build_size();
	///
	FD_form_bbox * build_bbox();
	///
	FD_form_special * build_special();

	/// Real GUI implementation.
	boost::scoped_ptr<FD_form_file> file_;
	///
	boost::scoped_ptr<FD_form_lyxview> lyxview_;
	///
	boost::scoped_ptr<FD_form_size> size_;
	///
	boost::scoped_ptr<FD_form_bbox> bbox_;
	///
	boost::scoped_ptr<FD_form_special> special_;

	/// Store the LaTeX names for the rotation origins.
	std::vector<string> origins_;
};

#endif  // FORMGRAPHICS_H
