// -*- C++ -*-
/* This file is part of
 * ======================================================
 *
 *           LyX, The Document Processor
 *
 *           Copyright 2001 The LyX Team.
 *
 * ======================================================
 *
 * \file ControlLog.h
 * \author John Levon, moz@compsoc.man.ac.uk
 * \author Angus Leeming <a.leeming@ic.ac.uk>
 */

#ifndef CONTROLLOG_H
#define CONTROLLOG_H

#include <utility>

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlDialog_impl.h"
#include "buffer.h" // Buffer::LogType

/**
 * A controller for a read-only text browser.
 */
class ControlLog : public ControlDialogBD {
public:
	///
	ControlLog(LyXView &, Dialogs &);
	///
	std::pair<Buffer::LogType, string> const & logfile()
		{ return logfile_; }

private:
	///
	virtual void apply() {}
	/// set the params before show or update
	virtual void setParams();
	/// clean-up on hide.
	virtual void clearParams();

	std::pair<Buffer::LogType, string> logfile_;
};

#endif // CONTROLLOG_H
