/* This file is part of
* ======================================================
* 
*           LyX, The Document Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*           Copyright (C) 1995-1998 The LyX Team.
*
*======================================================*/

#include <config.h>

#include "autocor.h"
LyXTextParameters* autocorrparameters = NULL;

// 	$Id: autocor.C,v 1.1.1.1 1998/04/20 21:14:45 larsbj Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: autocor.C,v 1.1.1.1 1998/04/20 21:14:45 larsbj Exp $";
#endif /* lint */


// if AutoCorrect returns True, posend contains the new
// cursor position in this paragraph
bool  AutoCorrect(LyXParagraph* par, int &pos, int &posend){
  if (autocorrparameters){
    LyXParagraph* tmppar = autocorrparameters->paragraph;;
    int i;
    // char c; // unused

    while (tmppar){
      i = 0;
      while (i < tmppar->Last()
	     && tmppar != par
	     && pos+i<=posend
	     && !tmppar->IsSeparator(i)
	     && tmppar->GetChar(i) == par->GetChar(pos+i)
	     && (tmppar->GetChar(i) != LYX_META_INSET
		 || (tmppar->GetInset(i)
		     && tmppar->GetInset(i)->IsEqual(par->GetInset(i))))){
	i++;
      }

      // check wether we found it
      if (pos+i > posend && tmppar->IsSeparator(i)) {
	// remove the old stuff from the paragraph
	int a;
	for (a=0; a<i; a++){
	  par->Erase(pos);
	  posend--;
	}
	// insert the new stuff
	posend++;
	i++;
	while (i < tmppar->Last() && tmppar->GetChar(i) != LYX_META_NEWLINE){
	  tmppar->CopyIntoMinibuffer(i);
	  par->InsertFromMinibuffer(posend);
	  posend++;
	  i++;
	}
	posend--;
	return true;
      }
      tmppar = tmppar->next;
    }
    
  }
  return false;
}



