#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include "func.h"

typedef unsigned long int uint32;

int merge(char *filename)
{
	FILE	*fp_split,
			*fp_merged;
	uint32	merged_size,
			split_size;

	int		filenr,
			amount,
			startnr,
			notfound,
			split_pos,
			bytes_read;

	char	*merged_fname = NULL,
			*split_fname = NULL,
			*orig_fname = NULL,
			*missing_fname = NULL,
			*c_bytes = NULL,
			split_sfname[31];

	int failed = 0;

	struct stat buf;

	int len = strlen(filename);

	c_bytes = (char*)malloc(sizeof(char*) * 5000);

	if (filename[strlen(filename)-4] != '.')
	{
		printf("Erroneous filename. Please supply the extension.\n"
			"Must end with .000 or .001\n");
		exit(0);
	}

	switch (filename[strlen(filename)-1])
	{
	case '0':
			startnr = 0;
			break;
	case '1':
			startnr = 1;
			break;
	default:
		printf("Erroneous filename. Please supply the extension.\n"
			"Must end with .000 or .001\n");
		exit(0);
	}

	
	orig_fname = (char*)malloc(sizeof(char) * len-3);
	split_fname = (char*)malloc(sizeof(char) * len+1);

	strncpy(orig_fname,filename,len-4);
	orig_fname[len-4] = '\0';

	merged_fname = (char*)strdup(orig_fname);
	merged_fname = (char*)strip_path(merged_fname);


	amount = 0;
	notfound = 0;
	merged_size = 0;


	for (filenr = startnr; filenr < 1000; filenr++)
	{
		sprintf(split_fname,"%s.%03d",orig_fname,filenr);

		if (stat(split_fname,&buf) == -1)
		{
			if ( filenr == startnr )
			{
				printf("Can't open %s\n",split_fname);
				failed = 1;
				break;
			}
			else
			{
				if ( notfound == 0)
				{
					missing_fname = (char*)strdup(split_fname);
					notfound = 1;
				}
			}
		}
		else
		{
			if (!S_ISREG(buf.st_mode))
			{
				printf("Can't open `%s'\n",split_fname);
				exit(0);
			} else {
				if (notfound)
				{
					printf("Missing file `%s' !\n", missing_fname);
					free(missing_fname);
					failed = 1;
					break;
				}
				merged_size += buf.st_size;
				amount++;
			}
				
		}
	}

	if ( failed == 0 )
	{
		printf("Creating merged file `%s`.\nComplete size: %lu in %d files.\n",
			merged_fname, merged_size, amount);
	
	
		if (stat(merged_fname,&buf) == 0)
		{
			printf("%s already exists! Aborting...\n",merged_fname);
		}
		else
		{
			fp_merged = fopen(merged_fname,"w");
		
		
			for (filenr=startnr; filenr <= amount + (startnr - 1); filenr++)
			{
				if (filenr < 10)
					sprintf(split_fname,"%s.00%d",orig_fname,filenr);
				else if (filenr < 100)
					sprintf(split_fname,"%s.0%d",orig_fname,filenr);
				else if (filenr < 1000)
					sprintf(split_fname,"%s.%d",orig_fname,filenr);
		
				shorten_path(split_fname, split_sfname);
		
				printf("Processing file `%s'...\n",split_sfname);
		
		
				if (stat(split_fname,&buf) == -1)
				{
					perror("Unable to open input file");
					exit(0);
				}
		
				split_size = buf.st_size;
		
				fp_split = fopen(split_fname, "r");
				if (fp_split == NULL)
				{
					perror("Unable to open input file");
					exit(0);
				}
				
				split_pos = 0;
		
				while (split_pos < (int)split_size)
				{
					bytes_read = fread(c_bytes, 1, 4096, fp_split);
					fwrite(c_bytes, 1, bytes_read, fp_merged);
					split_pos += bytes_read;
				}
		
				fclose(fp_split);
		
			}
		
			fclose(fp_merged);
			printf("Done!\n");
		}
	}

	free(missing_fname);
	free(c_bytes);
	free(orig_fname);
	free(split_fname);
	free(merged_fname);

	return 1;
}
