#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "split.h"
#include "merge.h"

void print_help(char *cmd)
{
	printf("LXSplit for Linux and Free-/OpenBSD version %s.\n"			\
			"By Richard Stellingwerff.\n\n"								\
																		\
			"Usage: %s [argument] [file] [splitsize]\n\n"				\
			"Arguments:\n"												\
			"   -s <splitsize>       split into chunks\n"				\
			"   -j <filename>        merge chunks into one big file\n\n"\
																		\
			"splitsize: (preceded by number)\n"												\
			"    M                   specify in Megabytes\n"			\
			"    k                   specify in kilobytes\n"			\
			"    b                   specify in bytes\n\n"				\
																		\
			"Examples: %s -s hugefile.bin 15M  (split files, 15MB each.)\n"\
			"          %s -j hugefile.bin.001  (merge files)\n\n",
			VERSION,cmd,cmd,cmd);

}

int main(int argc, char **argv)
{
	char	*filename,
			*usersize;
	uint32	size;


	if (argc < 3)
	{
		print_help(argv[0]);
		return 1;
	}

	filename = argv[2];
	if (!strcmp(argv[1],"-s"))
	{
		int len;
		char type;

		if (argc < 4 || argc > 4)
		{
			print_help(argv[0]);
			return 1;
		}
		
		len		 = strlen(argv[3]);
		
		if ( len < 2 )
		{
			print_help(argv[0]);
			return 1;
		}

		type	 = argv[3][len-1];
        usersize = (char*)malloc(len+1);
		
		strncpy(usersize, argv[3], len-1);
		usersize[len] = '\0';
		size = atoi(usersize);
		free( usersize );

		if (type == 'M' || type == 'm')
		{
			size *= (1024 * 1024);
		}
		else if (type == 'K' || type == 'k')
        {
               	size *= 1024;
        }
		else if (type == 'B' || type == 'b')
        {
        }
		else
		{
			printf("Please specify the size correctly!\n\n");
			print_help(argv[0]);
			return 1;
		}


		split_files(filename, size);

	}
	else if (!strcmp(argv[1],"-j"))
	{

		if (argc < 3 || argc > 3)
		{
			print_help(argv[0]);
			exit(0);
		}

		merge(filename);
	} else	/* if -merge */
	{
		printf("Whatcha wanna do?\n");
		print_help(argv[0]);
		return 1;
	}

	return 1;
}
