#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

char *strip_path(char *cfilename)
{
	int		lpos,
			i, n;
	char	*filename;


	lpos = 0;
	for (i=0; i < (int)strlen(cfilename); i++)
		if (cfilename[i] == '/')
			lpos = i;

	if (lpos != 0)
		lpos++;

	n = 0;

	filename = (char*)malloc(sizeof(char) * (strlen(cfilename)+1));

	for (i=lpos; i < (int)strlen(cfilename); i++)
	{
		filename[n] = cfilename[i];
		n++;
	}

	filename[n] = '\0';

	strcpy( cfilename, filename );

	free(filename);

	return cfilename;

}

const char *shorten_path( const char *original, char *destination )
{
	int i;
	char *dest = destination;

	int len = strlen( original );

	if ( len < 27 )
	{
		strcpy(destination, original);
		return original;
	}

	for ( i=0; i < 10; i++ )
	{
		*(dest++) = original[i];
	}

	strcpy( dest, "..." );

	dest+=3;

	for ( i = len-17; i < len; i++ )
	{
		*(dest++) = original[i];
	}

	*dest = 0;

	return destination;
}

