/*
 * dnode2.c - Sun node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */


/*
 * Copyright 1997 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode2.c,v 1.12 2000/06/25 17:31:11 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HASVXFS)

# if	defined(HASVXFS_FS_H) && !defined(HASVXFS_VX_INODE)
#undef	fs_bsize
#include <sys/fs/vx_fs.h>
# endif	/* defined(HASVXFS_FS_H) && !defined(HASVXFS_VX_INODE) */

# if	HASVXFS_SOL_H
#include <sys/fs/vx_sol.h>
# endif	/* defined(HSVXFS_SOL_H) */

# if	defined(HASVXFS_SOLARIS_H) && defined(HASVXFS_U64_T)
#include <sys/fs/vx_solaris.h>
# endif	/* defined(HASVXFS_SOLARIS_H) && defined(HASVXFS_U64_T) */

# if	defined(HASVXFS_MACHDEP_H)
#  if	defined(HASVXFS_OFF32_T) && solaris>=70000
#define	off32_t	VXFS_off32_t
#  endif	/* defined(HASVXFS_OFF32_T) && solaris>=70000 */
#include <sys/fs/vx_machdep.h>
# endif	/* defined(HASVXFS_MACHDEP_H) */

# if	defined(HASVXFS_SOLARIS_H)
struct kdm_vnode {			/* dummy for <sys/fs/vx_inode.h> */
    int d1;
};
#undef	fs_bsize
#define	uint16_t	VXFS_uint16_t

#  if	defined(HASVXFS_OFF64_T)
#define	off64_t		VXFS_off64_t
#  endif	/* defined(HASVXFS_OFF64_T) */

# if	defined(HASVXFS_SOLARIS_H) && !defined(HASVXFS_U64_T)
#include <sys/fs/vx_solaris.h>
# endif	/* defined(HASVXFS_SOLARIS_H) && !defined(HASVXFS_U64_T) */

#include <sys/fs/vx_layout.h>
#include <sys/fs/vx_const.h>
#include <sys/fs/vx_mlink.h>
# endif	/* defined(HASVXFS_SOLARIS_H) */

#include <sys/fs/vx_inode.h>


/*
 * read_vxnode() - read Veritas file system inode information
 */

int
read_vxnode(va, v, vfs, dev, ino, nl, sz, vnops)
	KA_T va;			/* containing vnode's address */
	struct vnode *v;		/* containing vnode */
	struct l_vfs *vfs;		/* local vfs structure */
	dev_t *dev;			/* device number receiver */
	unsigned long *ino;		/* inode number receiver */
	long *nl;			/* number of links receiver */
	unsigned long *sz;		/* size receiver */
	KA_T *vnops;			/* table of VxFS v_op values */
{
	struct vnode cv;
	char tbuf[32];

# if	defined(HASVXFS_VX_INODE)
	struct vx_inode vx;
# else	/* !defined(HASVXFS_VX_INODE) */
	struct inode vx;
# endif	/* defined(HASVXFS_VX_INODE) */

/*
 * See if this is vnode is served by fdd_chain_vnops.  If it is, its
 * v_data pointer leads to the "real" vnode.
 */
	if (v->v_data && v->v_op && (VXVOP_FDDCH < VXVOP_NUM)
	&&  vnops[VXVOP_FDDCH] && ((KA_T)v->v_op == vnops[VXVOP_FDDCH]))
	{
	    if (kread((KA_T)v->v_data, (char *)&cv, sizeof(cv))) {
		(void) sprintf(Namech,
		    "node at %s: can't read real vx vnode: %s",
		    print_kptr(va, tbuf),
		    print_kptr((KA_T)v->v_data, (char *)NULL));
		return(1);
	    }

# if	defined(HASNCACHE)
	    Lf->na = (KA_T)v->v_data;
# endif	/* defined(HASNCACHE) */

	    *v = cv;
	    Ntype = vop2ty(v);
	}
/*
 * Read vnode's vx_inode.
 */
	if (!v->v_data || kread((KA_T)v->v_data, (char *)&vx, sizeof(vx))) {
	    (void) sprintf(Namech, "node at %s: can't read vx_inode: %s",
		print_kptr(va, tbuf),
		print_kptr((KA_T)v->v_data, (char *)NULL));
	    return(1);
	}
/*
 * Return device number, inode number, and size.
 */
	if (v->v_type == VCHR || v->v_type == VBLK)
	    *dev = (dev_t)v->v_rdev;
	else if (vfs && vfs->fsname)
	    *dev = (dev_t)vfs->dev;
	else
	    *dev = (dev_t)vx.i_dev;
	*ino = (unsigned long)vx.i_number;
	*sz = (unsigned long)vx.i_size;
/*
 * Return link count.
 */
	*nl = (long)vx.i_nlink;
	return(0);
}
#endif	/* defined(HASVXFS) */
