/* Copyright (C) 2000-2003 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef HAVE_LIBLCONV_H
#  include <liblconv.h>
#endif

#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>

#include "support.h"
#include "lopster.h"
#include "global.h"
#include "hotlist.h"
#include "commands.h"
#include "string_list.h"
#include "wizard.h"
#include "dialog.h"
#include "handler.h"
#include "share2.h"
#include "scheme.h"
#include "server.h"
#include "chat.h"
#include "transfer.h"
#include "search.h"
#include "resume.h"
#include "statistic.h"
#include "userinfo.h"
#include "callbacks.h"
#include "filetips.h"
#include "ping.h"
#include "connection.h"
#include "exec.h"
#include "subscription.h"
#include "browse.h"
#include "utils.h"
#include "sarray.h"

#include "../pixmaps/speedgreen.xpm"
#include "../pixmaps/speedyellow.xpm"
#include "../pixmaps/speedred.xpm"
#include "../pixmaps/speedgray.xpm"
#include "../pixmaps/folder.xpm"
#include "../pixmaps/folder_open.xpm"
#include "../pixmaps/user1.xpm"	//
#include "../pixmaps/user2.xpm"	//
#include "../pixmaps/ignore.xpm"
#include "../pixmaps/enemy.xpm"
#include "../pixmaps/enemy2.xpm"
#include "../pixmaps/friend.xpm"
#include "../pixmaps/d16x16.xpm"
#include "../pixmaps/share_all.xpm"
#include "../pixmaps/share_none.xpm"
#include "../pixmaps/share_part.xpm"
#include "../pixmaps/server_con.xpm"
#include "../pixmaps/close.xpm"

typedef struct {
  gint src_fd;
  gint dest_fd;
  char* src;
} move_t;

const char LineSpeedShort[12][20] = {
  "?",
  "14.4",
  "28.8",
  "33.6",
  "56K",
  "64K",
  "128K",
  "Cable",
  "DSL",
  "T1",
  "T3+",
  "_?_"
};

char Network[N_NUMBER][20] = {
  "Unknown",
  "Opennap",
  "Opennap-ng",
  "SlavaNap",
  "UNUSED",
  "IRC"
};

char *Browser[BROWSER_NO] = {
  "None",
  "Netscape",
  "Mozilla",
  "Lynx",
  "w3m",
  "Opera",
  "Dillo",
  "Galeon",
  "Konqueror"
};

char *UserClass[4] = {
  "User that does not share",
  "Normal user that shares anything",
  "User i am downloading from",
  "Friend always allowed to download"
};

char *NetType[5] = {
  "?",
  "Nap",
  "Gnut",
  "?",
  "IRC"
};

GtkCTree* DownloadTree[4];
GtkWidget* DownloadScroll[4];
GtkWidget* DownloadVbox[4];

const int ModeMask[N_NUMBER] = {
  0x3fffff,   // unknown -> ALL
  0x003fff,   // opennap
  0x203fff,   // opennap-ng
  0x1fffff,   // slavanap
  0x000000,   // unused
  0x000000    // irc
};

const char* CModeNames[CMODE_NUMBER] = 
  {"Mt", "Mg", "Mn", "Ms", "Mp", "Mi", "Mm", "Mr", "Mq", "Ma"};

const char* ModeNames[MODE_NUMBER] = {
  "ERROR", "BAN", "CHANGE", "KILL",
  "LEVEL", "SERVER", "MUZZLE", "PORT",
  "WALLOP", "CLOAK", "FLOOD", "PING",
  "MSG", "WHOIS", "ANNOUNCE", "BROWSE",
  "MOTD", "FRIEND", "CHANNEL", "REGISTER",
  "VAR", "ABUSE"
};

int SocketStatus[S_NUMBER] = {
  S_REQUESTED,
  S_CONNECTING,
  S_INFO,
  S_PART,
  S_FINISHED,
  S_DOWNLOADING,
  S_UPLOADING,
  S_TIMEOUT,
  S_REJECT,
  S_INCOMPLETE,
  S_CANCELED,
  S_WAITING,
  S_FIREWALL,
  S_CONERROR,
  S_QUEUED,
  S_REMOTE,
  S_UNAVAILABLE,
  S_RESUME_ERR,
  S_DELETE,
  S_IO
};

// -2 is none
// -1 is user defined
// >= 0 is pos in string_list

static net_user_t nu;

const GtkTargetEntry lib_list_targets[LIB_LIST_TARGETS] = { 
  {"lib_subscribe_file", GTK_TARGET_SAME_APP, 0},
  {"lib_subscribe_dir", GTK_TARGET_SAME_APP, 1}
};

int ColorTable(int i1, int i2)
{
  static int table[10][10] = {
    {0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
    {10, 11, 12, 13, 14, 15, 0, 1, 1, 1},
    {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
    {1, 4, 3, 5, 2, 6, 10, 15, -3, -3},
    {1, 1, 1, 1, 1, 1, 1, 1, -4, -4},
    {14, 7, 9, 8, 12, 13, 11, 0, 15, 5},
    {-6, -6, -6, -6, -6, -6, -6, -6, -6, -6},
    {-7, -7, -7, -7, -7, -7, -7, -7, -7, -7},
    {-8, -8, -8, -8, -8, -8, -8, -8, -8, -8},
    {-9, -9, -9, -9, -9, -9, -9, -9, -9, -9}
  };
  if (i1 < 0) return 0;			// white
  if (i2 < 0) return 0;			// white
  if (i1 >= 10) return 0;		// white
  if (i2 >= 10) return 0;		// white
  if (table[i1][i2] < 0) return 0;	// white
  else return table[i1][i2];
}

int ColorTable2(int index)
{
  static int table[8] = {
    1, 4, 3, 5, 2, 6, 10, 15
  };

  if (index < 0)
    return 1;			// black
  if (index >= 8)
    return 1;			// black
  return table[index];
};

global_t global;
char tstr[10][512];
char *list[10] = {
  tstr[0], tstr[1],
  tstr[2], tstr[3],
  tstr[4], tstr[5],
  tstr[6], tstr[7],
  tstr[8], tstr[9]
};
char *p_rc_line;

void
detect_line_pixs(int speed, GdkPixmap ** pixmap,
		 GdkBitmap ** bitmap) {
  if (speed > 10 || speed < 1) {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  } else if (speed <= 3) {
    *pixmap = global.pix.sred;
    *bitmap = global.pix.sredb;
  } else if (speed <= 6) {
    *pixmap = global.pix.syellow;
    *bitmap = global.pix.syellowb;
  } else if (speed <= 10) {
    *pixmap = global.pix.sgreen;
    *bitmap = global.pix.sgreenb;
  } else {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  }
}

void
down_speed_pixs(double rate, GdkPixmap ** pixmap, 
		GdkBitmap ** bitmap) {
  if (rate > global.options.down_speed[2]) {
    *pixmap = global.pix.sgreen;
    *bitmap = global.pix.sgreenb;
  } else if (rate > global.options.down_speed[1]) {
    *pixmap = global.pix.syellow;
    *bitmap = global.pix.syellowb;
  } else if (rate > global.options.down_speed[0]) {
    *pixmap = global.pix.sred;
    *bitmap = global.pix.sredb;
  } else if (rate > 0) {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  } else {
    *pixmap = global.pix.dummy;
    *bitmap = global.pix.dummyb;
  }
}

void
up_speed_pixs(double rate, GdkPixmap ** pixmap, 
	      GdkBitmap ** bitmap) {
  if (rate > global.options.up_speed[2]) {
    *pixmap = global.pix.sgreen;
    *bitmap = global.pix.sgreenb;
  } else if (rate > global.options.up_speed[1]) {
    *pixmap = global.pix.syellow;
    *bitmap = global.pix.syellowb;
  } else if (rate > global.options.up_speed[0]) {
    *pixmap = global.pix.sred;
    *bitmap = global.pix.sredb;
  } else if (rate > 0) {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  } else {
    *pixmap = global.pix.dummy;
    *bitmap = global.pix.dummyb;
  }
}


int speed2int(char *linespeed) {
  int i1;

  for (i1 = 0; i1 < 11; i1++) {
    if (!strcmp(linespeed, LineSpeed(i1)))
      return i1;
  }

  return 0;
}

int level2int(char *level) {
  int i1;

  if (level[0] == '\"') {
    level++;
    level[strlen(level) - 1] = 0;
  }
  for (i1 = 0; i1 < 5; i1++) {
    if (!strncasecmp(level, Level(i1), 3))
      return i1;
  }

  return -1;
}

int mime2int(char *mime) {
  int i1;

  if (!mime) return MIME_NONE;
  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!strcmp(mime, MimeNames(i1, 0))) {
      return i1;
    }
  }

  return 0;
}

int status2int(char *status) {
  if (!strcmp("Inactive", status))
    return STATUS_INACTIVE;
  else if (!strcmp("Active", status))
    return STATUS_ACTIVE;
  else if (!strcmp("Active (Remote)", status))
    return STATUS_REMOTE;
  else if (!strcmp("Remote", status))
    return STATUS_REMOTE;
  else if (!strcmp("Cloaked", status))
    return STATUS_CLOAKED;
  else if (!strcmp("Leeched", status))
    return STATUS_LEECHED;
  else if (!strcmp("Muzzled", status))
    return STATUS_MUZZLED;
  else if (!strcmp("Unknown", status))
    return STATUS_UNKNOWN;
  else
    return STATUS_UNKNOWN;
}

int timestamp2int(char* stamp) {
  if (!l_strcasecmp(stamp, "None"))
    return TIME_NONE;
  else if (!l_strcasecmp(stamp, "Hour:Minute"))
    return TIME_HOUR_MIN;
  else if (!l_strcasecmp(stamp, "BeatTime"))
    return TIME_BEATTIME;
  else
    return TIME_HOUR_MIN_SEC;
}

int browser2int(char *browser) {
  int i1;

  for (i1 = 0; i1 < BROWSER_NO; i1++) {
    if (!l_strcasecmp(browser, Browser[i1]))
      return i1;
  }
  return BROWSER_NONE;
}

char *LineSpeed(int no) {
  switch (no) {
  case 0:
    return "unknown";
  case 1:
    return "14.4 kbps";
  case 2:
    return "28.8 kbps";
  case 3:
    return "33.6 kbps";
  case 4:
    return "56 kbps";
  case 5:
    return "64K ISDN";
  case 6:
    return "128K ISDN";
  case 7:
    return "Cable";
  case 8:
    return "DSL";
  case 9:
    return "T1";
  case 10:
    return "T3+";
  default:
    return "_unknown_";
  };
}

int verify_speed(int speed) {
  if (speed < 0) speed = 0;
  else if (speed > 10) speed = 0;

  return speed;
}

char* TimeNames(int no) {
  switch (no) {
  case 0:
    return "Unshared";
  case 1:
    return "Shared";
  case 2:
    return "New";
  default:
    return "All";
  };
}

char *MimeNames(int no, int mode) {
  switch (no) {
  case MIME_MP3:
    return "mp3";
  case MIME_AUDIO:
    return "audio";
  case MIME_VIDEO:
    return "video";
  case MIME_APPLICATION:
    return "application";
  case MIME_IMAGE:
    return "image";
  case MIME_TEXT:
    return "text";
  default:
    if (mode == 0)
      return "default";
    else if (mode == 1)
      return "any";
    else
      return "other";
  };
}

char *UserStatus(int status) {
  switch (status) {
  case STATUS_INACTIVE:
    return "Inactive";
  case STATUS_ACTIVE:
    return "Active";
  case STATUS_REMOTE:
    return "Remote";
  case STATUS_CLOAKED:
    return "Cloaked";
  case STATUS_LEECHED:
    return "Leeched";
  case STATUS_MUZZLED:
    return "Muzzled";
  case STATUS_UNKNOWN:
    return "Unknown";
  default:
    return "Unknown";
  };
}

char* TimeStamp(int id) {
  switch (id) {
  case TIME_NONE:
    return "None";
  case TIME_BEATTIME:
    return "BeatTime";
  case TIME_HOUR_MIN:
    return "Hour:Minute";
  case TIME_HOUR_MIN_SEC:
  default:
    return "Hour:Minute:Second";
  }
  return "??";
}

char *WebBrowser(int browser) {
  if ((browser < 0) || (browser >= BROWSER_NO))
    return Browser[BROWSER_NONE];
  return Browser[browser];
}

char* Level(int level) {
  switch (level) {
  case 0: return "Leech";
  case 1: return "User";
  case 2: return "Moderator";
  case 3: return "Administrator";
  case 4: return "Elite";
  }
  return "?level?";
};

char* LevelShort(int level) {
  switch (level) {
  case 0: return "Leech";
  case 1: return "User";
  case 2: return "Mod";
  case 3: return "Admin";
  case 4: return "Elite";
  }
  return "?level?";
};

int browser_running(int browser) {
  struct stat st;
  char *command = NULL;
  int res = 0;

  switch (browser) {
  case BROWSER_NETSCAPE:
    command = l_strdup_printf("%s/.netscape/lock", g_get_home_dir());
    if (lstat(command, &st) < 0)
      res = 0;
    else
      res = 1;
    break;
  case BROWSER_MOZILLA:
    break;
  case BROWSER_NONE:
  default:
    break;
  }

  if (command) l_free(command);
  return res;
}

char *browser_command(int browser) {
  int exist;
  char *command = NULL;
  char *term = g_getenv("TERM");
  static char *default_term = "xterm";

  if (!term || !(*term))
    term = default_term;

  exist = browser_running(browser);

  switch (browser) {
  case BROWSER_NETSCAPE:
    if (exist)
      command = l_strdup("netscape -remote 'openURL(%s, new-window)'");
    else
      command = l_strdup("netscape \"%s\"");
    break;
  case BROWSER_MOZILLA:
    command = l_strdup("mozilla \"%s\"");
    break;
  case BROWSER_LYNX:
    command = l_strdup_printf("%s -e lynx \"%%s\"", term);
    break;
  case BROWSER_W3M:
    command = l_strdup_printf("%s -e w3m \"%%s\"", term);
    break;
  case BROWSER_OPERA:
    command = l_strdup_printf("opera \"%%s\"");
    break;
  case BROWSER_DILLO:
    command = l_strdup_printf("dillo \"%%s\"");
    break;
  case BROWSER_GALEON:
    command = l_strdup_printf("galeon \"%%s\"");
    break;
  case BROWSER_KONQUEROR:
    command = l_strdup_printf("kfmclient openURL \"%%s\"");
    break;
  case BROWSER_NONE:
  default:
    break;
  }
  return command;
}

void browse_url(char *url) {
  char *command = NULL;
  char *pattern;
  int i;
  gchar *argv[4];
  gint pid;

  pattern = browser_command(global.options.browser);
  if (!pattern) {
    info_dialog("You haven't specified a browser");
    return;
  }

  command = l_strdup_printf(pattern, url);
  l_free(pattern);

  pid = fork();
  if (pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++)
      close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
  if (command) {
    //    printf("[%s]\n", command);
    l_free(command);
  }
}

int version_is_up_to_date(char *version)
{
  char *vers = l_strdup(version);
  char *pos;
  int res;

  if (strchr(VERSION, '-')) {	// local dev version
    if (!strcmp(vers, VERSION))
      res = 1;
    else
      res = 0;
  } else if ((pos = strchr(vers, '-'))) {	// remote dev version
    *pos = 0;
    if (!strcmp(vers, VERSION))
      res = 1;
    else
      res = 0;
  } else {
    if (!strcmp(vers, VERSION))
      res = 1;
    else
      res = 0;
  }

  l_free(vers);
  return res;
}

/*
int version_is_up_to_date2(char* version) {
  int l1 = strlen(version);
  int l2 = strlen(VERSION);

  if (l1 < l2) l2 = l1;
  //  printf("comp %d bytes [%s][%s]\n", l1, version, VERSION);
  if (!strncmp(version, VERSION, l2)) return 1;
  else return 0;
}
*/
int guess_mime(char *suffix) {
  if (!l_strcasecmp(suffix, "mp3"))
    return MIME_MP3;
  else if (!l_strcasecmp(suffix, "wav"))
    return MIME_AUDIO;
  else if (!l_strcasecmp(suffix, "au"))
    return MIME_AUDIO;
  else if (!l_strcasecmp(suffix, "ogg"))
#ifdef HAVE_OGG
    return MIME_MP3;
#else
    return MIME_AUDIO;
#endif
  else if (!l_strcasecmp(suffix, "mpg"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "mpeg"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "avi"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "asf"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "rm"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "ram"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "mov"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "wmf"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "bmp"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "png"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "jpg"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "jpeg"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "gif"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "tiff"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "tif"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "xpm"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "ps"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "txt"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "doc"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "dvi"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "lyx"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "pdf"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "gz"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "iso"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "zip"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "bz2"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "exe"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "dll"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "deb"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "rpm"))
    return MIME_APPLICATION;
  else
    return MIME_NONE;
}

int find_valid_bitrate(int bitrate)
{
  int i1;
  const int BitRate[18] = {
    8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 192, 224,
    256, 320
  };
  for (i1 = 0; i1 < 18; i1++) {
    if (bitrate <= BitRate[i1])
      return BitRate[i1];
  }
  return 32;
}

int get_beats(time_t tim)
{
  double beats;
  long h2;
  struct tm *gtime;

  tim += 3600;
  gtime = gmtime(&tim);

  h2 = (60 * gtime->tm_hour + gtime->tm_min) * 60 + gtime->tm_sec;
  beats = h2 / 86.4;

  return beats;
}

char *current_time(char *stime, int mode)
{
  struct tm *ltime;

  ltime = localtime(&global.current_time);

  switch (mode) {
  case TIME_HOUR_MIN:
    sprintf(stime, "%02d:%02d", ltime->tm_hour, ltime->tm_min);
    break;
  case TIME_BEATTIME:
    sprintf(stime, "%3d", get_beats(global.current_time));
    break;
  case TIME_HOUR_MIN_SEC:
  default:
    sprintf(stime, "%02d:%02d:%02d",
	    ltime->tm_hour, ltime->tm_min, ltime->tm_sec);
    break;
  }

  return stime;
}

char *ntoa(unsigned int ip) {
  struct in_addr a;

  memset(&a, 0, sizeof(a));
  a.s_addr = ip;
  return (inet_ntoa(a));
}

static void write_geometry() {
  char filename[1024];
  FILE *fd;
  GtkCList *clist;
  GtkPaned *paned;
  int i1;
  int x = 0;
  int y = 0;

  sprintf(filename, "%s/geometry", global.options.config_dir);

  if ((fd = fopen(filename, "w")) == NULL) {
    g_warning("could not save geometry");
    return;
  }

  if (global.win->window) {
    gdk_window_get_origin(global.win->window, &x, &y);
    fprintf(fd, "POSITION=%d %d\n", x, y);
  } else {
    g_warning("write_geometry: global.win->window == NULL");
  }

  fprintf(fd, "SIZE=%d %d\n", global.win->allocation.width,
	  global.win->allocation.height);
  fprintf(fd, "DETACHED=%d\n", global.extra_win);

  for (i1 = 0; i1 < G_SIZE; i1++) {
    fprintf(fd, "GEOMETRY=%d,%d,%d,%d,%d\n", i1,
	    global.geometry[i1].x, global.geometry[i1].y,
	    global.geometry[i1].width, global.geometry[i1].height);
  }

  
  clist = GTK_CLIST(DownloadTree[0]);
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD0_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(DownloadTree[1]);
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD1_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(DownloadTree[2]);
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD2_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(DownloadTree[3]);
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD3_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "UPLOAD_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  for (i1 = 0; i1 < 5; i1++) {
    fprintf(fd, "BROWSE_COLUMN=%d,%d,%d\n", i1,
	    global.browse_width[i1], global.browse_show[i1]);
  }
  for (i1 = 0; i1 < 5; i1++) {
    fprintf(fd, "CHANNEL_COLUMN=%d,%d,%d\n", i1,
	    global.channel_width[i1], global.channel_show[i1]);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HOTLIST_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist43"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SAVED_BROWSE_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist36"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "LIB_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "ctree10"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SERVER_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist34"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HISTORY_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  for (i1 = 0; i1 < 3; i1++) {
    fprintf(fd, "ONLINE_COLUMN=%d,%d,%d\n", i1,
	    global.online_width[i1], global.online_show[i1]);
  }
  for (i1 = 0; i1 < 9; i1++) {
    fprintf(fd, "SEARCH_COLUMN=%d,%d,%d\n", i1,
	    global.search_width[i1], global.search_show[i1]);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "ACCESS_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }

  fprintf(fd, "ONLINE_PANED_POS=%d\n", global.channel_paned);
  fprintf(fd, "SERVER_PANED_POS=%d\n", global.server_paned);
  fprintf(fd, "BROWSE_PANED_POS=%d\n", global.browse_paned);

  paned = GTK_PANED(lookup_widget(global.win, "vpaned4"));
  fprintf(fd, "STATISTIC_PANED_POS=%d\n", paned->child1_size);

  paned = GTK_PANED(lookup_widget(global.win, "hpaned4"));
  fprintf(fd, "LIB_PANED_POS=%d\n", paned->child1_size);

  paned = GTK_PANED(lookup_widget(global.win, "hpaned5"));
  fprintf(fd, "HOT_PANED_POS=%d\n", paned->child1_size);

  fclose(fd);
}


void sigpipe_handler(int val) {
  printf("sigpipe: Broken pipe: %d, continuing\n", val);
}

void sigseg_handler(int val) {
  static volatile int cnt = 0;

  cnt++;
  switch (cnt) {
  case 1:
    printf("sigseg: segmentation fault: %d\n", val);
    if (global.status.rc_read)
      printf("sigseg: rc-file was read\n");
    else {
      printf("sigseg: rc-file was *NOT* read\n");
      if (p_rc_line)
        printf("sigseg: last line read: [%s]\n", p_rc_line);
      printf("sigseg: It seems to be an upgrade problem\n");
      printf("sigseg: Please report this problem (this output and a backtrace if you know something about)\n");
      printf("sigseg: Deleting (renaming) the rcfile (%s) should solve the problem\n",
	     global.options.config_file);
    }
    if (global.status.geometry_read)
      printf("sigseg: geometry was read\n");
    else
      printf("sigseg: geometry was *NOT* read\n");
    if (global.status.access_read)
      printf("sigseg: access list was read\n");
    else
      printf("sigseg: access list was *NOT* read\n");
    if (global.status.search_read)
      printf("sigseg: search patterns were read\n");
    else
      printf("sigseg: search patterns were *NOT* read\n");

    printf("sigseg: please report the reason if you know\n");
    printf("--------------------------------------------------\n");
    printf("sigseg: trying to do normal exit\n");
    if (global.status.rc_read) {
      global_exit();
    } else {
      gtk_exit(-1);
    }
    break;
  case 2:
    printf("sigseg: normal exit failed\n");
    if (global.status.geometry_read) {
      printf("sigseg: trying to save geometry\n");
      write_geometry();
      printf("sigseg: geometry saved\n");
    }
    cnt++;
    if (global.status.rc_read) {
      printf("sigseg: trying to save rc-file\n");
      write_rc();
      printf("sigseg: rc-file saved\n");
    }
    cnt++;
    printf("sigseg: trying to log statistic\n");
    statistic_log(&global.statistic);
    printf("sigseg: statistic logged, exiting...\n");
    cnt++;
    gtk_exit(-2);
    break;
  case 3:
    printf("sigseg: saving geometry failed, force exit\n");
    exit(-3);
    break;
  case 4:
    printf("sigseg: saving rc-file failed, force exit\n");
    exit(-4);
    break;
  case 5:
    printf("sigseg: logging statistic failed, force exit\n");
    exit(-5);
    break;
  case 6:
  default:
    printf("sigseg: forcing exit\n");
    exit(-7);
  }
}

void sigchld_handler(int val ATTR_UNUSED) {
  //  printf("sigchld: %d\n", val);
}

void update_reply(char* user, net_t* net, int highlight) {
  GtkWidget *temp;
  char t[1024];

  temp = lookup_widget(global.win, "label2680");

  if (user && net) {
    if (global.user_reply.user) l_free(global.user_reply.user);
    global.user_reply.user = l_strdup(user);
    global.user_reply.net = net;
  }

  if (user)
    sprintf(t, "%s%s%s", user, net?"@":"", net?net->name:"");
  else
    sprintf(t, "<None>");
  gtk_label_set_text(GTK_LABEL(temp), t);
  gtk_widget_set_style(temp, global.styles[STYLE_TAB1+highlight]);

  temp = lookup_widget(global.win, "hbox206");
  gtk_widget_queue_resize(temp);
}

void update_status_line() {
  GtkWidget *temp;
  char t[1024];
  net_t* net = NULL;

  if (global.current_page)
    net = global.current_page->net;

  // user
  if (net) {
    temp = lookup_widget(global.win, "label271");
    gtk_label_set_text(GTK_LABEL(temp), net->user.username);
  }

  // server
  if (NET_CONNECTED(net)) {
    //temp = lookup_widget(global.win, "label271");
    //gtk_label_set_text(GTK_LABEL(temp), server->net->user.username);
    temp = lookup_widget(global.win, "label275");
    gtk_label_set_text(GTK_LABEL(temp), net->name);
    temp = lookup_widget(global.win, "label278");
    network_print_version(t, net);
    gtk_label_set_text(GTK_LABEL(temp), t);
  } else if (global.net_active) {
    temp = lookup_widget(global.win, "label275");
    sprintf(t, "Connected to %d Networks", 
	    g_list_length(global.net_active));
    gtk_label_set_text(GTK_LABEL(temp), t);
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), "???");
  } else {
    temp = lookup_widget(global.win, "label275");
    gtk_label_set_text(GTK_LABEL(temp), "Not connected");
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), "???");
  }
  temp = lookup_widget(global.win, "hbox206");
  gtk_widget_queue_resize(temp);
}

/*
char* strcasestr(char *str, char *sub) {
  char* p;
  char* startn = NULL;
  char* *np = NULL;

  for (p = str; *p; p++) {
    if (np) {
      if (toupper(*p) == toupper(*np)) {
	if (!*++np)
	  return startn;
      } else np = NULL;
    } else if (toupper(*p) == toupper(*sub)) {
      np = sub + 1;
      startn = p;
    }
  }
  
  return NULL;
}
*/

#ifndef HAVE_STRCASESTR
char *strcasestr(char *str, char *sub) {
  int len;
  int max_pos;
  int str_pos;
  int sub_pos;

  if (!str || !sub)
    return NULL;

  len = strlen(sub);
  max_pos = strlen(str) - len;
  str_pos = 0;
  sub_pos = 0;
  while (str_pos <= max_pos) {
    while (toupper(str[str_pos + sub_pos]) == toupper(sub[sub_pos])) {
      sub_pos++;
      if (sub_pos == len)
	return &(str[str_pos]);
    }
    str_pos++;
    sub_pos = 0;
  }

  return NULL;
}
#endif

int idle_function(gpointer data ATTR_UNUSED) {
  //  GtkWidget *temp;

  gtk_timeout_add(1200000, channel_refresh, NULL);
  //  gtk_timeout_add(3600000, user_info_cleanup, NULL);
  global.timer = gtk_timeout_add(1000, global_timer, NULL);

  global.resume_timer =
    gtk_timeout_add(global.options.resume_timeout * 60 * 1000, resume_timer,  NULL);

  net_group_startup_connect();

  if (global.options.check_version == 1)
    latest_version_get(0);

  ban_networks_load();
  if (global.auto_save) 
    global.lib = lib_load_saved(global.auto_save);
  if (!global.lib)
    global.lib = lib_create_new("shared.list");

  return 0;
}

////////////////////////////////////////////////////
// geometry stuff
////////////////////////////////////////////////////

static void geo_error(int cnt, char *line) {
  printf("unparsable line %d in geometry file: [%s]\n", cnt, line);
}

static char *is_clist(char *line) {
  if (!strncasecmp(line, "DOWNLOAD0_COLUMN", 16)) {
    return "ctree4";
  } else if (!strncasecmp(line, "DOWNLOAD1_COLUMN", 16)) {
    return "ctree11";
  } else if (!strncasecmp(line, "DOWNLOAD2_COLUMN", 16)) {
    return "ctree5";
  } else if (!strncasecmp(line, "DOWNLOAD3_COLUMN", 16)) {
    return "ctree12";
  } else if (!strncasecmp(line, "UPLOAD_COLUMN", 13)) {
    return "transfer_up";
  } else if (!strncasecmp(line, "BROWSE_COLUMN", 13)) {
    return (char *) 3;
  } else if (!strncasecmp(line, "SEARCH_COLUMN", 13)) {
    return (char *) 2;
  } else if (!strncasecmp(line, "LIB_COLUMN", 10)) {
    return "clist36";
  } else if (!strncasecmp(line, "CHANNEL_COLUMN", 14)) {
    return (char *) 4;
  } else if (!strncasecmp(line, "SERVER_COLUMN", 13)) {
    return "ctree10";
  } else if (!strncasecmp(line, "HISTORY_COLUMN", 14)) {
    return "clist34";
  } else if (!strncasecmp(line, "HOTLIST_COLUMN", 14)) {
    return "clist16";
  } else if (!strncasecmp(line, "SAVED_BROWSE_COLUMN", 19)) {
    return "clist43";
  } else if (!strncasecmp(line, "ACCESS_COLUMN", 13)) {
    return "ctree3";
  } else if (!strncasecmp(line, "ONLINE_COLUMN", 13)) {
    return (char *) 1;
  } else {
    return NULL;
  }
}

static char *is_paned(char *line) {
  if (!strncasecmp(line, "STATISTIC_PANED_POS", 19)) {
    return "vpaned4";
  } else if (!strncasecmp(line, "LIB_PANED_POS", 13)) {
    return "hpaned4";
  } else if (!strncasecmp(line, "HOT_PANED_POS", 13)) {
    return "hpaned5";
  } else if (!strncasecmp(line, "ONLINE_PANED_POS", 16)) {
    return (char *) 1;
  } else if (!strncasecmp(line, "SERVER_PANED_POS", 16)) {
    return (char *) 2;
  } else if (!strncasecmp(line, "BROWSE_PANED_POS", 16)) {
    return (char *) 3;
  } else {
    return NULL;
  }
}

static void read_geometry() {
  char File[1024];
  FILE *file;
  char line[500];
  char *pos1;
  char *pos2;
  char *pos3;
  int line_cnt;
  GtkCList *clist = NULL;
  int online;
  GtkWidget *temp = NULL;

  strcpy(File, global.options.config_dir);
  strcat(File, "/geometry");

  if ((file = fopen(File, "r")) == NULL) {
    global.status.geometry_read = 1;
    return;
  }

  line_cnt = 0;
  while (mfgets(line, sizeof(line), file)) {
    line_cnt++;
    if ((line[0] == '#') || (line[0] == ' ') || (line[0] == 0)) {
    } else if (!strncasecmp(line, "POSITION", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1 + 1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_widget_set_uposition(global.win, atoi(pos1 + 1), atoi(pos2 + 1));
    } else if (!strncasecmp(line, "SIZE", 4)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1 + 1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_window_set_default_size(GTK_WINDOW(global.win),
				  atoi(pos1 + 1), atoi(pos2 + 1));
    } else if (!strncasecmp(line, "DETACHED", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      global.extra_win = atoi(pos1 + 1);
    } else if (!strncasecmp(line, "GEOMETRY", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strchr(pos1 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].x = atoi(pos2 + 1);
      pos2 = strchr(pos2 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].y = atoi(pos2 + 1);
      pos2 = strchr(pos2 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].width = atoi(pos2 + 1);
      pos2 = strchr(pos2 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].height = atoi(pos2 + 1);
    } else if ((pos1 = is_paned(line)) != NULL) {
      if (pos1 == (char *) 1)
	online = 1;
      else if (pos1 == (char *) 2)
	online = 2;
      else if (pos1 == (char *) 3)
	online = 3;
      else {
	online = 0;
	temp = lookup_widget(global.win, pos1);
      }
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      if (online == 1)
	global.channel_paned = atoi(pos1 + 1);
      else if (online == 2)
	global.server_paned = atoi(pos1 + 1);
      else if (online == 3)
	global.browse_paned = atoi(pos1 + 1);
      else if (temp)
	gtk_paned_set_position(GTK_PANED(temp), atoi(pos1 + 1));
    } else if ((pos1 = is_clist(line)) != NULL) {
      if (pos1 == (char *) 1)
	online = 1;
      else if (pos1 == (char *) 2)
	online = 2;
      else if (pos1 == (char *) 3)
	online = 3;
      else if (pos1 == (char *) 4)
	online = 4;
      else {
	online = 0;
	clist = GTK_CLIST(lookup_widget(global.win, pos1));
      }
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strchr(pos1 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      if (online == 1)
	global.online_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else if (online == 2)
	global.search_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else if (online == 3)
	global.browse_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else if (online == 4)
	global.channel_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else
	gtk_clist_set_column_width(clist, atoi(pos1 + 1), atoi(pos2 + 1));
      pos3 = strchr(pos2 + 1, ',');
      if (pos3) {
	if (online == 1) {
	  global.online_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else if (online == 2) {
	  global.search_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else if (online == 3) {
	  global.browse_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else if (online == 4) {
	  global.channel_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else {
	  gtk_clist_set_column_visibility(clist, atoi(pos1 + 1),
					  atoi(pos3 + 1));
	}
      }
    } else {
      geo_error(line_cnt, line);
    }
  }
  global.status.geometry_read = 1;
  fclose(file);
}

////////////////////////////////////////////////////
// rcfile stuff
////////////////////////////////////////////////////

static void read_rc() {
  FILE *file;
  char *pos1;
  char *pos2;
  char *pos3;
  int section = 0;
  GtkWidget *temp;
  int changes = 1;
  char scheme[1024] = "";
  char rc_line[2048];
  int new_lib = 0;
  int create_rc = 0;

  if ((file = fopen(global.options.config_file, "r")) == NULL) {
    g_warning("could not load rc-file [%s]", global.options.config_file);
    changes = 0;
    create_rc = 1;
    //    on_preferences_activate(NULL, NULL);
  } else {
    p_rc_line = rc_line;
    while (mfgets(rc_line, sizeof(rc_line), file)) {
      if ((rc_line[0] == '#') || (rc_line[0] == ' ') || (rc_line[0] == 0)) {
      } else if (!strncasecmp(rc_line, "Section", 7)) {
	pos1 = strchr(rc_line, '[') + 1;
	pos2 = strrchr(rc_line, ']');
	pos2[0] = 0;
	if (!l_strcasecmp(pos1, "User"))
	  section = 1;
	else if (!l_strcasecmp(pos1, "Path"))
	  section = 2;
	else if (!l_strcasecmp(pos1, "Network"))
	  section = 3;
	else if (!l_strcasecmp(pos1, "Hotlist"))
	  section = 4;
	else if (!l_strcasecmp(pos1, "Chat"))
	  section = 6;
	else if (!l_strcasecmp(pos1, "Buttons"))
	  section = 7;
	else if (!l_strcasecmp(pos1, "Global"))
	  section = 8;
	else if (!l_strcasecmp(pos1, "Library"))
	  section = 9;
	else if (!l_strcasecmp(pos1, "Search"))
	  section = 10;
	else {
	  g_warning("unknown section in rc-file [%s]", pos1);
	}
      } else if (section == 1) {
	if (!strncasecmp(rc_line, "NAME", 4)) {
	  global.username = l_strdup(rc_line + 5);
	} else if (!strncasecmp(rc_line, "PASSWORD", 8)) {
	  global.password = l_strdup(rc_line + 9);
	} else if (!strncasecmp(rc_line, "EMAIL", 5)) {
	  if (global.email) l_free(global.email);
	  global.email = l_strdup(rc_line + 6);
	} else if (!strncasecmp(rc_line, "MODE", 4)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (isdigit((int)(*pos1)))  // backward compatible
	    global.usermode = atoi(pos1);
	} else {
	  g_warning("unknown tag in section USER [%s]", rc_line);
	}
      } else if (section == 2) {
	if (!strncasecmp(rc_line, "DOWNLOAD", 8)) {
	  int i1;
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!isdigit((int) (*pos1))) {	// backward compatible
	    i1 = MIME_MP3;
	    pos2 = pos1;
	  } else {
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    pos2++;
	    i1 = atoi(pos1);
	  }
	  if (global.mimetype[i1].download)
	    l_free(global.mimetype[i1].download);
	  global.mimetype[i1].download = l_strdup(pos2);
	} else if (!strncasecmp(rc_line, "INCOMPLETE", 10)) {
	  global.incomplete_path = l_strdup(&rc_line[11]);
	} else if (!strncasecmp(rc_line, "SUFFIX", 6)) {
	  int i1;
	  suffix_t *suffix;

	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  i1 = atoi(pos1);
	  pos1 = strchr(pos2, ':');
	  *pos1 = 0;
	  pos1++;
	  pos3 = strchr(pos1, ':');
	  
	  suffix = (suffix_t *) l_malloc(sizeof(suffix_t));
	  suffix->suffix = l_strdup(pos2);
	  if (pos3) {
	    *pos3 = 0;
	    pos3++;
	    suffix->as_mp3 = atoi(pos3);
	  }
	  if (i1 == MIME_MP3)
	    suffix->as_mp3 = 1;
	  suffix->application = l_strdup(pos1);

	  global.mimetype[i1].suffixes =
	    g_list_append(global.mimetype[i1].suffixes, suffix);
	} else if (!strncasecmp(rc_line, "SHARED", 6)) {
	  int i1;
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!isdigit((int) (*pos1))) {	// backward compatible
	    i1 = MIME_MP3;
	    pos2 = pos1;
	  } else {
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    pos2++;
	    i1 = atoi(pos1);
	  }
	  //	  lib_add_folder(pos2, 1<<i1);
	  new_lib = 1;
	} else {
	  g_warning("unknown tag in section PATH [%s]", rc_line);
	}
      } else if (section == 3) {
	if (!strncasecmp(rc_line, "LINESPEED", 9)) {
	  sscanf(rc_line + 10, "%d", &(global.linespeed));
	} else if (!strncasecmp(rc_line, "PORT", 4)) {
	  sscanf(rc_line + 5, "%d", &(global.network.port));
	} else if (!strncasecmp(rc_line, "ALLOWEDPORTS", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.allowed_ports = create_allowed_ports(pos1);
	} else if (!strncasecmp(rc_line, "MinSegmentSize", 14)) {
	  sscanf(rc_line + 15, "%d", &(global.limit.min_segment_size));
	} else if (!strncasecmp(rc_line, "MaxSeekAdd", 10)) {
	  sscanf(rc_line + 11, "%d", &(global.limit.max_seek_add));
	} else if (!strncasecmp(rc_line, "DLAbortLimit", 12)) {
	  sscanf(rc_line + 13, "%ld", &(global.limit.download_abort_limit));
	} else if (!strncasecmp(rc_line, "DLAbortNumber", 13)) {
	  sscanf(rc_line + 14, "%d", &(global.limit.download_abort_number));
	} else if (!strncasecmp(rc_line, "MAX_DOWNLOADS", 13)) {
	  sscanf(rc_line + 14, "%d", &(global.limit.max_downloads));
	  if (global.limit.max_downloads < 0)
	    global.limit.max_downloads = 0;
	} else if (!strncasecmp(rc_line, "MAX_UPLOADS", 11)) {
	  sscanf(rc_line + 12, "%d", &(global.limit.max_uploads));
	  if (global.limit.max_uploads < 0)
	    global.limit.max_uploads = 0;
	} else if (!strncasecmp(rc_line, "MAX_LARGE", 9)) {
	  sscanf(rc_line + 10, "%d", &(global.limit.max_large));
	} else if (!strncasecmp(rc_line, "LARGE_SIZE", 10)) {
	  sscanf(rc_line + 11, "%d", &(global.limit.large_size));
	} else if (!strncasecmp(rc_line, "DEFAULT_DOWNLOADS", 17)) {
	  sscanf(rc_line + 18, "%d", &(global.limit.default_downloads));
	  if (global.limit.default_downloads < 0)
	    global.limit.default_downloads = 0;
	} else if (!strncasecmp(rc_line, "DEFAULT_UPLOADS", 15)) {
	  sscanf(rc_line + 16, "%d", &(global.limit.default_uploads));
	  if (global.limit.default_uploads < 0)
	    global.limit.default_uploads = 0;
	} else if (!strncasecmp(rc_line, "AutoRetry", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_retry = atoi(pos1);
	} else if (!strncasecmp(rc_line, "DOWNLOAD_PERCENT", 16)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.limit.download_percent = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ResumeAbort", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos1 = arg(pos1, 0);
	  if (pos1) global.options.resume_abort[0] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (pos1) global.options.resume_abort[1] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (pos1) global.options.resume_abort[2] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (pos1) global.options.resume_abort[3] = atoi(pos1);
	} else if (!strncasecmp(rc_line, "FIREWALL", 8)) {
	  sscanf(rc_line + 9, "%d", &(global.network.firewall));
	} else if (!strncasecmp(rc_line, "TransferTimeoutUp", 17)) {
	  sscanf(rc_line + 18, "%d", &(global.network.transfer_timeout_up));
	} else if (!strncasecmp(rc_line, "TransferTimeoutDown", 19)) {
	  sscanf(rc_line + 20, "%d", &(global.network.transfer_timeout_down));
	} else if (!strncasecmp(rc_line, "DLAutoremove", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.dl_autoremove = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ULAutoremove", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.ul_autoremove = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TransferUpdate", 14)) {
	  sscanf(rc_line + 15, "%d", &(global.network.transfer_delay));
	  if (global.network.transfer_delay <= 0)
	    global.network.transfer_delay = 1;
	} else if (!strncasecmp(rc_line, "GraphSmooth", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.graph_smooth[0] = atoi(pos2);
	  if (global.options.graph_smooth[0] < 1)
	    global.options.graph_smooth[0] = 1;
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.graph_smooth[1] = atoi(pos2);
	  if (global.options.graph_smooth[1] < 1)
	    global.options.graph_smooth[1] = 1;
	} else if (!strncasecmp(rc_line, "GraphMode", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.graph_mode[0] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.graph_mode[1] = atoi(pos2);
	} else if (!strncasecmp(rc_line, "GraphShow", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.graph_show[0] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.graph_show[1] = atoi(pos2);
	} else if (!strncasecmp(rc_line, "GraphStep", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.graph_interval[0] = atoi(pos2);
	  if (global.options.graph_interval[0] < 0)
	    global.options.graph_interval[0] = 0;
	  if (global.options.graph_interval[0] > 3)
	    global.options.graph_interval[0] = 3;
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.graph_interval[1] = atoi(pos2);
	  if (global.options.graph_interval[1] < 0)
	    global.options.graph_interval[1] = 0;
	  if (global.options.graph_interval[1] > 3)
	    global.options.graph_interval[1] = 3;
	} else if (!strncasecmp(rc_line, "AllowDCC", 8)) {
	  sscanf(rc_line + 9, "%d", &(global.options.allow_dcc));
	} else if (!strncasecmp(rc_line, "AccessOnlyTransferring", 22)) {
	  sscanf(rc_line + 23, "%d", &(global.options.access_transferring));
	} else if (!strncasecmp(rc_line, "DownloadBandwidth", 17)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  global.down_width.limit = atoi(pos1);
	  global.down_width.maxval = atoi(pos2);
	} else if (!strncasecmp(rc_line, "UploadBandwidth", 15)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  global.up_width.limit = atoi(pos1);
	  global.up_width.maxval = atoi(pos2);
	} else if (!strncasecmp(rc_line, "ConfirmDelete", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.confirm_delete = atoi(pos1);
	} else if (!strncasecmp(rc_line, "CheckLibForDownload", 19)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.check_lib_for_download = atoi(pos1);
        } else if (!strncasecmp(rc_line, "TransferSpeedLights", 19)) {
          // Weasel75
	  pos1 = strchr(rc_line, '=');
          if (!pos1 || sscanf(pos1+1, "%d %d %d %d %d %d",
			      &(global.options.down_speed[0]),
			      &(global.options.down_speed[1]),
			      &(global.options.down_speed[2]),
			      &(global.options.up_speed[0]),
			      &(global.options.up_speed[1]),
			      &(global.options.up_speed[2]) ) != 6)
            { // load failed (malformed string), so use defaults
	      // normally in read_rc default values are not set
              global.options.down_speed[0] = SPEED_RED;
              global.options.down_speed[1] = SPEED_YELLOW;
              global.options.down_speed[2] = SPEED_GREEN;
              global.options.up_speed[0] = SPEED_RED2;
              global.options.up_speed[1] = SPEED_YELLOW2;
              global.options.up_speed[2] = SPEED_GREEN2;
            }
	} else {
	  g_warning("unknown tag in section NETWORK [%s]", rc_line);
	}
      } else if (section == 4) {
	if (!strncasecmp(rc_line, "USER", 4)) {
	  hot_t* hot;

	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  if (pos2 && (*pos2)) {
	    *pos2 = 0;
	    pos2++;
	  } else
	    pos2 = NULL;
	  hot = hotlist_add(pos1, pos2, 1);
	} else {
	  g_warning("unknown tag in section HOTLIST [%s]", rc_line);
	}
      } else if (section == 6) {
	if (!strncasecmp(rc_line, "Alias", 5)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(rc_line, ':');
	  pos2[0] = 0;
	  pos2++;
	  command_make_alias(pos2, pos1);
	} else if (!strncasecmp(rc_line, "Highlight", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 2);
	  while (pos2) {
	    highlight_add(pos2);
	    pos2 = arg(NULL, 2);
	  }
	} else if (!strncasecmp(rc_line, "Friend", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    friend_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Ignore", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    ignore_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Enemy", 5)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    enemy_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "NoDownload", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    nodownload_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Scheme", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  strcpy(scheme, pos1);
	} else if (!strncasecmp(rc_line, "ShowJoins", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.show_joins = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ShowParts", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.show_parts = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RecentTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.recent_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Logging", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.logging = atoi(pos1);
	} else if (!strncasecmp(rc_line, "LogExpire", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.log_expire = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColorParse", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.parse_colors = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColorStrip", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.strip_colors = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Piping", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.piping = atoi(pos1);
	} else if (!strncasecmp(rc_line, "NoPiping", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.no_piping = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TimeStamps", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.timestamps = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RejoinOpen", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.channel_rejoin = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColoredNicks2", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.colored_nicks2 = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColoredNicks", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.colored_nicks = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RejoinWhenKicked", 14)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.rejoin_when_kicked = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AFKReason", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 2);
	  while (pos2) {
	    afkreason_add(pos2);
	    pos2 = arg(NULL, 2);
	  }
	} else if (!strncasecmp(rc_line, "AutoAfk", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.afk.auto_afk = atoi(pos1);
	} else if (!strncasecmp(rc_line, "WarnAFK", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.afk.warn_afk = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ChatBufferLimit", 15)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.max_chat_buffer = atoi(pos1);
	} else {
	  g_warning("unknown tag in section CHAT [%s]", rc_line);
	}
      } else if (section == 7) {
	if (!strncasecmp(rc_line, "Search0", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button115");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(rc_line, "Search1", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button330");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(rc_line, "Search2", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button331");
	  set_button_state(temp, atoi(pos1));
	} else {
	  g_warning("unknown tag in section BUTTONS [%s]", rc_line);
	}
      } else if (section == 8) {
	if (!strncasecmp(rc_line, "Player", 6)) {	//backward 
	  suffix_t *suffix;

	  pos1 = strchr(rc_line, '=') + 1;
	  suffix = (suffix_t *) l_malloc(sizeof(suffix_t));
	  suffix->suffix = l_strdup("mp3");
	  suffix->application = l_strdup(pos1);
	  suffix->as_mp3 = 1;
	  global.mimetype[MIME_MP3].suffixes =
	      g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
	} else if (!strncasecmp(rc_line, "Version", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!strcmp(pos1, VERSION))
	    changes = 0;
#ifdef HAVE_LIBLCONV_H
        } else if (!strncasecmp(rc_line, "UseIconvConvert", 15)) {
          pos1 = strchr(rc_line, '=') + 1;
          global.options.use_iconv = atoi(pos1);
        } else if (!strncasecmp(rc_line, "DestCodeSet", 11)) {
          pos1 = strchr(rc_line, '=') + 1;
	  if (global.options.dest_codeset)
	    l_free(global.options.dest_codeset);
          global.options.dest_codeset = l_strdup(rc_line + 12);
#endif
	} else if (!strncasecmp(rc_line, "ServerMOTD", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.server_motd = atoi(pos1);
	} else if (!strncasecmp(rc_line, "DownloadLayout", 14)) {
	  download_layout_t layout;
	  pos1 = strchr(rc_line, '=') + 1;
	  pos1 = arg(pos1, 0);
	  if (!pos1) return;
	  layout.ctree_position[0] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.ctree_position[1] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.ctree_position[2] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.ctree_position[3] = atoi(pos1);
	  
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.transfer_position[0] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.transfer_position[1] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.transfer_position[2] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (!pos1) return;
	  layout.transfer_position[3] = atoi(pos1);
	  download_layout(&layout);
	} else if (!strncasecmp(rc_line, "AutoResume", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_resume = atoi(pos1);
	} else if (!strncasecmp(rc_line, "PingCommand", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (global.ping_command)
	    l_free(global.ping_command);
	  global.ping_command = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "ExternalHandler", 15)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (global.external_handler)
	    l_free(global.external_handler);
	  if (*pos1 =='\0' || *pos1==' ')
	    global.external_handler=NULL;
	  else
	    global.external_handler = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "ExternalEvents", 14)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.external_events = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RetryTimeout", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.retry_timeout[0] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[1] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[2] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[3] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[4] = atoi(pos2);
	} else if (!strncasecmp(rc_line, "UploadPriority", 14)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.upload_priority[0] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.upload_priority[1] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.upload_priority[2] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.upload_priority[3] = atoi(pos2);
	} else if (!strncasecmp(rc_line, "NapigatorUseProxy", 17)) {
		pos1 = strchr(rc_line, '=') + 1;
		global.napigator.use_proxy = atoi(pos1);
	} else if (!strncasecmp(rc_line, "NapigatorProxyUrl", 17)) {
		pos1 = strchr(rc_line, '=') + 1;
		if (global.napigator.proxy_url){
			l_free(global.napigator.proxy_url);
		}
		global.napigator.proxy_url = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "NapigatorProxyPort", 18)) {
		pos1 = strchr(rc_line, '=') + 1;
		global.napigator.proxy_port = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TabStyle", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.tab_style = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AccessTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.access_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "CheckVersion", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.check_version = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TimeDisplay", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.time_display = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Browser", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.browser = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AutoconnectSendQueueLimit", 25)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.autoconnect_sendqueue_limit = atoi(pos1);
	} else if (!strncasecmp(rc_line, "BanReason", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 2);
	  while (pos2) {
	    banreason_add(pos2);
	    pos2 = arg(NULL, 2);
	  }
	} else {
	  g_warning("unknown tag in section GLOBAL [%s]", rc_line);
	}
      } else if (section == 9) {
	if (!strncasecmp(rc_line, "DummyMD5", 8)) {
	  sscanf(rc_line + 9, "%d", &(global.options.dummy_md5));
	} else if (!strncasecmp(rc_line, "AutoSave", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.auto_save = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "MarkValue", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.lib_mark_val = atoi(pos1);
	} else {
	  g_warning("unknown tag in section LIBRARY [%s]", rc_line);
	}
      } else if (section == 10) {
	if (!strncasecmp(rc_line, "AutoSearch", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_search = atoi(pos1);
	} else if (!strncasecmp(rc_line, "SearchTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.search_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ResumeTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.resume_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "PingResults", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.ping_search = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ShowFolder", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.search_show_folder = atoi(pos1);
	} else if (!strncasecmp(rc_line, "PingCommand", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (global.ping_command)
	    l_free(global.ping_command);
	  global.ping_command = l_strdup(pos1);
	} else {
	  g_warning("unknown tag in section Search [%s]", rc_line);
	}
      } else {
	g_warning("unparsable rc_line [%s]", rc_line);
      }
    }
    p_rc_line = 0;
    fclose(file);
  }

  scheme_load_global(scheme);

  if (changes) {
    // reset the version checker, if enabled
    if (global.options.check_version)
      global.options.check_version = 1;
    // show changes
    changes_dialog();
  }

  if (new_lib) {
    //    ..
  }

  global.status.rc_read = 1;

  if (create_rc) {
    wizard_start();
  } else {
    if (!global.username) {
      info_dialog("Please specify a username in your Preferences before you get the napigator server list!\n Otherwise a default username is chosen and thats not recommended");
      global.username = l_strdup("TestUser");
    }
    if (!global.password) {
      info_dialog("Please specify a password in your Preferences!");
      global.password = l_strdup("TestPasswd");
    }
  }
}

void savelisti(FILE *file, int id, const char *name, const char *nlfmt, const char *spfmt)
{
  GList *dlist;
  char *str;
  int i1 = 0;

  for (dlist = global.string_list[id]; dlist; dlist = dlist->next) {
    if (i1 == 0) fprintf(file, name);
    str = (char *) (dlist->data);
    i1 += strlen(str);
    if (i1 > 1024) {
      i1 = 0;
      qfprintf(file, nlfmt, str);
    } else if (!dlist->next) {
      qfprintf(file, nlfmt, str);
      break;
    } else {
      i1++;
      qfprintf(file, spfmt, str);
    }
  }
}

static void savelist(FILE *file, int id, const char *name) {
  savelisti(file, id, name, "%s\n", "%s ");
}

static void qsavelist(FILE *file, int id, const char *name) {
  savelisti(file, id, name, "%S\n", "%S ");
}

void write_rc() {
  char *RCFile;
  FILE *file;
  GList *dlist;
  command_t *comm;
  int i1;
  char *str;
  GtkWidget *temp;
  suffix_t *suffix;
  hot_t *hot;

  //  printf("write rc\n");
  RCFile = l_strdup_printf("%s/lopsterrc.new", global.options.config_dir);

  if ((file = fopen(RCFile, "w")) == NULL) {
    l_free(RCFile);
    g_warning("could not write rc-file %s", RCFile);
    return;
  }

  fprintf(file, "# DANGER! Only edit if you know what you are doing\n");
  fprintf(file, "###################################\n");
  fprintf(file, "\nSection [USER]\n");
  fprintf(file, "Name=%s\n", global.username);
  fprintf(file, "Password=%s\n", global.password);
  fprintf(file, "EMail=%s\n", global.email);
  fprintf(file, "Mode=%d\n", global.usermode);

  fprintf(file, "\nSection [PATH]\n");
  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (global.mimetype[i1].download)
      fprintf(file, "Download=%d:%s\n", i1, global.mimetype[i1].download);
  }
  if (global.incomplete_path)
    fprintf(file, "Incomplete=%s\n", global.incomplete_path);
  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      fprintf(file, "Suffix=%d:%s:%s:%d\n", i1,
	      suffix->suffix, suffix->application, suffix->as_mp3);
    }
  }

  fprintf(file, "\nSection [GLOBAL]\n");
  fprintf(file, "Version=%s\n", VERSION);
#ifdef HAVE_LIBLCONV_H
  fprintf(file, "UseIconvConvert=%d\n", global.options.use_iconv);
  fprintf(file, "DestCodeSet=%s\n", global.options.dest_codeset);
#endif
  fprintf(file, "AutoResume=%d\n", global.options.auto_resume);
  if (global.external_handler)
    fprintf(file, "ExternalHandler=%s\n", global.external_handler);
  if (global.external_events)
    fprintf(file, "ExternalEvents=%d\n", global.external_events);
  fprintf(file, "TabStyle=%d\n", global.options.tab_style);
  fprintf(file, "ServerMOTD=%d\n", global.options.server_motd);
  fprintf(file, "DownloadLayout=%d %d %d %d %d %d %d %d\n",
	  global.dl_layout.ctree_position[0],
	  global.dl_layout.ctree_position[1],
	  global.dl_layout.ctree_position[2],
	  global.dl_layout.ctree_position[3],
	  global.dl_layout.transfer_position[0],
	  global.dl_layout.transfer_position[1],
	  global.dl_layout.transfer_position[2],
	  global.dl_layout.transfer_position[3]);
  fprintf(file, "AccessTimeout=%d\n", global.options.access_timeout);
  fprintf(file, "CheckVersion=%d\n", global.options.check_version);
  fprintf(file, "TimeDisplay=%d\n", global.options.time_display);
  fprintf(file, "AutoconnectSendQueueLimit=%d\n", global.options.autoconnect_sendqueue_limit);
  fprintf(file, "Browser=%d\n", global.options.browser);

  fprintf(file, "RetryTimeout=%d %d %d %d %d\n",
	  global.options.retry_timeout[0], global.options.retry_timeout[1],
	  global.options.retry_timeout[2], global.options.retry_timeout[3],
	  global.options.retry_timeout[4]);
  fprintf(file, "UploadPriority=%d %d %d %d\n",
	  global.options.upload_priority[0], global.options.upload_priority[1],
	  global.options.upload_priority[2], global.options.upload_priority[3]);
  fprintf(file, "NapigatorUseProxy=%d\n", global.napigator.use_proxy);
  if (global.napigator.proxy_url) {
    fprintf(file, "NapigatorProxyUrl=%s\n", global.napigator.proxy_url);
  }
  fprintf(file, "NapigatorProxyPort=%d\n", global.napigator.proxy_port);
  qsavelist(file, LIST_BANREASON, "BanReason=");
  
  fprintf(file, "\nSection [SEARCH]\n");
  fprintf(file, "AutoSearch=%d\n", global.options.auto_search);
  fprintf(file, "SearchTimeout=%d\n", global.options.search_timeout);
  fprintf(file, "ResumeTimeout=%d\n", global.options.resume_timeout);
  fprintf(file, "ShowFolder=%d\n", global.options.search_show_folder);
  fprintf(file, "PingResults=%d\n", global.options.ping_search);
  if (global.ping_command)
    fprintf(file, "PingCommand=%s\n", global.ping_command);

  fprintf(file, "\nSection [Network]\n");
  fprintf(file, "Linespeed=%d\n", global.linespeed);
  fprintf(file, "Port=%d\n", global.network.port);
  str = create_string_from_ports(global.allowed_ports);
  if (str)
    fprintf(file, "AllowedPorts=%s\n", str);
  l_free(str);
  fprintf(file, "Firewall=%d\n", global.network.firewall);
  fprintf(file, "MinSegmentSize=%d\n", global.limit.min_segment_size);
  fprintf(file, "MaxSeekAdd=%d\n", global.limit.max_seek_add);
  fprintf(file, "DLAbortLimit=%ld\n", global.limit.download_abort_limit);
  fprintf(file, "DLAbortNumber=%d\n", global.limit.download_abort_number);
  fprintf(file, "Max_Downloads=%d\n", global.limit.max_downloads);
  fprintf(file, "Max_Uploads=%d\n", global.limit.max_uploads);
  fprintf(file, "Max_Large=%d\n", global.limit.max_large);
  fprintf(file, "Large_Size=%d\n", global.limit.large_size);
  fprintf(file, "Default_Downloads=%d\n", global.limit.default_downloads);
  fprintf(file, "Default_Uploads=%d\n", global.limit.default_uploads);
  fprintf(file, "Download_Percent=%d\n", global.limit.download_percent);
  fprintf(file, "AutoRetry=%d\n", global.options.auto_retry);
  fprintf(file, "ResumeAbort=%d %d %d %d\n",
	  global.options.resume_abort[0], global.options.resume_abort[1],
	  global.options.resume_abort[2], global.options.resume_abort[3]);
  fprintf(file, "TransferTimeoutUp=%d\n", global.network.transfer_timeout_up);
  fprintf(file, "TransferTimeoutDown=%d\n", global.network.transfer_timeout_down);
  fprintf(file, "TransferUpdate=%d\n", global.network.transfer_delay);
  fprintf(file, "GraphSmooth=%d %d\n", global.options.graph_smooth[0],
	  global.options.graph_smooth[1]);
  fprintf(file, "GraphStep=%d %d\n", global.options.graph_interval[0],
	  global.options.graph_interval[1]);
  fprintf(file, "GraphMode=%d %d\n", global.options.graph_mode[0],
	  global.options.graph_mode[1]);
  fprintf(file, "GraphShow=%d %d\n", global.options.graph_show[0],
	  global.options.graph_show[1]);
  fprintf(file, "DLAutoremove=%d\n", global.options.dl_autoremove);
  fprintf(file, "ULAutoremove=%d\n", global.options.ul_autoremove);
  fprintf(file, "AllowDCC=%d\n", global.options.allow_dcc);
  fprintf(file, "AccessOnlyTransferring=%d\n", global.options.access_transferring);
  fprintf(file, "DownloadBandwidth=%ld:%ld\n",
	  global.down_width.limit, global.down_width.maxval);
  fprintf(file, "UploadBandwidth=%ld:%ld\n",
	  global.up_width.limit, global.up_width.maxval);
  fprintf(file, "ConfirmDelete=%d\n", global.options.confirm_delete);
  fprintf(file, "CheckLibForDownload=%d\n", global.options.check_lib_for_download);

  fprintf(file, "TransferSpeedLights=%d %d %d %d %d %d\n",
	  global.options.down_speed[0],
	  global.options.down_speed[1],
	  global.options.down_speed[2],
	  global.options.up_speed[0],
	  global.options.up_speed[1],
	  global.options.up_speed[2]);

  fprintf(file, "\nSection [Hotlist]\n");

  for (dlist = global.hotlist; dlist; dlist = dlist->next) {
    hot = dlist->data;
    if (!hot->visible) continue;
    fprintf(file, "User=%s:%s\n", hot->user,
	    (hot->description) ? (hot->description) : "");
  }

  // chat
  fprintf(file, "\nSection [Chat]\n");
  for (dlist = global.commands; dlist; dlist = dlist->next) {
    comm = dlist->data;
    if (comm->is_alias) {
      fprintf(file, "Alias=%s:%s\n", comm->name, &(comm->syntax[4]));
    }
  }
  qsavelist(file, LIST_HIGHLIGHT, "Highlight=");
  savelist(file, LIST_FRIEND, "Friend=");
  savelist(file, LIST_IGNORE, "Ignore=");
  savelist(file, LIST_ENEMY, "Enemy=");
  savelist(file, LIST_NODOWNLOAD, "NoDownload=");
  qsavelist(file, LIST_AFKREASON, "AFKReason=");
  fprintf(file, "AutoAFK=%d\n", global.afk.auto_afk);
  fprintf(file, "WarnAFK=%d\n", global.afk.warn_afk);
  if (global.scheme)
    fprintf(file, "Scheme=%s\n", global.scheme->name);
  fprintf(file, "ShowJoins=%d\n", global.options.show_joins);
  fprintf(file, "ShowParts=%d\n", global.options.show_parts);
  fprintf(file, "RecentTimeout=%d\n", global.options.recent_timeout);
  fprintf(file, "Logging=%d\n", global.options.logging);
  fprintf(file, "LogExpire=%d\n", global.options.log_expire);

  fprintf(file, "ColorParse=%d\n", global.options.parse_colors);
  fprintf(file, "ColorStrip=%d\n", global.options.strip_colors);
  fprintf(file, "Piping=%d\n", global.options.piping);
  fprintf(file, "NoPiping=%d\n", global.options.no_piping);
  fprintf(file, "TimeStamps=%d\n", global.options.timestamps);
  fprintf(file, "RejoinOpen=%d\n", global.options.channel_rejoin);
  fprintf(file, "ColoredNicks=%d\n", global.options.colored_nicks);
  fprintf(file, "ColoredNicks2=%d\n", global.options.colored_nicks2);
  fprintf(file, "RejoinWhenKicked=%d\n", global.options.rejoin_when_kicked);
  fprintf(file, "ChatBufferLimit=%d\n", global.options.max_chat_buffer);

  // buttons
  fprintf(file, "\nSection [Buttons]\n");
  temp = lookup_widget(global.win, "pix4");
  fprintf(file, "Search0=%d\n", GTK_WIDGET_VISIBLE(temp));
  temp = lookup_widget(global.win, "pixmap51");
  fprintf(file, "Search1=%d\n", GTK_WIDGET_VISIBLE(temp));
  temp = lookup_widget(global.win, "pixmap53");
  fprintf(file, "Search2=%d\n", GTK_WIDGET_VISIBLE(temp));

  fprintf(file, "\nSection [Library]\n");
  if (global.lib) 
    fprintf(file, "AutoSave=%s\n", FILE_TREE(global.lib)->name);
  fprintf(file, "DummyMD5=%d\n", global.options.dummy_md5);
  fprintf(file, "MarkValue=%d\n", global.options.lib_mark_val);

  if (!ferror(file)) {
    rename(RCFile, global.options.config_file);
  } else {
    g_warning("Could not write [%s]\n", RCFile);
  }

  l_free(RCFile);
  fclose(file);
}

static void setup_commands() {
  command_new(C_WHISPER, "msg", "/msg <user> <text>",
	      "Send a private message <text> to the User <user>",
	      L_USER, F_CHAT, lopster_whisper);
  command_new(C_EMOTE, "me", "/me <text>",
	      "Send action description <text> on the current channel.",
	      L_USER, F_CHAT, lopster_emote);
  command_new(C_JOIN, "join", "/join <channel>",
	      "Join channel <channel>",
	      L_USER, F_CHAT, lopster_join);
  command_new(C_JOIN, "autojoin", "/autojoin [[+|-]<channel>]",
	      "Add/remove channel from autojoin or list the channels", 
	      L_USER, F_CHAT, lopster_autojoin);
  command_new(C_RAW, "raw", "/raw <type> [<arg>....]", "?",
	      L_MOD, F_MOD,
	      lopster_raw);
  command_new(C_HELP, "help", "/help [<command>|all]",
	      "Type /help for a list of commands, type /help all for all commands, type /help <command> for a description of <command>",
	      L_USER, F_INFO, lopster_help);
  command_new(C_BAN, "ban", "/ban <user|ip> [[<timeout>[s|m|h|d|w]] <reason>]",
	      "Ban user or ip from server", 
	      L_MOD, F_MOD, lopster_ban);
  command_new(C_CLEAR, "clear", "/clear [BOTTOM|TOP]",
	      "Clears to current channel window",
	      L_USER, F_CLIENT, lopster_clear);
  command_new(C_CLOAK, "cloak", "/cloak",
	      "Toggle your invisible state.",
	      L_MOD, F_MOD, lopster_cloak);
  command_new(C_KICK, "kick", "/kick [<channel>] <user> [<reason>]",
	      "Kick <user> with a lower level than yours from the <channel>",
	      L_USER, F_OP, lopster_kick);
  command_new(C_KILL, "kill", "/kill <user> [reason]",
	      "Kill (disconnect) <user> with a lower lower level than yours.",
	      L_USER, F_MOD, lopster_kill);
  command_new(C_CHLIST, "chlist", "/chlist",
	      "List all channels in channel list",
	      L_USER, F_CLIENT, lopster_chlist);
  command_new(C_MOTD, "motd", "/motd",
	      "Show server's \"Message Of The Day\"", 
	      L_USER, F_INFO, lopster_motd);
  command_new(C_MUZZLE, "muzzle", "/muzzle <user> [<reason>]",
	      "Muzzle <user> with a lower level than yours",
	      L_MOD, F_MOD, lopster_muzzle);
  command_new(C_WALLOP, "wallop", "/wallop <text>",
	      "Send a message to all users with level moderator or higher",
	      L_MOD, F_MOD, lopster_wallop);
  command_new(C_PART, "part", "/part [<reason>]",
	      "Part the current channel with exit message <reason>",
	      L_USER, F_CHAT, lopster_part);
  command_new(C_PUBLIC, "public", "/public <text>",
	      "Force to send public message", 
	      L_USER, F_CHAT, lopster_public);
  command_new(C_EMAIL, "email", "/email <address>",
	      "Change e-mail address to <address>.",
	      L_USER, F_UMOD, lopster_email);
  command_new(C_SPEED, "speed", "/speed [<user>] [<speed>]",
	      "It will change the link speed for <user>. If no user is given your own link speed is modified",
	      L_USER, F_UMOD, lopster_speed);
  command_new(C_DATAPORT, "dataport", "dataport [<user>] <port>",
	      "Changes the dataport of <user> to <port>. If no user is specified it changes your own port",
	      L_USER, F_UMOD, lopster_dataport);
  command_new(C_PASSWORD, "password", "/password [<user>] <password>",
	      "It will change the password for <user> (admin or higher). If no user is given your own password is modified",
	      L_USER, F_UMOD, lopster_password);
  command_new(C_LEVEL, "level", "/level <user> <level>",
	      "Change level of <user> with a lower level than yours.",
	      L_USER, F_UMOD, lopster_level);
  command_new(C_USERMODE, "usermode", "/usermode [[-]args <...>]",
	      "Show or set current usermode (ERROR BAN CHANGE KILL LEVEL SERVER MUZZLE PORT WALLOP CLOAK FLOOD PING MSG WHOIS)",
	      L_USER, F_UMOD, lopster_usermode);
  command_new(C_WHOIS, "whois", "/whois [-text] [<user>]",
	      "Show whois info for <user>",
	      L_USER, F_INFO, lopster_whois);
  command_new(C_DISC, "disc", "/disc",
	      "Disconnect from server",
	      L_USER, F_MISC, lopster_disc);
  command_new(C_UNBAN, "unban", "/unban <user|ip>",
	      "Remove the ban on a user or ip",
	      L_MOD, F_MOD, lopster_unban);
  command_new(C_CHCLEAR, "chclear", "/chclear [<channel> <reason>]",
	      "Clear the channel from users with a lower level than yours. If no channel is specified the current channel is used",
	      L_USER, F_OP, lopster_chclear);
  command_new(C_LINKS, "links", "/links [GET|PRINT]",
	      "Get or show list of all linked servers",
	      L_USER, F_INFO, lopster_links);
  command_new(C_STATS, "stats", "/stats", 
	      "Show server statistics",
	      L_USER, F_INFO, lopster_stats);
  command_new(C_SCHEME, "scheme", "/scheme <name>",
	      "Loading Color scheme <name>",
	      L_USER, F_CLIENT, lopster_scheme);
  command_new(C_ALIAS, "alias", "/alias <alias> <command>",
	      "Making new <alias> for <command>",
	      L_USER, F_CLIENT, lopster_alias);
  command_new(C_AFK, "away", "/away [<text>]",
	      "If argument text is given, your status is set to AFK. Users sending you private messages will receive <text> as a private message. If no argument is given AFK is deactivated",
	      L_USER, F_CLIENT, lopster_afk);
  command_new(C_REPLY, "reply", "/reply <text>",
	      "Reply to the user who sent the last private message",
	      L_USER, F_CHAT, lopster_reply);
  command_new(C_PRIVATE, "private", "/private <user>",
	      "Create new page for private messaging to <user>", L_USER,
	      F_CHAT, lopster_private);
  command_new(C_CONN, "conn", "/conn",
	      "Start connecting to the servers",
	      L_USER, F_MISC, lopster_conn);
  command_new(C_QUIT, "quit", "/quit", 
	      "Exit program",
	      L_USER, F_MISC, lopster_quit);
  command_new(C_IGNORE, "ignore", "/ignore [<user>]",
	      "ignore user <user>. If User is not given, ignore list is shown",
	      L_USER, F_CHAT, lopster_ignore);
  command_new(C_UNIGNORE, "unignore", "/unignore <user>",
	      "Unignores <user>",
	      L_USER, F_CHAT, lopster_unignore);
  command_new(C_UNMUZZLE, "unmuzzle", "/unmuzzle <user>",
	      "Unmuzzle <user> with a lower level than yours",
	      L_MOD, F_MOD, lopster_unmuzzle);
  command_new(C_CHBAN, "chban", "/chban [<channel>] [<user|ip> [<reason>]]",
	      "Ban <user|ip> from <channel>. The channel may only be emitted if the user is present in the current channel page",
	      L_USER, F_OP, lopster_chban);
  command_new(C_CHUNBAN, "chunban", "/chunban [<channel>] <user|ip> [<reason>]",
	      "Unban <user|ip> from <channel>. The channel may only be emitted if the user is present in the current channel page",
	      L_USER, F_OP, lopster_chunban);
  command_new(C_TOPIC, "topic", "/topic [<topic>]",
	      "Get or set the topic", 
	      L_USER, F_OP, lopster_topic);
  command_new(C_VERSION, "version", "/version", 
	      "Show server version.",
	      L_MOD, F_MOD, lopster_version);
  command_new(C_NUKE, "nuke", "/nuke <user>",
	      "Nuke a <user> (delete account) with lower level than yours your yourself",
	      L_MOD, F_MOD, lopster_nuke);
  command_new(C_GLOBAL, "global", "/global <text>",
	      "Send global message to all users",
	      L_ADMIN, F_ADMIN, lopster_global);
  command_new(C_CVERSION, "cversion", "/cversion [-out]",
	      "Prints out the client version, if -out is given then lopster prints it to the current page",
	      L_USER, F_INFO, lopster_cversion);
  command_new(C_PING, "ping", "/ping <user>", 
	      "Ping <user>",
	      L_USER, F_MISC, lopster_ping);
  command_new(C_SPING, "sping", "/sping <server>", 
	      "Ping <server>", 
	      L_USER, F_MISC, lopster_sping);
  command_new(C_ECHO, "echo", "/echo <text>",
	      "Echo <text> to current window. What's this command good for?",
	      L_USER, F_CLIENT, lopster_echo);
  command_new(C_CHLIMIT, "chlimit", "/chlimit [<channel>] [<limit>]",
	      "Change max. user limit of <channel> to <limit>. If no limit is specified the current limit is shown. If no channel is specified the current channel is used",
	      L_USER, F_OP, lopster_chlimit);
  command_new(C_CHLEVEL, "chlevel", "/chlevel [<channel>] [<level>]",
	      "Set the minimum level required to join <channel>. If no level is given the current level is shown.If no channel is given the current channel is used",
	      L_USER, F_OP, lopster_chlevel);
  command_new(C_SSTATS, "sstats", "/sstats [<server>]",
	      "Show the server stats of <server> or local server if no argument is given (moderator or higher)",
	      L_USER, F_INFO, lopster_sstats);
  command_new(C_CHMODE, "chmode", "/chmode [<channel>] [*(<+|->*<mode>)]",
	      "Set or get <mode> for <channel>\n  -- <channel> Channel to operate on, default is current channel\n  -- <mode>    Mode may be the characters (t)opic, re(g)istered, (n)ooutside, (s)ecret, (p)rivate, (i)nvite, (m)oderated, (r)eop, (q)uiet, (a)nonymous",
	      L_USER, F_OP, lopster_chmode);
  command_new(C_CHWALLOP, "chwallop", "/chwallop <message>",
	      "Send message to all channel operators",
	      L_USER, F_OP, lopster_chwallop);
  command_new(C_OP, "op", "/op [<channel>] [<user>]",
	      "Set <user> as operator on the current channel. If no channel is given the current channel is used, if no user is given the operator list is shown",
	      L_USER, F_OP, lopster_op);
  command_new(C_DEOP, "deop", "/deop  [<channel>] <user>",
	      "Remove <user> as operator on the current channel or the specified channel",
	      L_USER, F_OP, lopster_deop);
  command_new(C_KILLGHOST, "killghost", "/killghost <ghost> [<passwd>]",
	      "kill your <ghost>. if no password is given, the current password is used",
	      L_USER, F_MISC, lopster_killghost);
  command_new(C_FRIEND, "friend", "/friend <user>",
	      "Add/remove a user to/from the friend list",
	      L_USER, F_CLIENT, lopster_friend);
  command_new(C_ENEMY, "enemy", "/enemy <user>",
	      "Add/remove a user to/from the enemy list",
	      L_USER, F_CLIENT, lopster_enemy);
  command_new(C_HOTADD, "hotadd", "/hotadd <user> [<description>]",
	      "Add a user to the hot list",
	      L_USER, F_CLIENT, lopster_hotadd);
  command_new(C_HOTREM, "hotrem", "/hotrem <user>",
	      "Remove a user from the hot list",
	      L_USER, F_CLIENT, lopster_hotrem);
  command_new(C_LOCATE, "locate", "/locate <user>",
	      "Display on which server <user> is",
	      L_USER, F_INFO, lopster_locate);
  command_new(C_CLIENTS, "clients", "/clients",
	      "Display clients versions if server has enabled logs",
	      L_USER, F_INFO, lopster_clients);
  command_new(C_INVITE, "invite", "/invite [<channel>] <user>",
	      "Invite <user> to <channel> or the current channel",
	      L_USER, F_CHAT, lopster_invite);
  command_new(C_CHMUZZLE, "chmuzzle", "/chmuzzle [<channel>] [<nick> [<reason>]]",
	      "Muzzle <user>. If no user is specified the muzzle list is shown",
	      L_USER, F_OP, lopster_chmuzzle);
  command_new(C_CHUNMUZZLE, "chunmuzzle", "/chunmuzzle [<channel>] <user> [<reason>]",
	      "Unmuzzle <user> with a lower level than yours.",
	      L_USER, F_OP, lopster_chunmuzzle);
  command_new(C_CHVOICE, "chvoice", "/chvoice [<channel>] [<user>]",
	      "Give <user> voice to speak in channel If no channel is given the current channel is used. If no user is specified the voice list is shown",
	      L_USER, F_OP, lopster_chvoice);
  command_new(C_CHUNVOICE, "chunvoice", "/chunvoice [<channel>] <user>",
	      "Remove voice from <user> to speak in channel",
	      L_USER, F_OP, lopster_chunvoice);
  command_new(C_GUSER, "guser", "/guser [<server> [<flags>]]",
	      "List all users. Flags may be a list of the characters: e=ELITE, a=ADMIN, m=MODERATOR, l=LEECH, z=MUZZLED, c=CLOAKED",
	      L_MOD, F_MOD, lopster_guser);
  command_new(C_SCONFIG, "sconfig", "/sconfig [var [value]]",
	      "Request server config. To change a variable you have to be ELITE",
	      L_MOD, F_MOD, lopster_sconfig);
  command_new(C_CLONES, "clones", "/clones <all|<channel>|<IP>> [<num>]",
	      "Show all clones or for specified IP or channel. Only available if global user list was received",
	      L_MOD, F_MOD, lopster_clones);
  command_new(C_EXEC, "exec", "/exec [-out|-msg <user>|-wallop|-chop|-quiet|-global|-kill <id>] [<command>]",
	      "Executes <command>. Without arguments the current processes are listed",
	      L_USER, F_CLIENT, lopster_exec);
  command_new(C_WHOWAS, "whowas", "/whowas <user>",
	      "Query information about <user>. Moderator or higher",
	      L_MOD, F_MOD, lopster_whowas);
  command_new(C_RAINBOW, "rainbow", "/rainbow [sep] <size> <text>",
	      "Send the <text> with rainbow colors as a public message. Color is changed after <size> letters. <sep> is a not colored text, that is inserted between the color changes",
	      L_USER, F_CLIENT, lopster_rainbow);
  command_new(C_RCOLORS, "rcolors", "/rcolor [<-reset|color_codes>]",
	      "Setup the colors for command /rainbow",
	      L_USER, F_CLIENT, lopster_rcolors);
  command_new(C_BROWSE, "browse", "/browse <user>",
	      "View files from <user>",
	      L_USER, F_CLIENT, lopster_browse);
  command_new(C_SEND, "send", "/send <user> <file>",
	      "Send a file to user",
	      L_USER, F_CLIENT, lopster_send);
  command_new(C_SLINK, "slink", "/slink <server> [<remote server>]",
	      "Attempts to link the current server to <server>. If <remote_server> is given, then that server attempts to make the link instead of the local server",
	      L_ADMIN, F_ADMIN, lopster_slink);	// admin
  command_new(C_SDELINK, "sdelink", "/sdelink <server> [<reason>]",
	      "delink current server from <server>",
	      L_ADMIN, F_ADMIN, lopster_sdelink);	// admin
  command_new(C_SREMOVE, "sremove", "/sremove <server> [<reason>]", 
	      "requests that <server> be removed from the table of allowed links", 
	      L_ELITE, F_ADMIN, lopster_sremove);	// elite
  command_new(C_SKILL, "skill", "/skill <server> [<reason>]",
	      "cause the server to shutdown",
	      L_ELITE, F_ADMIN, lopster_skill);	// elite
  command_new(C_SRELOAD, "sreload", "/srelead [<server>]", 
	      "Reload the server configuration of local server or <server>",
	      L_ELITE, F_ADMIN, lopster_sreload);	// elite
  command_new(C_SRECONFIG, "sreconfig", "/sreconfig <var>", 
	      "reset <var> to its default value",
	      L_ELITE, F_ADMIN, lopster_sreconfig);	// elite
  command_new(C_SHISTOGRAM, "shistogram", "/shistogram [-in|-out]",
	      "Report statistics for server commands", 
	      L_ELITE, F_ADMIN, lopster_shistogram);	// elite
  command_new(C_MASSKILL, "masskill", "/masskill <ip> [<reason>]",
	      "Kill all users with <ip>",
	      L_MOD, F_MOD, lopster_masskill);
  command_new(C_REGISTER, "register", "/register [<user> <passwd> <email> [<level>]]",
	      "Admin command to force registration of a nickname. If no arguments are given, then your current nick is registered",
	      L_ADMIN, F_ADMIN, lopster_register);
  command_new(C_REDIRECT, "redirect", "/redirect <user> <server> <port>",
	      "Redirect client to another server",
	      L_ADMIN, F_ADMIN, lopster_redirect);
  command_new(C_CYCLE, "cycle", "/cycle <user> <server>",
	      "Redirect client to a metaserver",
	      L_ADMIN, F_ADMIN, lopster_cycle);
  command_new(C_LIMIT, "limit", "/limit <add|remove|list> <ip>[/ip mask] [<count>]",
	      "This command allowes to setup specific clone limits to IPs",
	      L_MOD, F_MOD, lopster_limit);
  command_new(C_ILINE, "iline", "/iline <add|remove|list> <ip>[/ip mask] [<count>]",
	      "Setup the IPs that are only allowed to connect. <count> is useless here",
	      L_MOD, F_MOD, lopster_iline);
  command_new(C_DLINE, "dline", "/dline <add|remove|list> <ip>[/ip mask] [<count>]",
	      "Setup IPs, that are not allowed to connect, unless they are in elines. <count> is useless here",
	      L_MOD, F_MOD, lopster_dline);
  command_new(C_ELINE, "eline", "/eline <add|remove|list> <ip>[/ip mask] [<count>]",
	      "IPs that are allowed to connect, although they are in dlines. <count> is useless here",
	      L_MOD, F_MOD, lopster_eline);
  command_new(C_PRETEND, "pretend",
	      "/pretend <command> [<data>]",
	      "This pretends a message from the server",
	      L_USER, F_MOD, lopster_pretend);
  command_new(C_SERVERS, "servers",
	      "/servers [<num>] [<flags>]",
	      "Show servers in the chat tab.\n  <num>    - Index of the server you want to display, default is all servers\n  <flags>  - specifies what information should be printed, contains characters [n]ame, [c]ompression, [s]tats, default is 'n'",
	      L_USER, F_CLIENT, lopster_servers);
  command_new(C_URLS, "urls", "/urls",
	      "Show all collected urls",
	      L_USER, F_CLIENT, lopster_urls);
  command_new(C_STATUS, "status", "/status <user>",
	      "Show status information for <user>",
	      L_USER, F_CLIENT, lopster_status);
  command_new(C_SEARCH, "search",
	      "/search [:destination] [<type] [-exclude] [+]include",
	      "Fires up a search.\n  <destination> - Contains one or more of the characters [N]etwork, [L]ibrary, [B]rowses, [S]earch Results, default is 'N'\n  <type>        - 'mp3', 'audio', 'video', 'application', 'image', 'text', 'any', default is 'mp3'\n  <exclude>     - words you dont want to search for\n  <include>     - words you want to search for",
	      L_USER, F_CLIENT, lopster_search);
  command_new(C_NICK, "nick", "/nick <new_nick>",
	      "It will change your <nickname>",
	      L_USER, F_UMOD, lopster_nick);
#ifdef PROTOCOL_DEBUG
  command_new(C_TEST, "test", "/test",
	      "Internal test function",
	      L_MOD, F_MOD, lopster_test);
#endif
}

static void create_pixmaps() {
  GtkStyle *style;

  style = gtk_widget_get_style(global.win);
  global.pix.sgreen = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.sgreenb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   speedgreen_xpm);
  global.pix.sred = gdk_pixmap_create_from_xpm_d(global.win->window,
						 &(global.pix.sredb),
						 &style->
						 bg[GTK_STATE_NORMAL],
						 speedred_xpm);
  global.pix.syellow = gdk_pixmap_create_from_xpm_d(global.win->window,
						    &(global.pix.syellowb),
						    &style->
						    bg[GTK_STATE_NORMAL],
						    speedyellow_xpm);
  global.pix.sgray = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.sgrayb),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  speedgray_xpm);

  global.pix.folder = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.folderb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   folder);
  global.pix.folder_open = gdk_pixmap_create_from_xpm_d(global.win->window,
							&(global.pix.
							  folder_openb),
							&style->
							bg
							[GTK_STATE_NORMAL],
							folder_open);
  global.pix.user1 = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.user1b),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  user_on);
  global.pix.user2 = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.user2b),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  user_off);
  global.pix.ignore = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.ignoreb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   ignore_xpm);
  global.pix.enemy = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.enemyb),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  enemy_xpm);
  global.pix.enemy2 = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.enemy2b),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   enemy2_xpm);
  global.pix.friend = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.friendb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   friend_xpm);
  global.pix.dummy = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.dummyb),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  dummy_xpm);

  global.pix.share_all = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.share_allb),
				 &style->bg[GTK_STATE_NORMAL],
				 share_all_xpm);
  global.pix.share_none = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.share_noneb),
				 &style->bg[GTK_STATE_NORMAL],
				 share_none_xpm);
  global.pix.share_part = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.share_partb),
				 &style->bg[GTK_STATE_NORMAL],
				 share_part_xpm);
  global.pix.server_con = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.server_conb),
				 &style->bg[GTK_STATE_NORMAL],
				 server_con_xpm);
  global.pix.server_ign = 
    gdk_pixmap_create_from_xpm_d(global.win->window,
				 &(global.pix.server_ignb),
				 &style->bg[GTK_STATE_NORMAL],
				 close_xpm);
}

void setup_main_tab() {
  GtkWidget *temp;
  GtkWidget *temps[8];
  int show;
  int i1;

  temp = lookup_widget(global.win, "notebook1");
  if (!global.options.tab_style)
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(temp), FALSE);
  else {
    if (global.options.tab_style & TAB_ICON)
      show = 1;
    else
      show = 0;
    temps[0] = lookup_widget(global.win, "pixmap10");
    temps[1] = lookup_widget(global.win, "pixmap1");
    temps[2] = lookup_widget(global.win, "pixmap2");
    temps[3] = lookup_widget(global.win, "pixmap3");
    temps[4] = lookup_widget(global.win, "pixmap11");
    temps[5] = lookup_widget(global.win, "pixmap5");
    temps[6] = lookup_widget(global.win, "pixmap23");
    temps[7] = lookup_widget(global.win, "pixmap42");
    for (i1 = 0; i1 < 8; i1++) {
      if (show)
	gtk_widget_show(temps[i1]);
      else
	gtk_widget_hide(temps[i1]);
    }
    if (global.options.tab_style & TAB_TEXT)
      show = 1;
    else
      show = 0;
    temps[0] = lookup_widget(global.win, "label293");
    temps[1] = lookup_widget(global.win, "note_chat");
    temps[2] = lookup_widget(global.win, "note_library");
    temps[3] = lookup_widget(global.win, "note_search");
    temps[4] = lookup_widget(global.win, "label465");
    temps[5] = lookup_widget(global.win, "note_transfer");
    temps[6] = lookup_widget(global.win, "label530");
    temps[7] = lookup_widget(global.win, "label915");
    for (i1 = 0; i1 < 8; i1++) {
      if (show)
	gtk_widget_show(temps[i1]);
      else
	gtk_widget_hide(temps[i1]);
    }
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(temp), TRUE);
  }

}

void set_title() {
  char text[1024];

  if (INTERN_MICRO_VERSION)
    sprintf(text, VERSION_STRING".%d [%d]",
	    INTERN_MICRO_VERSION, global.lnumber);
  else
    sprintf(text, VERSION_STRING" [%d]", global.lnumber);
  gtk_window_set_title(GTK_WINDOW(global.win), text);

}

static void setup_widgets() {
  GtkWidget *temp;
  int i1, i2;

  set_title();
  setup_main_tab();

  global.progressbar = lookup_widget(global.win, "progressbar4");

  temp = lookup_widget(global.win, "notebook3");
  gtk_notebook_popup_enable(GTK_NOTEBOOK(temp));

  temp = lookup_widget(global.win, "clist36");
  gtk_clist_set_compare_func(GTK_CLIST(temp), lib_compare);
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), 1);
  gtk_clist_set_selection_mode (GTK_CLIST (temp),
				GTK_SELECTION_EXTENDED);

  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);
  gtk_drag_source_set(temp, GDK_BUTTON1_MASK,
		      &(lib_list_targets[0]), 1,
		      GDK_ACTION_COPY);

  temp = lookup_widget(global.win, "ctree8");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);

  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);
  gtk_drag_source_set(temp, GDK_BUTTON1_MASK,
		      &(lib_list_targets[1]), 1,
		      GDK_ACTION_COPY);

  gtk_clist_set_compare_func(GTK_CLIST(DownloadTree[0]), download_compare);
  gtk_clist_set_compare_func(GTK_CLIST(DownloadTree[1]), download_compare2);
  gtk_clist_set_compare_func(GTK_CLIST(DownloadTree[2]), download_compare2);
  gtk_clist_set_compare_func(GTK_CLIST(DownloadTree[3]), download_compare2);

  temp = lookup_widget(global.win, "ctree10");
  gtk_clist_set_compare_func(GTK_CLIST(temp), server_compare);

  temp = lookup_widget(global.win, "clist16");
  gtk_clist_set_compare_func(GTK_CLIST(temp), hotlist_compare);
  gtk_clist_set_sort_column(GTK_CLIST(temp), 1);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_sort_type(GTK_CLIST(temp), GTK_SORT_DESCENDING);

  temp = lookup_widget(global.win, "clist43");
  gtk_clist_set_compare_func(GTK_CLIST(temp), browse_saved_compare);
  gtk_clist_set_sort_column(GTK_CLIST(temp), 1);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_sort_type(GTK_CLIST(temp), GTK_SORT_DESCENDING);

  temp = lookup_widget(global.win, "ctree3");
  gtk_clist_set_compare_func(GTK_CLIST(temp), access_compare);
  gtk_clist_set_sort_column(GTK_CLIST(temp), 1);
  //  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);

  ///////////
  // adding this stuff here, because glade 0.6.2 has a bug.
  {
    GtkAdjustment* adj;
    
    /// libaray
    temp = lookup_widget(global.win, "hscale3");
    adj = gtk_range_get_adjustment(GTK_RANGE(temp));
    temp = lookup_widget(global.win, "label2695");
    gtk_signal_connect(GTK_OBJECT(adj), "value-changed",
		       on_lib_value_changed, temp);
    gtk_adjustment_set_value (adj, global.options.lib_mark_val);
  }
  ////////////////

  i2 = global.options.access_timeout;
  if (i2 < 0) i1 = -i2;
  else i1 = i2;

  temp = lookup_widget(global.win, "spinbutton61");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), i1 / 24);
  temp = lookup_widget(global.win, "spinbutton62");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), i1 % 24);
  temp = lookup_widget(global.win, "spinbutton74");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_uploads);
  temp = lookup_widget(global.win, "spinbutton75");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_uploads);
  temp = lookup_widget(global.win, "spinbutton78");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_downloads);
  temp = lookup_widget(global.win, "spinbutton79");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_downloads);

  if (i2 > 0) {
    temp = lookup_widget(global.win, "checkbutton64");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  }
  global.options.access_timeout = i2;

  temp = lookup_widget(global.win, "transfer_up");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_compare_func(GTK_CLIST(temp), transfer_compare);
  gtk_clist_set_reorderable(GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "clist34");
  gtk_clist_set_reorderable(GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "label6");
  gtk_widget_set_style(temp, global.styles[STYLE_PREF]);
  temp = lookup_widget(global.win, "label1784");
  gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
  temp = lookup_widget(global.win, "label1785");
  gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);

  print_topright_corner();

  global.down_width.area = lookup_widget(global.win, "drawingarea1");
  global.down_width.label_max = lookup_widget(global.win, "label536");
  global.down_width.label_cur = lookup_widget(global.win, "label538");
  global.up_width.area = lookup_widget(global.win, "drawingarea2");
  global.up_width.label_max = lookup_widget(global.win, "label541");
  global.up_width.label_cur = lookup_widget(global.win, "label542");

  temp = lookup_widget(global.win, "combo_entry28");
  gtk_entry_set_text(GTK_ENTRY(temp), LifeTime(PATTERN_TEMPORARY));
  
  temp = lookup_widget(global.win, "checkbutton45");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.ping_search);

  temp = lookup_widget(global.win, "checkbutton74");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.search_show_folder);

  for (i1 = 0; i1 < G_SIZE - G_SIZE_ADD; i1++) {
    if (global.extra_win & (1 << i1)) {
      global.extra_win ^= (1 << i1);
      temp = main_tab_detach(i1);
      /*
      while (gtk_events_pending())
	gtk_main_iteration();
      */
    }
  }
  if (global.extra_win & (1 << (G_SIZE - 2))) {
    temp = search_fields_detach2();
    /*
    while (gtk_events_pending())
      gtk_main_iteration();
    */
  }
  if (global.extra_win & (1 << (G_SIZE - 1))) {
    temp = search_fields_detach();
    /*
    while (gtk_events_pending())
      gtk_main_iteration();
    */
  }
}

static void setup_buttons() {
  GtkWidget *temp;

  temp = lookup_widget(global.win, "button115");	//search
  set_up_button(temp, "pix3", "pix4", "hbox710");
  temp = lookup_widget(global.win, "button330");
  set_up_button(temp, "pixmap50", "pixmap51", "table38");
  temp = lookup_widget(global.win, "button331");
  set_up_button(temp, "pixmap52", "pixmap53", "scrolledwindow96");
}

static void setup_mime() {
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    global.mimetype[i1].download = l_strdup("");;
    global.mimetype[i1].suffixes = NULL;
  }
}

void setup_global_vars() {
  int i1;

  global.email = l_strdup("");
  global.linespeed = 0;

  global.timer = -1;
  global.lib = NULL;

  global.lnumber = 0;

  global.upload_socket = NULL;

  global.connect_win = NULL;
  global.whois_win = NULL;
  global.options_win = NULL;
  global.ban_win = NULL;
  global.usermode_win = NULL;
  global.client_win = NULL;
  global.user_win = NULL;
  global.socket_win = NULL;
  global.splash_win = NULL;
  global.string_win = NULL;
  global.file_win = NULL;
  global.queue_win = NULL;
  global.subscription_win = NULL;
  global.usermode = ModeMask[N_UNKNOWN];

  global.status.exiting = E_NONE;
  global.status.rc_read = 0;
  global.status.geometry_read = 0;
  global.status.access_read = 0;
  global.status.search_read = 0;

  global.limit.cur_uploads = 0;
  global.limit.cur_downloads = 0;
  global.limit.cur_large = 0;
  global.limit.cur_real_downloads = 0;
  global.limit.cur_real_uploads = 0;
  global.limit.min_segment_size = 256;
  global.limit.max_seek_add = 50;
  global.limit.max_uploads = 4;
  global.limit.max_downloads = 20;
  global.limit.max_large = 3;
  global.limit.large_size = 20;
  global.limit.default_uploads = 1;
  global.limit.default_downloads = 2;
  global.limit.download_percent = 0;
  global.limit.download_abort_limit = 0;
  global.limit.download_abort_number = 2;

  global.network.firewall = 0;
  global.network.transfer_timeout_up = 100;
  global.network.transfer_timeout_down = 200;
  global.network.transfer_delay = 2;
  global.network.port = 6699;

  global.options.config_dir = NULL;
  global.options.config_file = NULL;
  global.options.auto_resume = 1;
  global.options.auto_search = 1;
  global.options.allow_dcc = 0;
  global.options.access_transferring = 1;
  global.options.show_joins = 1;
  global.options.show_parts = 2;
  global.options.recent_timeout = 60;
  global.options.logging = 0;
  global.options.parse_colors = 1;
  global.options.strip_colors = 0;
  global.options.dummy_md5 = 1;
#ifdef HAVE_LIBLCONV_H
  global.options.use_iconv = 1;
  // FIXME
  global.options.dest_codeset = l_strdup("SJIS");
#endif
  global.options.popup_create = 3;
  global.options.server_motd = 0;
  global.options.log_expire = 5;	// 5 hours
  global.options.auto_retry = RETRY_INCOMPLETE|RETRY_TIMEOUT|RETRY_REMOTE;
  global.options.resume_abort[0] = 0;
  global.options.resume_abort[1] = 0;
  global.options.resume_abort[2] = 30;
  global.options.resume_abort[3] = 100;
  global.options.dl_autoremove = 0;
  global.options.ul_autoremove = REMOVE_U_ABORTED;
  global.options.timestamps = TIME_HOUR_MIN;
  global.options.tab_style = TAB_ICON | TAB_TEXT;
  global.options.channel_rejoin = 1;
  global.options.confirm_delete = 1;
  global.options.access_timeout = - 30 * 24;	// 30 days
  global.options.check_version = 1;
  global.options.piping =
    PIPE_CHWALLOP | PIPE_WALLOP | PIPE_GLOBAL | PIPE_SERVER |
    PIPE_DOWNLOAD | PIPE_UPLOAD | PIPE_PRIVATE;
  global.options.no_piping = NOPIPE_PROTOCOL1 | NOPIPE_PROTOCOL2;
  global.options.colored_nicks = 2;
  global.options.colored_nicks2 = 0;
  global.options.rejoin_when_kicked = 1;
  global.options.resume_timeout = 60;
  global.options.check_lib_for_download = 1;
  global.options.time_display = 0;
  global.options.browser = BROWSER_NETSCAPE;

  global.options.down_speed[0] = SPEED_RED;
  global.options.down_speed[1] = SPEED_YELLOW;
  global.options.down_speed[2] = SPEED_GREEN;
  global.options.up_speed[0] = SPEED_RED2;
  global.options.up_speed[1] = SPEED_YELLOW2;
  global.options.up_speed[2] = SPEED_GREEN2;

  global.options.lib_mark_val=0;
  global.options.graph_smooth[0] = 5;
  global.options.graph_smooth[1] = 5;
  global.options.graph_interval[0] = 0;
  global.options.graph_interval[1] = 0;
  global.options.graph_mode[0] = 2;
  global.options.graph_mode[1] = 2;
  global.options.graph_show[0] = 2;
  global.options.graph_show[1] = 2;
  global.options.ping_search=0;
  global.options.search_show_folder=1;
  global.options.max_chat_buffer = 30;
  global.napigator.use_proxy = 0;
  global.napigator.proxy_url = NULL;
  global.napigator.proxy_port = 3128;

  for (i1 = 0; i1 < STRING_LIST_NO; i1++)
    global.string_list[i1] = NULL;
  global.commands = NULL;
  global.scheme = NULL;
  global.chat_history = NULL;
  global.afk.message = NULL;
  global.afk.auto_afk = 0;
  global.afk.warn_afk = 1;
  global.user_reply.user = NULL;
  global.user_reply.net = NULL;
  global.incomplete_path = NULL;
  global.incomplete = NULL;
  global.clones = NULL;
  global.client_list = NULL;
  global.sockets = NULL;
  global.browses = NULL;
  global.extra_win = 0;
  global.chat_pages = NULL;
  global.searches = NULL;
  global.hotlist = NULL;
  global.appearance = NULL;
  global.userstamp = NULL;
  global.whois_requests = NULL;
  global.speed_requests = NULL;
  global.reconnect_timer = -1;
  global.resume_timer = -1;
  global.my_ip = INADDR_NONE;
  global.path_warned = 0;
#ifdef ENABLE_WHITE_BOARD
  global.whiteboards = NULL;
#endif
  global.net_groups = NULL;
  global.net_active = NULL;
  global.server_check = -1;    // unused
  global.current_page = NULL;
  global.reply_page = NULL;    // unused for the moment
  global.resume_saver = -1;

  global.down_width.limit = 1024 * 1024;
  global.down_width.value = 0;
  global.down_width.maxval = 1024 * 1024;
  global.down_width.bytes[0] = 0;
  global.down_width.bytes[1] = 0;
  global.down_width.pixmap = NULL;
  global.down_width.area = NULL;
  global.down_width.label_cur = NULL;
  global.down_width.label_max = NULL;
  global.up_width.limit = 1024 * 128;
  global.up_width.value = 0;
  global.up_width.maxval = 1024 * 128;
  global.up_width.bytes[0] = 0;
  global.up_width.bytes[1] = 0;
  global.up_width.pixmap = NULL;
  global.up_width.area = NULL;
  global.up_width.label_cur = NULL;
  global.up_width.label_max = NULL;

  global.search_width[0] = 10;
  global.search_width[1] = 462;
  global.search_width[2] = 80;
  global.search_width[3] = 80;
  global.search_width[4] = 80;
  global.search_width[5] = 80;
  global.search_width[6] = 80;
  global.search_width[7] = 80;
  global.search_width[8] = 80;
  for (i1 = 0; i1 < 9; i1++)
    global.search_show[i1] = 1;

  global.rainbow_colors = l_strdup("RrpPBbcCgGYy");
  global.allowed_ports = NULL;

  global.auto_save = NULL;
  global.ping_command = l_strdup("/bin/ping -c 3 $IP");

  global.browse_width[0] = 369;
  global.browse_width[1] = 80;
  global.browse_width[2] = 80;
  global.browse_width[3] = 80;
  global.browse_width[4] = 80;
  for (i1 = 0; i1 < 5; i1++)
    global.browse_show[i1] = 1;

  global.channel_width[0] = 150;
  global.channel_width[1] = 80;
  global.channel_width[2] = 80;
  global.channel_width[3] = 80;
  global.channel_width[4] = 80;
  for (i1 = 0; i1 < 5; i1++)
    global.channel_show[i1] = 1;

  global.online_width[0] = 100;
  global.online_width[1] = 30;
  global.online_width[2] = 60;
  for (i1 = 0; i1 < 3; i1++)
    global.online_show[i1] = 1;

  global.channel_paned = 730;
  global.server_paned = 150;

  for (i1 = 0; i1 < G_SIZE; i1++)
    global.geometry[i1].x = global.geometry[i1].y =
      global.geometry[i1].width = global.geometry[i1].height = -1;

  global.options.retry_timeout[0] = 10;
  global.options.retry_timeout[1] = 300;
  global.options.retry_timeout[2] = 10;
  global.options.retry_timeout[3] = 300;
  global.options.retry_timeout[4] = 300;

  global.userinfo = NULL;
  global.options.upload_priority[PRI_FRIEND] = 1;
  global.options.upload_priority[PRI_DOWNLOAD] = 1;
  global.options.upload_priority[PRI_SHARE] = 1;
  global.options.upload_priority[PRI_NONE] = 0;

  global.options.config_dir = NULL;
  global.options.autoconnect_sendqueue_limit = 200;

  global.external_handler = NULL;
  global.external_events = 0;

  global.bannet = NULL;
  global.options.search_timeout = SEARCH_TIMEOUT;

  global.dl_layout.ctree_position[0] = 0;
  global.dl_layout.ctree_position[1] = 1;
  global.dl_layout.ctree_position[2] = 2;
  global.dl_layout.ctree_position[3] = 3;
  global.dl_layout.transfer_position[0] = 0;
  global.dl_layout.transfer_position[1] = 1;
  global.dl_layout.transfer_position[2] = 2;
  global.dl_layout.transfer_position[3] = 3;
}

static void setup_styles() {
  //  GdkFont* font;

  global.styles[STYLE_TAB1] = gtk_widget_get_style(global.win);

  global.styles[STYLE_TAB2] = gtk_style_new();
  global.styles[STYLE_TAB2]->font = global.styles[STYLE_TAB1]->font;
  global.styles[STYLE_TAB2]->fg[GTK_STATE_NORMAL].pixel =
    global.styles[STYLE_TAB1]->fg[GTK_STATE_SELECTED].pixel;
  global.styles[STYLE_TAB2]->fg[GTK_STATE_NORMAL].red = 65535;
  global.styles[STYLE_TAB2]->fg[GTK_STATE_NORMAL].green = 0;
  global.styles[STYLE_TAB2]->fg[GTK_STATE_NORMAL].blue = 0;

  global.styles[STYLE_LABEL] = gtk_style_new();
  global.styles[STYLE_LABEL]->font = global.styles[STYLE_TAB1]->font;  
  global.styles[STYLE_LABEL]->fg[GTK_STATE_NORMAL].red = 0;
  global.styles[STYLE_LABEL]->fg[GTK_STATE_NORMAL].green = 0;
  global.styles[STYLE_LABEL]->fg[GTK_STATE_NORMAL].blue = 63535;

  global.styles[STYLE_PREF] = gtk_style_new();
  global.styles[STYLE_PREF]->font = global.styles[STYLE_TAB1]->font;  
  global.styles[STYLE_PREF]->fg[GTK_STATE_NORMAL].red = 63535;
  global.styles[STYLE_PREF]->fg[GTK_STATE_NORMAL].green = 0;
  global.styles[STYLE_PREF]->fg[GTK_STATE_NORMAL].blue = 0;
}

void global_init() {
  char str[2048];

  global.current_time = time(NULL);
  global.afk.since = global.current_time;

  //
  DownloadTree[0] = GTK_CTREE(lookup_widget(global.win, "ctree4"));
  DownloadTree[1] = GTK_CTREE(lookup_widget(global.win, "ctree11"));
  DownloadTree[2] = GTK_CTREE(lookup_widget(global.win, "ctree5"));
  DownloadTree[3] = GTK_CTREE(lookup_widget(global.win, "ctree12"));
  DownloadScroll[0] = lookup_widget(global.win, "scrolledwindow92");
  DownloadScroll[1] = lookup_widget(global.win, "scrolledwindow107");
  DownloadScroll[2] = lookup_widget(global.win, "scrolledwindow93");
  DownloadScroll[3] = lookup_widget(global.win, "scrolledwindow108");
  DownloadVbox[0] = lookup_widget(global.win, "vbox231");
  DownloadVbox[1] = lookup_widget(global.win, "vbox232");
  DownloadVbox[2] = lookup_widget(global.win, "vbox195");
  DownloadVbox[3] = lookup_widget(global.win, "vbox233");

  advance_progress("Setting up lopster styles...", 0.15);
  setup_styles();

  if (!global.options.config_dir)
    global.options.config_dir = l_strdup_printf("%s/.lopster", g_get_home_dir());
  
  if (!global.options.config_file)
    global.options.config_file = 
      l_strdup_printf("%s/lopsterrc", global.options.config_dir);

  //  printf("lopsterhome [%s]\n", global.options.config_dir);
  sprintf(str, "%s%clog", global.options.config_dir, DIR_SEP);
  create_dir(str);
  sprintf(str, "%s%cschemes", global.options.config_dir, DIR_SEP);
  create_dir(str);
  sprintf(str, "%s%cshare", global.options.config_dir, DIR_SEP);
  create_dir(str);
  sprintf(str, "%s%cbrowse", global.options.config_dir, DIR_SEP);
  create_dir(str);
  sprintf(str, "%s%cchannels", global.options.config_dir, DIR_SEP);
  create_dir(str);

  global.start_time = global.current_time;
  global.session_start = l_strdup(ctime(&global.start_time));
  global.session_start[strlen(global.session_start) - 1] = 0;

  printf("Lopster started at %s\n", global.session_start);

  gdk_color_parse("#ffffff", &global.color_table[0]);	// W
  gdk_color_parse("#000000", &global.color_table[1]);	// Bl
  gdk_color_parse("#0000aa", &global.color_table[2]);	// b_
  gdk_color_parse("#00aa00", &global.color_table[3]);	// g_
  gdk_color_parse("#aa0000", &global.color_table[4]);	// r_
  gdk_color_parse("#aa5500", &global.color_table[5]);	// y_
  gdk_color_parse("#aa00aa", &global.color_table[6]);	// p_
  gdk_color_parse("#ff5555", &global.color_table[7]);	// R_
  gdk_color_parse("#ffff55", &global.color_table[8]);	// Y_
  gdk_color_parse("#55ff55", &global.color_table[9]);	// G
  gdk_color_parse("#00aaaa", &global.color_table[10]);	// c
  gdk_color_parse("#55ffff", &global.color_table[11]);	// C
  gdk_color_parse("#5555ff", &global.color_table[12]);	// B_
  gdk_color_parse("#ff55ff", &global.color_table[13]);	// P_
  gdk_color_parse("#555555", &global.color_table[14]);	//dG
  gdk_color_parse("#aaaaaa", &global.color_table[15]);	// w_


  // creating pixmaps
  advance_progress("Creating pixmaps...", 0.19);
  create_pixmaps();

  advance_progress("Initializing file tooltips...", 0.23);
  filetips_init();

  advance_progress("Reading geometry...", 0.27);
  read_geometry();

  // setting up
  advance_progress("Reading link-file...", 0.31);
  read_allowed_links();

  // setting up signal handlers
  advance_progress("Setting up signal handlers...", 0.35);

  signal(SIGPIPE, SIG_IGN);
  //  signal(SIGPIPE, sigpipe_handler);
  signal(SIGSEGV, sigseg_handler);

  //  signal(SIGCHLD, sigchld_handler);

  // setting up commands
  advance_progress("Setting up commands...", 0.39);
  setup_commands();

  // setting up show/hide buttons
  advance_progress("Setting up togglebuttons...", 0.43);
  setup_buttons();

  //
  advance_progress("Setting up mimetypes...", 0.47);
  setup_mime();
  
  // reading rc file
  advance_progress("Reading rc-file...", 0.51);
  read_rc();
  {
    ping_configure(600, 20, global.ping_command);
    ping_set_funcs(ping_update, client_message);

    retry_timeout_check();
  }

  advance_progress("Reading server list...", 0.55);
  server_load();

  advance_progress("Checking allowed ports...", 0.59);
  if (!global.allowed_ports) {
    global.allowed_ports = create_allowed_ports("6680-6699");
  }

  // always insert the mp3 suffix
  advance_progress("Checking for mimetype mp3...", 0.63);
  if (!check_suffix(".mp3", MIME_MP3)) {
    suffix_t *suffix;

    suffix = (suffix_t *) l_malloc(sizeof(suffix_t));
    suffix->suffix = l_strdup("mp3");
    suffix->application = l_strdup("");
    suffix->as_mp3 = 1;
    global.mimetype[MIME_MP3].suffixes =
      g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
  }

  // setting up some GtkWidgets
  advance_progress("Setting up widgets...", 0.67);
  setup_widgets();

  // creating  listening port
  advance_progress("Creating dataport...", 0.71);
  create_upload_port(global.network.port, TRUE);

  // loading resume list
  advance_progress("Loading incomplete files...", 0.75);
  sprintf(str, "%s/incomplete.list", global.options.config_dir);
  resume_load(str, 0);

  // loading saved searches
  advance_progress("Loading search patterns...", 0.80);
  search_pattern_load();

  advance_progress("Loading subscriptions...", 0.83);
  subscription_load();

  advance_progress("Loading saved browse list...", 0.84);
  browse_load_saved_list();

  update_status_line();
  update_reply(NULL, NULL, 0);

  advance_progress("Initializing statistic...", 0.85);
  user_info_load();
  statistic_init(&global.statistic);
  
  advance_progress("Invoking startup processes...", 0.95);
  gtk_idle_add(idle_function, NULL);
}

void global_exit() {
  transfer_cancel_running();
  
  if (global.status.access_read) {
    user_info_save();
    access_save();
  }
  if (global.status.geometry_read)
    server_save();

  extra_win_get_geometry();

  if (global.timer >= 0)
    gtk_timeout_remove(global.timer);

  // destroying all sockets
  
  exec_shutdown();

  if (global.status.rc_read) write_rc();

  if (global.status.geometry_read) write_geometry();

  statistic_log(&global.statistic);

  write_allowed_links();

  // deleting commands
  command_delete_all();

  gtk_main_quit();
}


gint
channel_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if ((clist->sort_column == 4) || (clist->sort_column == 0)) {
    return l_strcasecmp(text1, text2);
  } else if ((clist->sort_column == 1) ||
	     (clist->sort_column == 2) || (clist->sort_column == 3)) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2)
      return -1;
    if (u1 > u2)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

gint browse_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2)
{
  file_t *file1;
  file_t *file2;
  file_node_t *node1;
  file_node_t *node2;
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  if (clist->sort_column == 0) {
    text1 = GTK_CELL_TEXT(row1->cell[0])->text;
    text2 = GTK_CELL_TEXT(row2->cell[0])->text;
    if (!text2)
      return (text1 != NULL);
    if (!text1)
      return -1;
    return l_strcasecmp(text1, text2);
  }

  
  node1 = row1->data;
  node2 = row2->data;
  if (!node2) return (node1 != NULL);
  if (!node1) return -1;

  file1 = node1->file;
  file2 = node2->file;
  if (!file2) return (file1 != NULL);
  if (!file1) return -1;

  if (clist->sort_column == 1) {
    if (file1->size < file2->size)
      return -1;
    if (file1->size > file2->size)
      return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    if (file1->bitrate < file2->bitrate)
      return -1;
    if (file1->bitrate > file2->bitrate)
      return 1;
    return 0;
  } else if (clist->sort_column == 3) {
    if (file1->frequency < file2->frequency)
      return -1;
    if (file1->frequency > file2->frequency)
      return 1;
    return 0;
  } else if (clist->sort_column == 4) {
    if (file1->duration < file2->duration)
      return -1;
    if (file1->duration > file2->duration)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

gint browse_saved_compare(GtkCList * clist,
			  gconstpointer ptr1, gconstpointer ptr2)
{
  file_tree_t *browse1;
  file_tree_t *browse2;
  
  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  browse1 = row1->data;
  browse2 = row2->data;
  if (!browse2) return (browse1 != NULL);
  if (!browse1) return -1;

  if (clist->sort_column == 0) {
    return strcasecmp(browse1->name, browse2->name);
  } else if (clist->sort_column == 1) {
    if (browse1->fci[MIME_SIZE][3] <
	browse2->fci[MIME_SIZE][3])
      return -1;
    if (browse1->fci[MIME_SIZE][3] >
	browse2->fci[MIME_SIZE][3])
      return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    if (browse1->last_refreshed < browse2->last_refreshed)
      return -1;
    if (browse1->last_refreshed > browse2->last_refreshed)
      return 1;
    return 0;
  } else if (clist->sort_column == 3) {
    if (!browse1->description) return 1;
    else if (!browse2->description) return -1;
    else return strcasecmp(browse1->description,
			   browse2->description);
  } else {
    return 0;
  }
}

gint lib_compare(GtkCList * clist,
		 gconstpointer ptr1, gconstpointer ptr2)
{
  file_t *file1;
  file_t *file2;
  file_node_t *node1;
  file_node_t *node2;
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  if (clist->sort_column == 0) {
    text1 = GTK_CELL_TEXT(row1->cell[0])->text;
    text2 = GTK_CELL_TEXT(row2->cell[0])->text;
    if (!text2)
      return (text1 != NULL);
    if (!text1)
      return -1;
    return l_strcasecmp(text1, text2);
  }

  
  node1 = row1->data;
  node2 = row2->data;
  if (!node2) return (node1 != NULL);
  if (!node1) return -1;

  file1 = node1->file;
  file2 = node2->file;
  if (!file2) return (file1 != NULL);
  if (!file1) return -1;

  if (clist->sort_column == 1) {
    if (file1->size < file2->size)
      return -1;
    if (file1->size > file2->size)
      return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    if (file1->bitrate < file2->bitrate)
      return -1;
    if (file1->bitrate > file2->bitrate)
      return 1;
    return 0;
  } else if (clist->sort_column == 3) {
    if (file1->frequency < file2->frequency)
      return -1;
    if (file1->frequency > file2->frequency)
      return 1;
    return 0;
  } else if (clist->sort_column == 4) {
    if (file1->duration < file2->duration)
      return -1;
    if (file1->duration > file2->duration)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

gint socket_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2)
{
  socket_t *socket1;
  socket_t *socket2;
  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  socket1 = row1->data;
  if (!socket1) return 0;
  socket2 = row2->data;
  if (!socket2) return 0;

  switch (clist->sort_column) {
  case 0:
    if (socket1->type < socket2->type) return -1;
    if (socket1->type > socket2->type) return 1;
    return 0;
  case 1:
    if (ntohl(socket1->ip_long) < ntohl(socket2->ip_long))
      return -1;
    if (ntohl(socket1->ip_long) > ntohl(socket2->ip_long))
      return 1;
    return 0;
  case 2:
    if (ntohs(socket1->port) < ntohs(socket2->port))
      return -1;
    if (ntohs(socket1->port) > ntohs(socket2->port))
      return 1;
    return 0;
  case 3:
    if (ntohs(socket1->cnt) < ntohs(socket2->cnt))
      return -1;
    if (ntohs(socket1->cnt) > ntohs(socket2->cnt))
      return 1;
    return 0;
  case 4:
    if (ntohs(socket1->fd) < ntohs(socket2->fd))
      return -1;
    if (ntohs(socket1->fd) > ntohs(socket2->fd))
      return 1;
    return 0;
  case 5:
    if (ntohs(socket1->timer) < ntohs(socket2->timer))
      return -1;
    if (ntohs(socket1->timer) > ntohs(socket2->timer))
      return 1;
    return 0;
  }  
  return 0;
}

gint transfer_compare(GtkCList * clist,
		      gconstpointer ptr1, gconstpointer ptr2)
{

  socket_t *socket;
  upload_t *upload1;
  upload_t *upload2;
  file_t* file1;
  file_t* file2;
  user_info_t* userinfo1;
  user_info_t* userinfo2;
  double p1, p2;
  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;
  long s1, s2;

  socket = row1->data;
  if (!socket) return 0;
  upload1 = socket->data;
  if (!upload1) return 0;
  socket = row2->data;
  upload2 = socket->data;
  if (!upload2) return 0;
  file1 = upload1->file;
  file2 = upload2->file;
  userinfo1 = upload1->data->user_info;
  userinfo2 = upload2->data->user_info;

  switch (clist->sort_column) {
  case 0:
    return l_strcasecmp(file1->shortname, file2->shortname);
    break;
  case 1:
    if (upload1->segment) s1 = upload1->segment->stop - upload1->segment->size;
    else if (upload1->file) s1 = upload1->file->size;
    else s1 = 0;
    if (upload2->segment) s2 = upload2->segment->stop - upload2->segment->size;
    else if (upload2->file) s2 = upload2->file->size;
    else s2 = 0;
    if (s1 < s2) return -1;
    if (s1 > s2) return 1;
    return 0;
    break;
  case 2:
    return l_strcasecmp(userinfo1->nick, userinfo2->nick);
    break;
  case 3:
    if (upload1->data->status < upload2->data->status)
      return -1;
    if (upload1->data->status > upload2->data->status)
      return 1;
    return 0;
    
  case 4:
    if (userinfo1->linespeed < userinfo2->linespeed)
      return -1;
    if (userinfo1->linespeed > userinfo2->linespeed)
      return 1;
    return 0;
    break;
  case 5:
    if (!upload2->segment) return (upload1->segment != NULL);
    if (!upload1->segment) return -1;
    if (upload1->segment->size)
      p1 = (double) upload1->segment->size /
	(double) (upload1->segment->stop-upload1->segment->start);
    else p1 = 0;
    if (upload2->segment->size)
      p2 = (double) upload2->segment->size /
	(double) (upload2->segment->stop-upload2->segment->start);
    else
      p2 = 0;
    if (p1 < p2) return -1;
    if (p1 > p2) return 1;
    return 0;
    break;
  case 6:
    if (upload1->data->rate < upload2->data->rate)
      return -1;
    if (upload1->data->rate > upload2->data->rate)
      return 1;
    return 0;
    break;
  case 7:
    if (upload1->data->timeleft < upload2->data->timeleft)
      return -1;
    if (upload1->data->timeleft > upload2->data->timeleft)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint trans_comp(download_t * t1, download_t * t2, int col) {
  file_segment_t* seg1 = NULL;
  file_segment_t* seg2 = NULL;
  double p1, p2;

  if (!t1) return 0;
  if (!t2) return 0;

  if (t1->csegment) seg1 = t1->csegment->data;
  else seg1 = NULL;
  if (t2->csegment) seg2 = t2->csegment->data;
  else seg1 = NULL;
  
  switch (col) {
  case 0:
    l_strcasecmp(t1->file->filename, t2->file->filename);
    break;
  case 1:
    if (!seg1 || !seg2) return 0;
    if (seg1->stop-seg1->start < seg2->stop-seg2->start)
      return -1;
    if (seg1->stop-seg1->start > seg2->stop-seg2->start)
      return 1;
    return 0;
    break;
  case 2:
    return l_strcasecmp(t1->data->user_info->nick,
			t2->data->user_info->nick);
    break;
  case 3:
    if (t1->data->user_info->linespeed < t2->data->user_info->linespeed)
      return -1;
    if (t1->data->user_info->linespeed > t2->data->user_info->linespeed)
      return 1;
    return 0;
    break;
  case 4:
    if (t1->data->status < t2->data->status)
      return 1;
    if (t1->data->status > t2->data->status)
      return -1;
    if (!seg1 || !seg2) return 0;
    p1 = (double)(seg1->size)*100/(double)(seg1->stop - seg1->start);
    p2 = (double)(seg2->size)*100/(double)(seg2->stop - seg2->start);
    if (p1 < p2) return -1;
    if (p1 > p2) return 1;
    return 0;
    break;
  case 5:
    if (t1->data->rate < t2->data->rate)
      return -1;
    if (t1->data->rate > t2->data->rate)
      return 1;
    return 0;
    break;
  case 6:
    if (t1->data->timeleft < t2->data->timeleft)
      return -1;
    if (t1->data->timeleft > t2->data->timeleft)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint trans_comp2(download_t * t1, download_t * t2, int col)
{
  
  file_segment_t* seg1 = NULL;
  file_segment_t* seg2 = NULL;
  double p1, p2;

  if (!t1) return 0;
  if (!t2) return 0;
  if (t1->csegment) seg1 = t1->csegment->data;
  if (t2->csegment) seg2 = t2->csegment->data;

  switch (col) {
  case 0:
    return l_strcasecmp(t1->file->filename, t2->file->filename);
    break;
  case 1:
    if (!seg1 || !seg2) return 0;
    if (seg1->stop-seg1->start < seg2->stop-seg2->start)
      return -1;
    if (seg1->stop-seg1->start > seg2->stop-seg2->start)
      return 1;
    return 0;
    break;
  case 2:
    return l_strcasecmp(t1->data->user_info->nick, 
			t2->data->user_info->nick);
    break;
  case 3:
    if (t1->data->status < t2->data->status)
      return -1;
    if (t1->data->status > t2->data->status)
      return 1;
    if (!seg1 || !seg2) return 0;
    p1 = (double)(seg1->size)*100/(double)(seg1->stop - seg1->start);
    p2 = (double)(seg2->size)*100/(double)(seg2->stop - seg2->start);
    if (p1 < p2) return -1;
    if (p1 > p2) return 1;
    return 0;
    break;
  }
  return 0;
}

gint resume_comp(resume_t * r1, resume_t * r2, int col)
{
  double p1, p2;
  int l1, l2;

  if (!r1)
    return 0;
  if (!r2)
    return 0;

  switch (col) {
  case 0:
    return l_strcasecmp(get_file_name(r1->filename),
			get_file_name(r2->filename));
    break;
  case 1:
    if (r1->comp_size < r2->comp_size)
      return -1;
    if (r1->comp_size > r2->comp_size)
      return 1;
    return 0;
    break;
  case 2:
    if (r1->search)
      l1 = sarray_size(r1->search->results);
    else l1 = 0;
    if (r2->search)
      l2 = sarray_size(r2->search->results);
    else l2 = 0;
    if (l1 < l2) return -1;
    if (l1 > l2) return 1;
    return 0;
    break;
  case 3:
    if (r1->active < r2->active) return -1;
    if (r1->active > r2->active) return 1;
    return 0;
  case 4:
    if (r1->comp_size)
      p1 = (double) r1->inc_size / (double) r1->comp_size;
    else
      p1 = 0;
    if (r2->comp_size)
      p2 = (double) r2->inc_size / (double) r2->comp_size;
    else
      p2 = 0;
    if (p1 < p2) return -1;
    if (p1 > p2) return 1;
    return 0;
    break;
  case 5:
    return 0;
    break;
  case 6:
    return 0;
    break;
  }
  return 0;
}

gint resume_comp2(resume_t * r1, resume_t * r2, int col)
{
  double p1, p2;
  int l1, l2;
  time_t tim1;
  time_t tim2;

  if (!r1)
    return 0;
  if (!r2)
    return 0;

  switch (col) {
  case 0:
    return l_strcasecmp(get_file_name(r1->filename),
			get_file_name(r2->filename));
    break;
  case 1:
    if (r1->comp_size < r2->comp_size)
      return -1;
    if (r1->comp_size > r2->comp_size)
      return 1;
    return 0;
    break;
  case 2:
    if (r1->search)
      l1 = sarray_size(r1->search->results);
    else
      l1 = 0;
    if (r2->search)
      l2 = sarray_size(r2->search->results);
    else
      l2 = 0;
    if (l1 < l2)
      return -1;
    if (l1 > l2)
      return 1;
    return 0;
    break;
  case 3:
    if (r1->comp_size)
      p1 = (double) r1->inc_size / (double) r1->comp_size;
    else
      p1 = 0;
    if (r2->comp_size)
      p2 = (double) r2->inc_size / (double) r2->comp_size;
    else
      p2 = 0;
    if (p1 < p2) return -1;
    if (p1 > p2) return 1;
    return 0;
    break;
  case 4:
    tim1 = resume_time_of_death(r1);
    tim2 = resume_time_of_death(r2);
    if (tim2 == 0) return 1;
    if (tim1 == 0) return -1;
    if (tim2 == 1) return -1;
    if (tim1 == 1) return 1;
    if (r1->last_access+tim1 < r2->last_access+tim2)
      return -1;
    if (r1->last_access+tim1 > r2->last_access+tim2)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint download_compare(GtkCList * clist ATTR_UNUSED,
		      gconstpointer ptr1 ATTR_UNUSED, gconstpointer ptr2 ATTR_UNUSED)
{
  resume_t *resume1;
  resume_t *resume2;
  socket_t *socket1;
  socket_t *socket2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  GtkCTreeRow *rowt1 = (GtkCTreeRow *) ptr1;
  GtkCTreeRow *rowt2 = (GtkCTreeRow *) ptr2;

  if ((rowt1->parent && !rowt2->parent) ||
      (!rowt1->parent && rowt2->parent))
    return 0;

  if (rowt1->parent) {
    socket1 = row1->data;
    socket2 = row2->data;
    return trans_comp(socket1->data, socket2->data, clist->sort_column);
  } else {
    resume1 = row1->data;
    resume2 = row2->data;

    return resume_comp(resume1, resume2, clist->sort_column);
  }
}

gint download_compare2(GtkCList * clist ATTR_UNUSED,
		       gconstpointer ptr1 ATTR_UNUSED, gconstpointer ptr2 ATTR_UNUSED)
{
  resume_t *resume1;
  resume_t *resume2;
  socket_t *socket1;
  socket_t *socket2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  GtkCTreeRow *rowt1 = (GtkCTreeRow *) ptr1;
  GtkCTreeRow *rowt2 = (GtkCTreeRow *) ptr2;

  if ((rowt1->parent && !rowt2->parent) ||
      (!rowt1->parent && rowt2->parent))
    return 0;

  if (rowt1->parent) {
    socket1 = row1->data;
    socket2 = row2->data;
    return trans_comp2(socket1->data, socket2->data, clist->sort_column);
  } else {
    resume1 = row1->data;
    resume2 = row2->data;
    return resume_comp2(resume1, resume2, clist->sort_column);
  }
}

gint hotlist_compare(GtkCList * clist,
		     gconstpointer ptr1, gconstpointer ptr2)
{

  hot_t *hot1;
  hot_t *hot2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  hot1 = row1->data;
  if (!hot1) return 0;
  hot2 = row2->data;
  if (!hot2) return 0;

  switch (clist->sort_column) {
  case 0:
    if ((!hot1->nets && !hot2->nets) ||
	(hot1->nets && hot2->nets)) {
      return l_strcasecmp(hot1->user, hot2->user);
    } else {
      if (hot2->nets) return -1;
      if (hot1->nets) return 1;
    }
    break;
  case 1:
    if (hot1->nets && hot2->nets) {
      if (hot1->speed < hot2->speed) return -1;
      if (hot1->speed > hot2->speed) return 1;
    } else {
      if (hot2->nets) return -1;
      if (hot1->nets) return 1;
    }
    return 0;
    break;
  }
  return 0;
}

gint access_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2)
{

  access_t *ac1;
  access_t *ac2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  ac1 = row1->data;
  if (!ac1)
    return 0;
  ac2 = row2->data;
  if (!ac2)
    return 0;

  switch (clist->sort_column) {
  case 0:
    return l_strcasecmp(ac1->name, ac2->name);
    break;
  case 1:
    if (ac1->done < ac2->done) return -1;
    if (ac1->done > ac2->done) return 1;
    if (ac1->accesses < ac2->accesses) return -1;
    if (ac1->accesses > ac2->accesses) return 1;
    return 0;
    break;
  case 2:
    if (ac1->last < ac2->last)
      return -1;
    if (ac1->last > ac2->last)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint
client_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 1) {
    return l_strcasecmp(text1, text2);
  } else if (clist->sort_column == 0) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2)
      return -1;
    if (u1 > u2)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

void make_list_from_string(GList ** glist, char *text, char *sep)
{
  char *pos2;
  GList *dlist;

  for (dlist = *glist; dlist; dlist = dlist->next) {
    l_free(dlist->data);
  }
  if (*glist)
    g_list_free(*glist);
  *glist = NULL;

  pos2 = strtok(text, sep);
  while (pos2) {
    if (*pos2) *glist = g_list_append(*glist, l_strdup(pos2));
    pos2 = strtok(NULL, sep);
  }
}

char *make_string_from_list(GList * glist, char *sep)
{
  static char result[2048];
  char *text;
  GList *dlist;

  result[0] = 0;
  if (glist == NULL) return result;

  for (dlist = glist; dlist; dlist = dlist->next) {
    text = (char *) (dlist->data);
    if (*result) strcat(result, sep);
    strcat(result, text);
  }

  return result;
}

void clones_clear()
{
  GList *dlist;
  GList *dlist2;
  clone_t *clone;

  for (dlist = global.clones; dlist; dlist = dlist->next) {
    clone = (clone_t *) (dlist->data);
    for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
      l_free(dlist2->data);
    }
    g_list_free(clone->nicks);
    l_free(clone->ip);
    l_free(clone);
  }
  g_list_free(global.clones);
  global.clones = NULL;
}

client_t *is_client_in_list(GList * glist, char *t)
{
  GList *dlist;
  client_t *client;

  dlist = g_list_first(glist);
  while (dlist) {
    client = (client_t *) (dlist->data);
    if (!strcmp(t, client->info) && (client->cnt > 0))
      return client;
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char *is_string_in_list(GList * glist, char *t)
{
  GList *dlist;
  char *text;

  dlist = g_list_first(glist);

  while (dlist) {
    text = (char *) (dlist->data);
    if (!l_strcasecmp(t, text)) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char *is_prefix_in_list(GList * glist, char *t)
{
  GList *dlist;
  char *text;

  dlist = g_list_first(glist);

  //  printf("user: %s\n", t);
  while (dlist) {
    text = (char *) (dlist->data);
    //    printf("%s\n", text);
    if (t == NULL)
      return text;
    if (!strncasecmp(t, text, strlen(t))) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

int cmp_str(char *s1, char *s2)
{
  int i1, len;

  i1 = strlen(s1);
  len = strlen(s2);

  if (i1 < len)
    len = i1;

  for (i1 = 0; i1 < len; i1++) {
    if (toupper(s1[i1]) != toupper(s2[i1]))
      break;
  }
  return i1;
}

int calc_list_prefix(GList * glist)
{
  int res;
  int temp;
  char *text;

  if (!glist) return 0;

  text = glist->data;
  res = strlen(text);

  for (; glist; glist = glist->next) {
    temp = cmp_str(glist->data, text);
    if (temp < res) res = temp;
  }
  return res;
}

int calc_command_prefix(GList * glist)
{
  int res;
  int temp;
  char *text;
  command_t *command;
  
  if (!glist) return 0;

  command = glist->data;
  text = command->name;
  res = strlen(text);

  for ( ; glist; glist = glist->next) {
    command = glist->data;
    temp = cmp_str(command->name, text);
    if (temp < res) res = temp;
  }
  return res;
}

void play_file(char *filename) {
  char *command;
  suffix_t *suffix;
  struct stat st;

  //  printf("checking file [%s]\n", filename);
  if (stat(filename, &st) < 0)
    return;

  suffix = get_suffix(filename);
  if (!suffix) {
    openfile_dialog("Cannot open file: Unknown Suffix");
    return;
  }
  if (!suffix->application || (suffix->application[0] == 0)) {
    command =
      l_strdup_printf("Cannot open file [%s]\nNo application specified for suffix [%s]",
		      get_file_name(filename), suffix->suffix);
    openfile_dialog(command);
    l_free(command);
    return;
  }

  exec_command_safe(0, 0, suffix->application, filename, 0);
}

void set_button_state(GtkWidget * button, int open)
{
  GtkWidget *temp;

  if (open) {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_hide(temp);
    temp =
      GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_show(temp);
    temp =
      GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_show(temp);
  } else {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_show(temp);
    temp =
      GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_hide(temp);
    temp =
	GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_hide(temp);
  }
}

int toggle_button_state(GtkWidget * button)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));

  if (GTK_WIDGET_VISIBLE(temp)) {
    set_button_state(button, 0);
    return 0;
  } else {
    set_button_state(button, 1);
    return 1;
  }
}

void set_up_button(GtkWidget * button, char *pix1, char *pix2, char *wid)
{
  GtkObject *obj;
  GtkWidget *temp;

  obj = GTK_OBJECT(button);
  temp = lookup_widget(button, pix1);
  gtk_object_set_data(obj, "pix_open", temp);
  temp = lookup_widget(button, pix2);
  gtk_object_set_data(obj, "pix_closed", temp);
  temp = lookup_widget(button, wid);
  gtk_object_set_data(obj, "con_widget", temp);
}

void set_up_button2(GtkWidget * button,
		    GtkWidget * pix1, GtkWidget * pix2, GtkWidget * wid)
{
  GtkObject *obj;

  obj = GTK_OBJECT(button);
  gtk_object_set_data(obj, "pix_open", pix1);
  gtk_object_set_data(obj, "pix_closed", pix2);
  gtk_object_set_data(obj, "con_widget", wid);
}

void show_bans(net_t* net, char *channel)
{
  GtkWidget *temp;
  char str[1024];
  char *data;

  if (!net) return;

  if (global.ban_win) {
    temp = lookup_widget(global.ban_win, "clist3");
    gtk_clist_clear(GTK_CLIST(temp));
  } else {
    global.ban_win = create_ban_win();
    gtk_widget_show(global.ban_win);
  }

  // copy channel string, cause it could be a pointer to the
  // freed memory in the following 2 lines
  if (channel) channel = l_strdup(channel);

  data = gtk_object_get_data(GTK_OBJECT(global.ban_win), "channel");
  if (data) l_free(data);
  gtk_object_set_data(GTK_OBJECT(global.ban_win), "network", net);

  if (channel) {
    sprintf(str, "Banned Users for Channel %s on %s", channel, net->name);
    command_send(net, CMD_CHANNEL_BAN_LIST, channel);
    gtk_object_set_data(GTK_OBJECT(global.ban_win), "channel", channel);
  } else {
    sprintf(str, "Global banned Users on %s", net->name);
    command_send(net, CMD_BANLIST);
    gtk_object_set_data(GTK_OBJECT(global.ban_win), "channel", NULL);
    temp = lookup_widget(global.ban_win, "button186");
    if (net->user.level > L_USER) {
      gtk_widget_set_sensitive(temp, TRUE);
    } else {
      gtk_widget_set_sensitive(temp, FALSE);
    }
  }
  gtk_window_set_title(GTK_WINDOW(global.ban_win), str);
}

/////////////////////////////////////////////////////////////
// the code of the cparse() is almost copied from TekNap
/////////////////////////////////////////////////////////////
char *cparse(char *input) {
  int read;
  int write;
  int noappend = 1;
  static char output[2048];

  read = write = 0;

  while (input[read]) {
    if (input[read] == '%') {
      read++;
      switch (input[read]) {
      case 'k':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '0';
	break;
      case 'r':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '1';
	break;
      case 'g':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '2';
	break;
      case 'y':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '3';
	break;
      case 'b':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '4';
	break;
      case 'm':
      case 'p':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '5';
	break;
      case 'c':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '6';
	break;
      case 'w':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '7';
	break;

      case 'K':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '0';
	break;
      case 'R':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '1';
	break;
      case 'G':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '2';
	break;
      case 'Y':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '3';
	break;
      case 'B':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '4';
	break;
      case 'M':
      case 'P':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '5';
	break;
      case 'C':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '6';
	break;
      case 'W':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '7';
	break;

      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
	output[write++] = '\003';
	output[write++] = ',';
	output[write++] = '4';
	output[write++] = input[read];
	break;

      case 'F':
	output[write++] = '\006';
	break;
      case 'n':
	output[write++] = '\003';
	output[write++] = '\017';
	break;
      case 'N':
	noappend = 1;
	break;
      case '%':
	output[write++] = input[read];
	break;
      default:
	output[write++] = '%';
	output[write++] = input[read];
	break;
      }
      read++;
    } else {
      output[write++] = input[read++];
    }
  }
  if (noappend == 0) {
    output[write++] = '\003';
    output[write++] = '-';
    output[write++] = '1';
  }
  output[write] = 0;

  return output;
}

void client_message(const char *text, const char *fmt, ...) {
  va_list ap;
  char text2[2048];
  chat_page_t* page;
  char* pos1;
  char* pos2;
  int cnt = 0;

  if (!global.scheme) return;

  va_start(ap, fmt);
  vsprintf(text2, fmt, ap);
  va_end(ap);

  page = chat_page_get_printable();
  chat_print_time_stamp(page, M_PUBLIC);
  chat_print_prefix(page, 1);
  if (text) {
    chat_print_colored(page, M_PUBLIC, "text", "[");
    chat_print_colored(page, M_PUBLIC, "message", text);
    chat_print_colored(page, M_PUBLIC, "text", "] ");
  }

  pos1 = text2;
  while ((pos2 = strchr(pos1, '\n')) != NULL) {
    *pos2 = 0;
    if (cnt > 0) {
      chat_print_time_stamp(page, M_PUBLIC);
      chat_print_prefix(page, 1);
    }
    chat_print_colored(page, M_PUBLIC, "text", pos1);
    chat_print_text(page, M_PUBLIC, "text", "\n");
    pos1 = pos2 + 1;
    cnt++;
  }

  if (cnt > 0) {
    chat_print_time_stamp(page, M_PUBLIC);
    chat_print_prefix(page, 1);
  }
  chat_print_colored(page, M_PUBLIC, "text", pos1);
  chat_print_text(page, M_PUBLIC, "text", "\n");
}

void server_message(net_t* net, const char *fmt, ...) {
  va_list ap;
  char text2[2048];
  chat_page_t *page;
  int pserver;

  va_start(ap, fmt);
  vsprintf(text2, fmt, ap);
  va_end(ap);

  if (global.options.piping & PIPE_SERVER) {
    if (net->flags & NETWORK_MESSAGES) {
      page = chat_page_search(net, "Server", P_SERVER, 3);
      if (!page) page = create_network_page(net);
      pserver = 0;
    } else {
      page = chat_page_search(NULL, "Server", P_SERVER, 3);
      if (!page) page = create_network_page(NULL);
      pserver = 1;
    }
  } else {
    page = chat_page_get_printable();
    pserver = 1;
  }

  if (!page) {
    printf("have no current page\n");
    return;
  }

  chat_print_time_stamp(page, M_PUBLIC);
  chat_print_prefix(page, 0);
  if (pserver) {
    chat_print_text(page, M_PUBLIC, "user", "[");
    chat_print_network(page, M_PUBLIC, net, 0, 1);
    chat_print_text(page, M_PUBLIC, "user", "] ");
  }
  chat_print_colored(page, M_PUBLIC, "error", text2);
  chat_print_text(page, M_PUBLIC, "error", "\n");
}

void toggle_friend(char *user)
{
  if (string_list_search(LIST_FRIEND, user)) {
    friend_remove(user);
  } else {
    friend_add(user);
  }
}

void toggle_enemy(char *user)
{
  if (string_list_search(LIST_ENEMY, user)) {
    enemy_remove(user);
  } else {
    enemy_add(user);
  }
}

void toggle_nodownload(char *user)
{
  if (string_list_search(LIST_NODOWNLOAD, user)) {
    nodownload_remove(user);
  } else {
    nodownload_add(user);
  }
}

void opennap_notify()
{
  client_message("Message",
		 "Opennap commands are not allowed on this server");
}

GtkWidget *create_customize_win(GtkCList * clist, int* array)
{
  GtkWidget *customize_win;
  GtkWidget *frame138;
  GtkWidget *vbox84;
  GtkWidget *vbox85;
  GtkWidget *checkbutton;
  GtkWidget *hseparator19;
  GtkWidget *frame139;
  GtkWidget *hbox213;
  GtkWidget *button151;
  GtkWidget *button152;
  int i1;
  char wname[1024];
  GtkWidget *title;

  customize_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(customize_win), "customize_win",
		      customize_win);
  gtk_window_set_title(GTK_WINDOW(customize_win), "Customize List");
  gtk_window_set_modal(GTK_WINDOW(customize_win), TRUE);
  gtk_window_set_policy(GTK_WINDOW(customize_win), FALSE, TRUE, TRUE);

  frame138 = gtk_frame_new(NULL);
  gtk_widget_ref(frame138);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "frame138", frame138,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(frame138);
  gtk_container_add(GTK_CONTAINER(customize_win), frame138);
  gtk_container_set_border_width(GTK_CONTAINER(frame138), 5);

  vbox84 = gtk_vbox_new(FALSE, 5);
  gtk_widget_ref(vbox84);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "vbox84", vbox84,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox84);
  gtk_container_add(GTK_CONTAINER(frame138), vbox84);
  gtk_container_set_border_width(GTK_CONTAINER(vbox84), 5);

  vbox85 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox85);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "vbox85", vbox85,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox85);
  gtk_box_pack_start(GTK_BOX(vbox84), vbox85, TRUE, TRUE, 0);

  for (i1 = 0; i1 < clist->columns; i1++) {
    title = gtk_clist_get_column_widget(clist, i1);
    sprintf(wname, "Show column \"%s\"", GTK_LABEL(title)->label);
    checkbutton = gtk_check_button_new_with_label(wname);
    gtk_widget_ref(checkbutton);
    sprintf(wname, "check%d", i1);
    gtk_object_set_data_full(GTK_OBJECT(customize_win), wname, checkbutton,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(checkbutton);
    gtk_box_pack_start(GTK_BOX(vbox85), checkbutton, FALSE, FALSE, 0);
    if (clist->column[i1].visible)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton), FALSE);
  }

  hseparator19 = gtk_hseparator_new();
  gtk_widget_ref(hseparator19);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "hseparator19",
			   hseparator19,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hseparator19);
  gtk_box_pack_start(GTK_BOX(vbox84), hseparator19, FALSE, FALSE, 0);

  frame139 = gtk_frame_new(NULL);
  gtk_widget_ref(frame139);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "frame139", frame139,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(frame139);
  gtk_box_pack_start(GTK_BOX(vbox84), frame139, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type(GTK_FRAME(frame139), GTK_SHADOW_IN);

  hbox213 = gtk_hbox_new(TRUE, 5);
  gtk_widget_ref(hbox213);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "hbox213", hbox213,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox213);
  gtk_container_add(GTK_CONTAINER(frame139), hbox213);
  gtk_widget_set_usize(hbox213, -2, 37);
  gtk_container_set_border_width(GTK_CONTAINER(hbox213), 5);

  button151 = gtk_button_new_with_label("Apply");
  gtk_widget_ref(button151);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "button151",
			   button151, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(button151);
  gtk_box_pack_start(GTK_BOX(hbox213), button151, TRUE, TRUE, 0);

  button152 = gtk_button_new_with_label("Close");
  gtk_widget_ref(button152);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "button152",
			   button152, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(button152);
  gtk_box_pack_start(GTK_BOX(hbox213), button152, TRUE, TRUE, 0);

  gtk_signal_connect(GTK_OBJECT(customize_win), "destroy",
		     GTK_SIGNAL_FUNC(on_customize_win_destroy), NULL);
  gtk_signal_connect(GTK_OBJECT(button151), "clicked",
		     GTK_SIGNAL_FUNC(on_button1x_clicked), NULL);
  gtk_signal_connect(GTK_OBJECT(button152), "clicked",
		     GTK_SIGNAL_FUNC(on_button2x_clicked), NULL);
  gtk_object_set_data(GTK_OBJECT(customize_win), "ref_clist", clist);
  gtk_object_set_data(GTK_OBJECT(customize_win), "ref_array", array);

  return customize_win;
}

HANDLER(nap_version_stats);

void show_clients(net_t* net) {
  GtkWidget *temp;

  if (!global.client_win) {
    global.client_win = create_client_win();
    temp = lookup_widget(global.client_win, "clist8");
    gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
    gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
    gtk_clist_set_compare_func(GTK_CLIST(temp), client_compare);

    nap_version_stats(net, "");
  }
  gtk_object_set_data(GTK_OBJECT(global.client_win), "network", net);
  gtk_widget_show(global.client_win);
  if (!global.client_list)
    on_button149_clicked(NULL, NULL);
}

gint
user2_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{

  char *text1 = NULL;
  char *text2 = NULL;
  unsigned long l1, l2;
  GdkColor color = { 0, 0xff00, 0xbf00, 0xbf00 };

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 0) {
    return l_strcasecmp(text1, text2);
  } else if (clist->sort_column == 1) {
    l1 = inet_network(text1);
    l2 = inet_network(text2);
    if (l1 < l2)
      return -1;
    else if (l1 > l2)
      return 1;
    else {
      row1->background = color;
      row1->bg_set = TRUE;
      if (GTK_WIDGET_REALIZED(clist))
	gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(clist)),
			&row1->background);
      row2->background = color;
      row2->bg_set = TRUE;
      if (GTK_WIDGET_REALIZED(clist))
	gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(clist)),
			&row2->background);

      return 0;
    }
  }
  return 0;
}

void show_global_users(net_t* net, char *args) {
  GtkWidget *temp;

  if (!net || !net->active_server) return;

  if (global.user_win) {
    temp = lookup_widget(global.user_win, "clist12");
    if (global.user_win->window)
      gdk_window_raise(global.user_win->window);
  } else {
    global.user_win = create_user_win();
    temp = lookup_widget(global.user_win, "clist12");
    gtk_clist_set_compare_func(GTK_CLIST(temp),
			       (GtkCListCompareFunc) user2_compare);
  }

  gtk_widget_show(global.user_win);
  gtk_object_set_data(GTK_OBJECT(global.user_win), "network", net);

  if (args) {
    clones_clear();
    gtk_clist_clear(GTK_CLIST(temp));

    command_send(net, CMD_GUSER_LIST, args);
    temp = lookup_widget(global.user_win, "button164");
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

int get_media_type(char *name) {
  GList *dlist;
  char *suf;
  suffix_t *suffix;
  int i1;

  suf = strrchr(name, '.');
  if (!suf) return MIME_NONE;
  else suf++;

  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      if (!l_strcasecmp(suf, suffix->suffix))
	return i1;
    }
  }
  return MIME_NONE;
}

suffix_t *get_suffix(char *name)
{
  GList *dlist;
  char *suf;
  suffix_t *suffix;
  int i1;

  suf = strrchr(name, '.');
  if (!suf)
    return NULL;
  else
    suf++;

  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      if (!l_strcasecmp(suf, suffix->suffix))
	return suffix;
    }
  }
  return NULL;
}

void on_safe_exit_cancel(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.status.exiting = E_NONE;
}

void on_away_deactivate(GtkMenuItem * menuitem ATTR_UNUSED, 
			gpointer user_data ATTR_UNUSED) {
  set_afk(NULL);
}

void on_away_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  int number = GPOINTER_TO_INT(user_data);
  GtkEntry* entry;
  GList* dlist;

  switch (number) {
  case 0:
    set_afk("");
    break;
  case 1:
    switch_to_page(1);
    entry = GTK_ENTRY(lookup_widget(global.win, "chat_entry"));
    gtk_entry_set_text(entry, "/away ");
    break;
  default:
    dlist = g_list_nth(global.string_list[LIST_AFKREASON], number-2);
    if (!dlist) break;
    set_afk((char*)(dlist->data));
    break;
  }
}

void on_auto_afk_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			  gpointer user_data ATTR_UNUSED)
{
  if (global.afk.auto_afk)
    global.afk.auto_afk = 0;
  else
    global.afk.auto_afk = 1;
}

void on_warn_afk_activate(GtkMenuItem * menuitem ATTR_UNUSED,
			  gpointer user_data ATTR_UNUSED)
{
  if (global.afk.warn_afk)
    global.afk.warn_afk = 0;
  else
    global.afk.warn_afk = 1;
}

void add_away_popup(GtkWidget* popup) {
  GtkWidget *item;
  GtkWidget *popup2;
  int cnt;
  GList* dlist;

  item = gtk_menu_item_new_with_label("Away Mode");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);

  popup2 = gtk_menu_new();
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);

  item = gtk_menu_item_new_with_label("Deactivate");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  if (global.afk.message) {
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_away_deactivate), NULL);
  } else {
    gtk_widget_set_sensitive(item, FALSE);
  }
  item = gtk_menu_item_new();
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  gtk_widget_set_sensitive(item, FALSE);

  item = gtk_menu_item_new_with_label("<No Reason>");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_away_activate),
		     GINT_TO_POINTER(0));
  item = gtk_menu_item_new_with_label("<Enter Reason>");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_away_activate),
		     GINT_TO_POINTER(1));
  cnt = 2;
  for (dlist = global.string_list[LIST_AFKREASON]; dlist; dlist = dlist->next) {
    item = gtk_menu_item_new_with_label((char*)(dlist->data));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup2), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_away_activate),
		       GINT_TO_POINTER(cnt));
    cnt++;
  }

  item = gtk_menu_item_new();
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  gtk_widget_set_sensitive(item, FALSE);
  
  item = gtk_check_menu_item_new_with_label("Auto AFK after 10 minutes");
  if (global.afk.auto_afk)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item), TRUE);
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_auto_afk_activate),
		     NULL);

  item = gtk_check_menu_item_new_with_label("Warn if in AFK mode");
  if (global.afk.warn_afk)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item), TRUE);
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup2), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_warn_afk_activate),
		     NULL);
}

GtkWidget *create_mode_popup()
{
  GtkWidget *popup2;
  GtkWidget *mode_popup;
  GtkWidget *separator;
  GtkAccelGroup *mode_popup_accels;
  GtkWidget *mode;
  
  mode_popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(mode_popup), "mode_popup", mode_popup);
  mode_popup_accels =
    gtk_menu_ensure_uline_accel_group(GTK_MENU(mode_popup));

  if (!global.net_active) {
    mode = gtk_menu_item_new_with_label("Not connected");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    gtk_widget_set_sensitive(mode, FALSE);
  } else {
    if (global.status.exiting == E_SAFE) {
      mode = gtk_menu_item_new_with_label("Cancel safe exit");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(mode_popup), mode);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_safe_exit_cancel), NULL);
      separator = gtk_menu_item_new();
      gtk_widget_show(separator);
      gtk_container_add(GTK_CONTAINER(mode_popup), separator);
      gtk_widget_set_sensitive(separator, FALSE);
    }

    mode =
      gtk_check_menu_item_new_with_label("Show server error messages");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_ERROR))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) MODE_ERROR);
    
    mode = gtk_check_menu_item_new_with_label("Show bans messages");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_BAN))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) MODE_BAN);

    mode =
      gtk_check_menu_item_new_with_label("Show configuration changed");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_CHANGE))
      gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_CHANGE);

    mode = gtk_check_menu_item_new_with_label("Show kill messages");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_KILL))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_KILL);

    mode = gtk_check_menu_item_new_with_label("Show level changes");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_LEVEL))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_LEVEL);

    mode = gtk_check_menu_item_new_with_label("Show server messages");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_SERVER))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_SERVER);

    mode = gtk_check_menu_item_new_with_label("Show muzzle messages");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_MUZZLE))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_MUZZLE);

    mode = gtk_check_menu_item_new_with_label("Show dataport changes");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_PORT))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_PORT);

    mode = gtk_check_menu_item_new_with_label("Show wallops");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_WALLOP))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_WALLOP);

    mode = gtk_check_menu_item_new_with_label("Show cloaks");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_CLOAK))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_CLOAK);

    mode = gtk_check_menu_item_new_with_label("Show floods");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_FLOOD))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_FLOOD);

    mode = gtk_check_menu_item_new_with_label("Show pings");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_PING))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_PING);
    
    mode =
      gtk_check_menu_item_new_with_label("Allow private message");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_MSG))
      gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_MSG);
    
    mode = gtk_check_menu_item_new_with_label("Show whois requests");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (global.usermode & (1<<MODE_WHOIS))
      gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_WHOIS);
    
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(mode_popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    mode = gtk_menu_item_new_with_label("Additional Opennap-ng modes");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    {
      popup2 = gtk_menu_new();
      gtk_widget_show(popup2);
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(mode), popup2);
      
      mode = gtk_check_menu_item_new_with_label("Show client abuses");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_ABUSE))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_ABUSE);
      
    }
    mode = gtk_menu_item_new_with_label("Additional SlavaNap modes");
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    {
      popup2 = gtk_menu_new();
      gtk_widget_show(popup2);
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(mode), popup2);
      
      mode = gtk_check_menu_item_new_with_label("Show announcements");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_ANNOUNCE))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_ANNOUNCE);
      
      mode = gtk_check_menu_item_new_with_label("Show browse notifications");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_BROWSE))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_BROWSE);
      
      mode = gtk_check_menu_item_new_with_label("Show Motd");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_MOTD))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_MOTD);
      
      mode = gtk_check_menu_item_new_with_label("Show messages about friend list");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_FRIEND))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_FRIEND);
      
      mode = gtk_check_menu_item_new_with_label("Show channel operator actions");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_CHANNEL))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_CHANNEL);
      
      mode = gtk_check_menu_item_new_with_label("Show new user registrations");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_REGISTER))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_REGISTER);
      
      mode = gtk_check_menu_item_new_with_label("Show server config changes");
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(popup2), mode);
      if (global.usermode & (1<<MODE_VAR))
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *)MODE_VAR);
    }
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(mode_popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    add_away_popup(mode_popup);
  }
  return mode_popup;
}

static net_t *get_popup_net(int mode, void* data) {
  net_t* net = NULL;
  
  switch (mode) {
  case M_REPLY:
  case M_WHOIS:
  case M_SUBSCRIPTION:
  case M_GLOBAL:
  case M_TEXT: {
    net_user_t* nu = data;
    if (nu) net = nu->net;
    break;
  }
  case M_HOTLIST: {
    hot_t* hot = data;
    if (hot && hot->nets) 
      net = hot->nets->data;
    break;
  }
  case M_ONLINE: {
    channel_user_t* cu = data;
    if (cu && cu->page) 
      net = cu->page->net;
    break;
  }
  case M_BROWSE: {
    browse_t* browse = data;
    if (browse) net = browse->net;
    break;
  }
  case M_SEARCH: {
    file_t* file = data;
    if (file) net = file->net;
    break;
  }
  case M_DOWNLOAD: {
    download_t* download = data;
    net = DL_GET_NET(download);
    break;
  }
  case M_UPLOAD: {
    upload_t* upload = data;
    if (upload) net = upload->nu.net;
    break;
  }
  case M_SHARE: {
    share_t* share = data;
    if (share) net = share->nu.net;
    break;
  }
  case M_ACCESS:
  case M_STRING_LIST:
    break;
  default:
    printf("get_popup_server incomplete\n");
    break;
  }
  return net;
}

static char *get_popup_user(int mode, void* data) {
  char *user = NULL;

  switch (mode) {
  case M_REPLY:
  case M_WHOIS:
  case M_SUBSCRIPTION:
  case M_GLOBAL:
  case M_TEXT: {
    net_user_t* nu = data;
    if (nu) user = nu->user;
    break;
  }
  case M_HOTLIST: {
    hot_t* hot = data;
    if (hot) user = hot->user;
    break;
  }
  case M_ONLINE: {
    channel_user_t* cu = data;
    if (cu) user = cu->user;
    break;
  }
  case M_BROWSE: {
    file_tree_t* browse = data;
    if (browse) user = browse->name;
    break;
  }
  case M_SEARCH: {
    file_t* file = data;
    if (file) user = file->user;
    break;
  }
  case M_DOWNLOAD: {
    download_t* download = data;
    user = DL_GET_NICK(download);
    break;
  }
  case M_UPLOAD: {
    upload_t* upload = data;
    if (upload) user = upload->nu.user;
    break;
  }
  case M_SHARE: {
    share_t* share = data;
    if (share) user = share->nu.user;
    break;
  }
  case M_ACCESS: {
    access_t* access = data;
    if (access) user = access->name;
    break;
  }
  case M_STRING_LIST:
    user = data;
    break;
  default:
    printf("get_popup_user incomplete\n");
    break;
  }
  return user;
}

// TEXT     : word_info_t
// HOT      : hot_t
// ONLINE   : channel_user_t
// BROWSE   : browse_t
// SEARCH   : file_t
// TRANSFER : transfer_t
// RESUME   : resume_t
// STRING   : char
// GLOBAL   : net_user_t
// WHOIS    : net_user_t
// SUBSCRIPTION : net_user_t

void on_ban_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  int number = GPOINTER_TO_INT(user_data);
  int i1;
  GtkEntry* entry;
  char* text;
  GList* dlist;

  if (!nu.user || !nu.net) return;

  switch (number) {
  case 0:
    ban_user(nu.net, nu.user, NULL, 0);
    break;
  case 1:
    i1 = g_list_index(global.net_active, nu.net);
    if (i1 >= 0) {
      switch_to_page(1);
      entry = GTK_ENTRY(lookup_widget(global.win, "chat_entry"));
      text = l_strdup_printf("/ban :%d %s ", i1+1, nu.user);
      gtk_entry_set_text(entry, text);
      l_free(text);
    }
    break;
  default:
    dlist = g_list_nth(global.string_list[LIST_BANREASON], number-2);
    if (!dlist) break;
    ban_user(nu.net, nu.user, (char*)(dlist->data), 0);
    break;
  }
}

void on_tinfo_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  net_user_t* nu = user_data;

  if (!nu || !nu->user) return;
  
  send_user_status(NULL, nu->user);
}

static GList* download_list(user_info_t* userinfo) {
  GList* dlist;
  GList* result = NULL;
  socket_t* socket;
  download_t* download;
  
  for (dlist = global.sockets; dlist; dlist = dlist->next) {
    socket = dlist->data;
    if (socket->type != S_DOWNLOAD) continue;
    download = socket->data;
    if (!download) continue;
    if (download->data->user_info == userinfo)
      result = g_list_append(result, download);
  }
  return result;
}

static GList* upload_list(user_info_t* userinfo) {
  GList* dlist;
  GList* result = NULL;
  socket_t* socket;
  upload_t* upload;
  
  for (dlist = global.sockets; dlist; dlist = dlist->next) {
    socket = dlist->data;
    if (socket->type != S_UPLOAD) continue;
    upload = socket->data;
    if (!upload) continue;
    if (upload->data->user_info == userinfo)
      result = g_list_append(result, upload);
  }
  return result;
}

static GtkWidget* user_get_transfers(user_info_t* userinfo, int down) {
  GList* transfer_list;
  GList* dlist;
  GtkWidget* popup;
  download_t* download;
  upload_t* upload;
  char str[2048];
  GtkWidget* item;

  if (!userinfo) return NULL;

  if (down)
    transfer_list = download_list(userinfo);
  else
    transfer_list = upload_list(userinfo);

  if (!transfer_list) return NULL;

  popup = gtk_menu_new();
  
  if (down) {
    for (dlist = transfer_list; dlist; dlist = dlist->next) {
      download = dlist->data;
      sprintf(str, "[%s] %s", status_names(download->data->status),
	      download->file->filename);
      item = gtk_menu_item_new_with_label(str);
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
    }
  } else {
    for (dlist = transfer_list; dlist; dlist = dlist->next) {
      upload = dlist->data;
      sprintf(str, "[%s] %s", status_names(upload->data->status),
	      upload->file->filename);
      item = gtk_menu_item_new_with_label(str);
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
    }
  }
  g_list_free(transfer_list);

  return popup;
}

GtkWidget *create_user_popup(int mode, void* data) {
  GtkWidget *popup;
  GtkWidget *popup2;
  GtkWidget *popup3;
  GtkAccelGroup *popup_accels;
  GtkWidget *item;
  GtkWidget *item2;
  GtkWidget *item3;
  GtkWidget *separator;
  int in_hot;
  hot_t *hot;
  int subscribed;
  char* temp;
  user_info_t* userinfo;
  char speed[1024];
  GList* dlist;

  nu.user = get_popup_user(mode, data);
  nu.net = get_popup_net(mode, data);
  if (!nu.user) {
    printf("no user found\n");
    return NULL;
  }

  if (!NET_CONNECTED(nu.net)) nu.net = NULL;

  hot = hotlist_search_user(nu.user);
  in_hot = (hot && hot->visible);
  subscribed = (subscription_user_search(nu.user) != NULL);

  popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(popup));
  
  if (mode == M_TEXT) {
    item = gtk_menu_item_new_with_label(nu.user);
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
  }
  item = gtk_menu_item_new_with_label("Chat Window...");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_private_mode_activate),
		     &nu);
  
  item = gtk_menu_item_new_with_label("Send Message...");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_whisper_activate),
		     &nu);
  if (!nu.net) gtk_widget_set_sensitive(item, FALSE);

  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup), separator);
  gtk_widget_set_sensitive(separator, FALSE);

  if (mode == M_WHOIS)
    item = gtk_menu_item_new_with_label("Refresh Whois");
  else
    item = gtk_menu_item_new_with_label("Whois User");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_whois_user_activate), &nu);
  if (!nu.net) gtk_widget_set_sensitive(item, FALSE);

  if (in_hot) {
    item = gtk_menu_item_new_with_label("Remove from Hotlist");
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_remove_from_hotlist_activate),
		       &nu);
  } else {
    item = gtk_menu_item_new_with_label("Add to Hotlist");
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_add_to_hotlist_activate),
		       &nu);
  }
  item = gtk_menu_item_new_with_label("Browse Files");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_browse_files_activate),
		     &nu);
  if (!nu.net) gtk_widget_set_sensitive(item, FALSE);

  item = gtk_menu_item_new_with_label("Locate User");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_locate_activate),
		     &nu);
  
  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup), separator);
  gtk_widget_set_sensitive(separator, FALSE);
  
  item = gtk_menu_item_new_with_label("Send File (DCC)...");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_send_file_activate),
		     &nu);
  if (!nu.net) gtk_widget_set_sensitive(item, FALSE);

  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup), separator);
  gtk_widget_set_sensitive(separator, FALSE);

  item = gtk_menu_item_new_with_label("Status");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);

  popup2 = gtk_menu_new();
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);
  item2 = gtk_check_menu_item_new_with_label("Always allow upload");
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_FRIEND, nu.user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_friend_activate), &nu);
  item2 = gtk_check_menu_item_new_with_label("Never allow upload");
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_ENEMY, nu.user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_enemy_activate), &nu);
  item2 = gtk_check_menu_item_new_with_label("Never autoresume from user");
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_NODOWNLOAD, nu.user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_nodownload_activate), &nu);
  item2 = gtk_check_menu_item_new_with_label("Ignore messages");
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_IGNORE, nu.user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_ignore_activate), &nu);

  item2 = gtk_check_menu_item_new_with_label("In subscription list");
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (subscribed) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_subscribe_activate), &nu);

  item = gtk_menu_item_new_with_label("Information");
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);

  userinfo = user_info_search(nu.user);

  popup2 = gtk_menu_new();
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);
  
  if (NET_CONNECTED(nu.net)) {
    item2 = gtk_menu_item_new_with_label(nu.net->name);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
  } else {
    item2 = gtk_menu_item_new_with_label("<no server available>");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
  }

  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup2), separator);
  gtk_widget_set_sensitive(separator, FALSE);

  if (!userinfo) {
    item2 = gtk_menu_item_new_with_label("No Information found");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
  } else {
    if (userinfo->last_server) {
      temp = l_strdup_printf("Last userinfo from: %sreceived from %s", 
			     ctime(&(userinfo->last_seen)), userinfo->last_server);
    } else {
      temp = l_strdup_printf("Last userinfo from: %s", 
			     ctime(&(userinfo->last_seen)));
      temp[strlen(temp)-1] = 0;
    }
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->timestamp == 1) {
      temp = l_strdup_printf("Shared %d files with speed %s (user offline)", 
			     userinfo->shares, LineSpeed(userinfo->linespeed));
      item2 = gtk_menu_item_new_with_label(temp);
      l_free(temp);
      gtk_widget_show(item2);
      gtk_container_add(GTK_CONTAINER(popup2), item2);
    } else {
      temp = l_strdup_printf("Shares %d files with speed %s", 
			     userinfo->shares, LineSpeed(userinfo->linespeed));
      item2 = gtk_menu_item_new_with_label(temp);
      l_free(temp);
      gtk_widget_show(item2);
      gtk_container_add(GTK_CONTAINER(popup2), item2);
    }

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup2), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    temp = l_strdup_printf("%d (%d) Downloads",
			   userinfo->cur[0], userinfo->real_cur[0]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);

    popup3 = user_get_transfers(userinfo, 1);
    if (popup3) 
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(item2), popup3);

    if (userinfo->max[0] == 0)
      temp = l_strdup_printf("Limit: Unlimited");
    else if (userinfo->max[0] == -1)
      temp = l_strdup_printf("Limit: Default");
    else temp = l_strdup_printf("Limit: %d", userinfo->max[0]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->limit[0] == 0)
      temp = l_strdup_printf("Bandwidth Limit: Unlimited");
    else
      temp = l_strdup_printf("Bandwidth Limit: %s",
			     print_speed(speed, userinfo->limit[0], 1));
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup2), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    temp = l_strdup_printf("%d (%d) Uploads",
			   userinfo->cur[1], userinfo->real_cur[1]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    
    popup3 = user_get_transfers(userinfo, 0);
    if (popup3) 
      gtk_menu_item_set_submenu(GTK_MENU_ITEM(item2), popup3);

    if (userinfo->max[1] == 0)
      temp = l_strdup_printf("Limit: Unlimited");
    else if (userinfo->max[1] == -1)
      temp = l_strdup_printf("Limit: Default");
    else temp = l_strdup_printf("Limit: %d", userinfo->max[1]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->limit[1] == 0)
      temp = l_strdup_printf("Bandwidth Limit: Unlimited");
    else
      temp = l_strdup_printf("Bandwidth Limit: %s",
			     print_speed(speed, userinfo->limit[1], 1));
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup2), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    item = gtk_menu_item_new_with_label("Print more info");
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup2), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_tinfo_activate),
		       &nu);
  }

  if (userinfo && (item = create_bandwidth_popup(userinfo))) {
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
    
    gtk_container_add(GTK_CONTAINER(popup), item);
  }

  if (((mode == M_ONLINE) || (mode == M_TEXT)) &&
      (global.current_page->type == P_PUBLIC) && 
      NET_CONNECTED(nu.net) &&
      (nu.net->user.level > L_USER ||
       (global.current_page->opped && global.current_page->net == nu.net))) {

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
    
    item = gtk_menu_item_new_with_label("Channel Op");
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);

    ////////    
    popup2 = gtk_menu_new();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);
    
    item2 = gtk_menu_item_new_with_label("Muzzle User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_chmuzzle_activate),
		       &nu);

    item2 = gtk_menu_item_new_with_label("Kick User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_kick_activate), &nu);

    item2 = gtk_menu_item_new_with_label("Ban User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_chban_activate), &nu);
  }

  if (NET_CONNECTED(nu.net) && nu.net->user.level > L_USER) {
    int cnt = 2;

    item = gtk_menu_item_new_with_label("Server Mod+");
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);

    ////////    
    popup2 = gtk_menu_new();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);
    
    item2 = gtk_menu_item_new_with_label(nu.net->name);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_widget_set_sensitive(item2, FALSE);

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup2), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    item2 = gtk_menu_item_new_with_label("Muzzle User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_muzzle_activate),
		       &nu);

    item2 = gtk_menu_item_new_with_label("Kill User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_kill_activate), &nu);

    item2 = gtk_menu_item_new_with_label("Ban User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);

    ////////    
    popup3 = gtk_menu_new();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item2), popup3);
    item3 = gtk_menu_item_new_with_label("<No Reason>");
    gtk_widget_show(item3);
    gtk_container_add(GTK_CONTAINER(popup3), item3);
    gtk_signal_connect(GTK_OBJECT(item3), "activate",
		       GTK_SIGNAL_FUNC(on_ban_activate),
		       GINT_TO_POINTER(0));
    cnt = 2;
    for (dlist = global.string_list[LIST_BANREASON]; dlist; dlist = dlist->next) {
      item3 = gtk_menu_item_new_with_label((char*)(dlist->data));
      gtk_widget_show(item3);
      gtk_container_add(GTK_CONTAINER(popup3), item3);
      gtk_signal_connect(GTK_OBJECT(item3), "activate",
			 GTK_SIGNAL_FUNC(on_ban_activate),
			 GINT_TO_POINTER(cnt));
      cnt++;
    }
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup3), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    item3 = gtk_menu_item_new_with_label("Enter Reason");
    gtk_widget_show(item3);
    gtk_container_add(GTK_CONTAINER(popup3), item3);
    gtk_signal_connect(GTK_OBJECT(item3), "activate",
		       GTK_SIGNAL_FUNC(on_ban_activate),
		       GINT_TO_POINTER(1));

    item2 = gtk_menu_item_new_with_label("Nuke User");
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_nuke_activate), &nu);
  }

  return popup;
}

int cnt_pot(long num)
{
  int cnt = 0;

  while ((1 << cnt) < num) cnt++;

  return cnt;
}

int calc_x(long val, long max, int width) {
  if (val > max)
    return width;
  else
    return (int) (((double) val / (double) max) * (double) width);
}

void draw_band_width(bandwidth_t * bandwidth, int full) {
  char str[1024];
  int height;
  int width;
  int dx, dy, wc;
  GtkWidget *area = bandwidth->area;
  long x1, x2;
  int i1;
  int overrun;
  int borderx, bordery;
  int bordery2;
  int text_height;
  GtkStyle* style;

  if (!GTK_WIDGET_REALIZED(global.progressbar))
    gtk_widget_realize(global.progressbar);
  style = global.progressbar->style;
  dx = style->klass->xthickness;
  dy = style->klass->ythickness;

  if (full) {
    print_speed(str, bandwidth->limit, 1);
    gtk_label_set_text(GTK_LABEL(bandwidth->label_max), str);
  }
  print_speed(str, bandwidth->value, 1);
  gtk_label_set_text(GTK_LABEL(bandwidth->label_cur), str);

  if (!area->window) return;

  width = area->allocation.width;
  height = area->allocation.height;

  borderx = bordery = 0;
  if (bandwidth->pixmap) {
    gdk_window_get_size(bandwidth->pixmap, &borderx, &bordery);
  }
  
  if (!bandwidth->pixmap || width != borderx || height != bordery) {
    if (bandwidth->pixmap) gdk_pixmap_unref(bandwidth->pixmap);
    bandwidth->pixmap = gdk_pixmap_new (area->window,
					width, height, -1);
  }

  wc = gdk_string_width(area->style->font, "A")/2;
  text_height = style->font->ascent+2;

  borderx = area->style->klass->xthickness + 2 + dx;
  bordery = area->style->klass->ythickness + dy;
  bordery2 = bordery+text_height;
  
  if (full) {
    // background
    gtk_paint_box(area->style, bandwidth->pixmap,
		  GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		  NULL, area, "frame", 0, 0, width, height);
    x1 = 1;
    while (calc_x(x1, bandwidth->maxval, width - 2*borderx-1) < 70) {
      x1 *=2;
    }
    i1 = 0;
    while (i1*x1 <= bandwidth->maxval) {
      x2 = calc_x(x1 * i1, bandwidth->maxval, width - 2*borderx-1) +
	borderx;
      print_speed(str, x1 * i1, 0);
      gdk_draw_text (bandwidth->pixmap, style->font,
		     style->fg_gc[GTK_STATE_NORMAL],
		     x2 + wc, bordery2-dy-2, str, strlen (str));
      gdk_draw_line(bandwidth->pixmap,
		    area->style->fg_gc[GTK_STATE_NORMAL],
		    x2, 0, x2, height);
      i1++;
    }
  }

  gtk_paint_box (style, bandwidth->pixmap,
		 GTK_STATE_NORMAL, GTK_SHADOW_IN,
		 NULL, area, "trough",
		 borderx-dx, bordery2-dy,
		 width - 2*borderx + 2*dy,
		 height - bordery2 - 4);

  // bar
  x1 = calc_x(bandwidth->value, bandwidth->maxval,
	      width - 2*borderx);
  if (bandwidth->value > bandwidth->maxval) {
    overrun = 1;
    x1 -= 10;
  } else
    overrun = 0;

  if (x1 > 0) {
    gtk_paint_box(style, bandwidth->pixmap,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		  NULL, area, "bar",
		  borderx, bordery2,
		  x1, height - bordery2 - 4 - 2*dy);
  }
  if (overrun) {
    gtk_paint_arrow(area->style, bandwidth->pixmap,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, area, "hscrollbar", GTK_ARROW_RIGHT, TRUE,
		    borderx + x1, bordery2,
		    10, height - bordery2 - 4 - 2*dy);
  }
  
  x1 = calc_x(bandwidth->limit, bandwidth->maxval,
	      width - 2*borderx);

  if (bandwidth->limit <= bandwidth->maxval) {
    gtk_paint_arrow(area->style, bandwidth->pixmap,
		    GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		    NULL, area, "vscrollbar", GTK_ARROW_UP, TRUE,
		    borderx + x1 - 7, bordery2,
		    13, height - bordery2);
  }

  gdk_draw_pixmap (area->window,
		   area->style->black_gc,
		   bandwidth->pixmap,
		   0, 0, 0,0, width, height);
}

void extra_win_get_geometry()
{
  int i1;
  GtkWidget *win;
  char str[1024];

  for (i1 = 0; i1 < G_SIZE - G_SIZE_ADD; i1++) {
    if (global.extra_win & (1 << i1)) {
      sprintf(str, "extra%d", i1);
      win = gtk_object_get_data(GTK_OBJECT(global.win), str);
      if (!win)
	continue;
      if (win->window) {
	gdk_window_get_origin(win->window,
			      &global.geometry[i1].x,
			      &global.geometry[i1].y);
      }
      global.geometry[i1].width = win->allocation.width;
      global.geometry[i1].height = win->allocation.height;
    }
  }
  if (global.extra_win & (1 << (G_SIZE - 1))) {
    win = gtk_object_get_data(GTK_OBJECT(global.win), "fields");
    if (win && win->window) {
      gdk_window_get_origin(win->window,
			    &global.geometry[G_SIZE - 1].x,
			    &global.geometry[G_SIZE - 1].y);
    }
    global.geometry[G_SIZE - 1].width = win->allocation.width;
    global.geometry[G_SIZE - 1].height = win->allocation.height;
  }
  if (global.extra_win & (1 << (G_SIZE - 2))) {
    win = gtk_object_get_data(GTK_OBJECT(global.win), "fields2");
    if (win && win->window) {
      gdk_window_get_origin(win->window,
			    &global.geometry[G_SIZE - 2].x,
			    &global.geometry[G_SIZE - 2].y);
    }
    global.geometry[G_SIZE - 2].width = win->allocation.width;
    global.geometry[G_SIZE - 2].height = win->allocation.height;
  }
}

void lopster_wait(int msec)
{
  struct timeval start;
  struct timeval cur;

  gettimeofday(&start, NULL);
  do {
    gettimeofday(&cur, NULL);
  } while ((cur.tv_sec - start.tv_sec) * 1000 +
	   (cur.tv_usec - start.tv_usec) / 1000 < msec);
}

void advance_progress(char *message, gfloat per) {
  GtkProgressBar *progress;
  GtkLabel *label;

  if (per >= 1) return;

  if (!global.splash_win) return;

  progress =
      GTK_PROGRESS_BAR(lookup_widget(global.splash_win, "progress"));
  label = GTK_LABEL(lookup_widget(global.splash_win, "label"));
  if (message)
    gtk_label_set_text(label, message);
  gtk_progress_bar_update(progress, per);

  while (gtk_events_pending())
    gtk_main_iteration();
  //  lopster_wait(500);
}

GtkWidget *main_tab_detach(int no) {
  char str[1024];
  char title[1024];
  char wmclass[128];
  GtkWidget *widget;
  GtkWidget *window;
  GtkWidget *temp;

  //  printf("detach %d %d\n", no, global.extra_win);
  if (global.extra_win & (1 << no))
    return NULL;

  switch (no) {
  case 0:
    strcpy(title, "Server");
    strcpy(str, "vbox98");
    strcpy(wmclass, "Server");
    temp = lookup_widget(global.win, "detach_server");
    break;
  case 1:
    strcpy(title, "Chat");
    strcpy(str, "vbox15");
    strcpy(wmclass, "Chat");
    temp = lookup_widget(global.win, "detach_chat");
    break;
  case 2:
    strcpy(title, "Library");
    strcpy(str, "vbox207");
    strcpy(wmclass, "Library");
    temp = lookup_widget(global.win, "detach_library");
    break;
  case 3:
    strcpy(title, "Search");
    strcpy(str, "vbox5");
    strcpy(wmclass, "Search");
    temp = lookup_widget(global.win, "detach_search");
    break;
  case 4:
    strcpy(title, "Hotlist");
    strcpy(str, "vbox124");
    strcpy(wmclass, "Hotlist");
    temp = lookup_widget(global.win, "detach_hotlist");
    break;
  case 5:
    strcpy(title, "Downloads");
    strcpy(str, "vbox8");
    strcpy(wmclass, "Downloads");
    temp = lookup_widget(global.win, "detach_downloads");
    break;
  case 6:
    strcpy(title, "Uploads");
    strcpy(str, "vbox139");
    strcpy(wmclass, "Uploads");
    temp = lookup_widget(global.win, "detach_uploads");
    break;
  case 7:
    strcpy(title, "Statistic");
    strcpy(str, "vbox171");
    strcpy(wmclass, "Statistic");
    temp = lookup_widget(global.win, "detach_statistic");
    break;
  default:
    return NULL;
  }
  gtk_widget_set_sensitive(temp, FALSE);

  widget = lookup_widget(global.win, str);
  if (!widget)
    return NULL;

  global.extra_win |= (1 << no);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  sprintf(str, "extra%d", no);
  gtk_object_set_data(GTK_OBJECT(global.win), str, window);
  gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
  gtk_window_set_default_size(GTK_WINDOW(window),
			      (global.geometry[no].width ==
			       -1) ? widget->allocation.width : global.
			      geometry[no].width,
			      (global.geometry[no].height ==
			       -1) ? widget->allocation.height : global.
			      geometry[no].height);
  gtk_window_set_title(GTK_WINDOW(window), title);
  gtk_window_set_wmclass(GTK_WINDOW(window), wmclass, "Lopster");

  gtk_widget_ref(widget);
  gtk_container_remove(GTK_CONTAINER(widget->parent), widget);
  gtk_container_add(GTK_CONTAINER(window), widget);
  gtk_widget_unref(widget);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(on_extra_win_delete), (gpointer) no);

  if ((global.geometry[no].x >= 0) &&(global.geometry[no].y >= 0)) {
    gtk_widget_set_uposition(window, global.geometry[no].x, global.geometry[no].y);
  }

  gtk_my_widget_show(window);

  return window;
}

clone_t *is_ip_in_clones(GList * glist, char *ip)
{
  GList *dlist;
  clone_t *clone;

  dlist = g_list_first(glist);
  while (dlist) {
    clone = (clone_t *) (dlist->data);
    if (!strcmp(clone->ip, ip))
      return clone;
    dlist = dlist->next;
  }
  return NULL;
}

int get_version(net_t* net, const char *data) {
  char* pos;

  if (!strncasecmp("VERSION opennap-ng", data, 18)) {
    net->subtype = N_OPENNAP_NG;
    pos = strchr(data+18, ' ');
    if (pos)
      sscanf(pos+1, "%d.%d", &(net->major), &(net->minor));
    return N_OPENNAP_NG;
  } else if (!strncasecmp("VERSION opennap", data, 15)) {
    net->subtype = N_OPENNAP;
    pos = strchr(data+15, ' ');
    if (pos)
      sscanf(pos+1, "%d.%d", &(net->major), &(net->minor));
    return N_OPENNAP;
  } else if (!strncasecmp("VERSION SlavaNap", data, 16)) {
    net->subtype = N_SLAVANAP;
    sscanf(data + 17, "%d.%d.%d", &(net->major), &(net->minor),
	   &(net->micro));
    return N_SLAVANAP;
  } else {
    net->subtype = N_UNKNOWN;
    return N_UNKNOWN;
  }
}

void get_server(net_t* net, char *data) {
  if (!strncasecmp("SERVER ", data, 7)) {
    net->links = l_malloc(sizeof(link_t));
    net->links->server = l_strdup(data + 7);
    net->links->links = NULL;
    net->links->ping = 0;
    network_links_get(net);
  }
}

void convert_port_list(GList * list)
{
  GList *dlist;
  char *ports;
  char *sep;
  int p1, p2, temp;
  int *res;

  for (dlist = list; dlist; dlist = dlist->next) {
    ports = (char *) (dlist->data);
    if (!ports)
      continue;
    //    printf("changing [%s] to ", ports);
    sep = strchr(ports, '-');
    if (sep) {
      *sep = 0;
      p1 = atoi(ports);
      p2 = atoi(sep + 1);
      if (p1 > p2) {
	temp = p1;
	p1 = p2;
	p2 = temp;
      }
    } else {
      p1 = p2 = atoi(ports);
    }
    l_free(ports);

    dlist->data = l_malloc(sizeof(int) * 2);
    res = (int *) (dlist->data);
    res[0] = p1;
    res[1] = p2;
    //    printf("[%d-%d]\n", res[0], res[1]);
  }
}

gint ports_compare_func(gconstpointer a, gconstpointer b)
{
  int *p1 = (int *) a;
  int *p2 = (int *) b;

  if (!p2)
    return (p1 != NULL);
  if (!p1)
    return -1;

  if (p1[0] < p2[0])
    return -1;
  if (p1[0] > p2[0])
    return 1;
  return 0;
}

GList *simplify_port_list(GList ** list)
{
  GList *dlist;
  int *res;
  int *res2 = NULL;

  *list = g_list_sort(*list, (GCompareFunc) ports_compare_func);

  if (!(*list))
    return NULL;
  dlist = *list;
  res = (int *) (dlist->data);
  dlist = dlist->next;
  while (dlist) {
    res2 = (int *) (dlist->data);
    dlist = dlist->next;
    //    printf("[%d-%d][%d-%d]\n", res[0], res[1], res2[0], res2[1]);
    if (res[1] + 1 >= res2[0]) {
      if (res2[1] > res[1])
	res[1] = res2[1];
      *list = g_list_remove(*list, res2);
    } else {
      res = res2;
    }
  }
  return *list;
}

GList *create_allowed_ports(char *string)
{
  GList *temp_list = NULL;
  char *temp;

  if (!string || !(*string))
    return NULL;

  temp = l_strdup(string);
  make_list_from_string(&temp_list, temp, ",");
  l_free(temp);
  convert_port_list(temp_list);
  simplify_port_list(&temp_list);
  return temp_list;
}

int get_next_port(GList * list, int last) {
  GList *dlist;
  int *res;
  int new_port = last + 1;

  if (!list)
    return 0;
  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if (res[1] < new_port)
      continue;
    break;
  }
  if (!dlist) {			// last port too high, getting first allowed port
    res = (int *) (list->data);
    return res[0];
  }
  // ok, segment found that may includes last+1, check min value
  // new_port <= res[1]
  if (new_port < res[0])
    return res[0];
  else
    return new_port;
}

char *create_string_from_ports(GList * list)
{
  char *result = NULL;
  GList *dlist;
  int len = 0;
  char str[1024];
  int *res;

  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if (res[0] == res[1])
      sprintf(str, "%d", res[0]);
    else
      sprintf(str, "%d-%d", res[0], res[1]);
    len += strlen(str) + 1;
  }
  result = (char *) l_malloc(sizeof(char) * len);
  *result = 0;
  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if (res[0] == res[1])
      sprintf(str, "%d", res[0]);
    else
      sprintf(str, "%d-%d", res[0], res[1]);
    if (*result)
      strcat(result, ",");
    strcat(result, str);
  }
  return result;
}

void destroy_string_list(GList * list)
{
  GList *dlist;

  if (!list) return;

  for (dlist = list; dlist; dlist = dlist->next) {
    l_free(dlist->data);
  }
  g_list_free(list);
}

int port_is_allowed(GList * list, int port) {
  GList *dlist;
  int *res;

  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if ((port >= res[0]) && (port <= res[1]))
      return 1;
  }
  return 0;
}

void gtk_my_widget_show(GtkWidget * widget)
{
  GList *dlist;

  if (global.splash_win) {
    dlist = gtk_object_get_data(GTK_OBJECT(global.win), "hidden");
    dlist = g_list_append(dlist, widget);
    gtk_object_set_data(GTK_OBJECT(global.win), "hidden", dlist);
  } else {
    gtk_widget_show(widget);
  }
}

void gtk_my_widget_show_all()
{
  GList *dlist;
  GList *hidden;

  hidden = gtk_object_get_data(GTK_OBJECT(global.win), "hidden");
  for (dlist = hidden; dlist; dlist = dlist->next) {
    gtk_widget_show(GTK_WIDGET(dlist->data));
  }
  g_list_free(hidden);
  gtk_object_set_data(GTK_OBJECT(global.win), "hidden", NULL);
}

void switch_to_page(int no)
{
  char str[1024];
  GtkWidget *temp;
  int i1, sum;

  if (global.extra_win & (1 << no)) {
    sprintf(str, "extra%d", no);
    temp = gtk_object_get_data(GTK_OBJECT(global.win), str);
    if (temp->window) gdk_window_raise(temp->window);
  } else {
    sum = no;
    for (i1 = 0; i1 < no; i1++)
      if (global.extra_win & (1 << i1))
	sum--;
    temp = lookup_widget(global.win, "notebook1");
    gtk_notebook_set_page(GTK_NOTEBOOK(temp), sum);
  }
}

int notebook_page_current() {
  GtkWidget *temp;
  int nth;
  int i1;

  temp = lookup_widget(global.win, "notebook1");
  nth = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
  for (i1 = 0; i1 < G_SIZE - G_SIZE_ADD; i1++) {
    if ((global.extra_win & (1 << i1)) == 0) nth--;
    if (nth < 0) break;
  }
  return i1;
}

int notebook_page_visible(int no)
{
  GtkWidget *temp;
  int sum;
  int i1;

  if (global.extra_win & (1 << no))
    return 1;
  else {
    temp = lookup_widget(global.win, "notebook1");
    sum = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
    for (i1 = 0; i1 < no; i1++)
      if (global.extra_win & (1 << i1))
	sum++;
    if (sum == no)
      return 1;
    else
      return 0;
  }
}

void print_topright_corner()
{
  struct tm *ltime;
  char *text;
  int hour;
  GtkWidget *temp;
  char comm[1024];

  temp = lookup_widget(global.win, "label914");
  if (global.options.time_display == 0) {
    text = l_strdup_printf("Boot time: %s", global.session_start);
  } else if (global.options.time_display == 1) {
    text =
      l_strdup_printf("Uptime: %s",
		      print_time(comm, global.current_time - global.start_time));
  } else if (global.options.time_display == 2) {
    ltime = localtime(&global.current_time);
    if (ltime->tm_hour == 12)
      hour = ltime->tm_hour;
    else
      hour = ltime->tm_hour % 12;
    text = l_strdup_printf("Time: %02d:%02d:%02d %sm",
			   hour, ltime->tm_min, ltime->tm_sec,
			   (ltime->tm_hour < 12) ? "a" : "p");
  } else if (global.options.time_display == 3) {
    text = l_strdup_printf("Beats: %3d", get_beats(global.current_time));
  } else {
    return;
  }
  gtk_label_set_text(GTK_LABEL(temp), text);
  l_free(text);
}

void set_user_level(net_t* net, int level) {
  chat_page_t *page;
  GList *dlist;

  net->user.level = level;

  if (level > L_USER) {
    for (dlist = global.chat_pages; dlist; dlist = dlist->next) {
      page = dlist->data;
      if (page->net != net) continue;
      if (page->type != P_PUBLIC) continue;
      chat_page_set_op(page, TRUE);
    }
  }
  update_status_line();
}

gint file_move_idle(gpointer data) {
  gint return_tmp, return_tmp2;
  move_t* fds = data;
  static char buffer[1024*64];

  return_tmp = read(fds->src_fd, buffer, 1024*64);
  if (return_tmp < 0) {
    g_warning("file_move_idle(): error reading while moving file to save directory (%s)\n", g_strerror(errno));
    goto no_success;
  }
  if (!return_tmp) goto success;
  
  return_tmp2 = write(fds->dest_fd, buffer, return_tmp);
  if (return_tmp2 < 0) {
    g_warning("file_move_idle(): error writing while moving file to save directory (%s)\n", g_strerror(errno));
    goto no_success;
  }
  if (return_tmp < 1024*64) goto success;

  return 1;

 success:
  unlink(fds->src);
 no_success:
  close(fds->src_fd); close(fds->dest_fd);
  l_free(fds->src);
  l_free(fds);
  return 0;
}

void file_move(char* src, char* dest) {
  gint return_tmp;
  move_t *fds;

  //  printf("moving [%s] to [%s]\n", src, dest);
  if (!strcmp(src, dest)) return;

  /* First try and link it to the new locatation */
  return_tmp = rename(src, dest);

  if (return_tmp == -1 && (errno == EXDEV || errno == EPERM)) {
    /* link failed becase either the two paths aren't on the */
    /* same filesystem or the filesystem doesn't support hard */
    /* links, so we have to do a copy. */
    
    gint tmp_src, tmp_dest;
    if ((tmp_src  = open(src, O_RDONLY)) < 0) {
      g_warning("Unable to open() file '%s' (%s) !\n", src, g_strerror(errno));
      return;
    }

    if ((tmp_dest = open(dest, O_WRONLY | O_CREAT | O_TRUNC, 0644)) < 0) {
      close(tmp_src);
      g_warning("Unable to create file '%s' (%s) !\n", src, g_strerror(errno));
      return;
    }
    
    fds = l_malloc(sizeof(move_t));
    fds->src_fd = tmp_src;
    fds->dest_fd = tmp_dest;
    fds->src = l_strdup(src);
    gtk_idle_add(file_move_idle, fds);
  }
  
  return;
}

void ban_user(net_t* net, char* user, char* reason, long timeout) {
  if (!net || !user) return;

  command_send(net, CMD_BAN, user, reason, timeout);
}

typedef struct {
  int priority;
  int class;
  int queued;
  int bposition;
  int wposition;
  double bsize;
  double wsize;
} queue_info_t;

GList* queue_info(user_info_t* userinfo, queue_info_t* qinfo) {
  GtkCList* clist;
  int row;
  upload_t* upload;
  socket_t* socket;
  GList* transfer_list = NULL;
  int temp;
  GList* running = NULL;
  GList* app = NULL;
  
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  qinfo->queued = 0;
  qinfo->bposition = 0;
  qinfo->wposition = 0;
  qinfo->bsize = 0.;
  qinfo->wsize = 0.;
  qinfo->priority = user_info_priority(userinfo, &(qinfo->class));

  row = 0;
  while (1) {
    if (row >= clist->rows) break;
    socket = gtk_clist_get_row_data(clist, row);
    if (socket->type != S_UPLOAD) {
      row++;
      continue;
    }
    upload = socket->data;
    
    if (upload->data->user_info != userinfo && upload->segment && 
	!g_list_find(running, upload->data->user_info))
      running = g_list_append(running, upload->data->user_info);
    row++;
  }

  row = 0;
  while (1) {
    if (row >= clist->rows) break;
    socket = gtk_clist_get_row_data(clist, row);
    if (socket->type != S_UPLOAD) {
      row++;
      continue;
    }
    upload = socket->data;

    if (upload->offline) {
      row++;
      continue;
    } else if (upload->data->user_info == userinfo) {
      transfer_list = g_list_append(transfer_list, upload);
      if (upload->data->status == S_QUEUED) qinfo->queued++;
    } else if (upload->data->status == S_QUEUED) {
      temp = user_info_priority(upload->data->user_info, NULL);
      if (temp > qinfo->priority) {
	// this upload definitely comes first
	qinfo->bposition++;
	qinfo->wposition++;
	if (upload->file->size > 50*1024*1024) {
	  // first factor  : percent of the file the user might download
	  // second factor : possibility that the transfer will timeout
	  qinfo->bsize += upload->file->size/2   * 2/3;
	} else {
	  qinfo->bsize += upload->file->size/4*3 * 2/3; 
	}
	qinfo->wsize += upload->file->size; // worst case as it used to be
      } else if (temp == qinfo->priority && qinfo->queued == 0) {
	qinfo->wposition++;
	// this upload has a better queue position
	if (!g_list_find(running, upload->data->user_info) &&
	    !g_list_find(app, upload->data->user_info)) {
	  // this upload definitely comes first, cause this user
	  // has no upload running yet and its the first queued upload
	  // from this user
	  qinfo->bposition++;
	  if (upload->file->size > 50*1024*1024)
	    qinfo->bsize += upload->file->size/2   * 2/3;
	  else
	    qinfo->bsize += upload->file->size/4*3 * 2/3; 
	}
	qinfo->wsize += upload->file->size;
	app = g_list_append(app, upload->data->user_info);
      }
    } else if (upload->segment) {
      // upload is already running
      long size = upload->segment->stop - upload->segment->start
	- upload->segment->size; // bytes to go
      qinfo->bsize += size;
      qinfo->wsize += size;
    } else if (upload_in_progress(upload)) {
      // this upload is about to start
      if (upload->file->size > 50*1024*1024)
	qinfo->bsize += upload->file->size/2   * 1/4;
      else
	qinfo->bsize += upload->file->size/4*3 * 1/4;
      qinfo->wsize += upload->file->size;
    }
    row++;
  }

  g_list_free(running);
  g_list_free(app);
  if (qinfo->class == PRI_FRIEND) {
    qinfo->bposition = 0;
    qinfo->wposition = 0;
    qinfo->bsize = 0;
    qinfo->wsize = 0;
  }
  return transfer_list;
}

/*
typedef struct {
  int priority;
  int class;
  int time;
} queue_info_t;

typedef struct {
  upload_t* upload;
  int timeleft;
  double timeout;
  long size;
} queue_entry_t;

static int queue_compare_item(void* item1, void* item2) {
  queue_entry_t* ent1 = item1;
  queue_entry_t* ent2 = item2;
  int pri1, pri2;

  pri1 = user_info_priority(ent1->upload->data->user_info, NULL);
  pri2 = user_info_priority(ent2->upload->data->user_info, NULL);
  if (pri1 < pri2) return 1;
  else if (pri1 > pri2) return -1;
  else return 0;
}
static void queue_delete(void* item) {
  l_free((queue_entry_t*)item);
}

GList* queue_info(user_info_t* userinfo, queue_info_t* qinfo) {
  GtkCList* clist;
  int row;
  upload_t* upload;
  socket_t* socket;
  int passed = 0;
  int temp;
  sarray_t* queue;
  sarray_t* active;
  queue_entry_t* entry;
  int running = 0;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  qinfo->priority = user_info_priority(userinfo, &(qinfo->class));
  
  if (string_list_search(LIST_ENEMY, userinfo->nick)) {
    qinfo->time = 60*60*24;   // one day
    return NULL;
  }

  queue = sarray_new(queue_compare_item, queue_delete);
  active = sarray_new(queue_compare_item, queue_delete);
  row = 0;
  while (1) {
    if (row >= clist->rows) break;
    socket = gtk_clist_get_row_data(clist, row);
    upload = socket->data;
    if (!upload->offline &&
	upload->data->user_info->timestamp != 1 &&
	NET_CONNECTED(upload->nu.net)) {
      ;
    } else if (upload->data->status == S_QUEUED) {
      entry = l_malloc(sizeof(*entry));
      entry->upload = upload;
      entry->timeleft = -1;
      entry->timeout = 0.5;                // 50% timeout
      entry->size = upload->file->size/2;  // 50% of file upload
      sarray_insert(queue, entry);
      if (upload->data->user_info == userinfo) passed = 1;
    } else if (upload->segment) {
      entry = l_malloc(sizeof(*entry));
      entry->upload = upload;
      entry->timeleft = upload->data->timeleft;
      entry->timeout = 0;                  //  0% timeout
      entry->size = 
	upload->segment->stop-
	upload->seegmen->start;            // whole segment
      sarray_insert(active, entry);
      running++;
    } else if (upload_in_progress(upload)) {
      entry = l_malloc(sizeof(*entry));
      entry->upload = upload;
      entry->timeleft = -1;
      entry->timeout = 0.75;               // 75% timeout
      entry->size = upload->file->size/2;  // half the file
      sarray_insert(queue, entry);
      running++;
    }
    row++;
  }

  // now simulate the upload
  mark = 0;
  while (1) {
    // start all possible uploads now
    temp = 0;
    while () {
    }
    // advance time
    if (temp == 0) {
    }
  }
}
*/

void send_user_status(net_t* net, char* user) {
  user_info_t* userinfo;
  queue_info_t qinfo;
  char str[2048];
  char speed[1024];
  upload_t* upload;
  download_t* download;
  GList* transfer_list;
  GList* dlist;
  chat_page_t* page;
  char* prefix;
  char temp2[100];

  page = chat_page_get_printable();
  chat_print_time_stamp(page, M_PUBLIC);
  prefix = cparse(global.scheme->client_prefix);
  if (net) {
    chat_print_colored(page, M_PUBLIC, "message", prefix);
    chat_print_text(page, M_PUBLIC, "user", "<");
    chat_print_nick(page, M_PUBLIC, user, net);
    chat_print_text(page, M_PUBLIC, "user", "> ");
    chat_print_text(page, M_PUBLIC, "message", "has requested transfer status!\n");
  } else {
    chat_print_colored(page, M_PUBLIC, "message", prefix);
    chat_print_text(page, M_PUBLIC, "message", "User status for ");
    chat_print_text(page, M_PUBLIC, "user", "<");
    chat_print_nick(page, M_PUBLIC, user, net);
    chat_print_text(page, M_PUBLIC, "user", ">\n");
  }
    
  userinfo = user_info_search(user);
  if (!userinfo) {
    if (net)
      send_notice(net, user, "Your status hasn't been registered yet.", 0);
    else
      client_message(NULL, "** Not found **");
    return;
  }
  
  transfer_list = queue_info(userinfo, &qinfo);
  
  if (net) {
    send_notice(net, user, "------------ User Classes -----------", 0);
    
    sprintf(str, " * Priority: %d (user class: %s)",
	    global.options.upload_priority[PRI_NONE],
	    UserClass[PRI_NONE]);
    send_notice(net, user, str, 0);
    sprintf(str, " * Priority: %d (user class: %s)",
	    global.options.upload_priority[PRI_SHARE],
	    UserClass[PRI_SHARE]);
    send_notice(net, user, str, 0);
    sprintf(str, " * Priority: %d (user class: %s)",
	    global.options.upload_priority[PRI_DOWNLOAD],
	    UserClass[PRI_DOWNLOAD]);
    send_notice(net, user, str, 0);
    sprintf(str, " * Priority: %d (user class: %s)",
	    global.options.upload_priority[PRI_FRIEND],
	    UserClass[PRI_FRIEND]);
    send_notice(net, user, str, 0);

    send_notice(net, user, "------------ Your Status ------------", 0);
  }

  sprintf(str, " * Priority       : %d (user class: %s)", 
	  qinfo.priority, UserClass[qinfo.class]);
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);

  sprintf(str, " * Uploads        : %d Files (%d)", 
	  userinfo->real_cur[1], userinfo->cur[1]);
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);

  sprintf(str, " * Downloads      : %d Files (%d)", 
	  userinfo->real_cur[0], userinfo->cur[0]);
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);

  if (userinfo->max[1] == 0)
    sprintf(str, " * User Up Limit  : Unlimited");
  else if (userinfo->max[1] == -1) {
    if (global.limit.default_uploads == 0)
      sprintf(str, " * User Up Limit  : Unlimited (default)");
    else
      sprintf(str, " * User Up Limit  : %d Files (default)",
	      global.limit.default_uploads);
  } else {
    sprintf(str, " * User Up Limit  : %d Files", userinfo->max[1]);
  }
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);

  if (global.limit.max_uploads == 0) {
    if (global.limit.max_large == 0)
      sprintf(str, " * Overall Limit  : Unlimited (Unlimited large Files)");
    else
      sprintf(str, " * Overall Limit  : Unlimited (%d large Files)",
	      global.limit.max_large);
  } else {
    if (global.limit.max_large == 0)
      sprintf(str, " * Overall Limit  : %d (Unlimited large Files)", 
	      global.limit.max_uploads);
    else
      sprintf(str, " * Overall Limit  : %d (%d large Files)", 
	      global.limit.max_uploads,
	      global.limit.max_large);
  }
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);


  sprintf(str, " * Queued Uploads : %d Files", qinfo.queued);
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);

  if (userinfo->limit[1] == 0)
    sprintf(str, " * Bandwidth Limit: Unlimited");
  else 
    sprintf(str, " * Bandwidth Limit: %s",
	    print_speed(speed, userinfo->limit[1], 1));
  if (net) send_notice(net, user, str, 0);
  else client_message(NULL, str);
  
  qinfo.queued = 0;
  if (transfer_list) {
    if (net) send_notice(net, user, "------------ Uploads -----------", 0);
    else client_message(NULL, "------------ %s -----------", "Uploads");
    for (dlist = transfer_list; dlist; dlist = dlist->next) {
      upload = dlist->data;
      if (net) {
	sprintf(str, " [%s] %s", _status_names(upload->data->status),
		upload->file->shortname);
	send_notice(net, user, str, 0);
      } else 
	client_message(status_names(upload->data->status),
		       upload->file->shortname);
      if (upload->data->status == S_QUEUED) qinfo.queued = 1;
    }
    g_list_free(transfer_list);
    if (net) send_notice(net, user, "--------------------------------", 0);
    else client_message(NULL, "--------------------------------") ;
  } else {
    if (net) send_notice(net, user, "------- No Uploads found -------", 0);
    else client_message(NULL, "------- %s -------", "No uploads found");
  }

  if (qinfo.queued)
    sprintf(str, "The queue position for the first requested file:");
  else
    sprintf(str, "The queue position would be:");
  if (net)
    send_notice(net, user, str, 0);
  else
    client_message(NULL, str);
  
  sprintf(str, "   Best case: %10d    Worst Case: %10d", 
	  qinfo.bposition, qinfo.wposition);
  if (net)
    send_notice(net, user, str, 0);
  else 
    client_message(NULL, str);
  sprintf(str, "Before there is a free upload slot i have to send");
  if (net) 
    send_notice(net, user, str, 0);
  else 
    client_message(NULL, str);
  sprintf(str, "   Estimated: %10s    Worst Case: %10s", 
	  print_size(speed, qinfo.bsize), print_size(temp2, qinfo.wsize));
  if (net)
    send_notice(net, user, str, 0);
  else
    client_message(NULL, str);
  
  if (net) {
    sprintf(str, "My upload bandwidth limit currently is %s/s",
	    print_size(speed, (double)global.up_width.limit));
    send_notice(net, user, str, 0);
  } else {
    transfer_list = download_list(userinfo);
    if (transfer_list) {
      client_message(NULL, "----------- %s ----------", "Downloads");
      for (dlist = transfer_list; dlist; dlist = dlist->next) {
	download = dlist->data;
	client_message(status_names(download->data->status),
		       download->file->filename);
      }
      g_list_free(transfer_list);
      if (net) send_notice(net, user, "--------------------------------", 0);
      else client_message(NULL, "--------------------------------") ;
    } else {
      client_message(NULL, "------ %s ------", "No downloads found");
    }
  }
}

double global_queue_size() {
  GList* dlist;
  double size = .0;
  net_t* net;

  for (dlist = global.net_active; dlist; dlist = dlist->next) {
    net = dlist->data;
    if (net->out_buffer)
      size += net->out_buffer->datasize;
  }
  return size;
}
void update_queue_length() {
  static GtkLabel* label = NULL;
  static char str[128];
  double size = .0;

  if (!label) 
    label = GTK_LABEL(lookup_widget(global.win, "label1687"));
  size = global_queue_size();
  print_size(str, size);
  gtk_label_set_text(label, str);
}

void download_ctree_hide(int who, int where ATTR_UNUSED) {
  GtkWidget* widget;

  widget = GTK_WIDGET(DownloadScroll[who]);
  gtk_widget_ref(widget);
  gtk_container_remove(GTK_CONTAINER(widget->parent), widget);
}

void download_ctree_show(int who, int where) {
  GtkWidget* widget;
  GtkWidget* vbox;

  widget = GTK_WIDGET(DownloadScroll[who]);
  vbox = DownloadVbox[where];
  gtk_widget_show(widget);
  gtk_box_pack_start (GTK_BOX (vbox), widget, TRUE, TRUE, 0);
  //  gtk_widget_unref(widget);
}

void notebook_hide(int who, int pos) {
  GtkNotebook* notebook;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook9"));
  gtk_notebook_remove_page(notebook, pos);
  DownloadVbox[who] = NULL;

  if (g_list_length(notebook->children) == 1) {
    gtk_notebook_set_show_tabs(notebook, FALSE);
    gtk_notebook_set_show_border(notebook, FALSE);
  }
}

void notebook_show(int who, int pos) {
  GtkNotebook* notebook;
  GtkWidget* vbox;
  GtkWidget* label;

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook9"));
  
  vbox = gtk_vbox_new (TRUE, 2);
  gtk_widget_show (vbox);
  DownloadVbox[who] = vbox;

  switch (who) {
  case 0:
    label = gtk_label_new ("Active");
    break;
  case 1:
    label = gtk_label_new ("Queued");
    break;
  case 2:
    label = gtk_label_new ("Inactive");
    break;
  case 3:
    label = gtk_label_new ("Deactivated");
    break;
  default :
    label = NULL;
  }

  gtk_notebook_insert_page(notebook, vbox, label, pos);
  if (g_list_length(notebook->children) == 2) {
    gtk_notebook_set_show_tabs(notebook, TRUE);
    gtk_notebook_set_show_border(notebook, TRUE);
  }
}

void download_layout(download_layout_t* new_layout) {
  char ctree_used[4] = {0, 0, 0, 0};
  char notebook_used[4] = {0, 0, 0, 0};
  char nctree_used[4] = {0, 0, 0, 0};
  char nnotebook_used[4] = {0, 0, 0, 0};
  int i1;
  int cnt;
  GList* dlist;

  for (i1 = 0; i1 < 4; i1++)
    ctree_used[(int)(global.dl_layout.transfer_position[i1])]++;
  for (i1 = 0; i1 < 4; i1++)
    nctree_used[(int)(new_layout->transfer_position[i1])]++;
  for (i1 = 0; i1 < 4; i1++)
    if (ctree_used[i1])
      notebook_used[(int)(global.dl_layout.ctree_position[i1])]++;
  for (i1 = 0; i1 < 4; i1++)
    if (nctree_used[i1])
      nnotebook_used[(int)(new_layout->ctree_position[i1])]++;

  // show notebooks, that will be used;
  cnt = 0;
  for (i1 = 0; i1 < 4; i1++) {
    if (notebook_used[i1] == 0) {
      if (nnotebook_used[i1] > 0) {
	notebook_show(i1, cnt);
	cnt++;
      }
    } else {
      cnt++;
    }
  }

  // ok, now move the ctrees to the correct notebook page
  // or hide it.
  for (i1 = 0; i1 < 4; i1++) {
    if (ctree_used[i1] == 0 && nctree_used[i1] == 0) continue;
    if (ctree_used[i1] == 0) {
      download_ctree_show(i1, new_layout->ctree_position[i1]);
    } else if (nctree_used[i1] == 0) {
      download_ctree_hide(i1, global.dl_layout.ctree_position[i1]);
    } else if (global.dl_layout.ctree_position[i1] !=
	       new_layout->ctree_position[i1]) {
      download_ctree_hide(i1, global.dl_layout.ctree_position[i1]);
      download_ctree_show(i1, new_layout->ctree_position[i1]);
    }
  }

  // hide notebook pages, that are not used any longer
  cnt = 0;
  for (i1 = 0; i1 < 4; i1++) {
    if (notebook_used[i1] > 0) {
      if (nnotebook_used[i1] == 0)
	notebook_hide(i1, cnt);
      else
	cnt++;
    } else if (nnotebook_used[i1] > 0) {
      cnt++;
    }
  }

  memcpy(&global.dl_layout, new_layout, sizeof(download_layout_t));

  gtk_clist_freeze(GTK_CLIST(DownloadTree[0]));
  gtk_clist_freeze(GTK_CLIST(DownloadTree[1]));
  gtk_clist_freeze(GTK_CLIST(DownloadTree[2]));
  gtk_clist_freeze(GTK_CLIST(DownloadTree[3]));
  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume_t *resume = dlist->data;
    resume_show(resume);   // reshows resume if in wrong ctree
  }
  gtk_clist_thaw(GTK_CLIST(DownloadTree[0]));
  gtk_clist_thaw(GTK_CLIST(DownloadTree[1]));
  gtk_clist_thaw(GTK_CLIST(DownloadTree[2]));
  gtk_clist_thaw(GTK_CLIST(DownloadTree[3]));
}

int chmode2int_lop(char* mode, int* chmode1, int* chmode2) {
  int plus = -1;
  int i1;

  if (!mode) return 0;

  *chmode1 = 0;
  *chmode2 = 0;

  while (*mode) {
    if (*mode == '+') {
      plus = 1;
    } else if (*mode == '-') {
      plus = 0;
    } else for (i1 = 0; i1 < CMODE_NUMBER; i1++) {
      if (CModeNames[i1][1] == *mode) {
	if (plus == 1) *chmode1 |= (1<<i1);
	else if (plus == 0) *chmode2 |= (1<<i1);
	break;
      }
    }
    mode++;
  }
  return 1;
}

char* int2chmode_lop(int set, int clear) {
  static char mode[2048];
  char* pos;
  int cnt;

  pos = mode;

  cnt = 0;
  if (set) *pos++ = '+';
  while (set) {
    if (set & 1) *pos++ = CModeNames[cnt][1];
    cnt++;
    set >>= 1;
  }
  cnt = 0;
  if (clear) *pos++ = '-';
  while (clear) {
    if (clear & 1) *pos++ = CModeNames[cnt][1];
    cnt++;
    clear >>= 1;
  }

  *pos = 0;

  if (*mode) return mode;
  else return NULL;
}

