/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#define SERVER_TIMEOUT   500

#define PRI_NONE           0
#define PRI_SHARE          1
#define PRI_DOWNLOAD       2
#define PRI_FRIEND         3

#define CMODE_TOPIC      0x01
#define CMODE_REGISTERED 0x02
#define CMODE_PRIVATE    0x04
#define CMODE_INVITE     0x08
#define CMODE_MODERATED  0x10
#define CMODE_QUIET      0x20

#define PATTERN_IGNORE     0
#define PATTERN_TEMPORARY  1
#define PATTERN_SAVE       2
#define PATTERN_SEARCH     3

#define LIST_HIGHLIGHT     0
#define LIST_FRIEND        1
#define LIST_ENEMY         2
#define LIST_IGNORE        3
#define LIST_OPCHANNEL     4
#define LIST_AUTOJOIN      5
#define LIST_NODOWNLOAD    6
#define STRING_LIST_NO     7

#define BROWSER_NONE       0
#define BROWSER_NETSCAPE   1
#define BROWSER_MOZILLA    2
#define BROWSER_LYNX       3
#define BROWSER_W3M        4
#define BROWSER_OPERA      5
#define BROWSER_NO         6

#define PIPE_AWAY_LOG    0x01
#define PIPE_CHWALLOP    0x02
#define PIPE_WALLOP      0x04
#define PIPE_GLOBAL      0x08
#define PIPE_SERVER      0x10
#define PIPE_PRIVATE     0x20
#define PIPE_DOWNLOAD    0x40
#define PIPE_UPLOAD      0x80

#define NOPIPE_SERVER    0x01
#define NOPIPE_DOWNLOAD  0x02
#define NOPIPE_PROTOCOL1 0x04
#define NOPIPE_PROTOCOL2 0x08
#define NOPIPE_UPLOAD    0x10

#define C_UNKNOWN          0
#define C_OTHER            1
#define C_WINMX            2

#define HOT_UNKNOWN     0x01
#define HOT_OFFLINE     0x02
#define HOT_ONLINE      0x03

#define TAB_ICON        0x01
#define TAB_TEXT        0x02

#define WHOIS_NONE      0x00
#define WHOIS_SHOW      0x01
#define WHOIS_TEXT      0x02

#define SPEED_NONE      0x00
#define SPEED_SHOW      0x01
#define SPEED_RESUME    0x02
#define SPEED_UPLOAD    0x04
#define SPEED_DOWNLOAD  0x08
#define SPEED_ALL       0x0F

// Weasel75
// default values if loading fails
#define SPEED_RED       1024
#define SPEED_YELLOW    4096
#define SPEED_GREEN    20480

#define G_SIZE            10
#define G_SIZE_ADD         2

// startup modes
#define L_NOT_SHARE        1
#define L_NOT_JOIN         2
#define L_WAIT_MOTD        4

#define TIME_NONE          0
#define TIME_HOUR_MIN      1
#define TIME_HOUR_MIN_SEC  2
#define TIME_BEATTIME      3

// mode for user popup
#define M_ONLINE           0
#define M_SEARCH           1
#define M_HOTLIST          2
#define M_TRANSFER         3
#define M_GLOBAL           4
#define M_WHOIS            5
#define M_TEXT             6
#define M_IGNORE           7
#define M_BROWSE           8
#define M_RESUME           9
#define M_ACCESS          10
#define M_STRING_LIST     11
#define M_SUBSCRIPTION    12

// gtk styles for some lopster widgets
#define STYLE_NUMBER       6
#define STYLE_TAB1         0
#define STYLE_TAB2         1
#define STYLE_CHAT         2
#define STYLE_LABEL        3
#define STYLE_SEARCH       4
#define STYLE_PREF         5

// user status
#define STATUS_INACTIVE    0
#define STATUS_ACTIVE      1
#define STATUS_REMOTE      2
#define STATUS_CLOAKED     3
#define STATUS_LEECHED     4
#define STATUS_MUZZLED     5
#define STATUS_UNKNOWN     6

// major mime types
#define MIME_NONE          0
#define MIME_MP3           1
#define MIME_AUDIO         2
#define MIME_VIDEO         3
#define MIME_APPLICATION   4
#define MIME_IMAGE         5
#define MIME_TEXT          6
#define MIME_SIZE          7

// debugging output control
//#define SHARE_DEBUG
//#define RESUME_DEBUG
//#define BROWSE_DEBUG
//#define GLOBAL_DEBUG
//#define SEARCH_DEBUG
//#define TRANSFER_DEBUG
//#define CONNECTION_DEBUG
//#define PROTOCOL_DEBUG
//#define TRAFFIC_DEBUG

// network type
#define N_UNKNOWN          0
#define N_OPENNAP          1
#define N_SLAVANAP         2
#define N_CQ_NAP           3
#define N_NAPSTER          4

// socket type
#define S_UNKNOWN          0
#define S_SHARE            1
#define S_BROWSE           2
#define S_TRANSFER         3
#define S_SERVER           4
#define S_HTTP             5
#define S_DATA             6
#ifdef ENABLE_WHITE_BOARD
 #define S_WHITEBOARD       7
#endif

// exit mode
#define E_NONE             0
#define E_NORMAL           1
#define E_SAFE             2

// chat page type
#define P_FIX              0
#define P_PRIVATE          1
#define P_PUBLIC           2
#define P_OTHER            3

// transfer status
#define S_INACTIVE         0
#define S_CONNECTING       1
#define S_INFO             2
#define S_FINISHED         3
#define S_DOWNLOADING      4
#define S_UPLOADING        5
#define S_TIMEOUT          6
#define S_REJECT           7
#define S_INCOMPLETE       8
#define S_CANCELED         9
#define S_INFO1           10
#define S_INFO2           11
#define S_INFO3           12
#define S_WAITING         13
#define S_FIREWALL        14
#define S_CONERROR        15
#define S_QUEUED          16
#define S_REMOTE          17
#define S_UNAVAILABLE     18
#define S_RESUME_ERR      19
#define S_DELETE          20
#define S_IO              21
#define S_NUMBER          22

// transfer types
#define T_UNKNOWN          0
#define T_DOWNLOAD         1
#define T_UPLOAD           2

#define TRANSFER_HISTORY_TIME         60	// 60 seconds

// transfer major types
#define T_NONE             0	// inactive
#define T_CURRENT          1	// conecting..downloading
#define T_STOPPED          2	// active, but stopped (queue)
#define T_TRANSFER         3	// transfering

// download retry flags
#define RETRY_TIMEOUT         0x01
#define RETRY_REJECT          0x02
#define RETRY_INCOMPLETE      0x04
#define RETRY_CONERROR        0x08
#define RETRY_REMOTE          0x10
#define RETRY_UNAVAILABLE     0x20

// download remove flags
#define REMOVE_D_FINISHED    0x001
#define REMOVE_D_ABORTED     0x002
#define REMOVE_D_OFFLINE     0x004

// upload remove flags
#define REMOVE_U_FINISHED    0x001
#define REMOVE_U_ABORTED     0x002
#define REMOVE_U_QUEUED      0x004
#define REMOVE_U_OFFLINE     0x008

// upload advanced flags
#define AU_RESTART           0x002

// resume status
#define R_ACTIVE                 0
#define R_QUEUED                 1
#define R_FINISHED               2

// search status
#define SEARCH_ACTIVE            0
#define SEARCH_QUEUED            1
#define SEARCH_FINISHED          2

// destination for search
#define DEST_NAPSTER             0
#define DEST_HOTLIST             1
#define DEST_LIBRARY             2
#define DEST_SEARCH              3

// flags for files in library
#define FLAG_TO_REMOVE           1
#define FLAG_TO_SHARE            2
#define FLAG_TO_DELETE           4
#define FLAG_TO_UNSHARE          8
#define FLAG_SHARED             16

#define SERVER (global.napster?((server_t*)(global.napster->data)):(NULL))

// user level
typedef enum
{
  L_LEECH,
  L_USER,
  L_MOD,
  L_ADMIN,
  L_ELITE
}
user_level_t;


typedef struct _geometry_t geometry_t;
typedef struct _chat_page_t chat_page_t;
typedef struct _afk_t afk_t;
typedef struct _clone_t clone_t;
typedef struct _client_t client_t;
typedef struct _suffix_t suffix_t;
typedef struct _mime_t mime_t;
typedef struct _user_t user_t;
typedef struct _link_t link_t;
typedef struct _network_t network_t;
typedef struct _limit_t limit_t;
typedef struct _option_t option_t;
typedef struct _status_t status_t;
typedef struct _file_t file_t;
typedef struct _pix_t pix_t;
typedef struct _bandwidth_t bandwidth_t;
typedef struct _napigator_t napigator_t;
typedef struct _global_t global_t;
typedef struct _transfer_t transfer_t;
typedef struct _resume_t resume_t;
typedef struct _user_info_t user_info_t;
typedef struct _search_t search_t;
typedef struct _search_pattern_t search_pattern_t;
typedef struct _napster_command_t napster_command_t;
typedef struct _server_t server_t;
typedef struct _socket_t socket_t;
typedef struct _style_t style_t;
typedef struct _scheme_t scheme_t;
typedef struct _user_timestamp_t user_timestamp_t;
typedef struct _statistic_t statistic_t;
typedef struct _hot_t hot_t;
typedef struct _whois_t whois_t;
typedef struct _speed_t speed_t;
typedef struct _file_tips_t file_tips_t;
typedef struct _access_t access_t;
typedef struct _browse_t browse_t;
typedef struct _subscription_t subscription_t;

struct _subscription_t {
  char* user;
  int friend_while_subs;
  GList* files;
};

struct _browse_t
{
  char *nick;
  char buf[2048];
  int pos;
};

struct _access_t
{
  char *name;
  time_t last;
  int accesses;
  GList **access_list;
  int done;
};

struct _speed_t
{
  char *user;
  int flag;
  int speed;
  time_t sent;
};

struct _whois_t
{
  int flag;
  time_t received;
  int online;
  int advanced;
  int yourself;

  char *user;
  user_level_t level;
  time_t online_time;
  char *channels;
  char *status;
  int shared;
  int downloads;
  int uploads;
  int link;
  char *client;

  // advanced
  int total_down;
  int total_up;
  char *ip;
  int server_port;
  int data_port;
  char *email;
  char* server;
};

struct _geometry_t
{
  int x;
  int y;
  int width;
  int height;
};

struct _chat_page_t
{
  char *name;
  GtkWidget *window;		// window, if present
  GtkWidget *header;		// topic text
  GtkWidget *wallop;		// wallop text
  GtkWidget *main;		// main text
  GtkWidget *tlabel;		// label text widget
  GtkWidget *mlabel;		// label widget
  GtkWidget *online;		// online clist
  GtkWidget *no;		// online number widget
  GtkWidget *toplevel;		// toplevel widget
  GtkWidget *paned;		//
  int snap;
  int modified;
  int timeout;
  int type;
  int active;
  int lines;
  int close_on_part;
  int chmode;
  int limit;
  user_level_t level;
};

struct _afk_t
{
  char *message;
  time_t since;
};

struct _clone_t
{
  GList *nicks;
  char *ip;
};

struct _client_t
{
  char *info;
  int logins;
  int cnt;
};

struct _suffix_t
{
  char *suffix;
  char *application;
  int as_mp3;
};

struct _mime_t
{
  GList *shared;
  char *download;
  GList *suffixes;
};

struct _user_t
{
  char username[100];
  char password[100];
  char email[100];
  int linespeed;
  int shared;
  int unshared;
  double bytes;
  user_level_t level;
  int status;
  GList *files;
  int timeout;
  GtkWidget *link;
  double filesize_info[MIME_SIZE];
  int filecount_info[MIME_SIZE];
};

struct _link_t
{
  char *server;
  GList *links;
  char *ping;
};

struct _network_t
{
  int port;
  int firewall;
  int transfer_delay;
  int transfer_timeout;
};

struct _limit_t
{
  int max_searches;
  int max_searches_real;
  int max_downloads;
  int max_uploads;
  int max_large;
  int large_size;
  int default_uploads;
  int default_downloads;
  int cur_uploads;
  int cur_downloads;
  int cur_large;
  int cur_real_downloads;
  int cur_real_uploads;
  int download_percent;
};

struct _option_t
{
  char show_joins;
  char show_parts;
  char recent_timeout;
  char public_ignore;
  char parse_color;
  char logging;
  char log_expire;
  int auto_retry;
  int dl_autoremove;
  int ul_autoremove;
  int advanced_upload;
  int autoresume_download;
  int resume_abort[4];
  unsigned int popup_create;
  int login_mode;
  int timestamps;
  int dummy_md5;
  int tab_style;
  int channel_rejoin;
  char confirm_delete;
  int access_timeout;
  int access_save;
  int check_version;
  int piping;
  int no_piping;
  int colored_nicks;
  int resume_timeout;
  int check_lib_for_download;
  int auto_search;
  int allow_dcc;
  int auto_resume;
  int auto_connect;
  int auto_reconnect;
  int rejoin_when_kicked;
  int time_display;
  char *config_dir;
  char *config_file;
  int browser;
  int retry_timeout[6];
  int upload_priority[4];
  //Weasel75
  int speedred, speedyellow, speedgreen;
  int emulate_winmx;
};

struct _status_t
{
  char connection;
  char searching;
  char exiting;
  char rc_read;
  char search_read;
  char access_read;
  char geometry_read;
  char building;
};

struct _file_t
{
  char *longname;		// local name
  char *shortname;		// short local name
  char *winname;		// web name
  unsigned long size;
  char *user;
  unsigned long ip;		// for search response
  char *md5;
  int bitrate;
  int frequency;
  int duration;
  int linespeed;
  int flags;			// 1=in lib  2=shared
  int local;
  int mime_type;
  int ping;
  int vbr;
};

struct _file_tips_t
{
  GtkWidget *widget;
  GtkWidget *tips;
  file_t *file;
  int row;
  int col;
  int timeout;
};

#ifdef TRAFFIC_DEBUG
typedef struct
{
  int cnt;
  long long bytes;
}
traffic_t;
#endif

struct _statistic_t
{
  double incomplete[2];
  double download[2];
  double upload[2];
  double total[2];
  int no_download[S_NUMBER+1];
  int cur_down;
  int no_upload[S_NUMBER+1];
  int cur_up;
  int *upload_band;
  int *download_band;
  int band_pos[2];
  int band_size[2];
  int access_format;
  access_t *file_access;
#ifdef TRAFFIC_DEBUG
  traffic_t traffic[2][10302 + 1];
#endif
};

struct _pix_t
{
  GdkPixmap *sgray;
  GdkBitmap *sgrayb;
  GdkPixmap *sgreen;
  GdkBitmap *sgreenb;
  GdkPixmap *syellow;
  GdkBitmap *syellowb;
  GdkPixmap *sred;
  GdkBitmap *sredb;

  GdkPixmap *folder;
  GdkBitmap *folderb;
  GdkPixmap *folder_open;
  GdkBitmap *folder_openb;
  GdkPixmap *user1;
  GdkBitmap *user1b;
  GdkPixmap *user2;
  GdkBitmap *user2b;
  GdkPixmap *ignore;
  GdkBitmap *ignoreb;
  GdkPixmap *enemy;
  GdkBitmap *enemyb;
  GdkPixmap *enemy2;
  GdkBitmap *enemy2b;
  GdkPixmap *friend;
  GdkBitmap *friendb;
  GdkPixmap *dummy;
  GdkBitmap *dummyb;
};

struct _bandwidth_t
{
  long limit;
  long current;
  long maxval;
  GtkWidget *area;
  GtkWidget *label_max;
  GtkWidget *label_cur;
  long bytes;
};

struct _napigator_t
{
  int use_proxy;
  char *proxy_url;
  int proxy_port;
};

struct _global_t
{
  //wins
  GtkWidget *win;
  GtkWidget *connect_win;
  GtkWidget *whois_win;
  GtkWidget *options_win;
  GtkWidget *ban_win;
  GtkWidget *usermode_win;
  GtkWidget *client_win;
  GtkWidget *user_win;
  GtkWidget *socket_win;
  GtkWidget *splash_win;
  GtkWidget *string_win;
  GtkWidget *file_win;
  GtkWidget *queue_win;
  GtkWidget *subscription_win;

  time_t current_time;
  socket_t *napster;		// connected server
  socket_t *upload_socket;	// listen socket file transfer
  user_t user;			// you
  mime_t mimetype[MIME_SIZE];
  status_t status;
  server_t *last_server;
  pix_t pix;			// pix for intern use

  GList *string_list[STRING_LIST_NO];
  GList *servers;		// list of servers
  GList *commands;		// the list of commands
  GList *chat_history;		// history of input line
  int history_pos;
  GList *hotlist;		// users in hot list
  GList *logs;			// list of open logfiles
  GList *incomplete;		// list of incomplete downloads
  GList *client_list;
  GList *clones;
  GList *search_pattern;
  GList *searches;
  GList *usermode;
  GList *chat_pages;
  chat_page_t *current_page;
  GList *queue;
  GList *share_queue;
  GList *browses;
  GList *sockets;

  bandwidth_t down_width;
  bandwidth_t up_width;
  int popup_row;
  GtkWidget *popup_list;
  int timer;
  afk_t afk;
  char *reply;
  char *session_start;
  time_t start_time;
  link_t *links;
  link_t *allowed_links;
  GtkStyle *style[STYLE_NUMBER];
  GdkColor color_table[16];
  char *clientinfo;
  int extra_win;
  char *incomplete_path;
  int search_width[7];
  int search_show[7];
  int browse_width[5];
  int browse_show[5];

  //options
  network_t network;		// network options
  limit_t limit;		// limit options
  option_t options;		// other options
  statistic_t statistic;
  napigator_t napigator;	// napigator options

  // some temp geometry info
  int connect_button;
  int online_width[3];
  int online_show[3];
  int paned_pos;
  int paned_pos2;
  geometry_t geometry[G_SIZE];
  char *rainbow_colors;
  GList *allowed_ports;
  scheme_t *scheme;
  char *auto_save;
  GList *execs;
  GList *pings;
  char *ping_command;
  GList *appearance;
  GList *userstamp;
  GList *whois_requests;
  GList *speed_requests;
  GList *userinfo;
  int reconnect_timer;
  int resume_timer;
  unsigned long my_ip;
  int path_warned;
  GList* subscriptions;
#ifdef ENABLE_WHITE_BOARD
  GList* whiteboards;
#endif
};

struct _user_info_t
{
  char *user;
  char* last_server;
  int linespeed;
  // up/download
  int real_cur[2];   // dl, ul
  int cur[2];   // dl, ul
  int max[2];
  long bytes[2];
  long limit[2];
  int ignore_global[2];
  time_t timestamp;
  time_t last_seen;
  // additional upload
  int shares;
  int remotes;
  int client;
};

struct _transfer_t
{
  char *longname;
  char *shortname;
  char *winname;
  char *download_dir;
  char *md5;

  user_info_t *user_info;
  unsigned long progress;
  double rate;
  int timeleft;
  time_t start_time;
  time_t end_time;
  unsigned long start_size;
  int status;
  unsigned long size;
  FILE *file;
  int type;
  int is_dcc;

  long history[TRANSFER_HISTORY_TIME];
  int hist_cnt;
  int hist_pos;

  char *resume_check;
  int check_length;
  int mime_type;
  resume_t *resume;
  int queue;
};

struct _resume_t
{
  char *filename;
  char *dirname;
  unsigned long size;
  long local_size;
  search_t *search;
  socket_t *socket;
  char *user;
  char *org_file;
  char *search_string;
  int online;
  int status;
  time_t last_access;
  GList *downloads;
  GtkCTree* ctree;
  GtkCTreeNode* node;
  int is_dcc;
};

struct _search_pattern_t
{
  char *name;
  char *include;
  char *exclude;
  int max_results;
  char *media_type;
  int destination;
  char *bitrate_lo;
  char *bitrate_hi;
  char *freq_lo;
  char *freq_hi;
  char *speed_lo;
  char *speed_hi;
  unsigned long size_lo;
  unsigned long size_hi;
  int duration_lo;
  int duration_hi;
  int id;
  int level;
};

struct _search_t
{
  search_pattern_t *pattern;
  GList *results;
  int type;
  int resume;
  int status;
  int local;
  void *link;
  time_t timestamp;
};

struct _socket_t
{
  unsigned long ip_long;
  int port;
  int fd;
  int input;
  int timeout;
  int cnt;			// intern counter
  int max_cnt;			// max count for timeout
  void *data;
  int type;
};

struct _server_t
{
  char *address;
  char *description;
  int port;
  char *nick;
  char *passwd;
  int meta;
  int network;
  int major;
  int minor;
  int micro;
};

struct _napster_command_t
{
  gint16 type;
  unsigned char *data;
};

struct _scheme_t
{
  char *name;
  GList *colors;		// the color scheme
  char *server_prefix;
  char *client_prefix;
  char *join_prefix;
  char *part_prefix;
};

struct _style_t
{
  char *name;
  char *n_fore;
  char *n_back;
  char *n_font;
  GdkFont *font;
  GdkColor *fore;
  GdkColor *back;
};

struct _user_timestamp_t
{
  char *user;
  struct timeval tv;
};

struct _hot_t
{
  char *user;
  char *description;
  int speed;
  int online;
  int visible;
};

/*
*/
/* 
   i:line : only allowed ips
   d:line : rejects unless in e_line
   e:line : ... 
 */
