#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/utsname.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"
#include "log.h"
#include "statistic.h"

void statistic_init(statistic_t* stat) {
  int i1;
  GtkWidget* temp;

  stat->incomplete[0] = .0;
  stat->incomplete[1] = .0;
  stat->download[0] = .0;
  stat->download[1] = .0;
  stat->upload[0] = .0;
  stat->upload[1] = .0;
  stat->total[0] = .0;
  stat->total[1] = .0;
  /*
  stat->size_down[0] = 0;
  stat->size_down[1] = 100;
  stat->download_band = (int*)malloc(stat->size_down[1]*sizezof(int));
  stat->size_up[0] = 0;
  stat->size_up[1] = 100;
  stat->upload_band = (int*)malloc(stat->size_up[1]*siezof(int));
  */
  for (i1 = 0; i1 < S_NUMBER; i1++) {
    stat->no_download[i1] = 0;
    stat->no_upload[i1] = 0;
  }
  stat->cur_down = 0;
  stat->cur_up = 0;

  temp = lookup_widget(global.win, "drawingarea3");
  i1 = temp->allocation.width;
  stat->download_band = (int*)malloc(sizeof(int)*i1);
  stat->band_size[0] = i1;
  stat->band_pos[0] = 0;
  memset(stat->download_band, 0, sizeof(int)*i1);

  temp = lookup_widget(global.win, "drawingarea4");
  i1 = temp->allocation.width;
  stat->upload_band = (int*)malloc(sizeof(int)*i1);
  stat->band_size[1] = i1;
  stat->band_pos[1] = 0;
  memset(stat->upload_band, 0, sizeof(int)*i1);
  //  printf("size %d %d\n", stat->band_size[0], stat->band_size[1]);
  
  stat->file_access = access_new(NULL, _("File Request Statistic"), 0);
  stat->file_access->last = 0;
  stat->file_access->accesses = 0;
  access_load();
}

void statistic_update(statistic_t* stat) {
  GList* dlist;
  resume_t* resume;
  socket_t* socket;
  transfer_t* transfer;

  // calcing incomplete
  stat->incomplete[0] = .0;
  stat->incomplete[1] = .0;
  for (dlist = global.incomplete; dlist; dlist = dlist->next) {
    resume = (resume_t*)(dlist->data);
    stat->incomplete[0] += resume->local_size;
    stat->incomplete[1] += resume->size;
  }

  stat->download[0] = .0;
  stat->download[1] = .0;
  stat->upload[0] = .0;
  stat->upload[1] = .0;
  for (dlist = global.sockets; dlist; dlist = dlist->next) {
    socket = (socket_t*)(dlist->data);
    if (!socket) continue;
    if (socket->type != S_TRANSFER) continue;
    transfer = (transfer_t*)(socket->data);
    if (!transfer) continue;
    if ((transfer->status != S_DOWNLOADING) &&
	(transfer->status != S_UPLOADING)) continue;
    if (transfer->type == T_DOWNLOAD) {
      stat->download[0] += transfer->progress;
      stat->download[1] += transfer->size;
    } else if (transfer->type == T_UPLOAD) {
      stat->upload[0] += transfer->progress;
      stat->upload[1] += transfer->size;
    }
  }

  // calcing download and upload
  stat->download_band[stat->band_pos[0]] = global.down_width.bytes;
  stat->band_pos[0]++;
  if (stat->band_pos[0] >= stat->band_size[0]) stat->band_pos[0] = 0;
  
  stat->upload_band[stat->band_pos[1]] = global.up_width.bytes;
  stat->band_pos[1]++;
  if (stat->band_pos[1] >= stat->band_size[1]) stat->band_pos[1] = 0;
  
}

void statistic_draw_bars(statistic_t* stat, int full) {
  GtkWidget* temp;
  int width, height;
  int posx, posy;
  char str[1024];
  char str2[1024];
  GdkColor colors[S_NUMBER] = {
    { 0, 0x0000, 0x0000, 0x0000 },  // 0
    { 0, 0x0000, 0x0000, 0x0000 },
    { 0, 0x0000, 0x0000, 0x0000 },
    { 0, 0xbbbb, 0xbbbb, 0xffee },
    { 0, 0x9999, 0x9999, 0xffee },  // 4
    { 0, 0x9999, 0x9999, 0xffee },
    { 0, 0xbbbb, 0x6666, 0x4444 },
    { 0, 0xbbbb, 0x4444, 0x6666 },
    { 0, 0xbbbb, 0x6666, 0x6666 },  // 8
    { 0, 0xbbbb, 0x4444, 0x4444 },
    { 0, 0x0000, 0x0000, 0x0000 },
    { 0, 0x0000, 0x0000, 0x0000 },
    { 0, 0x0000, 0x0000, 0x0000 },  // 12
    { 0, 0x0000, 0x0000, 0x0000 },
    { 0, 0xbbbb, 0x6666, 0x8888 },
    { 0, 0xbbbb, 0x8888, 0x8888 },
    { 0, 0x0000, 0x0000, 0x0000 },  // 16
    { 0, 0xbbbb, 0x9999, 0x8888 },
    { 0, 0xbbbb, 0x8888, 0x9999 },
    { 0, 0xbbbb, 0xaaaa, 0x9999 },
    { 0, 0xbbbb, 0xaaaa, 0xaaaa },  // 20
    { 0, 0xbbbb, 0xBBBB, 0xbbbb }
  };
  static GdkGC *gc = NULL;
  int number, i1;
  int old_x = 0;
  int new_x = 0;

  temp = lookup_widget(global.win, "drawingarea5");
  if (!temp->window) return;
  temp = lookup_widget(global.win, "drawingarea6");
  if (!temp->window) return;
  temp = lookup_widget(global.win, "drawingarea7");
  if (!temp->window) return;
  temp = lookup_widget(global.win, "drawingarea8");
  if (!temp->window) return;
  temp = lookup_widget(global.win, "drawingarea9");
  if (!temp->window) return;


  temp = lookup_widget(global.win, "drawingarea7");
  width = temp->allocation.width;
  height = temp->allocation.height;
  if (full) {
    gtk_paint_box(temp->style, temp->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_IN,
		  NULL, temp, "trough",
		  0, 0, width, height);
    gtk_paint_flat_box(temp->style, temp->window,
		       GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		       NULL, temp, "entry_bg",
		       2, 2, width-4, height-4);
  }
  if (stat->incomplete[1] > 0) {
    posx = (width-4)*stat->incomplete[0]/stat->incomplete[1];
    if (posx > 0)
      gtk_paint_box(temp->style, temp->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, temp, "bar",
		    2, 2, posx, height-4);
    if (posx < width-4)
      gtk_paint_flat_box(temp->style, temp->window,
			 GTK_STATE_NORMAL, GTK_SHADOW_NONE,
			 NULL, temp, "entry_bg",
			 posx+2, 2, width-posx-4, height-4);
    print_size(str2, stat->incomplete[1]);
    sprintf(str, _("%.1f%% of %s"), stat->incomplete[0]/stat->incomplete[1]*100, str2);
    if (posx + 20 + gdk_string_width(temp->style->font, str) > width) {
      posx -= (10 + gdk_string_width(temp->style->font, str));
    } else {
      posx += 10;
    }
    posy = (height + gdk_string_height(temp->style->font, str))/2-1;
    //    posy = (height + temp->style->font->ascent)/2;
    gtk_paint_string(temp->style, temp->window,
		     GTK_STATE_PRELIGHT, NULL, temp, "label",
		     posx, posy, str);
  }

  temp = lookup_widget(global.win, "drawingarea8");
  width = temp->allocation.width;
  height = temp->allocation.height;
  if (full) {
    gtk_paint_box(temp->style, temp->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_IN,
		  NULL, temp, "trough",
		  0, 0, width, height);
    gtk_paint_flat_box(temp->style, temp->window,
		       GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		       NULL, temp, "entry_bg",
		       2, 2, width-4, height-4);
  }
  if (stat->download[1] > 0) {
    posx = width*stat->download[0]/stat->download[1];
    if (posx > 0)
      gtk_paint_box(temp->style, temp->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, temp, "bar",
		    2, 2, posx, height-4);
    if (posx < width-4)
      gtk_paint_flat_box(temp->style, temp->window,
			 GTK_STATE_NORMAL, GTK_SHADOW_NONE,
			 NULL, temp, "entry_bg",
			 posx+2, 2, width-posx-4, height-4);
    print_size(str2, stat->download[1]);
    sprintf(str, _("%.1f%% of %s"), stat->download[0]/stat->download[1]*100, str2);
    if (posx + 20 + gdk_string_width(temp->style->font, str) > width) {
      posx -= (10 + gdk_string_width(temp->style->font, str));
    } else {
      posx += 10;
    }
    posy = (height + gdk_string_height(temp->style->font, str))/2-1;
    gtk_paint_string(temp->style, temp->window,
		     GTK_STATE_PRELIGHT, NULL, temp, "label",
		     posx, posy, str);
  }

  temp = lookup_widget(global.win, "drawingarea9");
  width = temp->allocation.width;
  height = temp->allocation.height;
  if (full) {
    gtk_paint_box(temp->style, temp->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_IN,
		  NULL, temp, "trough",
		  0, 0, width, height);
    gtk_paint_flat_box(temp->style, temp->window,
		       GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		       NULL, temp, "entry_bg",
		       2, 2, width-4, height-4);
  }
  if (stat->upload[1] > 0) {
    posx = width*stat->upload[0]/stat->upload[1];
    if (posx > 0)
      gtk_paint_box(temp->style, temp->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, temp, "bar",
		    2, 2, posx, height-4);
    if (posx < width-4)
      gtk_paint_flat_box(temp->style, temp->window,
			 GTK_STATE_NORMAL, GTK_SHADOW_NONE,
			 NULL, temp, "entry_bg",
			 posx+2, 2, width-posx-4, height-4);
    print_size(str2, stat->upload[1]);
    sprintf(str, _("%.1f%% of %s"), stat->upload[0]/stat->upload[1]*100, str2);
    if (posx + 20 + gdk_string_width(temp->style->font, str) > width) {
      posx -= (10 + gdk_string_width(temp->style->font, str));
    } else {
      posx += 10;
    }
    posy = (height + gdk_string_height(temp->style->font, str))/2-1;
    gtk_paint_string(temp->style, temp->window,
		     GTK_STATE_PRELIGHT, NULL, temp, "label",
		     posx, posy, str);
  }

  for (number = 0; number < S_NUMBER; number++) {
    gdk_color_alloc(gtk_widget_get_colormap(global.win), &colors[number]);
  }

  if (!gc) gc = gdk_gc_new(global.win->window);

  temp = lookup_widget(global.win, "drawingarea5");
  width = temp->allocation.width;
  height = temp->allocation.height;
  
  number = 0;
  old_x = 0;
  if (stat->no_download[0] > 0) {
    gdk_gc_copy(gc, GTK_WIDGET(global.win)->style->black_gc);
    for (i1 = 1; i1 < S_NUMBER; i1++) {
      number += stat->no_download[i1];
      new_x = width*number/stat->no_download[0] - old_x;

      gdk_gc_set_foreground(gc, &colors[i1]);
      gdk_draw_rectangle(temp->window, gc, TRUE, 
			 old_x, 0, new_x, height);
      gdk_gc_set_foreground(gc, &colors[0]);
      gdk_draw_line(temp->window, gc, 
		    old_x, 0, old_x, height);
      old_x += new_x;
    }
  }

  temp = lookup_widget(global.win, "drawingarea6");
  width = temp->allocation.width;
  height = temp->allocation.height;

  number = 0;
  old_x = 0;
  if (stat->no_upload[0] > 0) {
    gdk_gc_copy(gc, GTK_WIDGET(global.win)->style->black_gc);
    for (i1 = 1; i1 < S_NUMBER; i1++) {
      number += stat->no_upload[i1];
      // draw the background (unfilled progress)
      new_x = width*number/stat->no_upload[0] - old_x;

      gdk_gc_set_foreground(gc, &colors[i1]);
      gdk_draw_rectangle(temp->window, gc, TRUE, 
			 old_x, 0, new_x, height);
      gdk_gc_set_foreground(gc, &colors[0]);
      gdk_draw_line(temp->window, gc, 
		    old_x, 0, old_x, height);
      old_x += new_x;
    }
  }
}

void statistic_output(statistic_t* stat) {
  GtkWidget* temp;
  char str[1024];
  char str2[1024];
  char* text;
  time_t tim;

  statistic_draw_bars(stat, 0);

  temp = lookup_widget(global.win, "label792");
  if (stat->cur_down)
    sprintf(str, _("[Downloads] %s: %d - Total: %d"), status_names(stat->cur_down), 
	    global.statistic.no_download[stat->cur_down],
	    global.statistic.no_download[0]);
  else
    sprintf(str, _("Total downloads: %d"), stat->no_download[0]);
  gtk_label_set_text(GTK_LABEL(temp), str);

  temp = lookup_widget(global.win, "label793");
  if (stat->cur_up)
    sprintf(str, _("[Uploads] %s: %d - Total: %d"), status_names(stat->cur_up), 
	    global.statistic.no_upload[stat->cur_up],
	    global.statistic.no_upload[0]);
  else
    sprintf(str, _("Total uploads: %d"), stat->no_upload[0]);
  gtk_label_set_text(GTK_LABEL(temp), str);

  time(&tim);
  if (tim <= global.start_time) tim = global.start_time+1;

  temp = lookup_widget(global.win, "label790");
  print_size(str, stat->total[0]);
  print_speed(str2, stat->total[0]/(tim - global.start_time), 1);
  text = g_strdup_printf("%s (%s)", str, str2);
  gtk_label_set_text(GTK_LABEL(temp), text);
  free(text);

  temp = lookup_widget(global.win, "label791");
  print_size(str, stat->total[1]);
  print_speed(str2, stat->total[1]/(tim - global.start_time), 1);
  text = g_strdup_printf("%s (%s)", str, str2);
  gtk_label_set_text(GTK_LABEL(temp), text);
  free(text);

  statistic_draw_download(stat);
  statistic_draw_upload(stat);

  access_ctree_remove_old();
}

void statistic_draw_download(statistic_t* stat) {
  int i1, i2, i3, i4, i5;
  int width, height;
  int max = 0;
  GdkColor color = { 0, 0x8888, 0x8888, 0x9999 };
  GdkColor color2 = { 0, 0x0000, 0x0000, 0x0000 };
  GdkColor color3 = { 0, 0xcccc, 0x4444, 0x4444 };
  GdkColor color4 = { 0, 0x0000, 0xcccc, 0x0000 };
  static GdkGC *gc = NULL;
  static GdkGC *gc2 = NULL;
  static GdkGC *gc3 = NULL;
  static GdkGC *gc4 = NULL;
  GtkWidget* temp;
  int pos;
  GdkFont* font;
  char str[1024];
  long bytes;
  long av_bytes;
  int add;
  int theight;

  if (!global.win->window) return;

  for (i1 = 0; i1 < stat->band_size[0]; i1++) {
    if (stat->download_band[i1] > max)
      max = stat->download_band[i1];
  }
  max = (int)(max*1.1);
  if (max == 0) max = 1;

  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color2);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color3);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color4);
  if (!gc) gc = gdk_gc_new(global.win->window);
  if (!gc2) gc2 = gdk_gc_new(global.win->window);
  if (!gc3) gc3 = gdk_gc_new(global.win->window);
  if (!gc4) gc4 = gdk_gc_new(global.win->window);
  gdk_gc_set_foreground(gc, &color);
  gdk_gc_set_foreground(gc2, &color2);
  gdk_gc_set_foreground(gc3, &color3);
  gdk_gc_set_foreground(gc4, &color4);
  font = gdk_font_load ("-Adobe-Helvetica-medium-R-Normal--*-100-*-*-*-*-iso8859-*");
  
  temp = lookup_widget(global.win, "drawingarea3");
  if (!temp->window) return;

  width = temp->allocation.width;
  height = temp->allocation.height;
  if (width > stat->band_size[0]) width = stat->band_size[0];

  i3 = 32;
  while (height*i3 < 25*max) i3*=2;

  bytes = 0;
  pos = stat->band_pos[0];
  for (i1 = width-1; i1 >= 0; i1--) {
    pos--;
    if (pos < 0) pos = stat->band_size[0]-1;
    i2 = height*stat->download_band[pos]/max;
    gdk_draw_line(temp->window, gc2,
		  i1, 0,
		  i1, height-i2);
    gdk_draw_line(temp->window, gc,
		  i1, height-i2,
		  i1, height-1);
    if ((width-i1) % 60 == 0) {
      i4 = (width-i1) / 60;
      gdk_draw_line(temp->window, gc3, i1, height-15, i1, height-1);
      sprintf(str, "%d min", i4);
      gdk_draw_string(temp->window, font, gc3, i1+2, height-3, str);
      add = i3/4;
    } else {
      add = i3;
    }

    i4 = 0;
    while (1) {
      i4 += add;
      i5 = height*i4/max;
      if (i5 > height) break;
      if ((i5 > i2) || (i1%8 == 0) || (add!=i3))
	gdk_draw_point(temp->window, gc3, i1, height-i5);
    }
    bytes += stat->download_band[pos];
    av_bytes= (long)((double)bytes / (double)(width-i1));
    i4 = height*av_bytes/max;
    gdk_draw_point(temp->window, gc4, i1, height-i4);
  }

  theight = gdk_string_height(font, "1,23KB");
  i4 = 0;
  while (1) {
    i4 += i3;
    i5 = height*i4/max;
    if (height-i5 < theight+5) break;
    print_size(str, i4);
    gdk_draw_string(temp->window, font, gc3, 5, height-i5+theight+2, str);
  }
  if (height-i5 > 0)
    gdk_draw_string(temp->window, font, gc3, 2, height-i5+theight+2, _("Download"));
  else gdk_draw_string(temp->window, font, gc3, 2, theight+2, _("Download"));
}

void statistic_draw_upload(statistic_t* stat) {
  int i1, i2, i3, i4, i5;
  int width, height;
  int max = 0;
  GdkColor color = { 0, 0x8888, 0x8888, 0x9999 };
  GdkColor color2 = { 0, 0x0000, 0x0000, 0x0000 };
  GdkColor color3 = { 0, 0xcccc, 0x4444, 0x4444 };
  GdkColor color4 = { 0, 0x0000, 0xcccc, 0x0000 };
  static GdkGC *gc = NULL;
  static GdkGC *gc2 = NULL;
  static GdkGC *gc3 = NULL;
  static GdkGC *gc4 = NULL;
  GtkWidget* temp;
  int pos;
  GdkFont* font;
  char str[1024];
  long bytes;
  long av_bytes;
  int add;
  int theight;

  if (!global.win->window) return;

  for (i1 = 0; i1 < stat->band_size[1]; i1++) {
    if (stat->upload_band[i1] > max)
      max = stat->upload_band[i1];
  }
  max = (int)(max*1.1);
  if (max == 0) max = 1;
  
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color2);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color3);
  gdk_color_alloc(gtk_widget_get_colormap(global.win), &color4);
  if (!gc) gc = gdk_gc_new(global.win->window);
  if (!gc2) gc2 = gdk_gc_new(global.win->window);
  if (!gc3) gc3 = gdk_gc_new(global.win->window);
  if (!gc4) gc4 = gdk_gc_new(global.win->window);
  gdk_gc_set_foreground(gc, &color);
  gdk_gc_set_foreground(gc2, &color2);
  gdk_gc_set_foreground(gc3, &color3);
  gdk_gc_set_foreground(gc4, &color4);
  font = gdk_font_load ("-Adobe-Helvetica-medium-R-Normal--*-100-*-*-*-*-iso8859-*");
  
  temp = lookup_widget(global.win, "drawingarea4");
  if (!temp->window) return;

  width = temp->allocation.width;
  height = temp->allocation.height;
  if (width > stat->band_size[1]) width = stat->band_size[1];

  i3 = 32;
  while (height*i3 < 25*max) i3*=2;

  bytes = 0;
  pos = stat->band_pos[1];
  for (i1 = width-1; i1 >= 0; i1--) {
    pos--;
    if (pos < 0) pos = stat->band_size[1]-1;
    i2 = height*stat->upload_band[pos]/max;
    gdk_draw_line(temp->window, gc2,
		  i1, 0,
		  i1, height-i2);
    gdk_draw_line(temp->window, gc,
		  i1, height-i2,
		  i1, height-1);

    if ((width-i1) % 60 == 0) {
      i4 = (width-i1) / 60;
      gdk_draw_line(temp->window, gc3, i1, height-15, i1, height-1);
      sprintf(str, "%d min", i4);
      gdk_draw_string(temp->window, font, gc3, i1+2, height-3, str);
      add = i3/4;
    } else {
      add = i3;
    }
    i4 = 0;
    while (1) {
      i4 += add;
      i5 = height*i4/max;
      if (i5 > height) break;
      if ((i5 > i2) || (i1%8 == 0) || (add!=i3))
	gdk_draw_point(temp->window, gc3, i1, height-i5);
    }
    bytes += stat->upload_band[pos];
    av_bytes= (long)((double)bytes / (double)(width-i1));
    i4 = height*av_bytes/max;
    gdk_draw_point(temp->window, gc4, i1, height-i4);
  }
  
  theight = gdk_string_height(font, "1,23KB");
  i4 = 0;
  while (1) {
    i4 += i3;
    i5 = height*i4/max;
    if (height-i5 < theight+5) break;
    print_size(str, i4);
    gdk_draw_string(temp->window, font, gc3, 5, height-i5+theight+2, str);
  }
  if (height-i5 > 0)
    gdk_draw_string(temp->window, font, gc3, 2, height-i5+theight+2, _("Upload"));
  else gdk_draw_string(temp->window, font, gc3, 2, theight+2, _("Upload"));
}

void statistic_log(statistic_t* stat) {
  char str[1204];
  char str2[1204];
  time_t tim;
  int i1;

  time(&tim);

  log("statistic", LOG_OTHER, "Uptime            : %s\n",
      print_time(str, tim - global.start_time));
  log("statistic", LOG_OTHER, "Bytes downloaded  : %.0f (%s) (%s)\n",
      stat->total[0], print_size(str, stat->total[0]),
      print_speed(str2, stat->total[0]/(tim - global.start_time), 1));
  log("statistic", LOG_OTHER, "Bytes uploaded    : %.0f (%s) (%s)\n",
      stat->total[1], print_size(str, stat->total[1]),
      print_speed(str2, stat->total[1]/(tim - global.start_time), 1));
  log("statistic", LOG_OTHER, "---transfer--------download/upload----- :\n");
  for (i1 = 0; i1 < S_NUMBER; i1++) {
    if (stat->no_download[i1] || stat->no_upload[i1]) {
      log("statistic", LOG_OTHER, "%17s : %5d %5d\n",
	  (i1==S_INACTIVE)?"Total":status_names(i1), 
	  stat->no_download[i1], stat->no_upload[i1]);
    }
  }
}

access_t* access_new(access_t* parent, char* name, int file) {
  access_t* result;
  
  result = (access_t*)malloc(sizeof(access_t));
  result->name = strdup(name);
  result->last = 0;
  result->accesses = 0;
  result->access_list = NULL;
  access_touch(result);
  if (parent) {
    parent->access_list = g_list_append(parent->access_list, result);
    parent->accesses++;
  }

  access_ctree_insert(parent, result, file);
  
  return result;
}

access_t* access_add(access_t* access, char* name, int file) {
  access_t* sub;
  
  access_touch(access);
  sub = access_search(access, name);
  if (!sub) {
    sub = access_new(access, name, file);
  } else {
    access_touch(sub);
  }
  return sub;
}

void access_touch(access_t* access) {
  time(&(access->last));
}

access_t* access_search(access_t* access, char* name) {
  GList* dlist;
  access_t* sub;

  for (dlist = access->access_list; dlist; dlist = dlist->next) {
    sub = (access_t*)(dlist->data);
    if (!strcmp(sub->name, name)) return sub;
  }
  return NULL;
}

void access_destroy(access_t* access) {
  GList* dlist;
  access_t* sub;

  for (dlist = access->access_list; dlist; dlist = dlist->next) {
    sub = (access_t*)(dlist->data);
    access_destroy(sub);
  }
  if (access->access_list) g_list_free(access->access_list);
  access->access_list = NULL;
  if (access->name) free(access->name);
  free(access);
}

void access_new_request(transfer_t* transfer) {
  access_t* access1;
  access_t* access2;
  
  if (transfer->is_dcc) return;
  if (global.options.access_timeout == 0) return;

  access1 = access_add(global.statistic.file_access, transfer->longname, 1);
  access2 = access_add(access1, transfer->user, 0);
  access2->accesses = 1;

  access_ctree_update(global.statistic.file_access, 0);
  access_ctree_update(access1, 0);
  access_ctree_update(access2, 0);

  access_save();
}

void access_ctree_insert(access_t* parent, access_t* access, int file) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  GtkCTreeNode* node2;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, parent);
  
  if (file) strcpy(tstr[0], extract_short_name(access->name));
  else strcpy(tstr[0], access->name);
  tstr[1][0] = 0;
  tstr[2][0] = 0;
  
  if (file) {
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 5,
				  global.pix.folder, 
				  global.pix.folderb,
				  global.pix.folder_open, 
				  global.pix.folder_openb,
				  FALSE, FALSE);
  } else {
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 5,
				  NULL, NULL, NULL, NULL,
				  FALSE, FALSE);
  }
  gtk_ctree_node_set_row_data(ctree, node2, access);
  //  if (node) gtk_ctree_sort_node(ctree, node);
}

void access_ctree_update(access_t* access, int rec) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  GList* dlist;
  access_t* sub;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, access);
  if (node) {
    if (access->access_list) {
      sprintf(tstr[0], "%d", access->accesses);
      gtk_ctree_node_set_text(ctree, node, 1, tstr[0]);
    }
    
    if (access->last) {
      strcpy(tstr[0], ctime(&access->last));
      tstr[0][strlen(tstr[0])-1] = 0;
    } else strcpy(tstr[0], _("None yet"));
    gtk_ctree_node_set_text(ctree, node, 2, tstr[0]);
  }
  if (!rec) return;
  for (dlist = access->access_list; dlist; dlist = dlist->next) {
    sub = (access_t*)(dlist->data);
    access_ctree_update(sub, rec);
  }
}

void access_ctree_remove_old() {
  GtkCTree* ctree;
  access_t* access;
  GList* dlist;
  time_t tim;
  GtkCTreeNode* node;
  
  if (global.options.access_timeout <= 0) return;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_clist_freeze(GTK_CLIST(ctree));

  time(&tim);
  dlist = global.statistic.file_access->access_list;
  while (dlist) {
    access = (access_t*)(dlist->data);
    dlist = dlist->next;
    if (tim - access->last > (time_t)(global.options.access_timeout)*60*60) {
      global.statistic.file_access->access_list = 
	g_list_remove(global.statistic.file_access->access_list, access);
      node = gtk_ctree_find_by_row_data(ctree, NULL, access);
      if (node) gtk_ctree_remove_node(ctree, node);
      global.statistic.file_access->accesses -= access->accesses;
      access_destroy(access);
    }
  } 
  gtk_clist_thaw(GTK_CLIST(ctree));
}

void access_ctree_update_all() {
  GtkCList* clist;

  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  gtk_clist_freeze(clist);
  access_ctree_update(global.statistic.file_access, 1);
  gtk_clist_thaw(clist);
}

gint access_load_idle(gpointer data) {
  FILE* fd = (FILE*)data;
  char line[2048];
  char* text;
  int cnt = 0;
  static access_t *current = NULL;
  access_t* access;
  int child;
  GtkCList* clist;
  
  while (fgets(line, 2048-1, fd)) {
    cnt++;
    text = arg(line, 0);
    if (*text == '-') {
      if (!current) continue;
      text = arg(NULL, 0);
      child = 1;
    } else {
      child = 0;
      current = global.statistic.file_access;
    }
    
    access = (access_t*)malloc(sizeof(access_t));
    access->name = strdup(text);
    access->last = strtoul(arg(NULL, 0), NULL, 10);
    if (child) access->accesses = 1;
    else access->accesses = 0;
    //    access->accesses = atoi(arg(NULL, 0));
    access->access_list = NULL;
    if (global.statistic.file_access->last < access->last)
      global.statistic.file_access->last = access->last;
    
    current->access_list = g_list_append(current->access_list, access);
    access_ctree_insert(current, access, (child==0));
    if (!child) {
      current = access;
    } else {
      global.statistic.file_access->accesses++;
      current->accesses++;
    }
    if (cnt > 10) return 1;
  }

  fclose(fd);
  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  gtk_clist_thaw(clist);

  access_ctree_remove_old();
  access_ctree_update_all();
  
  return 0;
}

void access_load() {
  FILE* fd;
  char* fname;
  GtkCList* clist;

  fname = g_strdup_printf("%s/access.list", global.lopster_home);
  if ((fd = fopen(fname, "r")) == NULL) {
    free(fname);
    return;
  }
  free(fname);

  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  gtk_clist_freeze(clist);

  gtk_idle_add(access_load_idle, (gpointer)fd);
}

void access_save() {
  GList* dlist;
  GList* dlist2;
  char* fname;
  char* fname_new;
  FILE* fd;
  access_t* access1;
  access_t* access2;

  fname = g_strdup_printf("%s/access.list", global.lopster_home);
  fname_new = g_strdup_printf("%s/access.list.new",  global.lopster_home);

  if (!global.options.access_save) {
    unlink(fname);
    return;
  }

  if ((fd = fopen(fname_new, "w")) == NULL) {
    g_warning(_("Could not write [%s]\n"), fname);
    free(fname);
    free(fname_new);
    return;
  }

  for (dlist = global.statistic.file_access->access_list; dlist; dlist = dlist->next) {
    access1 = (access_t*)(dlist->data);
    fprintf(fd, "\"%s\" %lu %d\n",
	    access1->name, access1->last, access1->accesses);
    for (dlist2 = access1->access_list; dlist2; dlist2 = dlist2->next) {
      access2 = (access_t*)(dlist2->data);
      fprintf(fd, "- \"%s\" %lu %d\n",
	      access2->name, access2->last, access2->accesses);
    }
  }

  if(! ferror(fd) )
    rename(fname_new, fname);
  else {
    g_warning(_("Could not write [%s]\n"), fname);
  }

  fclose(fd);
  free(fname);
  free(fname_new);
}

void
on_access_collapse(GtkMenuItem     *menuitem,
		   gpointer         user_data) {
  GtkCTree* ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_ctree_collapse_recursive(ctree, NULL);
}

void
on_access_expand(GtkMenuItem     *menuitem,
		 gpointer         user_data) {
  GtkCTree* ctree;

  ctree = GTK_CTREE(lookup_widget(global.win, "ctree3"));
  gtk_ctree_expand_recursive(ctree, NULL);
}

void
on_access_play(GtkMenuItem     *menuitem,
	       gpointer         user_data) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  access_t* access;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node) return;

  access = (access_t*)gtk_ctree_node_get_row_data(ctree, node);
  play_file(access->name);
}

GtkWidget* create_access_popup (void) {
  GtkCTree* ctree;
  GtkCTreeNode* node;
  GtkWidget *popup;
  GtkWidget *user_popup;
  GtkWidget *item;
  GtkWidget *separator;
  GtkAccelGroup *popup_accels;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  
  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));

  if (node && (GTK_CTREE_ROW(node)->parent != NULL)) {
    if (GTK_CTREE_ROW(node)->children != NULL) {
      item = gtk_menu_item_new_with_label (_("Open File"));
      gtk_widget_show (item);
      gtk_container_add (GTK_CONTAINER (popup), item);
      gtk_signal_connect (GTK_OBJECT (item), "activate",
			  GTK_SIGNAL_FUNC (on_access_play),
			  node);
      
    } else {
      item = gtk_menu_item_new_with_label (_("User Menu"));
      gtk_widget_show (item);
      gtk_container_add (GTK_CONTAINER (popup), item);
      
      user_popup = create_user_popup(M_ACCESS);
      gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), user_popup);
    }
    separator = gtk_menu_item_new ();
    gtk_widget_show (separator);
    gtk_container_add (GTK_CONTAINER (popup), separator);
    gtk_widget_set_sensitive (separator, FALSE);
  }

  item = gtk_menu_item_new_with_label (_("Expand"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
		      GTK_SIGNAL_FUNC (on_access_expand),
		      NULL);

  item = gtk_menu_item_new_with_label (_("Collapse"));
  gtk_widget_show (item);
  gtk_container_add (GTK_CONTAINER (popup), item);
  gtk_signal_connect (GTK_OBJECT (item), "activate",
		      GTK_SIGNAL_FUNC (on_access_collapse),
		      NULL);
  
  return popup;
}
