/*
 * Anfngliche Datei main.c, erzeugt durch Glade. Bearbeiten Sie
 * Sie, wie Sie wollen. Glade wird diese Datei nicht berschreiben.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <netdb.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "global.h"
#include "splash.h"
#include "interface.h"

struct option long_options[] = {
  {"help", 0, 0, 0},
  {"dir", 1, 0, 0},
  {"config", 1, 0, 0},
  {"version", 0, 0, 0},
  {0, 0, 0, 0}
};

void display_usage(void) {
  fprintf(stderr,
	  _("\nUsage: lopster [options]\n\n"
	    "Options:\n"
	    "--------\n\n"
	    "-h, --help                   Display this text and exit.\n"
	    "-d  --dir                    Use other config folder than default (.lopster)\n"
	    "-c  --config                 Use other rc-file than default (lopsterrc)\n"
	    "                             Use with CAUTION!!\n"
	    "-v, --version                Print version number and exit.\n\n"));
  exit(0);
}

void parse_cmd_line(int argc, char **argv) {
  gint c, o;

  while ((c = getopt_long(argc, argv, "hd:c:v", long_options, &o)) != -1) {
    switch (c) {
    case 0:
      switch (o) {
      case 0:
	display_usage();
	break;
      case 1:
	if (optarg) global.config_dir = strdup(optarg);
	break;
      case 2:
	if (optarg) global.config_file = strdup(optarg);
	break;
      case 3:
	printf("Lopster %s\n", VERSION);
	exit(0);
	break;
      }
      break;
    case 'h':
      display_usage();
      break;
    case 'd':
      if (optarg) global.config_dir = strdup(optarg);
      break;
    case 'c':
      if (optarg) global.config_file = strdup(optarg);
      break;
    case 'v':
      printf("Lopster %s\n", VERSION);
      exit(0);
      break;
    }
  }

  if (!global.config_dir) global.config_dir = strdup(".lopster");
  if (!global.config_file) global.config_file = strdup("lopsterrc");
}

int main (int argc, char *argv[]) {

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  setup_global_vars();
  parse_cmd_line(argc, argv);

  global.splash_win = splash_screen();
  
  advance_progress(_("Starting Lopster"), 0.05);
  global.win = create_window ();

  // dont really show it, only add it to queue
  gtk_my_widget_show(global.win);
  gtk_widget_realize(global.win);


  while (gtk_events_pending()) gtk_main_iteration();
  //  gdk_window_raise (global.splash_win->window);
  //  gtk_window_set_transient_for (GTK_WINDOW(global.splash_win), GTK_WINDOW(global.win));

  advance_progress(_("Initializing..."), 0.10);
  global_init();
  advance_progress(_("Initialization done."), 1);

  gtk_widget_destroy(global.splash_win);
  global.splash_win = NULL;
  
  // now show all windows in queue
  gtk_my_widget_show_all();

  gtk_main ();
  return 0;
}

