#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/time.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "callbacks.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "browse.h"
#include "hotlist.h"
#include "support.h"
#include "chat.h"
#include "handler.h"
#include "resume.h"
#include "whois.h"

void create_description_win (hot_t* hot);

void
on_enter_description_activate                (GtkMenuItem     *menuitem,
					      gpointer         user_data) {
  GtkCList* clist;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  char* user;
  hot_t* hot;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);

  gtk_clist_get_pixtext (clist, global.popup_row, 0, &user, &space,
			 &pixmap, &bitmap);

  hot = hotlist_search_user(user);
  
  if (hot) create_description_win(hot);
}

GtkWidget* create_hotlist_popup() {
  GtkWidget *popup;
  GtkWidget *user_popup;
  GtkWidget *item;
  GtkAccelGroup *popup_accels;
  GtkWidget *refresh_users_files;
  GtkWidget *remove_user_from_hotlist;
  GtkWidget *trennlinie6;
  GtkWidget *trennlinie20;
  GtkWidget *customize_list6;

  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));

  if (global.popup_row != -1) {
    refresh_users_files = gtk_menu_item_new_with_label (_("Refresh Users Files"));
    gtk_widget_show (refresh_users_files);
    gtk_container_add (GTK_CONTAINER (popup), refresh_users_files);
    gtk_signal_connect (GTK_OBJECT (refresh_users_files), "activate",
			GTK_SIGNAL_FUNC (on_refresh_users_files_activate),
			NULL);
    
    remove_user_from_hotlist = gtk_menu_item_new_with_label (_("Remove User From Hotlist"));
    gtk_widget_show (remove_user_from_hotlist);
    gtk_container_add (GTK_CONTAINER (popup), remove_user_from_hotlist);
    gtk_signal_connect (GTK_OBJECT (remove_user_from_hotlist), "activate",
			GTK_SIGNAL_FUNC (on_remove_user_from_hotlist_activate),
			NULL);
    
    trennlinie6 = gtk_menu_item_new ();
    gtk_widget_show (trennlinie6);
    gtk_container_add (GTK_CONTAINER (popup), trennlinie6);
    gtk_widget_set_sensitive (trennlinie6, FALSE);

    remove_user_from_hotlist = gtk_menu_item_new_with_label (_("Enter description"));
    gtk_widget_show (remove_user_from_hotlist);
    gtk_container_add (GTK_CONTAINER (popup), remove_user_from_hotlist);
    gtk_signal_connect (GTK_OBJECT (remove_user_from_hotlist), "activate",
			GTK_SIGNAL_FUNC (on_enter_description_activate),
			NULL);
    
    trennlinie6 = gtk_menu_item_new ();
    gtk_widget_show (trennlinie6);
    gtk_container_add (GTK_CONTAINER (popup), trennlinie6);
    gtk_widget_set_sensitive (trennlinie6, FALSE);
    
    item = gtk_menu_item_new_with_label (_("User Menu"));
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);

    user_popup = create_user_popup(M_HOTLIST);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), user_popup);

    trennlinie20 = gtk_menu_item_new ();
    gtk_widget_show (trennlinie20);
    gtk_container_add (GTK_CONTAINER (popup), trennlinie20);
    gtk_widget_set_sensitive (trennlinie20, FALSE);
  }
    
  customize_list6 = gtk_menu_item_new_with_label (_("Customize List"));
  gtk_widget_ref (customize_list6);
  gtk_object_set_data_full (GTK_OBJECT (popup), "customize_list6", customize_list6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (customize_list6);
  gtk_container_add (GTK_CONTAINER (popup), customize_list6);
  gtk_signal_connect (GTK_OBJECT (customize_list6), "activate",
                      GTK_SIGNAL_FUNC (on_customize_list_activate),
                      NULL);

  return popup;
}

hot_t* hotlist_new(char* user, char* des, int visible) {
  hot_t* result;

  result = (hot_t*)malloc(sizeof(hot_t));
  result->user = strdup(user);
  if (des) result->description = strdup(des);
  else result->description = NULL;
  result->visible = visible;
  result->online = HOT_UNKNOWN;

  global.hotlist = g_list_append(global.hotlist, result);
  if (visible && global.status.rc_read) write_rc();

  return result;
}

hot_t* hotlist_search_user(char* user) {
  GList* dlist;
  hot_t* hot;

  for (dlist = global.hotlist; dlist; dlist = dlist->next) {
    hot = (hot_t*)(dlist->data);
    if (!strcasecmp(hot->user,  user)) return hot;
  }

  return NULL;
}

void hotlist_add(char* nick, char* des, int visible) {
  GtkWidget* temp;
  int row;
  hot_t* hot;

  hot = hotlist_search_user(nick);
  if (hot && (!visible || hot->visible)) {
    client_message(_("Message"), _("User <%s> is already in hotlist"), nick);
    return;
  }

  temp = lookup_widget(global.win, "clist16");
  // !hot || (visible && !hot->visible)
  if (!hot) {
    hot = hotlist_new(nick, des, visible);
    if (global.status.connection == 2) {
      send_command(CMD_CLIENT_ADD_HOTLIST, nick);
    }
    if (visible) {
      strcpy(tstr[0], nick);
      strcpy(tstr[1], "");
      strcpy(tstr[2], "");
      row = gtk_clist_append(GTK_CLIST(temp), list);
      gtk_clist_set_row_data(GTK_CLIST(temp), row, hot);
      gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			     tstr[0], 5, 
			     global.pix.dummy, global.pix.dummyb);
    }
    hot->visible = visible;
  } else {
    strcpy(tstr[0], nick);
    strcpy(tstr[1], "");
    strcpy(tstr[2], "");
    row = gtk_clist_append(GTK_CLIST(temp), list);
    gtk_clist_set_row_data(GTK_CLIST(temp), row, hot);

    strcpy(tstr[0], hot->user);
    if (hot->online == HOT_ONLINE) {
      gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			     tstr[0], 5, 
			     global.pix.user1, global.pix.user1b);
      strcpy(tstr[1], LineSpeed(hot->speed));
      gtk_clist_set_text (GTK_CLIST(temp), row, 2, tstr[1]);
    } else if (hot->online == HOT_OFFLINE) {
      gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			     tstr[0], 5, 
			     global.pix.user2, global.pix.user2b);
    } else {
      gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			     tstr[0], 5, 
			     global.pix.dummy, global.pix.dummyb);
    }
    hot->visible = 1;
  }
}

void hotlist_remove(char* nick, int visible) {
  int row;
  GtkCList* clist;
  hot_t* hot;

  hot = hotlist_search_user(nick);
  if (!hot) {
    client_message(_("Message"), _("User <%s> is not in hotlist"), nick);
    return;
  }

  if (visible) {
    clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
    row = gtk_clist_find_row_from_data(clist, hot);
    if (row >= 0) gtk_clist_remove(clist, row);
    hot->visible = 0;
    if (!chat_page_search(hot->user, P_PRIVATE)) {
      send_command(CMD_CLIENT_REMOVE_HOTLIST, hot->user);
      global.hotlist = g_list_remove(global.hotlist, hot);
      if (hot->user) free(hot->user);
      if (hot->description) free(hot->description);
      free(hot);
    }
  } else if (!hot->visible) {
    send_command(CMD_CLIENT_REMOVE_HOTLIST, hot->user);
    global.hotlist = g_list_remove(global.hotlist, hot);
    if (hot->user) free(hot->user);
    if (hot->description) free(hot->description);
    free(hot);
  }
}

void hotlist_update_user(user_t* userinfo) {
  int row;
  GtkCList* clist;
  char str[1024];
  hot_t* hot;

  hot = hotlist_search_user(userinfo->username);
  if (!hot || !(hot->visible)) return;

  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  row = gtk_clist_find_row_from_data(clist, hot);
  if (row < 0) return;
  sprintf(str, "%d", userinfo->shared);
  gtk_clist_set_text(clist, row, 1, str);
  gtk_clist_sort(clist);
}

void
on_button_des_cancel_clicked                   (GtkButton       *button,
						gpointer         user_data)
{
  GtkWidget* win;

  win = GTK_WIDGET(user_data);
  gtk_widget_destroy(win);
}

void
on_button_des_ok_clicked                   (GtkButton       *button,
					    gpointer         user_data)
{
  hot_t* hot;
  GtkWidget* temp;
  char* text;

  hot = (hot_t*)user_data;
  if (!hot) return;

  temp = lookup_widget(GTK_WIDGET(button), "entry105");
  if (!temp) return;
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (hot->description) free(hot->description);
  hot->description = strdup(text);

  temp = lookup_widget(GTK_WIDGET(button), "description_win");
  on_button_des_cancel_clicked(button, temp);
}

void create_description_win (hot_t* hot) {
  GtkWidget *description_win;
  GtkWidget *frame;
  GtkWidget *vbox175;
  GtkWidget *vbox176;
  GtkWidget *frame297;
  GtkWidget *hbox635;
  GtkWidget *label796;
  GtkWidget *label797;
  GtkWidget *entry105;
  GtkWidget *hseparator34;
  GtkWidget *frame296;
  GtkWidget *hbox634;
  GtkWidget *button275;
  GtkWidget *button276;

  if (!hot) return;

  description_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (description_win), "description_win", description_win);
  gtk_widget_set_usize (description_win, 500, -2);
  gtk_window_set_title (GTK_WINDOW (description_win), _("Enter Description"));
  gtk_window_set_default_size (GTK_WINDOW (description_win), 170, -1);
  gtk_window_set_policy (GTK_WINDOW (description_win), FALSE, FALSE, FALSE);

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  gtk_container_add (GTK_CONTAINER (description_win), frame);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

  vbox175 = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox175);
  gtk_container_add (GTK_CONTAINER (frame), vbox175);
  gtk_container_set_border_width (GTK_CONTAINER (vbox175), 5);

  vbox176 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox176);
  gtk_box_pack_start (GTK_BOX (vbox175), vbox176, TRUE, TRUE, 0);

  frame297 = gtk_frame_new (NULL);
  gtk_widget_show (frame297);
  gtk_box_pack_start (GTK_BOX (vbox176), frame297, TRUE, TRUE, 0);

  hbox635 = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (hbox635);
  gtk_container_add (GTK_CONTAINER (frame297), hbox635);
  gtk_container_set_border_width (GTK_CONTAINER (hbox635), 5);

  label796 = gtk_label_new (_("Enter description for"));
  gtk_widget_show (label796);
  gtk_box_pack_start (GTK_BOX (hbox635), label796, FALSE, FALSE, 0);

  label797 = gtk_label_new (hot->user);
  gtk_object_set_data (GTK_OBJECT (description_win), "label797", label797);
  gtk_widget_show (label797);
  gtk_box_pack_start (GTK_BOX (hbox635), label797, FALSE, FALSE, 0);
  gtk_widget_set_style(label797, global.style[5]);

  entry105 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (description_win), "entry105", entry105);
  gtk_widget_show (entry105);
  gtk_box_pack_start (GTK_BOX (vbox176), entry105, FALSE, FALSE, 0);
  if (hot->description)
    gtk_entry_set_text(GTK_ENTRY(entry105), hot->description);

  hseparator34 = gtk_hseparator_new ();
  gtk_widget_show (hseparator34);
  gtk_box_pack_start (GTK_BOX (vbox175), hseparator34, FALSE, FALSE, 0);

  frame296 = gtk_frame_new (NULL);
  gtk_widget_show (frame296);
  gtk_box_pack_start (GTK_BOX (vbox175), frame296, FALSE, FALSE, 0);
  gtk_widget_set_usize (frame296, -2, 41);
  gtk_frame_set_shadow_type (GTK_FRAME (frame296), GTK_SHADOW_IN);

  hbox634 = gtk_hbox_new (TRUE, 5);
  gtk_widget_show (hbox634);
  gtk_container_add (GTK_CONTAINER (frame296), hbox634);
  gtk_container_set_border_width (GTK_CONTAINER (hbox634), 5);

  button275 = gtk_button_new_with_label (_("Ok"));
  gtk_widget_show (button275);
  gtk_box_pack_start (GTK_BOX (hbox634), button275, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button275), "clicked",
		      on_button_des_ok_clicked, hot);


  button276 = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_show (button276);
  gtk_box_pack_start (GTK_BOX (hbox634), button276, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (button276), "clicked",
		      on_button_des_cancel_clicked, description_win);
  
  gtk_signal_connect (GTK_OBJECT (description_win), "destroy",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);

  gtk_widget_show(description_win);

  return;
}

void hotlist_user_unknown(hot_t* hot) {
  GtkCList* clist;
  int row;
  chat_page_t* page;

  resume_user_offline(hot->user);
  hot->online = HOT_UNKNOWN;

  if (hot->visible) {
    clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
    row = gtk_clist_find_row_from_data(clist, hot);
    if (row >= 0) {
      gtk_clist_set_pixtext (clist, row, 0, hot->user, 5, 
			     global.pix.dummy, global.pix.dummyb);
      gtk_clist_set_text(clist, row, 1, "");
      gtk_clist_set_text(clist, row, 2, "");
      gtk_clist_sort(clist);
    }
  }
  page = chat_page_search(hot->user, P_PRIVATE);
  if (!page) return;
  chat_page_set_active(page, 0);
}

void hotlist_user_offline(hot_t* hot) {
  GtkCList* clist;
  int row;
  chat_page_t* page;

  resume_user_offline(hot->user);
  client_message(NULL, _("<%s> is off !"), hot->user);
  hot->online = HOT_OFFLINE;

  if (hot->visible) {
    clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
    row = gtk_clist_find_row_from_data(clist, hot);
    if (row >= 0) {
      gtk_clist_set_pixtext (clist, row, 0, hot->user, 5, 
			     global.pix.user2, global.pix.user2b);
      gtk_clist_set_text(clist, row, 1, "");
      gtk_clist_set_text(clist, row, 2, "");
      gtk_clist_sort(clist);
    }
  }

  page = chat_page_search(hot->user, P_PRIVATE);
  if (!page) return;
  chat_page_set_active(page, 0);
}

void hotlist_user_online(hot_t* hot) {
  GtkCList* clist;
  int row;
  chat_page_t* page;

  resume_user_online(hot->user, hot->speed);
  client_message(NULL, _("<%s> is on !"), hot->user);
  hot->online = HOT_ONLINE;

  if (hot->visible) {
    clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
    row = gtk_clist_find_row_from_data(clist, hot);
    if (row >= 0) {
      gtk_clist_set_pixtext (clist, row, 0, hot->user, 5, 
			     global.pix.user1, global.pix.user1b);
      gtk_clist_set_text(clist, row, 2, LineSpeed(hot->speed));
      gtk_clist_sort(clist);
    }
  }
  whois_request(hot->user, WHOIS_NONE);

  page = chat_page_search(hot->user, P_PRIVATE);
  if (!page) return;
  chat_page_set_active(page, 1);
}
