#define CMD_VERSION_CHECK               4
#define CMD_AUTO_UPGRADE                5
#define CMD_HOTLIST_ERROR               302
#define CMD_CHANNEL_ALT_TOPIC           425
#define CMD_GET_ERROR                   609

#define CMD_SERVER_ERROR		0
#define CMD_CLIENT_LOGIN		2
#define CMD_SERVER_EMAIL		3
#define CMD_CLIENT_LOGIN_REGISTER	6
#define CMD_CLIENT_REGISTER		7
#define CMD_SERVER_REGISTER_OK		8
#define CMD_SERVER_REGISTER_FAIL	9
#define CMD_SERVER_BAD_NICK		10
#define CMD_CLIENT_CHECK_PASS		11
#define CMD_SERVER_PASS_OK		12
#define CMD_SERVER_ECHO			13
#define CMD_CLIENT_ADD_FILE		100
#define CMD_CLIENT_UNSHARE_ALL          110
#define CMD_CLIENT_REMOVE_FILE		102
#define CMD_CLIENT_SEARCH		200
#define CMD_SERVER_SEARCH_RESULT	201
#define CMD_SERVER_SEARCH_END		202
#define CMD_CLIENT_DOWNLOAD		203
#define CMD_SERVER_FILE_READY		204
#define CMD_CLIENT_PRIVMSG		205
#define CMD_SERVER_SEND_ERROR		206
#define CMD_CLIENT_ADD_HOTLIST		207
#define CMD_CLIENT_ADD_HOTLIST_SEQ	208
#define CMD_SERVER_USER_SIGNON		209
#define CMD_SERVER_USER_SIGNOFF		210
#define CMD_CLIENT_BROWSE		211
#define CMD_SERVER_BROWSE_RESPONSE	212
#define CMD_SERVER_BROWSE_END		213
#define CMD_SERVER_STATS		214
#define CMD_CLIENT_RESUME_REQUEST	215
#define CMD_SERVER_RESUME_MATCH		216
#define CMD_SERVER_RESUME_MATCH_END	217
#define CMD_CLIENT_DOWNLOAD_START	218
#define CMD_CLIENT_DOWNLOAD_END		219
#define CMD_CLIENT_UPLOAD_START		220
#define CMD_CLIENT_UPLOAD_END		221
#define CMD_CLIENT_CHECK_PORT		300
#define CMD_SERVER_HOTLIST_ACK		301
#define CMD_CLIENT_REMOVE_HOTLIST	303
#define CMD_SERVER_DISCONNECTING	316
#define CMD_CLIENT_IGNORE_LIST		320
#define CMD_SERVER_IGNORE_ENTRY		321
#define CMD_CLIENT_IGNORE_USER		322
#define CMD_CLIENT_UNIGNORE_USER	323
#define CMD_SERVER_NOT_IGNORED		324
#define CMD_SERVER_ALREADY_IGNORED	325
#define CMD_CLIENT_CLEAR_IGNORE		326
#define CMD_CLIENT_JOIN			400
#define CMD_CLIENT_PART			401
#define CMD_CLIENT_PUBLIC		402
#define CMD_SERVER_PUBLIC		403
#define CMD_SERVER_NOSUCH		404
#define CMD_SERVER_JOIN_ACK		405
#define CMD_SERVER_JOIN			406
#define CMD_SERVER_PART			407
#define CMD_SERVER_CHANNEL_USER_LIST	408	/* list of users in a channel */
#define CMD_SERVER_CHANNEL_USER_LIST_END	409
#define CMD_SERVER_TOPIC		410	/* server and client */
#define CMD_CLIENT_CHANNEL_BAN_LIST	420
#define CMD_SERVER_CHANNEL_BAN_LIST	421
#define CMD_CLIENT_CHANNEL_BAN		422
#define CMD_CLIENT_CHANNEL_UNBAN	423
#define CMD_CLIENT_CHANNEL_CLEAR_BANS	424
#define CMD_CLIENT_DOWNLOAD_FIREWALL	500
#define CMD_SERVER_UPLOAD_FIREWALL	501
#define CMD_CLIENT_USERSPEED		600
#define CMD_SERVER_USER_SPEED		601
#define CMD_CLIENT_WHOIS		603	/* whois query */
#define CMD_SERVER_WHOIS_RESPONSE	604
#define CMD_SERVER_WHOWAS		605
#define CMD_CLIENT_SETUSERLEVEL		606
#define CMD_SERVER_UPLOAD_REQUEST	607
#define CMD_CLIENT_UPLOAD_OK		608
#define CMD_CLIENT_KILL			610
#define CMD_CLIENT_NUKE			611
#define CMD_CLIENT_BAN			612
#define CMD_CLIENT_ALTER_PORT		613
#define CMD_CLIENT_UNBAN		614
#define CMD_CLIENT_BANLIST		615
#define CMD_SERVER_IP_BANLIST		616
#define CMD_CLIENT_LIST_CHANNELS	617
#define CMD_SERVER_CHANNEL_LIST_END	617
#define CMD_SERVER_CHANNEL_LIST		618
#define CMD_CLIENT_LIMIT		619
#define CMD_SERVER_LIMIT		620
#define CMD_CLIENT_MOTD			621	/* client request for motd */
#define CMD_SERVER_MOTD			621
#define CMD_CLIENT_MUZZLE		622
#define CMD_CLIENT_UNMUZZLE		623
#define CMD_CLIENT_UNNUKE		624
#define CMD_CLIENT_ALTER_SPEED		625
#define CMD_CLIENT_DATA_PORT_ERROR	626
#define CMD_SERVER_DATA_PORT_ERROR	626	/* same as client message */
#define CMD_CLIENT_WALLOP		627
#define CMD_SERVER_WALLOP		627	/* same as client message */
#define CMD_CLIENT_ANNOUNCE		628
#define CMD_SERVER_ANNOUNCE		628	/* same as client message */
#define CMD_SERVER_NICK_BANLIST		629
#define CMD_CLIENT_BROWSE_DIRECT        640
#define CMD_SERVER_BROWSE_DIRECT_OK     641
#define CMD_SERVER_BROWSE_DIRECT_ERR    642
#define CMD_CLIENT_CLOAK		652
#define CMD_CLIENT_CHANGE_SPEED		700
#define CMD_CLIENT_CHANGE_PASS		701
#define CMD_CLIENT_CHANGE_EMAIL		702
#define CMD_CLIENT_CHANGE_DATA_PORT	703
#define CMD_SERVER_GHOST		748
#define CMD_CLIENT_PING_SERVER		750
#define CMD_CLIENT_PING			751
#define CMD_SERVER_PING			751
#define CMD_CLIENT_PONG			752
#define CMD_SERVER_PONG			752
#define CMD_CLIENT_ALTER_PASS		753	/* admin pass change */
#define CMD_CLIENT_SERVER_RECONFIG	800
#define CMD_CLIENT_SERVER_VERSION	801
#define CMD_CLIENT_SERVER_CONFIG	810
#define CMD_CLIENT_CLEAR_CHANNEL	820
#define CMD_CLIENT_REDIRECT		821
#define CMD_CLIENT_CYCLE		822
#define CMD_CLIENT_SET_CHAN_LEVEL	823
#define CMD_CLIENT_EMOTE		824
#define CMD_SERVER_NAMES_LIST		825
#define CMD_CLIENT_CHANNEL_LIMIT	826
#define CMD_CLIENT_FULL_CHANNEL_LIST	827
#define CMD_SERVER_FULL_CHANNEL_INFO	828
#define CMD_CLIENT_KICK			829
#define CMD_SERVER_NAMES_LIST_END	830
#define CMD_CLIENT_NAMES_LIST		830
#define CMD_CLIENT_GLOBAL_USER_LIST	831
#define CMD_SERVER_GLOBAL_USER_LIST	832
#define CMD_CLIENT_ADD_DIRECTORY	870

/* non-standard message unique to this server */
#define CMD_CLIENT_QUIT			10000	/* user has quit */
#define CMD_SERVER_LOGIN		10010	/* server login request */
#define CMD_SERVER_LOGIN_ACK		10011	/* server login response */
#define CMD_SERVER_USER_SHARING		10012
#define CMD_SERVER_USER_IP		10013	/* ip for user */
#define CMD_SERVER_REGINFO		10014	/* registration info */
#define CMD_SERVER_REMOTE_SEARCH	10015
#define CMD_SERVER_REMOTE_SEARCH_RESULT	10016
#define CMD_SERVER_REMOTE_SEARCH_END	10017
#define CMD_SERVER_ENCAPSULATED		10018
#define CMD_SERVER_LINK_INFO		10019
#define CMD_SERVER_QUIT			10020
#define CMD_SERVER_NOTIFY_MODS		10021
#define CMD_CLIENT_CONNECT		10100
#define CMD_CLIENT_DISCONNECT		10101
#define CMD_CLIENT_KILL_SERVER		10110
#define CMD_CLIENT_REMOVE_SERVER	10111
#define CMD_CLIENT_LINKS		10112
#define CMD_SERVER_LINKS		10112
#define CMD_CLIENT_USAGE_STATS		10115	/* server usage stats */
#define CMD_SERVER_USAGE_STATS		10115
#define CMD_CLIENT_REHASH		10117	/* reload config file */
#define CMD_CLIENT_VERSION_STATS        10118   /* client version stats */
#define CMD_CLIENT_WHICH_SERVER         10119   /* which server a user is on */
#define CMD_CLIENT_PING_ALL_SERVERS     10120
#define CMD_CLIENT_WHO_WAS              10121
#define CMD_CLIENT_MASS_KILL            10122
#define CMD_CLIENT_HISTOGRAM		10123
#define CMD_SERVER_HISTOGRAM		10124
#define CMD_CLIENT_REGISTER_USER	10200
#define CMD_CLIENT_CHANNEL_LEVEL	10201	/* deprecated, use 823 instead*/
#define CMD_CLIENT_KICK_USER		10202	/* deprecated, use 829 instead*/
#define CMD_CLIENT_USER_MODE		10203	/* set a user mode */
#define CMD_SERVER_USER_MODE		10203
#define CMD_CLIENT_OP			10204
#define CMD_CLIENT_DEOP			10205
#define CMD_CLIENT_CHANNEL_WALLOP	10208
#define CMD_CLIENT_CHANNEL_MODE		10209
#define CMD_CLIENT_CHANNEL_INVITE	10210
#define CMD_CLIENT_CHANNEL_VOICE	10211
#define CMD_CLIENT_CHANNEL_UNVOICE	10212
#define CMD_CLIENT_CHANNEL_MUZZLE	10213
#define CMD_CLIENT_CHANNEL_UNMUZZLE	10214
#define CMD_CLIENT_CLASS_ADD            10250
#define CMD_CLIENT_CLASS_DEL            10251
#define CMD_CLIENT_CLASS_LIST           10252
#define CMD_CLIENT_DLINE_ADD            10253
#define CMD_CLIENT_DLINE_DEL            10254
#define CMD_CLIENT_DLINE_LIST           10255
#define CMD_CLIENT_ILINE_ADD            10256
#define CMD_CLIENT_ILINE_DEL            10257
#define CMD_CLIENT_ILINE_LIST           10258
#define CMD_CLIENT_ELINE_ADD            10259
#define CMD_CLIENT_ELINE_DEL            10260
#define CMD_CLIENT_ELINE_LIST           10261
#define CMD_CLIENT_SHARE_FILE		10300	/* generic media type */
#define CMD_CLIENT_BROWSE_NEW		10301
#define CMD_SERVER_BROWSE_RESULT_NEW	10302

#define NO_MODES     14
extern char Mode[NO_MODES][20];

#define HANDLER(f) void f (char *data)

typedef struct {
  int code;
  HANDLER ((*handler));
} HANDLER_ENTRY;

int mode2int(char* mode);
void not_implemented(int type, char* data);
int search_handler(int code);
void handle_command(int type, char* data);

HANDLER(cmd_do_nothing);
HANDLER(cmd_server_error);
HANDLER(cmd_login_ack);
HANDLER(cmd_register_fail);
HANDLER(cmd_bad_nick);
HANDLER(cmd_search_response);
HANDLER(cmd_end_of_search);
HANDLER(cmd_download_ack);
HANDLER(cmd_private_message);
HANDLER(cmd_get_error);
HANDLER(cmd_user_sign_on);
HANDLER(cmd_user_sign_off);
HANDLER(cmd_browse_response);
HANDLER(cmd_browse_end);
HANDLER(cmd_server_stats);
HANDLER(cmd_resume_match);
HANDLER(cmd_hotlist_ack);
HANDLER(cmd_hotlist_error);
HANDLER(cmd_disconnecting);
HANDLER(cmd_ignore_user);
HANDLER(cmd_unignore_user);
HANDLER(cmd_part_channel);
HANDLER(cmd_public_message);
HANDLER(cmd_error_message);
HANDLER(cmd_create_channel );
HANDLER(cmd_join_message);
HANDLER(cmd_part_message);
HANDLER(cmd_user_online);
HANDLER(cmd_channel_topic);
HANDLER(cmd_banlist_entry);
HANDLER(cmd_channel_alt_topic);
HANDLER(cmd_alternate_ack);
HANDLER(cmd_linkspeed_response);
HANDLER(cmd_eval_whois);
HANDLER(cmd_eval_whowas);
HANDLER(cmd_upload_request);
HANDLER(cmd_set_port);
HANDLER(cmd_channel_list_end);
HANDLER(cmd_channel_list);
HANDLER(cmd_remote_queued);
HANDLER(cmd_motd);
HANDLER(cmd_data_port_error);
HANDLER(cmd_operator_message);
HANDLER(cmd_global_message);
HANDLER(cmd_nick_banlist);
HANDLER(cmd_browse_direct);
HANDLER(cmd_browse_direct_ok);
HANDLER(cmd_browse_direct_err);
HANDLER(cmd_ghost);
HANDLER(cmd_sping);
HANDLER(cmd_ping);
HANDLER(cmd_pong);
HANDLER(cmd_emote);
HANDLER(cmd_channel_list_entry);
HANDLER(cmd_global_user_end);
HANDLER(cmd_global_user);
HANDLER(cmd_server_links);
HANDLER(cmd_whowas);
HANDLER(cmd_usage_stats);
HANDLER(cmd_version_stats);
HANDLER(cmd_user_mode);
HANDLER(cmd_browse_new);
HANDLER(cmd_redirect);
HANDLER(cmd_cycle);
HANDLER(cmd_histogram);
HANDLER(cmd_histogram_end);
HANDLER(cmd_acl_list);
