#ifndef _GLOBAL_H_
#define _GLOBAL_H_

extern const char Level[5][20];
extern const char LineSpeedShort[11][20];
extern char tstr[10][512];
extern char* list[10];
extern char Network[3][20];
extern char* Browser[BROWSER_NO];
extern int SocketStatus[S_NUMBER];

extern char **environ;

#ifdef WORDS_BIGENDIAN
#define BSWAP16(x) ((((x) & 0xff) << 8) | (((x) >> 8) & 0xff))
#define BSWAP32(x) (((x) << 24) | (((x) & 0x0000ff00) << 8) | ((x) >> 24) | (((x) & 0x00ff0000) >> 8))
#else
#define BSWAP16(x) (x)
#define BSWAP32(x) (x)
#endif

#ifndef HAVE_STRCASECMP
#define strcasecmp g_strcasecmp
#endif

extern global_t global;

int ColorTable(int i1, int i2);
int ColorTable2(int index);

char* browser_to_string(int browser);
int browser_to_int(char* browser);
void browse_url(char* url);
int version_is_up_to_date(char* version);
int verify_speed(int speed);
int get_beats(time_t tim);
int guess_mime(char* suffix);
int find_valid_bitrate(int bitrate);
char* current_time(char* stime, int with_secs);
char* ntoa (unsigned int ip);
int directory_exists(char* dir);
void create_dir(char* dir);
char* MimeNames(int no);
char* MimeNames_(int no);
char* LineSpeed(int no);
char* UserStatus(int status);

void update_user_stats(int highlight);
char* strcasestr(char* str, char* sub);

int speed2int(char* linespeed);
int level2int(char* level);
int mime2int(char* mime);
int mime2int_(char* mime);
int status2int(char* status);

int idle_function(gpointer data);
void read_geometry();
void write_geometry();

void read_rc();
void write_rc();

void setup_sensitive(int section);
void setup_commands();
void create_pixmaps();
void setup_main_tab();
void setup_widgets();
void setup_buttons();
void setup_mime();
void setup_global_vars();

void global_init();
void global_exit();

char* extract_short_name(char* longname);
char* convert_to_win(char* name);
char* convert_to_unix(char* name, int change);

void destroy_file_row(gpointer data);



gint channel_compare (GtkCList      *clist,
		      gconstpointer  ptr1,
		      gconstpointer  ptr2);
gint transfer_compare (GtkCList      *clist,
		       gconstpointer  ptr1,
		       gconstpointer  ptr2);
gint browse_compare (GtkCList      *clist,
		     gconstpointer  ptr1,
		     gconstpointer  ptr2);
gint hotlist_compare (GtkCList      *clist,
		      gconstpointer  ptr1,
		      gconstpointer  ptr2);
gint access_compare (GtkCList      *clist,
		     gconstpointer  ptr1,
		     gconstpointer  ptr2);
gint
client_compare (GtkCList      *clist,
		gconstpointer  ptr1,
		gconstpointer  ptr2);
gint resume_compare (GtkCList      *clist,
		     gconstpointer  ptr1,
		     gconstpointer  ptr2);

void send_search_request();
void cmd_eval_whois(char* data);
void cmd_eval_whowas(char* data);
void cmd_whowas(char* data);

void cmd_server_stats(char* data);

void make_list_from_string(GList** glist, char* text, char* sep);
char* make_string_from_list(GList* glist, char* sep);
clone_t* is_user_in_clones(GList* glist, char* t);
client_t* is_client_in_list(GList* glist, char* t);
char* is_string_in_list(GList* glist, char* t);
char* is_prefix_in_list(GList* glist, char* t);
int calc_list_prefix(GList* glist);
int calc_command_prefix(GList* glist);
void play_file(char* filename);
void set_last_server(server_t* server);
void set_button_state(GtkWidget* button, int open);
int toggle_button_state(GtkWidget* button);
void set_up_button(GtkWidget* button, 
		   char* pix1, char* pix2, char *wid);
void set_up_button2(GtkWidget* button, 
		    GtkWidget* pix1, GtkWidget* pix2, 
		    GtkWidget* wid);
void show_bans(char* channel);
void cmd_banlist_entry(char* data);
char* cparse(char *input);
void client_message(char* text, const char *fmt, ...);
void server_message(char* text, const char *fmt, ...);
void cmd_sping(char* data);
void cmd_ping(char* data);
void cmd_pong(char* data);

void cmd_set_port(char* data);

void toggle_friend(char* user);
void toggle_enemy(char* user);

void opennap_notify();
int opennap_version(int major, int minor);
char* arg(char* data, int last);
void convert_chars(char* text, char from, char to);

GtkWidget* create_customize_win (GtkCList* clist);
void show_clients();
void show_global_users(char* args, int clear);
void convert_file(char* name);
void detect_speed_pixs(int speed,
		       GdkPixmap** pixmap, GdkBitmap** bitmap);
file_t* file_dup(file_t* file);
int get_mimetype(char* name);
suffix_t* get_suffix(char* name);
GtkWidget* create_mode_popup (void);
GtkWidget* create_user_popup(int mode);
char* print_speed(char* str, long bytes, int withdot);
char* print_time_average(char* str, int secs);
char* print_time(char* str, int secs);
char* print_time_short(char* str, int secs);
char* print_size(char* str, double bytes);
void draw_band_width(bandwidth_t* bandwidth, int full);

void extra_win_get_geometry();
void advance_progress(char* message, gfloat per);
GtkWidget* main_tab_detach(int no);

clone_t* is_ip_in_clones(GList* glist, char* ip);
int get_version(char* data);
void get_server(char* data);
void clones_clear();

GList* create_allowed_ports(char* string);
int get_next_port(GList* list, int last);
char* create_string_from_ports(GList* list);
void destroy_allowed_ports(GList* list);
int port_is_allowed(GList* list, int port);

void gtk_my_widget_show(GtkWidget* widget);
void gtk_my_widget_show_all();

void switch_to_page(int no);
int notebook_page_visible(int no);

void print_topright_corner();

#endif
