/*
 * Anfngliche Datei main.c, erzeugt durch Glade. Bearbeiten Sie
 * Sie, wie Sie wollen. Glade wird diese Datei nicht berschreiben.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <time.h>
#include <stdio.h>
#include <netdb.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "global.h"
#include "splash.h"
#include "interface.h"

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

  global.splash_win = splash_screen();
  
  advance_progress(_("Starting Lopster"), 0.05);
  global.win = create_window ();

  // dont really show it, only add it to queue
  gtk_my_widget_show(global.win);
  gtk_widget_realize(global.win);


  while (gtk_events_pending()) gtk_main_iteration();
  //  gdk_window_raise (global.splash_win->window);
  //  gtk_window_set_transient_for (GTK_WINDOW(global.splash_win), GTK_WINDOW(global.win));

  advance_progress(_("Initializing..."), 0.10);
  global_init();
  advance_progress(_("Initialization done."), 1);

  gtk_widget_destroy(global.splash_win);
  global.splash_win = NULL;
  
  // now show all windows in queue
  gtk_my_widget_show_all();

  gtk_main ();
  return 0;
}

