#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/time.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "callbacks.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "browse.h"
#include "hotlist.h"
#include "support.h"
#include "chat.h"
#include "handler.h"

GtkWidget* create_hotlist_popup() {
  GtkWidget *popup;
  GtkWidget *user_popup;
  GtkWidget *item;
  GtkAccelGroup *popup_accels;
  GtkWidget *refresh_users_files;
  GtkWidget *remove_user_from_hotlist;
  GtkWidget *trennlinie6;
  GtkWidget *trennlinie20;
  GtkWidget *customize_list6;

  popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (popup));

  if (global.popup_row != -1) {
    refresh_users_files = gtk_menu_item_new_with_label (_("Refresh Users Files"));
    gtk_widget_ref (refresh_users_files);
    gtk_object_set_data_full (GTK_OBJECT (popup), "refresh_users_files", refresh_users_files,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (refresh_users_files);
    gtk_container_add (GTK_CONTAINER (popup), refresh_users_files);
    gtk_signal_connect (GTK_OBJECT (refresh_users_files), "activate",
			GTK_SIGNAL_FUNC (on_refresh_users_files_activate),
			NULL);
    
    remove_user_from_hotlist = gtk_menu_item_new_with_label (_("Remove User From Hotlist"));
    gtk_widget_ref (remove_user_from_hotlist);
    gtk_object_set_data_full (GTK_OBJECT (popup), "remove_user_from_hotlist", remove_user_from_hotlist,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (remove_user_from_hotlist);
    gtk_container_add (GTK_CONTAINER (popup), remove_user_from_hotlist);
    gtk_signal_connect (GTK_OBJECT (remove_user_from_hotlist), "activate",
			GTK_SIGNAL_FUNC (on_remove_user_from_hotlist_activate),
			NULL);
    
    trennlinie6 = gtk_menu_item_new ();
    gtk_widget_ref (trennlinie6);
    gtk_object_set_data_full (GTK_OBJECT (popup), "trennlinie6", trennlinie6,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (trennlinie6);
    gtk_container_add (GTK_CONTAINER (popup), trennlinie6);
    gtk_widget_set_sensitive (trennlinie6, FALSE);
    
    item = gtk_menu_item_new_with_label (_("User Menu"));
    gtk_widget_ref (item);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (popup), item);

    user_popup = create_user_popup(M_HOTLIST);
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), user_popup);

    trennlinie20 = gtk_menu_item_new ();
    gtk_widget_ref (trennlinie20);
    gtk_object_set_data_full (GTK_OBJECT (popup), "trennlinie20", trennlinie20,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (trennlinie20);
    gtk_container_add (GTK_CONTAINER (popup), trennlinie20);
    gtk_widget_set_sensitive (trennlinie20, FALSE);
  }
    
  customize_list6 = gtk_menu_item_new_with_label (_("Customize List"));
  gtk_widget_ref (customize_list6);
  gtk_object_set_data_full (GTK_OBJECT (popup), "customize_list6", customize_list6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (customize_list6);
  gtk_container_add (GTK_CONTAINER (popup), customize_list6);
  gtk_signal_connect (GTK_OBJECT (customize_list6), "activate",
                      GTK_SIGNAL_FUNC (on_customize_list_activate),
                      NULL);

  return popup;
}

void add_to_hotlist(char* nick) {
  char* user;
  GtkWidget* temp;
  user_t* userinfo;
  int row;

  user = is_string_in_list(global.hotlist, nick);
  if (user) {
    client_message(_("Message"), _("User <%s> is already in hotlist"), nick);
    return;
  }

  global.hotlist = 
    g_list_insert_sorted(global.hotlist, strdup(nick),
			 (GCompareFunc)strcasecmp);

  temp = lookup_widget(global.win, "clist16");
  strcpy(tstr[0], nick);
  strcpy(tstr[1], "");
  strcpy(tstr[2], "");
  row = gtk_clist_append(GTK_CLIST(temp), list);

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			 tstr[0], 5, 
			 global.pix.dummy, global.pix.dummyb);

  userinfo = (user_t*)malloc(sizeof(user_t));
  strcpy(userinfo->username, nick); 
  userinfo->linespeed = 0;
  userinfo->shared = 0;
  userinfo->bytes = 0;
  userinfo->files = NULL;
  gtk_clist_set_row_data(GTK_CLIST(temp), row, (gpointer)userinfo);
  
  send_command(CMD_CLIENT_ADD_HOTLIST, nick);
}

void remove_from_hotlist(char* nick) {
  char* user;
  int row;
  GtkCList* clist;
  user_t* userinfo;
  
  user = is_string_in_list(global.hotlist, nick);
  if (!user) {
    client_message(_("Message"), _("User <%s> is not in hotlist"), user);
    return;
  }

  global.hotlist = g_list_remove(global.hotlist, user);

  row = is_user_in_hotlist(user);
  if (row >= 0) {
    clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
    userinfo = gtk_clist_get_row_data(clist, row);
    hotlist_remove_user_files(userinfo);
    free(userinfo);
    
    gtk_clist_remove(clist, row);
  }

  send_command(CMD_CLIENT_REMOVE_HOTLIST, user);
}

int is_user_in_hotlist(char* user) {
  GtkCList* clist;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  char* text;
  int i1;

  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));

  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_pixtext (clist, i1, 0, &text, &space,
			   &pixmap, &bitmap);
    if (!strcasecmp(user, text)) return i1;
  }
  return -1;
}

void search_hot(user_t* userinfo, search_pattern_t* search, int *cnt) {
  file_t* file;
  GList* dlist;

  for (dlist = userinfo->files; dlist; dlist = dlist->next) {
    file = (file_t*)(dlist->data);
    if (search_pattern_fits_file(search, file, 1)) {
      file = file_dup(file);
      file_insert_search(file, DEST_HOTLIST);
      (*cnt)++;
    }
    if (*cnt >= search->max_results) return;
  }
}

void hotlist_search(search_pattern_t* search) {
  GtkCList* clist;
  user_t* userinfo;
  int i1;
  GList* dlist;
  int cnt = 0;

  if (search->max_results == 0) return;

  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  for (i1 = 0; i1 < clist->rows; i1++) {
    userinfo = gtk_clist_get_row_data(clist, i1);
    search_hot(userinfo, search, &cnt);
    if (cnt >= search->max_results) return;
  }
  for (dlist = global.browses; dlist; dlist = dlist->next) {
    userinfo = (user_t*)(dlist->data);
    search_hot(userinfo, search, &cnt);
    if (cnt >= search->max_results) return;
  }
}

void hotlist_update_user() {
  GtkWidget* temp;
  user_t* browse;
  char str[1024];

  temp = lookup_widget(global.win, "ctree3");
  browse = (user_t*)gtk_object_get_data(GTK_OBJECT(temp), "userinfo");
  if (!browse) return;

  temp = lookup_widget(global.win, "label221");
  gtk_label_set_text(GTK_LABEL(temp), browse->username);
  temp = lookup_widget(global.win, "label223");
  sprintf(str, "%d", browse->shared);
  gtk_label_set_text(GTK_LABEL(temp), str);
  temp = lookup_widget(global.win, "label225");
  sprintf(str, "%.0f", browse->bytes/1048576.);
  gtk_label_set_text(GTK_LABEL(temp), str);
}

void hotlist_update_stats() {
  GtkWidget* temp;
  user_t* user;
  char str[1024];

  temp = lookup_widget(global.win, "clist16");
  user = (user_t*)gtk_object_get_data(GTK_OBJECT(temp), "userinfo");

  temp = lookup_widget(global.win, "label229");
  sprintf(str, "%d", user->shared);
  gtk_label_set_text(GTK_LABEL(temp), str);
  temp = lookup_widget(global.win, "label231");
  sprintf(str, "%.0f", user->bytes/1048576.);
  gtk_label_set_text(GTK_LABEL(temp), str);
}

void hotlist_remove_user_files(user_t* userinfo) {
  GtkCList* clist;
  user_t* stats;
  GList* dlist;
  file_t* file;
  int row;
  
  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  stats = (user_t*)gtk_object_get_data(GTK_OBJECT(clist), "userinfo");
  stats->shared -= userinfo->shared;
  stats->bytes -= userinfo->bytes;
  hotlist_update_stats();
  if ((row = gtk_clist_find_row_from_data(clist, userinfo))>=0) {
    gtk_clist_set_text(clist, row, 1, "");
  }
  userinfo->shared = 0;
  userinfo->bytes = 0;
  browse_clear(userinfo);

  // releasing file list
  for (dlist = (GList*)(userinfo->files); dlist; dlist = dlist->next) {
    file = (file_t*)(dlist->data);
    destroy_file_row(file);
  }
  g_list_free(userinfo->files);
  userinfo->files = NULL;
}

