#ifndef _GLOBAL_H_
#define _GLOBAL_H_

extern const char Level[5][20];
extern const char LineSpeedShort[11][20];
extern char tstr[10][512];
extern char* list[10];
extern char Network[3][20];

extern char **environ;

#ifdef WORDS_BIGENDIAN
#define BSWAP16(x) ((((x) & 0xff) << 8) | (((x) >> 8) & 0xff))
#define BSWAP32(x) (((x) << 24) | (((x) & 0x0000ff00) << 8) | ((x) >> 24) | (((x) & 0x00ff0000) >> 8))
#else
#define BSWAP16(x) (x)
#define BSWAP32(x) (x)
#endif

extern global_t global;

int ColorTable(int i1, int i2);
int ColorTable2(int index);

char* ntoa (unsigned int ip);
int directory_exists(char* dir);
void create_dir(char* dir);
char* MimeNames(int no);
char* MimeNames_(int no);
char* LineSpeed(int no);

void update_user_stats();
char* strcasestr(char* str, const char* sub);

int speed2int(char* linespeed);
int level2int(char* level);
int mime2int(char* mime);
int mime2int_(char* mime);
int status2int(char* status);

int idle_function(gpointer data);
void read_geometry();
void write_geometry();

void read_rc();
void write_rc();

void setup_sensitive(int section);
void setup_commands();
void create_pixmaps();
void setup_widgets();
void setup_buttons();
void setup_mime();

void global_init();
void global_exit();

char* extract_short_name(char* longname);
char* convert_to_win(char* name);
char* convert_to_unix(char* name);

void destroy_file_row(gpointer data);



gint channel_compare (GtkCList      *clist,
		      gconstpointer  ptr1,
		      gconstpointer  ptr2);
gint
client_compare (GtkCList      *clist,
		gconstpointer  ptr1,
		gconstpointer  ptr2);

void send_search_request();
void cmd_eval_whois(char* data);
void cmd_eval_whowas(char* data);
void cmd_whowas(char* data);

void cmd_server_stats(char* data);

void make_list_from_string(GList** glist, char* text, char* sep);
char* make_string_from_list(GList* glist, char* sep);
clone_t* is_user_in_clones(GList* glist, char* t);
client_t* is_client_in_list(GList* glist, char* t);
char* is_string_in_list(GList* glist, char* t);
char* is_prefix_in_list(GList* glist, char* t);
int calc_list_prefix(GList* glist);
int calc_command_prefix(GList* glist);
void play_file(char* filename);
void set_last_server(server_t* server);
void set_button_state(GtkWidget* button, int open);
int toggle_button_state(GtkWidget* button);
void set_up_button(GtkWidget* button, 
		   char* pix1, char* pix2, char *wid);
void show_bans(char* channel);
void cmd_banlist_entry(char* data);
char* cparse(char *input);
void client_message(char* text, const char *fmt, ...);
void server_message(char* text, const char *fmt, ...);
void cmd_sping(char* data);
void cmd_ping(char* data);
void cmd_pong(char* data);

void cmd_set_port(char* data);

void toggle_friend(char* user);
void toggle_enemy(char* user);

void opennap_notify();
int opennap_version(int major, int minor);
char* arg(char* data, int last);
void convert_chars(char* text, char from, char to);

GtkWidget* create_customize_win (GtkCList* clist);
void show_clients();
void show_global_users(char* args, int clear);
void convert_file(char* name);
void detect_speed_pixs(int speed,
		       GdkPixmap** pixmap, GdkBitmap** bitmap);
file_t* file_dup(file_t* file);
int get_mimetype(char* name);
suffix_t* get_suffix(char* name);
GtkWidget* create_mode_popup (void);
GtkWidget* create_user_popup(int mode);
void print_speed(char* str, long bytes, int withdot);
void draw_band_width(bandwidth_t* bandwidth, int full);

void extra_win_get_geometry();
void advance_progress(char* message, gfloat per);
GtkWidget* main_tab_detach(int no);

clone_t* is_ip_in_clones(GList* glist, char* ip);
int get_version(char* data);
void get_server(char* data);
void clones_clear();

GList* create_ports_from_string(char* string);
char* create_string_from_ports(GList* ports);

void gtk_my_widget_show(GtkWidget* widget);
void gtk_my_widget_show_all();

#endif
