#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <ctype.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/utsname.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"
#include "log.h"
#include "exec.h"

char* FolderNames(int no) {
  switch (no) {
  case 0: return _("Chat Commands");
  case 1: return _("User Modification Commands");
  case 2: return _("Infomation Commands");
  case 3: return _("Misc Commands");
  case 4: return _("Client Commands");
  case 5: return _("Channel Operator Commands");
  case 6: return _("Moderator Commands");
  case 7: return _("Admin Commands");
  default: return _("Unspecified command");
  }
}

int command_new(int id, char* iname, char* syntax, char* ides,
		user_level_t ilevel, folder_t ifolder, 
		COMMAND((*ihandler))) {
  command_t* new_comm;
  
  if (!iname) {
    g_warning(_("no command name given"));
    return 0;
  }
  if (command_is_command(iname)) {
    g_warning(_("chat command already exists [%s]"), iname);
    return 0;
  }
  new_comm = (command_t*)malloc(sizeof(command_t));
  new_comm->id = id;
  new_comm->name = strdup(iname);
  new_comm->syntax = strdup(syntax);
  new_comm->description = strdup(ides);
  new_comm->is_alias = 0;
  new_comm->level = ilevel;
  new_comm->folder = ifolder;
  new_comm->handler = ihandler;

  global.commands = 
    g_list_append(global.commands, new_comm);

  return 1;
}

int command_rename(int iid, char* iname) {
  command_t* comm;
  
  comm = command_is_command(iname);
  
  if (!comm) {
    g_warning(_("chat command does not exists"));
    return 0;
  }
  
  free(comm->name);
  comm->name = strdup(iname);

  return 1;
}

GList* command_search(char* prefix) {
  GList* result = NULL;
  command_t* comm;
  int len = strlen(prefix);
  int i1;

  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if (!strncasecmp(prefix, comm->name, len))
      result = g_list_append(result, comm);
  }
  
  return result;
}

command_t* command_is_command(char* iname) {
  command_t* comm;
  char* name;
  int i1;

  if (!iname) return NULL;
  if (*iname == '/') name = iname+1;
  else name = iname;

  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if (!strcasecmp(name, comm->name))
      return comm;
  }
  
  return NULL;
}

char* command_get_alias_string(int id) {
  command_t* comm;
  int i1;
  static char result[1024];

  result[0] = 0;
  for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if ((comm->id == id) && (comm->is_alias)) {
      if (strlen(result) > 0) strcat(result, " ");
      strcat(result, comm->name);
    }
  }
  
  return result;
}

int command_make_alias(char* iname, char* alias) {
  command_t* comm;
  command_t* new_alias;
  char temp[1024];

  if (!iname) {
    g_warning(_("no command name given"));
    return 0;
  }
  comm = command_is_command(alias);
  if (comm) {
    client_message(_("Error"), _("Command does already exists"));
    return 0;
  }
  if (!alias) {
    client_message(_("Error"), _("No alias name given"));
    return 0;
  }
  comm = command_is_command(iname);
  if (!comm) {
    client_message(_("Error"), _("Command does not exists"));
    return 0;
  }

  new_alias = (command_t*)malloc(sizeof(command_t));
  new_alias->id = comm->id;
  new_alias->name = strdup(alias);
  sprintf(temp, _("see %s"), iname);
  new_alias->syntax = strdup(temp);
  strcpy(temp, _("This is an alias for <"));
  strcat(temp, iname);
  strcat(temp, ">");
  new_alias->description = strdup(temp);
  new_alias->is_alias = 1;
  new_alias->level = comm->level;
  new_alias->folder = comm->folder;
  new_alias->handler = comm->handler;
  global.commands =
    g_list_append(global.commands, new_alias);
  
  strcpy(temp, _("New alias: "));
  strcat(temp, alias);
  strcat(temp, " := ");
  strcat(temp, iname);
  client_message(_("Message"), temp);

  return 1;
}

void command_delete_alias_for(int id) {
  command_t* comm;
  int i1;

  i1 = 0;
  while (i1 < g_list_length(global.commands)) {
    comm = 
      (command_t*)(g_list_nth(global.commands, i1)->data);
    if ((comm->id == id) && (comm->is_alias)) {
      global.commands = 
	g_list_remove(global.commands, comm);
    } else {
      i1++;
    }
  }
}

void command_delete_all() {
  command_t* comm;

  while (g_list_length(global.commands) > 0) {
    comm = 
      (command_t*)(g_list_first(global.commands)->data);
    global.commands = 
      g_list_remove(global.commands, comm);

    free(comm->name);
    free(comm->syntax);
    free(comm->description);
  }
  global.commands = NULL;
}

void handle_lopster_command(char* data) {
  char* pos;
  command_t* comm;

  if (global.commands == NULL) {
    g_warning("no commands declared!");
    return;
  }
  if (data[0] != '/') {
    return;
  } else data++;
  
  pos = arg(data, 0);
  if (pos) {
    comm = command_is_command(pos);
    if (!comm) {
      client_message(_("Error"), _("Unknown command! Type /help for a list of commands."));
      return;
    }
    if ((comm->id >= 100) && (!opennap_version(0,0))) {
      opennap_notify();
      return;
    }
    pos = arg(NULL, 1);
    comm->handler(pos);
  }
}

COMMAND(lopster_none) {
  g_warning("command with id C_NONE");
}

COMMAND(lopster_whisper) {
  char* nick;
  char* message;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("You have to specify a nickname!"));
    return;
  }
  message = arg(NULL, 1);
  if (!message) {
    client_message(_("Error"), _("Whisper what?"));
    return;
  }
  send_private(nick, message);
}

COMMAND(lopster_whois) {
  char* nick;
  
  if (global.status.connection < 2) return;

  nick = arg(data, 0);
  if (!nick) {
    if (global.reply)
      send_command(CMD_CLIENT_WHOIS, global.reply);
    else
      send_command(CMD_CLIENT_WHOIS, SERVER->nick);
  } else {
    send_command(CMD_CLIENT_WHOIS, nick);
  }
}

COMMAND(lopster_emote) {
  char* message;

  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("Please specify an emote message!"));
    return;
  }
  if (in_channel()) {
    send_emote(message);
  } else {
    chat_print(_("Error"), _("/emote not supported this page\n"));
  }
}

COMMAND(lopster_join) {
  char* channel;

  channel = arg(data, 0);
  if (!channel) {
    client_message(_("Error"), _("Join which channel?"));
    return;
  }
  join_channel(channel);
}

COMMAND(lopster_raw) {
  int type;
  char* args;

  args = arg(data, 0);
  if (!args) {
    client_message(_("Error"), _("You have to specify a command code!"));
    return;
  }
  type = atoi(args);
  args = arg(NULL, 1);
  if (!args) send_command(type, "");
  else send_command(type, args);
}

COMMAND(lopster_help) {
  char* com;
  int i1, i2, i3;
  command_t* command;
  char* temp_str;
  int cnt;
  char str[1024];

  com = arg(data, 0);
  if (!com) {
    chat_print("message", _("[Available Commands]\n"));
    for (i2 = 0; i2 < NO_FOLDERS; i2++) {
      if ((i2 == F_OP) && !global.opchannel) continue;
      if ((i2 == F_MOD) && 
	  ((int)global.user.level < (int)L_MOD)) continue;
      if ((i2 == F_ADMIN) && 
	  ((int)global.user.level < (int)L_ADMIN)) continue;
      chat_print("message", " ");
      temp_str = strdup(FolderNames(i2));
      chat_print("error", temp_str);
      free(temp_str);
      cnt = 0;
      for (i1 = 0; i1 < g_list_length(global.commands); i1++) {
	command = (command_t*)(g_list_nth(global.commands, i1)->data);
	if (((int)command->level > L_USER) &&
	    ((int)command->level > (int)global.user.level))
	  continue;
	if (command->folder == i2) {
	  if (cnt%5==0) chat_print("NULL", "\n      ");
	  else chat_print("NULL", " ");
	  //	  chat_print("message", "/");
	  sprintf(str, "%%K[%%n%s", command->name);
	  for (i3 = strlen(command->name); i3 < 10; i3++)
	    strcat(str, " ");
	  strcat(str, "%K]");
	  temp_str = cparse(str);
	  chat_print("message", temp_str);
	  cnt++;
	}
      }
      chat_print("NULL", "\n");
    }
    chat_print("text", _("Type "));
    chat_print("message", "/help <command>");
    chat_print("text", _(" for more information!\n"));
  } else {
    command = command_is_command(com);
    if (command) {
      chat_print("error", _("[Help for command] "));
      chat_print_ln("message", command->name);
      client_message(_("Syntax"), command->syntax);
      client_message(_("Description"), command->description);
      if ((int)command->level > L_MOD)
	if (global.user.level > L_MOD)
	  client_message(_("Access"), _("Admin or higher (and you are!)"));
	else
	  client_message(_("Access"), _("Admin or higher (not you!)"));
      else if ((int)command->level > L_USER)
	if (global.user.level > L_USER)
	  client_message(_("Access"), _("Moderator or higher (and you are!)"));
	else
	  client_message(_("Access"), _("Moderator or higher (not you!)"));
      else if ((int)command->folder == F_OP)
	client_message(_("Access"), _("All channel operators"));
      else
	client_message(_("Access"), _("All users"));
    } else {
      client_message(_("Error"), _("This is not a command!"));
    }
  }
}

COMMAND(lopster_ban) {
  char* nick;
  char* message;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    show_bans(NULL);
    return;
  }
  message = arg(NULL, 1);
  if (!message) {
    send_command(CMD_CLIENT_BAN, nick);
  } else {
    command = g_strdup_printf("%s \"%s\"",
			      nick, message);
    send_command(CMD_CLIENT_BAN, command);
    g_free(command);
  }
}

COMMAND(lopster_chlevel) {
  char* arg1;
  char* arg2;
  char* command;

  arg1 = arg(data, 0);
  if (!arg1) {
    if (in_channel())
      send_command(CMD_CLIENT_SET_CHAN_LEVEL, global.current_page->name);
    else
      client_message(_("Error"), _("Please specify a channel or switch to a channel and specify a level!"));
    return;
  }
  arg2 = arg(NULL, 0);
  if (!arg2) {
    if (level2int(arg1) >= 0) {
      if (in_channel()) {
	command = g_strdup_printf("%s %s", global.current_page->name,
				  arg1);
	send_command(CMD_CLIENT_SET_CHAN_LEVEL, command);
	g_free(command);
      } else
	client_message(_("Error"), _("Please specify a channel or switch to a channel!"));
    } else {
      send_command(CMD_CLIENT_SET_CHAN_LEVEL, arg1);
    }
  } else {
    command = g_strdup_printf("%s %s", arg1, arg2);
    send_command(CMD_CLIENT_SET_CHAN_LEVEL, command);
    g_free(command);
  }
}

COMMAND(lopster_clear) {
  GtkWidget* temp;
  char* channel;
  char* where;

  if (!strcasecmp("Channels", global.current_page->name)) return;
  
  where = arg(data, 0);
  if (where) {
    if (!strcasecmp(where, "TOP") && in_channel()) {
      channel = g_strdup_printf("%s_text2", global.current_page->name);
      temp = lookup_widget(global.win, channel);
      gtk_text_set_point(GTK_TEXT(temp), 0);
      gtk_text_forward_delete(GTK_TEXT(temp),
			      gtk_text_get_length(GTK_TEXT(temp)));
      g_free(channel);
    } else if (!strcasecmp(where, "BOTTOM")) {
      channel = g_strdup_printf("%s_text", global.current_page->name);
      temp = lookup_widget(global.win, channel);
      gtk_text_set_point(GTK_TEXT(temp), 0);
      gtk_text_forward_delete(GTK_TEXT(temp),
			      gtk_text_get_length(GTK_TEXT(temp)));
      g_free(channel);
    } else {
      client_message(_("Error"), _("Clear what?"));
    }
  } else {
    channel = g_strdup_printf("%s_text", global.current_page->name);
    temp = lookup_widget(global.win, channel);
    gtk_text_set_point(GTK_TEXT(temp), 0);
    gtk_text_forward_delete(GTK_TEXT(temp),
			    gtk_text_get_length(GTK_TEXT(temp)));
    g_free(channel);
    if (in_channel()) {
      channel = g_strdup_printf("%s_text2", global.current_page->name);
      temp = lookup_widget(global.win, channel);
      gtk_text_set_point(GTK_TEXT(temp), 0);
      gtk_text_forward_delete(GTK_TEXT(temp),
			      gtk_text_get_length(GTK_TEXT(temp)));
      g_free(channel);
    }
  }
}

COMMAND(lopster_cloak) {
  send_command(CMD_CLIENT_CLOAK, "");
  if (global.status.connection > 1) {
    global.status.whois_hide++;
    send_command(CMD_CLIENT_WHOIS, SERVER->nick);
  }
}

COMMAND(lopster_conn) {
  GtkWidget* temp;

  if (global.napster && (global.napster->timeout >= 0)) {
    gtk_timeout_remove(global.napster->timeout);
    global.napster->timeout = -1;
  }
  if (!global.connect_win) {
    on_connect_activate(NULL, NULL);
    temp = lookup_widget(global.connect_win, "combo_entry12");
    gtk_entry_set_text(GTK_ENTRY(temp), _("Last Server"));
  }
  on_connection_ok_clicked(NULL, NULL);
}

COMMAND(lopster_dataport) {
  char* nick;
  char* port;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Missing argument in command /dataport !"));
    return;
  }
  
  port = arg(NULL, 0);
  if (!port) {
    create_upload_port(atoi(nick), TRUE);
  } else {
    command = g_strdup_printf("%s %s", nick, port);
    send_command(CMD_CLIENT_ALTER_PORT, command);
    g_free(command);
  }
}

COMMAND(lopster_disc) {
  on_disconnect_activate(NULL, NULL);
}

COMMAND(lopster_email) {
  char* email;

  email = arg(data, 0);
  if (!email) {
    client_message(_("Error"), _("You have to specify an e-mail address!"));
    return;
  }
  send_command(CMD_CLIENT_CHANGE_EMAIL, email);
}

COMMAND(lopster_kick) {
  char* arg1;
  char* arg2;
  char* arg3;
  char* command;

  arg1 = arg(data, 0);
  arg2 = arg(NULL, 0);
  arg3 = arg(NULL, 0);

  if (!arg1) {
    client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
    return;
  }
  if (!arg2) {
    command = g_strdup_printf("%s %s", global.current_page->name, arg1);
    send_command(CMD_CLIENT_KICK, command);
    g_free(command);
    return;
  }
  if (!arg3) {
    if (user_search_full(arg1)) {
      command = g_strdup_printf("%s %s \"%s\"", 
				global.current_page->name, arg1, arg2);
    } else if (!strcmp(arg1, ".")) {
      command = g_strdup_printf("%s %s", global.current_page->name, arg2);
    } else {
      command = g_strdup_printf("%s %s", arg1, arg2);
    }
    send_command(CMD_CLIENT_KICK, command);
    g_free(command);
    return;
  } else {
    if (!strcmp(arg1, "."))
      command = g_strdup_printf("%s %s \"%s\"", global.current_page->name,
				arg2, arg3);
    else
      command = g_strdup_printf("%s %s \"%s\"", arg1, arg2, arg3);
    send_command(CMD_CLIENT_KICK, command);
    g_free(command);
  }
}

COMMAND(lopster_kill) {
  char* nick;
  char* reason;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Who should be killed?"));
    return;
  }
  reason = arg(NULL, 1);
  if (!reason)
    send_command(CMD_CLIENT_KILL, nick);
  else {
    command = g_strdup_printf("%s \"%s\"", nick, reason);
    send_command(CMD_CLIENT_KILL, command);
    g_free(command);
  }
}

COMMAND(lopster_level) {
  char* nick;
  char* level;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Please specify a user!"));
    return;
  }
  level = arg(NULL, 0);
  if (!level) {
    if (level2int(nick) >= 0) {
      client_message(_("Error"), _("If you are sure that you want change your own user level, then use: /raw 606 <yournick> <level>"));
    } else {
      client_message(_("Error"), _("Please sepcify a user level!"));
    }
  } else {
    command = g_strdup_printf("%s %s", nick, level);
    send_command(CMD_CLIENT_SETUSERLEVEL, command);
    g_free(command);
  }
}

COMMAND(lopster_chlist) {
  on_join_chatrooms_activate(NULL, NULL);
}

COMMAND(lopster_motd) {
  send_command(CMD_SERVER_MOTD, "");
}

COMMAND(lopster_muzzle) {
  char* nick;
  char* reason;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Who should be muzzled?"));
    return;
  }
  reason = arg(NULL, 1);
  if (!reason) {
    send_command(CMD_CLIENT_MUZZLE, nick);
  } else {
    command = g_strdup_printf("%s \"%s\"", nick, reason);
    send_command(CMD_CLIENT_MUZZLE, command);
    g_free(command);
  }
}

COMMAND(lopster_wallop) {
  char* message;

  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("Do you want to send an operator message or NOT?"));
    return;
  }
  send_wallop(message);
}

COMMAND(lopster_part) {
  on_button24_clicked(NULL, NULL);
}

COMMAND(lopster_password) {
  char* nick;
  char* passwd;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Please specify a nickname!"));
    return;
  }
  passwd = arg(NULL, 0);
  if (!passwd) {
    send_command(CMD_CLIENT_CHANGE_PASS, nick);
    command = g_strdup_printf(_("Your password was changed to [%s]"), nick);
    client_message(_("Message"), command);
    g_free(command);
  } else {
    command = g_strdup_printf("%s %s", nick, passwd);
    send_command(CMD_CLIENT_ALTER_PASS, command);
    g_free(command);
  }
}

COMMAND(lopster_ping) {
  char* nick;
  time_t tim;
  char* t;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Please specify a nickname!"));
    return;
  }
  time(&tim);
  t = strdup(ctime(&tim));
  t[strlen(t)-1] = 0;
  client_message(_("Message"), _("pinging %s [%s]"), nick, t);
  send_command(CMD_CLIENT_PING, nick);
}

COMMAND(lopster_quit) {
  on_exit_activate(NULL, NULL);
}

COMMAND(lopster_speed) {
  char* nick;
  char* speed;
  char* command;

  nick = arg(data, 0);

  if (!nick) {
    client_message(_("Error"), _("Please specify a nickname!"));
    return;
  }
  speed = arg(NULL, 0);
  if (!speed) {
    if (isdigit(*nick)) {
      send_command(CMD_CLIENT_CHANGE_SPEED, nick);
      client_message(_("LineSpeed"), _("Your linespeed was changed to %s!"), nick);
      global.user.linespeed = atoi(nick);
    }
    else send_command(CMD_CLIENT_USERSPEED, nick);
  } else {
    command = g_strdup_printf("%s %s", nick, speed);
    send_command(CMD_CLIENT_ALTER_SPEED, command);
    g_free(command);
  }
}

COMMAND(lopster_stats) {
  send_command(CMD_SERVER_STATS, "");
}

COMMAND(lopster_topic) {
  char* channel;
  char* topic;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    if (in_channel())
      send_command(CMD_SERVER_TOPIC, global.current_page->name);
    else
      client_message(_("Error"), _("You have to specify a channel!"));
    return;
  }
  
  topic = arg(NULL, 1);
  if (!topic) {
    if (!strcmp(channel, "."))
      send_command(CMD_SERVER_TOPIC, global.current_page->name);
    else
      send_command(CMD_SERVER_TOPIC, channel);
  } else {
    if (global.options.parse_color) topic = cparse(topic);
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, topic);
    else
      command = g_strdup_printf("%s %s", channel, topic);
    send_command(CMD_SERVER_TOPIC, command);
    g_free(command);
  }
}

COMMAND(lopster_unban) {
  char* nick;
  char* message;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Who should be unbanned?"));
    return;
  }
  message = arg(NULL, 1);
  if (!message) {
    send_command(CMD_CLIENT_UNBAN, nick);
  } else {
    command = g_strdup_printf("%s \"%s\"", nick, message);
    send_command(CMD_CLIENT_UNBAN, command);
    g_free(command);
  }
}

COMMAND(lopster_unmuzzle) {
  char* nick;
  char* reason;
  char* command;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Who should be unmuzzled?"));
    return;
  }
  reason = arg(NULL, 1);
  if (!reason) {
    send_command(CMD_CLIENT_UNMUZZLE, nick);
  } else {
    command = g_strdup_printf("%s \"%s\"", nick, reason);
    send_command(CMD_CLIENT_UNMUZZLE, command);
    g_free(command);
  }
}

COMMAND(lopster_version) {
  send_command(CMD_CLIENT_SERVER_VERSION, "");
}

COMMAND(lopster_scheme) {
  char* scheme;
  char* command;
  scheme_t* scheme1;
 
  scheme = arg(data, 1);
  if (!scheme) {
    command = g_strdup_printf(_("Current scheme is [%s]"), global.scheme);
    client_message(_("Message"), command);
    g_free(command);
  } else {
    scheme1 = scheme_load(scheme);
    if (scheme1) {
      if (global.scheme) scheme_destroy(global.scheme);
      global.scheme = scheme1;
      client_message(_("Message"), _("Scheme [%s] loaded!"),
		     global.scheme->name);
    } else {
      client_message(_("Message"), _("Loading scheme [%s] failed!"),
		     scheme);
    }
  }
}

COMMAND(lopster_alias) {
  char* alias;
  char* command;
  
  alias = arg(data, 0);
  if (!alias) {
    client_message(_("Error"), _("Please give an alias name!"));
    return;
  }
  command = arg(NULL, 0);
  if (!command) {
    client_message(_("Error"), _("Please give an command name!"));
    return;
  }
  command_make_alias(command, alias);
}

COMMAND(lopster_afk) {
  char* message;
  
  message = arg(data, 1);
  if (!message) set_afk(NULL);
  else set_afk(message);
}

COMMAND(lopster_public) {
  char* message;

  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("Want to send _nothing_?"));
    return;
  }
  if (!in_channel()) {
    client_message(_("Message"), _("/public not supported in this page"));
    return;
  }
  send_public(global.current_page->name, message);
}

COMMAND(lopster_reply) {
  char* message;
  
  if (global.reply == NULL) {
    client_message(_("Message"), _("Noone to reply!"));
    return;
  }
  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("Want to reply _nothing_?"));
    return;
  }
  send_private(global.reply, message);
}

COMMAND(lopster_private) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Yes, private mode, but to whom?"));
    return;
  }
  if (chat_page_search(nick, P_PRIVATE)) {
    client_message(_("Message"), _("User is already in private list!"));
    return;
  }
  create_private_page(nick);
}

COMMAND(lopster_ignore) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    on_show_ignore_list_activate(NULL, NULL);
  } else {
    send_command(CMD_CLIENT_IGNORE_USER, nick);
  }
}

COMMAND(lopster_chclear) {
  char* channel;

  channel = arg(data, 0);
  if (!channel) {
    if (!in_channel()) {
      client_message(_("Message"), _("/chclear is not supported without argument in this page!"));
    } else {
      send_command(CMD_CLIENT_CLEAR_CHANNEL, global.current_page->name);
    }
  } else {
    send_command(CMD_CLIENT_CLEAR_CHANNEL, channel);
  }
}

COMMAND(lopster_unignore) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Who should be unignored?"));
  } else {
    send_command(CMD_CLIENT_UNIGNORE_USER, nick);
  }
}

COMMAND(lopster_chban) {
  char* nick;
  char* channel;
  char* reason;
  char* command;
  GtkCList* clist;
  char t[1024];
  int user;

  channel = arg(data, 0);

  if (!channel) {
    if (in_channel()) {
      show_bans(global.current_page->name);
    } else {
      client_message(_("Error"), _("Trying to ban a user from a channel? Better type /help chban !"));
    }
    return;
  }

  if (in_channel()) {
    sprintf(t, "%s_online", global.current_page->name);
    clist = GTK_CLIST(lookup_widget(global.win, t));
    user = search_user_in_list(clist, channel);
    if (user >= 0) nick = channel;
    else nick = arg(NULL, 0);
  } else {
    nick = arg(NULL, 0);
    user = -1;
  }
  
  if (!nick) {
    client_message(_("Error"), _("Missing Nickname!"));
    return;
  }

  reason = arg(NULL, 1);
  
  if (user >= 0) {  // user found
    if (reason)
      command = g_strdup_printf("%s %s \"%s\"", global.current_page->name,
				nick, reason);
    else
      command = g_strdup_printf("%s %s", global.current_page->name,
				nick);
  } else {
    if (reason)
      command = g_strdup_printf("%s %s \"%s\"", channel,
				nick, reason);
    else
      command = g_strdup_printf("%s %s", channel, nick);
  }

  send_command(CMD_CLIENT_CHANNEL_BAN, command);
  g_free(command);
}

COMMAND(lopster_chunban) {
  char* nick;
  char* channel;
  char* reason;
  char* command;

  channel = arg(data, 0);

  if (!channel) {
    client_message(_("Error"), _("Trying to unban a user from a channel? Better type /help chunban !"));
    return;
  }

  nick = arg(NULL, 0);
  if (!nick) {
    client_message(_("Error"), _("Missing Nickname!"));
    return;
  }

  reason = arg(NULL, 1);
  
  if (reason)
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s \"%s\"", global.current_page->name,
				nick, reason);
    else
      command = g_strdup_printf("%s %s \"%s\"", channel,
				nick, reason);
  else
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, nick);
    else
      command = g_strdup_printf("%s %s", channel, nick);
      
  send_command(CMD_CLIENT_CHANNEL_UNBAN, command);
  g_free(command);
}

COMMAND(lopster_nuke) {
  char* nick;

  nick = arg(data, 0);

  if (!nick) {
    client_message(_("Error"), _("Specify a user!"));
    return;
  }
  send_command(CMD_CLIENT_NUKE, nick);
}

COMMAND(lopster_unnuke) {
  char* nick;

  nick = arg(data, 0);

  if (!nick) {
    client_message(_("Error"), _("Specify a user!"));
    return;
  }
  send_command(CMD_CLIENT_UNNUKE, nick);
}

COMMAND(lopster_global) {
  char* message;

  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("Want to send _nothing_?"));
    return;
  }
  send_global(message);
}

COMMAND(lopster_cversion) {
  char t2[1024];
  struct utsname uts;

  strcpy(t2, "Lopster ");
  if (uname(&uts) < 0) {
    strcat(t2, VERSION);
  } else {
    strcat(t2, VERSION);
    strcat(t2, " / ");
    strcat(t2, uts.nodename);
    strcat(t2, " ");
    strcat(t2, uts.sysname);
    strcat(t2, " ");
    strcat(t2, uts.release);
  }   
  if (in_channel())
    send_public(global.current_page->name, t2);
  else if (in_private())
    send_private(global.current_page->name, t2);
  else
    client_message(_("Message"), t2);
}

COMMAND(lopster_echo) {
  char* message;
  char* text2;

  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("Echo what?"));
  } else {
    if (global.options.parse_color) text2 = cparse(message);
    else text2 = message;
    chat_print_ln("text", text2);
  }
}

COMMAND(lopster_chlimit) {
  char* channel;
  char* limit;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    if (in_channel())
      send_command(CMD_CLIENT_CHANNEL_LIMIT, global.current_page->name);
    else
      client_message(_("Error"), _("Please specify a channel or switch to a channel"));
    return;
  }
  limit = arg(NULL, 0);
  if (!limit) {
    if (isdigit(*channel)) {
      if (in_channel()) {
	command = g_strdup_printf("%s %s", 
				  global.current_page->name, channel);
	send_command(CMD_CLIENT_CHANNEL_LIMIT, command);
	g_free(command);
      } else
	client_message(_("Error"), _("Please specify a channel or switch to a channel"));
    } else {
      send_command(CMD_CLIENT_CHANNEL_LIMIT, channel);
    }
  } else {
    command = g_strdup_printf("%s %s", channel, limit);
    send_command(CMD_CLIENT_CHANNEL_LIMIT, command);
    g_free(command);
  }
}

COMMAND(lopster_sping) {
  char* server;
  time_t tim;
  char* t;

  server = arg(data, 0);
  if (!server) {
    client_message(_("Error"), _("Pinging, yes, but what server?"));
    return;
  }
  time(&tim);
  t = strdup(ctime(&tim));
  t[strlen(t)-1] = 0;
  client_message(_("Ping"), _("pinging server %s [%s]"), server, t);
  send_command(CMD_CLIENT_PING_SERVER, server);
  free(t);
}

COMMAND(lopster_friend) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("You have to specify a user!"));
    return;
  }
  toggle_friend(nick);
}

COMMAND(lopster_enemy) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("You have to specify a user!"));
    return;
  }
  toggle_enemy(nick);
}

COMMAND(lopster_hotadd) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("You have to specify a user!"));
    return;
  }
  add_to_hotlist(nick);
}

COMMAND(lopster_hotrem) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("You have to specify a user!"));
    return;
  }
  remove_from_hotlist(nick);
}

COMMAND(lopster_clientinfo) {
  char* info;

  info = arg(data, 1);
  if (info) {
    if (global.clientinfo) free(global.clientinfo);
    if (!strcasecmp(info, "NONE")) global.clientinfo = NULL;
    else global.clientinfo = strdup(info);
  }
  if (global.clientinfo) {
    client_message(_("Client Info"), "%s", global.clientinfo);
  } else {
    client_message(_("Client Info"), _("No alternative client info"));
  }
}

COMMAND(lopster_guser) {
  char* message;

  message = arg(data, 1);
  if (global.user_win)
    gtk_widget_show(global.user_win);
  if (!message) {
    show_global_users("", TRUE);
  } else {
    show_global_users(message, TRUE);
  }
}

COMMAND(lopster_sconfig) {
  char* var;
  char* val;
  char* command;

  var = arg(data, 0);
  if (!var) {
    send_command(CMD_CLIENT_SERVER_CONFIG, "");
    return;
  }
  val = arg(NULL, 0);
  if (!val) {
    send_command(CMD_CLIENT_SERVER_CONFIG, var);
  } else {
    command = g_strdup_printf("%s %s", var, val);
    send_command(CMD_CLIENT_SERVER_CONFIG, command);
    g_free(command);
  }
}

COMMAND(lopster_clones) {
  GList* dlist;
  GList* dlist2;
  char* pos;
  int cnt, cnt2, cnt3;
  clone_t* clone;
  char t[1024];
  char* which;
  int number;

  which = arg(data, 0);
  if (!which) {
    client_message(_("Error"), _("Print which clones?"));
    return;
  }
  pos = arg(NULL, 0);
  if (pos) number = atoi(pos);
  else number = 2;

  if (!strcmp(which, "all")) {
    cnt = cnt2 = 0;
    sprintf(t, _("Printing IPs with at least %d nicks"), number);
    client_message(_("Clones"), t);
    for (dlist = global.clones; dlist; dlist = dlist->next) {
      clone = (clone_t*)(dlist->data);
      if (g_list_length(clone->nicks) < number) continue;
      sprintf(t, _("IP with %d clones"), g_list_length(clone->nicks));
      client_message(t, clone->ip);
      for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
	pos = (char*)(dlist2->data);
	client_message("--->", pos);
	cnt++;
      }
      cnt2++;
    }
    sprintf(t, _("[%d clones found] (%d IPs)"), cnt, cnt2);
    client_message("--Sum-->", t);
  } else if (!strcmp(which, ".")) {
    if (!in_channel()) {
      client_message(_("Error"), _("Have to switch to a channel"));
      return;
    }
    sprintf(t, _("Printing IPs with at least %d nicks"), number);
    client_message(_("Clones"), t);
    cnt = cnt2 = cnt3 = 0;
    for (dlist = global.clones; dlist; dlist = dlist->next) {
      clone = (clone_t*)(dlist->data);
      if (g_list_length(clone->nicks) < number) continue;
      for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
	pos = (char*)(dlist2->data);
	if (user_search_full(pos)) break;
      }
      if (dlist2) {
	sprintf(t, _("IP with %d clones"), g_list_length(clone->nicks));
	client_message(t, clone->ip);
	cnt++;
      } else continue;
      for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
	pos = (char*)(dlist2->data);
	if (user_search_full(pos)) {
	  sprintf(t, "(C) %s", pos);
	  cnt3++;
	} else {
	  sprintf(t, "( ) %s", pos);
	}
	client_message("--->", t);
	cnt2++;
      }
    }
    sprintf(t, _("[%d clones found in channel %s] (%d IPs / %d clones)"),
	    cnt3, global.current_page->name, cnt, cnt2);
    client_message("--Sum-->", t);
  } else {
    sprintf(t, _("Printing nicks for IP %s"), which);
    client_message(_("Clones"), t);
    for (dlist = global.clones; dlist; dlist = dlist->next) {
      clone = (clone_t*)(dlist->data);
      if (strcmp(clone->ip, which)) continue;
      sprintf(t, _("IP with %d clones"), g_list_length(clone->nicks));
      client_message(t, clone->ip);
      for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
	pos = (char*)(dlist2->data);
	sprintf(t, "%s", pos);
	client_message("--->", t);
      }
      break;
    }
  }
}

COMMAND(lopster_op) {
  char* nick;
  char* channel;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    if (in_channel())
      send_command(CMD_CLIENT_OP, global.current_page->name);
    else
      client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
    return;
  }
  nick = arg(NULL, 0);
  if (!nick) {
    if (user_search_full(channel)) {
      command = g_strdup_printf("%s %s", global.current_page->name,
				channel);
      send_command(CMD_CLIENT_OP, command);
      g_free(command);
    } else
      if (!strcmp(channel, "."))
	send_command(CMD_CLIENT_OP, global.current_page->name);
      else
	send_command(CMD_CLIENT_OP, channel);
  } else {
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, nick);
    else
      command = g_strdup_printf("%s %s", channel, nick);
    send_command(CMD_CLIENT_OP, command);
    g_free(command);
  }
}

COMMAND(lopster_deop) {
  char* nick;
  char* channel;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
    return;
  }
  nick = arg(NULL, 0);
  if (!nick) {
    if (user_search_full(channel)) {
      command = g_strdup_printf("%s %s", global.current_page->name,
				channel);
      send_command(CMD_CLIENT_DEOP, command);
      g_free(command);
    } else
      client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
  } else {
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, nick);
    else
      command = g_strdup_printf("%s %s", channel, nick);
    send_command(CMD_CLIENT_DEOP, command);
    g_free(command);
  }
}

COMMAND(lopster_chvoice) {
  char* nick;
  char* channel;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    if (in_channel())
      send_command(CMD_CLIENT_CHANNEL_VOICE, global.current_page->name);
    else
      client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
    return;
  }
  nick = arg(NULL, 0);
  if (!nick) {
    if (user_search_full(channel)) {
      command = g_strdup_printf("%s %s", global.current_page->name,
				channel);
      send_command(CMD_CLIENT_CHANNEL_VOICE, command);
      g_free(command);
    } else
      if (!strcmp(channel, "."))
	send_command(CMD_CLIENT_CHANNEL_VOICE, global.current_page->name);
      else
	send_command(CMD_CLIENT_CHANNEL_VOICE, channel);
  } else {
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, nick);
    else
      command = g_strdup_printf("%s %s", channel, nick);
    send_command(CMD_CLIENT_CHANNEL_VOICE, command);
    g_free(command);
  }
}

COMMAND(lopster_chunvoice) {
  char* nick;
  char* channel;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
    return;
  }
  nick = arg(NULL, 0);
  if (!nick) {
    if (user_search_full(channel)) {
      command = g_strdup_printf("%s %s", global.current_page->name,
				channel);
      send_command(CMD_CLIENT_CHANNEL_UNVOICE, command);
      g_free(command);
    } else
      client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
  } else {
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, nick);
    else
      command = g_strdup_printf("%s %s", channel, nick);
    send_command(CMD_CLIENT_CHANNEL_UNVOICE, command);
    g_free(command);
  }
}

COMMAND(lopster_links) {
  char* action = NULL;

  if (data) action = arg(data, 0);

  if (!action) {
    if (!global.links || !data) {
      client_message(_("Message"), _("Evaluating linked server list"));
      if (!global.links) {
	free_links(global.links);
	global.links = NULL;
      }
      send_command(CMD_SERVER_LINKS, "");
    } else {
      print_links(global.links, 0);
    }
  } else if (!strcasecmp(action, "GET")) {
    client_message(_("Message"), _("Evaluating linked server list"));
    if (!global.links) {
      free_links(global.links);
      global.links = NULL;
    }
    send_command(CMD_SERVER_LINKS, "");
  } else if (!strcasecmp(action, "PRINT")) {
    print_links(global.links, 0);
  } else {
    client_message(_("Error"), _("Unknown action for /links"));
  }
}

COMMAND(lopster_invite) {
  char* nick;
  char* channel;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    client_message(_("Error"), _("You have to specify at least a user!"));
    return;
  }
  
  nick = arg(NULL, 0);
  if (!nick) {
    if (in_channel()) {
      command = g_strdup_printf("%s %s", global.current_page->name, channel);
      send_command(CMD_CLIENT_CHANNEL_INVITE, command);
      g_free(command);
    } else
      client_message(_("Error"), _("Please specify a channel or switch to a channel!"));
  } else {
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, nick);
    else
      command = g_strdup_printf("%s %s", channel, nick);
    send_command(CMD_CLIENT_CHANNEL_INVITE, command);
    g_free(command);
  }
}

COMMAND(lopster_chmuzzle) {
  char* command;
  char* nick;
  char* reason;

  nick = arg(data, 0);
  if (!nick) {
    if (in_channel())
      send_command(CMD_CLIENT_CHANNEL_MUZZLE, global.current_page->name);
    else
      client_message(_("Error"), _("Please specify a user switch to a channel"));
    return;
  }
  reason = arg(NULL, 1);
  if (!reason) {
    send_command(CMD_CLIENT_CHANNEL_MUZZLE, nick);
  } else {
    command = g_strdup_printf("%s \"%s\"", nick, reason);
    send_command(CMD_CLIENT_CHANNEL_MUZZLE, command);
    g_free(command);
  }
}

COMMAND(lopster_chunmuzzle) {
  char* command;
  char* arg1;
  char* arg2;
  char* arg3;

  arg1 = arg(data, 0);
  arg2 = arg(NULL, 0);
  arg3 = arg(NULL, 0);

  if (!arg1) {
    client_message(_("Error"), _("Please specify a channel or a user switch to a channel"));
    return;
  }
  if (!arg2) {
    command = g_strdup_printf("%s %s", global.current_page->name, arg1);
    send_command(CMD_CLIENT_CHANNEL_UNMUZZLE, command);
    g_free(command);
    return;
  }
  if (!arg3) {
    if (user_search_full(arg1)) {
      command = g_strdup_printf("%s %s \"%s\"", 
				global.current_page->name, arg1, arg2);
    } else if (!strcmp(arg1, ".")) {
      command = g_strdup_printf("%s %s", global.current_page->name, arg2);
    } else {
      command = g_strdup_printf("%s %s", arg1, arg2);
    }
    send_command(CMD_CLIENT_CHANNEL_UNMUZZLE, command);
    g_free(command);
    return;
  } else {
    if (!strcmp(arg1, "."))
      command = g_strdup_printf("%s %s \"%s\"", global.current_page->name,
				arg2, arg3);
    else
      command = g_strdup_printf("%s %s \"%s\"", arg1, arg2, arg3);
    send_command(CMD_CLIENT_CHANNEL_UNMUZZLE, command);
    g_free(command);
  }
}


COMMAND(lopster_usermode) {
  char* message;
  
  message = arg(data, 1);
  if (!message) {
    send_command(CMD_CLIENT_USER_MODE, "");
  } else {
    send_command(CMD_CLIENT_USER_MODE, message);
  }
}

COMMAND(lopster_sstats) {
  send_command(CMD_CLIENT_USAGE_STATS, "");
}

COMMAND(lopster_chmode) {
  char* channel;
  char* mode;
  char* command;

  channel = arg(data, 0);
  if (!channel) {
    if (in_channel())
      send_command(CMD_CLIENT_CHANNEL_MODE, global.current_page->name);
    else
      client_message(_("Error"), _("Please specify a channel or switch to a channel!"));
    return;
  }
  mode = arg(NULL, 0);
  if (!mode) {
    if ((*channel == '+') || (*channel == '-')) {
      if (in_channel()) {
	command = g_strdup_printf("%s %s", global.current_page->name,
				  channel);
	send_command(CMD_CLIENT_CHANNEL_MODE, command);
	g_free(command);
      } else
	client_message(_("Error"), _("Please specify a channel or switch to a channel!"));
    } else {
      if (!strcmp(channel, "."))
	send_command(CMD_CLIENT_CHANNEL_MODE, global.current_page->name);
      else
	send_command(CMD_CLIENT_CHANNEL_MODE, channel);
    }
  } else {
    if (!strcmp(channel, "."))
      command = g_strdup_printf("%s %s", global.current_page->name, mode);
    else
      command = g_strdup_printf("%s %s", channel, mode);
    send_command(CMD_CLIENT_CHANNEL_MODE, command);
    g_free(command);
  }
}

COMMAND(lopster_chwallop) {
  char* message;

  message = arg(data, 1);
  if (!message) {
    client_message(_("Error"), _("You want say something, but what?"));
    return;
  }
  if (!in_channel()) {
    client_message(_("Error"), _("Switch to a channel page!"));
    return;
  }
  send_chwallop(global.current_page->name, message);
}

COMMAND(lopster_killghost) {
  char* ghost;
  char* passwd;
  char* command;

  ghost = arg(data, 0);
  if (!ghost) {
    client_message(_("Error"), _("You have to specify the ghost!"));
    return;
  }
  passwd = arg(NULL, 0);
  if (!passwd) {
    command = g_strdup_printf("ghost %s %s", 
			      ghost, global.user.password);
  } else {
    command = g_strdup_printf("ghost %s %s", ghost, passwd);
  }

  send_private("NickServ", command);
  g_free(command);
}

COMMAND(lopster_locate) {
  char* nick;

  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("You have to specify a user!"));
    return;
  }
  send_command(CMD_CLIENT_WHICH_SERVER, nick);
}

COMMAND(lopster_clients) {
  show_clients();
}

// /exec by R00t
////////////////////////////////

COMMAND(lopster_exec) {
  exec_command(data);
}

COMMAND(lopster_whowas) {
  char* nick;

  if (!opennap_version(0, 38)) {
    client_message(_("Error"), _("Not supported on this server (need to be opennap 0.38)"));
    return;
  }
  nick = arg(data, 0);
  if (!nick) {
    client_message(_("Error"), _("Whowas who?"));
    return;
  }
  send_command(10121, nick);
}

COMMAND(lopster_rcolors) {
  int i1;
  char str[1024];
  int pos = 0;
  char* codes;

  codes = arg(data, 0);

  if (!codes) {
  } else if (!strcasecmp(codes, "-reset")) {
    free(global.rainbow_colors);
    global.rainbow_colors = strdup("RrpPBbcCgGYy");
  } else {
    for (i1 = 0; (i1 < strlen(data))&&(i1 < 1023); i1++) {
      if (strchr("krgybmpcwKRGYBMPCWn", data[i1]))
	str[pos++] = data[i1];
    }
    str[pos] = 0;
    if (pos == 0) global.rainbow_colors = strdup("RrpPBbcCgGYy");
    else global.rainbow_colors = strdup(str);
  }
  client_message("Rainbow colors", global.rainbow_colors);
}

COMMAND(lopster_rainbow) {
  char* size;
  int isize;
  char* sep = NULL;
  char* message;
  char command[2048];
  int pos;
  int cpos;
  int cnt;
  int i1;
  
  if (!in_channel() && !in_private()) {
    client_message(_("Error"), _("Not allowed in this page!"));
    return;
  }
  size = arg(data, 0);
  if (!size) {
    client_message(_("Error"), _("Wrong format in command /rainbow!"));
    return;
  }
  if (!isdigit(*size)) {
    sep = size;
    size = arg(NULL, 0);
  }
  if (!size) {
    client_message(_("Error"), _("Wrong format in command /rainbow!"));
    return;
  }
  message = arg(NULL, 1);
  if (!message) {
    client_message(_("Error"), _("Wrong format in command /rainbow!"));
    return;
  }
  
  isize = atoi(size);
  if (isize < 1) isize = 1;
  pos = cnt = 0;
  cpos = strlen(global.rainbow_colors)-1;
  for (i1 = 0; i1 < strlen(message); i1++) {
    if (message[i1] == '\n') {
      command[pos++] = message[i1];
      command[pos++] = '%';
      command[pos++] = global.rainbow_colors[cpos];
    } else {
      if ((cnt % isize) == 0) {
	if (sep) {
	  int temp = 0;
	  command[pos++] = '%';
	  command[pos++] = 'n';
	  while (sep[temp] != 0) {
	    command[pos++] = sep[temp];
	    temp++;
	  }
	}

	cpos++;
	if (cpos == strlen(global.rainbow_colors)) cpos = 0;
	command[pos++] = '%';
	command[pos++] = global.rainbow_colors[cpos];
      }
      cnt++;
      command[pos++] = message[i1];
    }
  }
  command[pos++] = 0;

  if (in_channel())
    send_public(global.current_page->name, command);
  else
    send_private(global.current_page->name, command);
}

COMMAND(lopster_browse) {
  char* nick;
  GtkWidget* temp;
  char* max;

  nick = arg(data, 0);
  max = arg(NULL, 0);

  if (!nick) {
    client_message(_("Error"), _("Browse who?"));
    return;
  }
  temp = lookup_widget(global.win, "entry79");
  gtk_entry_set_text(GTK_ENTRY(temp), nick);
  if (max) {
    temp = lookup_widget(global.win, "checkbutton36");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    temp = lookup_widget(global.win, "spinbutton33");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), atoi(max));
  }
  on_entry79_activate(NULL, NULL);
}

COMMAND(lopster_send) {
  char* nick;
  char* file;
  char* command;
  struct stat st;
  transfer_t* new_trans;
  struct sockaddr_in localaddr;
  int len = sizeof(struct sockaddr_in);
  socket_t* socket;

  nick = arg(data, 0);
  file = arg(NULL, 1);

  if (!nick || !file) {
    client_message(_("Error"), _("Wrong format in command send!"));
    return;
  }
  if (stat(file, &st) < 0) {
    client_message(_("Error"), _("File does not exist!"));
    return;
  }

  new_trans = transfer_new();
  new_trans->longname = strdup(file);
  new_trans->winname = strdup(file);
  convert_to_win(new_trans->winname);
  new_trans->shortname =
    strdup(extract_short_name(new_trans->longname));
  new_trans->user = strdup(nick);
  new_trans->type = T_UPLOAD;
  new_trans->is_dcc = TRUE;
  new_trans->mime_type = get_mimetype(file);
  
  send_command(CMD_CLIENT_USERSPEED, new_trans->user);
  new_trans->size = st.st_size;
  socket = socket_new(S_TRANSFER);
  socket->data = new_trans;
  
  transfer_insert(socket);
  upload_start(socket);
  
  getsockname(global.napster->fd,
	      (struct sockaddr *)&localaddr, &len);
  command = 
    g_strdup_printf("%s %cSEND %s %lu %d \"%s\" %lu %s %d%c", 
		    nick, '\001', SERVER->nick, 
		    (unsigned long)BSWAP32(localaddr.sin_addr.s_addr), 
		    global.network.port, new_trans->winname, 
		    (unsigned long)st.st_size, "checksum", 0, '\001');
  send_command(CMD_CLIENT_PRIVMSG, command);

}

COMMAND(lopster_slink) {
  char* server;
  char* remote;
  char* command;

  server = arg(data, 0);
  remote = arg(NULL, 0);

  if (!server) {
    client_message(_("Error"), _("Link a server or what?"));
    return;
  }
  
  if (remote) {
    command = g_strdup_printf("%s %s", server, remote);
    send_command(CMD_CLIENT_CONNECT, command);
    g_free(command);
  } else {
    send_command(CMD_CLIENT_CONNECT, data);
  }
}

COMMAND(lopster_sdelink) {
  char* server;
  char* reason;
  char* command;

  server = arg(data, 0);
  reason = arg(NULL, 1);
  if (!server) {
    client_message(_("Error"), _("Delink a server or what?"));
    return;
  }
  if (reason)
    command = g_strdup_printf("%s \"%s\"", server, reason);
  else
    command = g_strdup_printf("%s", server);
  
  send_command(CMD_CLIENT_DISCONNECT, command);
  g_free(command);
}

COMMAND(lopster_skill) {
  char* server;
  char* reason;
  char* command;

  server = arg(data, 0);
  reason = arg(NULL, 1);
  if (!server) {
    client_message(_("Error"), _("Kill what server?"));
    return;
  }

  if (reason)
    command = g_strdup_printf("%s \"%s\"", server, reason);
  else
    command = g_strdup_printf("%s", server);
  
  send_command(CMD_CLIENT_KILL_SERVER, command);
  g_free(command);
}

COMMAND(lopster_sremove) {
  char* server;
  char* reason;
  char* command;

  server = arg(data, 0);
  reason = arg(NULL, 1);
  if (!server) {
    client_message(_("Error"), _("Remove what server?"));
    return;
  }

  if (reason)
    command = g_strdup_printf("%s \"%s\"", server, reason);
  else
    command = g_strdup_printf("%s", server);
  
  send_command(CMD_CLIENT_REMOVE_SERVER, command);
  g_free(command);
}

COMMAND(lopster_sreload) {
  if (data)
    send_command(CMD_CLIENT_REHASH, data);
  else
    send_command(CMD_CLIENT_REHASH, "");
}

COMMAND(lopster_masskill) {
  char* ip;
  char* reason;
  char* command;
  
  ip = arg(data, 0);
  reason = arg(NULL, 1);
  if (!ip) {
    client_message(_("Error"), _("Kill what ip?"));
    return;
  }
  if (reason) {
    command = g_strdup_printf("%s \"%s\"", ip, reason);
    send_command(CMD_CLIENT_MASS_KILL, command);
    g_free(command);
  } else {
    send_command(CMD_CLIENT_MASS_KILL, ip);
  }
}
COMMAND(lopster_test) {
  //  ping(data);
}
