#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netdb.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "global.h"
#include "splash.h"
#include "interface.h"
#include "server.h"
#include "search.h"
#include "handler.h"
#include "callbacks.h"
#include "connection.h"
#include "preferences.h"
#include "dirselect.h"
#include "share.h"
#include "chat.h"
#include "transfer.h"
#include "commands.h"
#include "hotlist.h"
#include "browse.h"
#include "scheme.h"
#include "log.h"
#include "dialog.h"
#include "resume.h"

///////////////////////////
// CONNECTION
///////////////////////////

void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GList *combo4_items = NULL;
  GtkWidget* combo;
  char server_str[1024];
  server_t* server;
  GList* dlist;
  
  if (global.connect_win) return;

  global.connect_win = create_connection_win();

  temp = lookup_widget(global.connect_win, "button84");
  set_up_button(temp, "pix11", "pix12", "frame58");
  set_button_state(temp, global.connect_button);
  
  combo = lookup_widget(global.connect_win, "combo4");
  if (global.servers) {
    dlist = g_list_first(global.servers);
    while (dlist) {
      server = (server_t*)(dlist->data);
      sprintf(server_str, "%s %d", server->description, 
	      server->port);
      combo4_items = g_list_append (combo4_items, strdup(server_str));
      dlist = g_list_next(dlist);
    }
  }

  if (global.last_server) {
    combo4_items = g_list_insert (combo4_items, _("Last Server"), 0);
  }

  gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo4_items);
  g_list_free (combo4_items);

  gtk_widget_show(global.connect_win);
}

void
on_connect3_activate                    (GtkMenuItem     *menuitem,
					 gpointer         user_data)
{
  server_t* server;
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.status.connection == 1) return;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node) return;

  server = create_server_from_napigator(ctree, node);
  if (!server) return;
  
  if (strlen(server->nick) < 1) {
    client_message(_("Message"), _("No username specified in preferences"));
    server_destroy(server);
    return;
  }
  if (strchr(server->nick, ' ')) {
    client_message(_("Message"), _("No spaces allowed in nickname"));
    server_destroy(server);
    return;
  }
  if (strlen(server->passwd) < 1) {
    client_message(_("Message"), _("No password specified in preferences"));
    server_destroy(server);
    return;
  }
  if (strlen(server->passwd) < 1) {
    client_message(_("Message"), _("No spaces allowed in password"));
    server_destroy(server);
    return;
  }
  
  // this should disconnect
  if (global.status.connection) {
    socket_end(global.napster, 0);
  }
  
  napster_connect(server);
}

void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  napster_disconnect(NULL);
}

void
on_connection_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkStatusbar* status;
  GtkWidget* entry;
  server_t* server;
  int row;

  if (!global.connect_win) return;
  if (global.status.connection == 1) return;

  server = search_server();
  if (!server) return;

  entry = lookup_widget(global.connect_win, "connection_name");
  server_set_nick(server, gtk_entry_get_text(GTK_ENTRY(entry)));

  if (strlen(server->nick) < 1) {
    status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("Enter a Nickname"));
    
    temp = lookup_widget(global.connect_win, "button84");
    set_button_state(temp, 1);
    return;
  }
  if (strchr(server->nick, ' ')) {
    status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("No spaces in nick allowed"));
    return;
  }

  // updating nick in selected server clist
  temp = lookup_widget(global.win, "clist11");
  row = gtk_clist_find_row_from_data(GTK_CLIST(temp), server);
  if (row >= 0)
    gtk_clist_set_text(GTK_CLIST(temp), row, 4, server->nick);

  entry = lookup_widget(global.connect_win, "connection_pass");
  server_set_passwd(server, gtk_entry_get_text(GTK_ENTRY(entry)));
  
  if (strlen(server->passwd) < 1) {
    status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("Enter a Password"));
    
    temp = lookup_widget(global.connect_win, "button84");
    set_button_state(temp, 1);
    return;
  }
  if (strchr(server->passwd, ' ')) {
    status = GTK_STATUSBAR(lookup_widget(global.connect_win, "connect_status"));
    connect_progress(_("No spaces in password"));
    return;
  }
  
  // this should disconnect
  if (global.status.connection) {
    socket_end(global.napster, 0);
  }
  
  temp = lookup_widget(global.connect_win, "checkbutton42");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    global.options.login_mode |= L_NOT_JOIN;
  }
  temp = lookup_widget(global.connect_win, "checkbutton43");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    global.options.login_mode |= L_NOT_SHARE;
  }

  napster_connect(server_copy(server));
}

void
on_connection_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = global.connect_win;
  if (global.status.connection == 1) {
    napster_disconnect(NULL);
  } else {
    if (global.status.connection == 0)
      napster_disconnect(NULL);
    gtk_widget_hide(win);
    gtk_widget_destroy(win);
    global.connect_win = NULL;
  }
}

void
on_connection_win_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = GTK_WIDGET(object);
  if (global.status.connection == 1) {
    socket_destroy(global.napster, 0);
  }

  gtk_widget_hide(win);
  gtk_widget_destroy(win);
  global.connect_win = NULL;
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (global.options_win) return;
  global.options_win = create_options_win();

  temp = lookup_widget(global.options_win, "text8");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);
  gtk_widget_set_style(temp, global.style[2]);  
  temp = lookup_widget(global.options_win, "text9");
  gtk_text_set_word_wrap(GTK_TEXT(temp), 1);
  temp = lookup_widget(global.options_win, "clist6");
  gtk_clist_set_reorderable (GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons (GTK_CLIST(temp), TRUE);


  setup_preferences(P_TREE);
  setup_preferences(P_ALL);

  gtk_my_widget_show(global.options_win);
}


void
on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  on_window_delete_event(NULL, NULL, NULL);
}


void
on_join_chatrooms_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (global.status.connection < 2) return;
  
  temp = lookup_widget(global.win, "notebook1");
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), 1);
  temp = lookup_widget(global.win, "notebook3");
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), 1);
  temp = lookup_widget(global.win, "channel_list");
  
  if (GTK_CLIST(temp)->rows == 0) {
    on_hidden1_activate(NULL, NULL);
  }
  
}


void
on_button6_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(GTK_WIDGET(button), "search_artist");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "search_results");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)100);
  temp = lookup_widget(GTK_WIDGET(button), "combo_bitrate");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_bitrate2");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_freq");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_freq2");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_speed");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "combo_speed2");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "entry70");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "entry71");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(GTK_WIDGET(button), "entry69");
  gtk_entry_set_text(GTK_ENTRY(temp), "");
}


void
on_button7_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  send_search_request(FALSE);
}


void 
on_dir_select29(gchar* dir) {
  GtkWidget* temp;
  
  if (!global.options_win) return;
  temp = lookup_widget(global.options_win, "entry14");
  if (dir) {
    if (dir[strlen(dir)-1] == '/') dir[strlen(dir)-1] = 0;
    gtk_entry_set_text(GTK_ENTRY(temp), dir);
  }
}

void
on_button29_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = create_dir_browser(_("Select Directory"), NULL, 
			   GTK_SELECTION_SINGLE, on_dir_select29);
  gtk_widget_show(win);
}

void
on_button30_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  apply_preferences();
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void
on_button31_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  char* filename;

  win = lookup_widget(GTK_WIDGET(button), "fileselection1");
  filename = strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(win)));
  
  gtk_widget_hide(win);
  gtk_widget_destroy(win);

  //  log_show_file(filename);

  free(filename);
}


void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = lookup_widget(GTK_WIDGET(button), "fileselection1");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}

void
on_button33_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void
on_button10_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget* win;

  win = create_add_user_win();
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void*)1);
  gtk_window_set_title (GTK_WINDOW (win), _("Add User To Hotlist"));
  gtk_widget_show(win);
}

void
on_refresh1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lib_refresh();
}

void
on_button24_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  chat_page_t* page;

  page = chat_page_get_current_main();
  if (!page) return;

  chat_page_leave(page);
}

void
on_chat_entry_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
#define MAX_HISTORY   1000
  GtkEntry* entry;
  char* text;
  char* pos;

  entry = GTK_ENTRY(editable);
  text = strdup(gtk_entry_get_text(entry));
  if (strlen(text) <= 0) {
    free(text);
    return;
  }

  global.chat_history = g_list_append(global.chat_history, strdup(text));

  // updating history
  while (g_list_length(global.chat_history) > MAX_HISTORY) {
    pos = g_list_nth_data(global.chat_history, 0);
    free(pos);
    global.chat_history = g_list_remove(global.chat_history, pos);
  }
  global.history_pos = g_list_length(global.chat_history);
  
  if (text[0] == '/') {
    handle_lopster_command(text);
  } else {
    if (global.current_page->type == P_PUBLIC) {
      lopster_public(text);
    } else if (global.current_page->type == P_PRIVATE) {
      send_private(global.current_page->name, text);
    } else if (!strcmp("Console", global.current_page->name)) {
      send_wallop(text);
    }
  }
  gtk_entry_set_text(entry, "");
  free(text);
}


void
on_notebook3_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  chat_page_t* page2;
  
  temp = page->tab_label;
  if (!strcmp(GTK_LABEL(temp)->label, _("Console")))
    page2 = chat_page_search("Console", P_FIX);
  else if (!strcmp(GTK_LABEL(temp)->label, _("Channels")))
    page2 = chat_page_search("Channels", P_FIX);
  else
    page2 = chat_page_search(GTK_LABEL(temp)->label, -1);

  if (!page2) return;

  gtk_widget_set_style(temp, global.style[0]);  
  
  temp = lookup_widget(global.win, "button24");

  if (page2->type == P_FIX)
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);

  temp = lookup_widget(global.win, "chat_entry");
  gtk_widget_grab_focus(temp);

  if (global.current_page->window) return;
  global.current_page = page2;
}


gboolean
on_search_list_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  file_t* file;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    file = (file_t*)gtk_clist_get_row_data(GTK_CLIST(widget),
					   global.popup_row);
    if (file->local)
      on_play_file3_activate(NULL, NULL);
    else
      on_download_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    //    if (row == -1) return FALSE;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    file = (file_t*)gtk_clist_get_row_data(GTK_CLIST(widget),
					   global.popup_row);
    
    pop = create_search_list_popup(file);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

//////////////////////////////////////////
// download stuff
void
on_download_selected_activate         (GtkMenuItem     *menuitem,
				       gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  file_t* file;
  int row;
  
  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;

  while (row_list) {
    row = (int)row_list->data;
    file = (file_t*)gtk_clist_get_row_data(clist, row);
    if (!file->local) download_file(file, (int)user_data);
    row_list = row_list->next;
  }
  
}

void
on_download_activate            (GtkMenuItem     *menuitem,
				 gpointer         user_data)
{
  GtkCList* list;
  file_t* file;

  list = GTK_CLIST(global.popup_list);
  file = (file_t*)gtk_clist_get_row_data(list, global.popup_row);
  if (!file->local) download_file(file, (int)user_data);
}


// end download stuff
/////////////////////////////////

//////////////////////////////////////////
// hotlist stuff

void set_prefix(char* prefix, int client) {
  GtkWidget* temp;
  char* text;
  scheme_t* scheme;

  if (!global.options_win) return;
  if (!prefix) return;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (client) {
    if (scheme->client_prefix) free(scheme->client_prefix);
    scheme->client_prefix = strdup(prefix);
  } else {
    if (scheme->server_prefix) free(scheme->server_prefix);
    scheme->server_prefix = strdup(prefix);
  }
  scheme_draw(scheme);
}

void
on_button32_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char text[200];
  void* pointer;

  temp = lookup_widget(GTK_WIDGET(button), "entry16");
  strcpy(text, gtk_entry_get_text(GTK_ENTRY(temp)));

  if (strlen(text) == 0) return;

  temp = lookup_widget(GTK_WIDGET(button), "add_user_win");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "ref");
  if (pointer == (void*)1) {
    add_to_hotlist(text);
  } if (pointer == (void*)2) {
    send_command(CMD_CLIENT_WHOIS, text);
  } if (pointer == (void*)3) {
    search_pattern_rename_current(text);
  } if (pointer == (void*)4) {
    set_prefix(text, 0);
  } if (pointer == (void*)5) {
    set_prefix(text, 1);
  }
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void
on_add_to_hot_list_activate       (GtkMenuItem     *menuitem,
				   gpointer         user_data)
{
  GtkWidget* win;

  win = create_add_user_win();
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void*)1);
  gtk_window_set_title (GTK_WINDOW (win), _("Add User To Hotlist"));
  gtk_widget_show(win);
}

gboolean
on_online_button_press_event         (GtkWidget       *widget,
				      GdkEventButton  *event,
				      gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  if (row == -1) return FALSE;
  global.popup_row = row;
  global.popup_list = widget;

  if (event->type == GDK_2BUTTON_PRESS) {
    on_whois_user_activate(NULL, (gpointer)M_ONLINE);
    return FALSE;
  }

  if (event->button == global.options.popup_create) {
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);

    pop = create_online_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

// end hotlist stuff
/////////////////////////////////

/////////////////////////////////
// list stuff
void
on_list_click_column                   (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
  if (column == clist->sort_column) {
    if (clist->sort_type == GTK_SORT_ASCENDING)
      gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
    else
      gtk_clist_set_sort_type(clist, GTK_SORT_ASCENDING);
  } else {
    gtk_clist_set_sort_column(clist, column);
    gtk_clist_set_sort_type(clist, GTK_SORT_DESCENDING);
  }

  gtk_clist_freeze (clist);
  gtk_clist_sort(clist);
  gtk_clist_thaw(clist);

}
// end list stuff
/////////////////////////////////


gboolean
on_transfer_down_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  socket_t* socket;
  transfer_t* transfer = NULL;
  GtkCList* clist;


  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  
  //    if (row == -1) return FALSE;
  global.popup_row = row;
  global.popup_list = widget;
  
  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_play_file_activate(NULL, NULL);
    return FALSE;
  }

  if (event->button == global.options.popup_create) {
    clist = GTK_CLIST(global.popup_list);
    socket = (socket_t*)gtk_clist_get_row_data(clist, global.popup_row);
    if (socket) {
      transfer = (transfer_t*)(socket->data);
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    }
    pop = create_download_popup(transfer);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL, 
		   event->button, event->time);
  }
  return FALSE;
}


void
on_cancel_transfer_activate (GtkMenuItem     *menuitem,
			     gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;
  socket_t* socket;
  GList* next;
  
  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int)row_list->data;
    next = row_list->next;
    socket = (socket_t*)gtk_clist_get_row_data(clist, row);
    socket_end(socket, S_CANCELED);
    row_list = next;
  }

}

void
on_delete_transfer_activate (GtkMenuItem     *menuitem,
			     gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;
  socket_t* socket;
  GList* next;

  clist = GTK_CLIST(global.popup_list);
  row_list = clist->selection;
  while (row_list) {
    row = (int)row_list->data;
    next = row_list->next;
    socket = (socket_t*)gtk_clist_get_row_data(clist, row);
    socket_end(socket, S_DELETE);
    row_list = next;
  }

}

void
on_retry_download_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  socket_t* socket;

  list = GTK_CLIST(global.popup_list);
  socket = (socket_t*)gtk_clist_get_row_data(list, global.popup_row);
  download_start(socket, FALSE);
}

void
on_force_download_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  socket_t* socket;

  list = GTK_CLIST(global.popup_list);
  socket = (socket_t*)gtk_clist_get_row_data(list, global.popup_row);
  download_start(socket, TRUE);
}

void
on_button64_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  int i1;
  socket_t* socket;
  transfer_t* transfer;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    socket = (socket_t*)gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t*)(socket->data);
    if (transfer->status == S_FINISHED) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    socket = (socket_t*)gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t*)(socket->data);
    if ((!transfer_is_active(transfer)) || (transfer->status == S_QUEUED)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
}

void
on_search_artist_activate              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(editable), "activate");
  send_search_request(FALSE);
}


void
on_search_results_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  send_search_request(FALSE);
}



gboolean
on_chat_entry_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkEntry* entry;
  char* text;
  char* text2;
  char comm[1024];
  char t[1024];
  GList* c_list;
  int i1;
  command_t* command;
  static int cnt = 0;

  entry = GTK_ENTRY(widget);
  if (event->type == GDK_KEY_PRESS) {
    if (event->keyval == 65289) {     // tab
      cnt++;
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");

      text = strdup(gtk_entry_get_text(entry));

      if (strlen(text) <= 0) {
	free(text);
	return TRUE;
      }
      text2 = strrchr(text, ' ');
      if ((text[0] != '/') || (text2)) {
	if (text2) text2++;
	else text2 = text;

	if (text2[0] == '@') text2++;
	c_list = user_search(text2);
	
	switch (g_list_length(c_list)) {
	case 0:
	  client_message(_("Error"), _("no matching user found"));
	  cnt = 0;
	  break;
	case 1:
	  text2[0] = 0;
	  strcpy(t, text);
	  strcat(t, c_list->data);
	  if (!strchr(t, ' ')) strcat(t, ": ");
	  gtk_entry_set_text(entry, t);
	  cnt = 0;
	  break;
	default:
	  i1 = calc_list_prefix(c_list);
	  text2[0] = 0;
	  strcpy(t, text);
	  strncat(t, c_list->data, i1);
	  gtk_entry_set_text(entry, t);

	  if (cnt > 1) {
	    client_message(NULL, _("Available Users:"));
	    *t = 0;
	    for (i1 = 0; i1 < g_list_length(c_list); i1++) {
	      if (i1 > 0) strcat(t, ", ");
	      strcat(t, g_list_nth(c_list, i1)->data);
	    }
	    chat_print_ln("message", t);
	    cnt = 0;
	  }
	  break;
	}
      } else {
	text2 = strdup(text+1);
	c_list = command_search(text2);

	switch (g_list_length(c_list)) {
	case 0:
	  client_message(_("Error"), _("no matching command found"));
	  cnt = 0;
	  break;
	case 1:
	  command = (command_t*)(c_list->data);
	  sprintf(comm,"/%s ", command->name);
	  gtk_entry_set_text(entry, comm);
	  cnt = 0;
	  break;
	default:
	  i1 = calc_command_prefix(c_list);
	  command = (command_t*)(c_list->data);
	  comm[0] = '/';
	  comm[1] = 0;
	  strncat(comm, command->name, i1);
	  gtk_entry_set_text(entry, comm);

	  if (cnt > 1) {
	    client_message(NULL, _("Available Commands:"));
	    *t = 0;
	    for (i1 = 0; i1 < g_list_length(c_list); i1++) {
	      if (i1 > 0) strcat(t, ", /");
	      else strcat(t, "/");
	      command = (command_t*)(g_list_nth(c_list, i1)->data);
	      strcat(t, command->name);
	    }
	    chat_print_ln("message", t);
	    cnt = 0;
	  }
	  break;
	}
	free(text2);
      }
    } else if ((event->keyval == 65362) || (event->keyval == 65364)) {
      cnt = 0;
      if (event->keyval == 65362) {     // Up
	if (global.history_pos > 0) global.history_pos--;
	else global.history_pos = 0;
      }
      if (event->keyval == 65364) {     // Down
	if (global.history_pos < g_list_length(global.chat_history))
	  global.history_pos++;
	else global.history_pos = g_list_length(global.chat_history);
      }
      c_list = g_list_nth(global.chat_history, global.history_pos);
      if (c_list) {
	text = c_list->data;
	if (text) gtk_entry_set_text(GTK_ENTRY(widget), text);
      } else {
	gtk_entry_set_text(GTK_ENTRY(widget), "");
      }
      gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    } else {
      cnt = 0;
    }
  }

  text = gtk_entry_get_text(entry);
  if (!strcasecmp(text, "/reply") && (event->keyval == 32)) {
    if (global.reply)
      sprintf(t, "/whisper %s", global.reply);
    else
      sprintf(t, "/whisper");
    gtk_entry_set_text(GTK_ENTRY(widget), t);
  }
  if (!strcasecmp(text, "/reply ")) {
    if (global.reply)
      sprintf(t, "/whisper %s ", global.reply);
    else
      sprintf(t, "/whisper ");
    gtk_entry_set_text(GTK_ENTRY(widget), t);
  }
  
  return 1;
}


void
on_whois_win_destroy                   (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(global.whois_win);
  global.whois_win = NULL;
}


void
on_button82_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.whois_win);
}


gboolean
on_transfer_up_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  GtkCList* clist;
  transfer_t* transfer = NULL;
  socket_t* socket;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  
  global.popup_row = row;
  global.popup_list = widget;
  
  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_play_file_activate(NULL, NULL);
    return FALSE;
  }
  
  if (event->button == global.options.popup_create) {
    clist = GTK_CLIST(global.popup_list);
    socket = (socket_t*)gtk_clist_get_row_data(clist, global.popup_row);
    if (socket) {
      transfer = (transfer_t*)(socket->data);
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    }
    pop = create_upload_popup(transfer);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL, 
		   event->button, event->time);
  }

  return FALSE;
}

void
on_entry34_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char user[200];
  
  temp = lookup_widget(GTK_WIDGET(editable), "entry34");
  strcpy(user, gtk_entry_get_text(GTK_ENTRY(temp)));
  send_command(CMD_CLIENT_WHOIS, user);
}


void
on_entry16_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char text[200];
  void* pointer;

  temp = lookup_widget(GTK_WIDGET(editable), "entry16");
  strcpy(text, gtk_entry_get_text(GTK_ENTRY(temp)));

  if (strlen(text) == 0) return;

  temp = lookup_widget(GTK_WIDGET(editable), "add_user_win");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "ref");
  if (pointer == (void*)1) {
    add_to_hotlist(text);
  } if (pointer == (void*)2) {
    send_command(CMD_CLIENT_WHOIS, text);
  } if (pointer == (void*)3) {
    search_pattern_rename_current(text);
  }
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_togglebutton2_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkWidget* temp2;

  temp = lookup_widget(GTK_WIDGET(togglebutton), "label125");
  temp2 = lookup_widget(GTK_WIDGET(togglebutton), "entry35");

  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
  }
  
}


void
on_button84_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  global.connect_button = toggle_button_state(GTK_WIDGET(button));
}


void
on_button90_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


void
on_add_to_hotlist_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  add_to_hotlist(user);
}


void
on_whois_user_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  send_command(CMD_CLIENT_WHOIS, user);
}


void
on_ignore_activate                (GtkMenuItem     *menuitem,
				   gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);

  if (is_string_in_list(global.ignored_users, user)) {
    send_command(CMD_CLIENT_UNIGNORE_USER, user);
  } else {
    send_command(CMD_CLIENT_IGNORE_USER, user);
  }
}


void
on_show_ignore_list_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (global.ignore_win) {
    gtk_widget_show(global.ignore_win);
  } else {
    global.ignore_win = create_ignore_win();
    gtk_widget_show(global.ignore_win);
    send_command(CMD_CLIENT_IGNORE_LIST, "");
  }
}


void
on_ignore_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
  
  gtk_widget_hide(global.ignore_win);
  gtk_widget_destroy(global.ignore_win);
  global.ignore_win = NULL;
}


void
on_button91_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  int i1;
  GtkCList* clist;
  char* text;

  // clear ignore list
  clist = GTK_CLIST(lookup_widget(global.ignore_win, "ignore_list"));
  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_text(clist, i1, 0, &text);
    send_command(CMD_CLIENT_UNIGNORE_USER, text);
  }
  
}


void
on_button93_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.ignore_win);
}


void
on_refresh_users_files_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  user_t* user;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  user = (user_t*)gtk_clist_get_row_data(clist, global.popup_row);
  browse_user_files(user->username, 0);
}


void
on_remove_user_from_hotlist_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  user_t* user;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  user = (user_t*)gtk_clist_get_row_data(clist, global.popup_row);
  remove_from_hotlist(user->username);
}

void rec_download_file (GtkCTree *ctree, GtkCTreeNode *node,
			char* data) {
  file_t* file;

  file = (file_t*)gtk_ctree_node_get_row_data(ctree, node);
  if (file) download_file(file, 1);
}

void
on_download_folder_activate (GtkMenuItem     *menuitem,
			     gpointer         user_data) {
  GtkCTree* ctree;
  GtkCTreeNode* node;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  
  gtk_ctree_post_recursive(ctree, node, 
			   (GtkCTreeFunc)rec_download_file, NULL);
}

void
on_download2_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GList* row_list;
  file_t* file;
  GtkCTreeNode* node;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    file = (file_t*)gtk_ctree_node_get_row_data(ctree, node);
    if (file) download_file(file, (int)user_data);
    row_list = row_list->next;
  }
}


gboolean
on_hot_tree_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  if (row == -1) return FALSE;
  global.popup_row = row;
  global.popup_list = widget;

  if (event->type == GDK_2BUTTON_PRESS) {
    on_refresh_users_files_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row (GTK_CLIST(widget), global.popup_row, 0);
    pop = create_hotlist_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}



void
on_combo_entry14_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkEntry* entry;
  GtkEntry* entry2;
  GtkText* des;
  GtkEntry* alias;
  char* text;
  command_t* command;
  char t[2048];

  entry = GTK_ENTRY(lookup_widget(global.options_win, "combo_entry14"));
  entry2 = GTK_ENTRY(lookup_widget(global.options_win, "entry40"));
  des = GTK_TEXT(lookup_widget(global.options_win, "text9"));
  alias = GTK_ENTRY(lookup_widget(global.options_win, "entry41"));
  
  text = gtk_entry_get_text(entry);
  command = command_is_command(text);
  if (!command) {
    g_warning("could not get command, CRITICAL!");
    return;
  }
  
  // syntax
  gtk_entry_set_text(entry2, command->syntax);

  // description
  gtk_text_backward_delete(des, gtk_text_get_length(des));
  sprintf(t, "%s\n", command->description);
  gtk_text_insert(des, NULL, NULL, NULL, t, strlen(t));

  // alias
  text = command_get_alias_string(command->id);
  gtk_entry_set_text(alias, text);
}



void
on_button101_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry* entry1;
  GtkEntry* entry2;
  char* text;
  char* pos;

  command_t* command;

  entry1 = 
    GTK_ENTRY(lookup_widget(global.options_win, "combo_entry14"));
  entry2 = 
    GTK_ENTRY(lookup_widget(global.options_win, "entry41"));

  text = gtk_entry_get_text(entry1);
  command = command_is_command(text);
  if (!command) {
    g_warning("chat command does not exists");
    return;
  }
  command_delete_alias_for(command->id);
  
  text = strdup(gtk_entry_get_text(entry2));
  
  pos = strtok(text, " \t");
  while (pos) {
    if (strlen(pos) > 0)
      command_make_alias(command->name, pos);
    pos = strtok(NULL, " \t");
  }
  free(text);
  
  text = command_get_alias_string(command->id);
  gtk_entry_set_text(entry2, text);
}



void
on_button96_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  apply_preferences();
}


void
on_combo_entry15_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;
  GtkWidget* temp2;
  scheme_t* scheme1;
  scheme_t* scheme2;
  char* text;
  GList* list2;
  GList* dlist;
  style_t* style;

  win = global.options_win;
  temp = lookup_widget(win, "combo_entry15");
  
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp = lookup_widget(global.options_win, "button98");
  temp2 = lookup_widget(global.options_win, "button99");

  scheme1 = gtk_object_get_data(GTK_OBJECT(win), "scheme");
  if ((scheme2 = scheme_load(text)) != NULL) {
    scheme_draw(scheme2);
    if (scheme1) scheme_destroy(scheme1);
    gtk_object_set_data(GTK_OBJECT(win), "scheme", scheme2);
    gtk_widget_set_sensitive(temp, TRUE);
    gtk_widget_set_sensitive(temp2, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
    gtk_widget_set_sensitive(temp2, FALSE);
    return;
  }

  list2 = NULL;
  temp = lookup_widget(win, "combo5");
  for (dlist = scheme2->colors; dlist; dlist = dlist->next) {
    style = (style_t*)(dlist->data);
    list2 = g_list_append (list2, style->name);
  }
  gtk_combo_set_popdown_strings (GTK_COMBO (temp), list2);
  g_list_free (list2);
}

void
on_resume_download_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data) {  
  GtkCList* list;
  socket_t* socket;

  list = GTK_CLIST(global.popup_list);
  
  socket = (socket_t*)gtk_clist_get_row_data(list, global.popup_row);
  download_start(socket, FALSE);
}

void
on_stop_download_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data) {
  GtkCList* list;
  socket_t* socket;

  list = GTK_CLIST(global.popup_list);
  
  socket = (socket_t*)gtk_clist_get_row_data(list, global.popup_row);
  
  if (socket) socket_end(socket, S_STOPPED);
}

void
on_options_win_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.options_win);
  gtk_widget_destroy(global.options_win);
  global.options_win = NULL;
}


void
on_fileselection1_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_ban_win_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* data;

  temp = lookup_widget(global.ban_win, "clist3");
  data = gtk_object_get_user_data(object);
  if (data) free(data);

  gtk_widget_hide(global.ban_win);
  gtk_widget_destroy(global.ban_win);
  global.ban_win = NULL;

}


int hex_to_int(char ch) {
  if ((ch <= '9') && (ch >= '0')) 
    return ch-'0';
  else if ((ch <= 'f') && (ch >= 'a'))
    return ch-'a'+10;
  else if ((ch <= 'F') && (ch >= 'A'))
    return ch-'A'+10;
  else return 0;
}

void convert_color(char* text, gdouble* color) {
  int temp;

  temp = hex_to_int(text[1])*16 + hex_to_int(text[2]);
  color[0] = (gdouble)temp/255.0;
  temp = hex_to_int(text[3])*16 + hex_to_int(text[4]);
  color[1] = (gdouble)temp/255.0;
  temp = hex_to_int(text[5])*16 + hex_to_int(text[6]);
  color[2] = (gdouble)temp/255.0;
}

void
on_button94_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* colorsel;
  GtkWidget* temp;
  gdouble color[3];
  char* text;
  scheme_t* scheme;
  style_t* style;

  win = create_colorselectiondialog1();
  gtk_object_set_data(GTK_OBJECT(win),
		      "foreground", (gpointer)1);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no scheme found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_fore, color);
  
  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void
on_button106_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* colorsel;
  GtkWidget* temp;
  gdouble color[3];
  char* text;
  scheme_t* scheme;
  style_t* style;

  win = create_colorselectiondialog1();
  gtk_object_set_data_full(GTK_OBJECT(win),
			   "foreground", (gpointer)2, NULL);

  temp = lookup_widget(win, "NULL_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));
  temp = lookup_widget(win, "cancel_button2");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  // setting up current color
  colorsel = GTK_COLOR_SELECTION_DIALOG(win)->colorsel;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  convert_color(style->n_back, color);
  
  gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_show(win);
}


void
on_button107_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* fontsel;
  GtkWidget* temp;
  char* text;
  scheme_t* scheme;
  style_t* style;
  
  win = create_fontselectiondialog1();

  temp = lookup_widget(win, "NULL_button1");
  gtk_signal_connect (GTK_OBJECT (temp), "clicked",
                      GTK_SIGNAL_FUNC (on_NULL_button1_clicked),
                      NULL);
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));
  
  temp = lookup_widget(win, "cancel_button3");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  temp = lookup_widget(win, "ok_button3");
  gtk_signal_connect (GTK_OBJECT (temp), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_button3_clicked),
                      NULL);


  // setting up font
  fontsel = GTK_FONT_SELECTION_DIALOG(win)->fontsel;
  temp = lookup_widget(global.options_win, "combo_entry13");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  scheme = gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }
  style = style_search(scheme, text);
  if (!style) {
    g_warning("style not found");
    return;
  }
  
  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(fontsel), style->n_font);

  gtk_widget_show(win);
}


void
on_colorselectiondialog1_destroy       (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);
}


void
on_fontselectiondialog1_destroy        (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = GTK_WIDGET(object);
  gtk_widget_destroy(temp);

}


void
on_cancel_button3_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  gtk_widget_destroy(temp);

}


void set_color(gdouble* color, int fore) {
  GtkWidget* temp;
  char* text;
  scheme_t* scheme;
  char color_str[20];
  char hex[17] = "0123456789abcdef";
  int int_val;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (!color) {
    if (fore)
      style_update(scheme, text, "NULL", NULL, NULL);
    else
      style_update(scheme, text, NULL, "NULL", NULL);
    scheme_draw(scheme);
    return;
  }

  color_str[0] = '#';
  int_val = (int)(color[0]*255);
  color_str[1] = hex[int_val/16];
  color_str[2] = hex[int_val%16];
  int_val = (int)(color[1]*255);
  color_str[3] = hex[int_val/16];
  color_str[4] = hex[int_val%16];
  int_val = (int)(color[2]*255);
  color_str[5] = hex[int_val/16];
  color_str[6] = hex[int_val%16];
  color_str[7] = 0;
  if (fore)
    style_update(scheme, text, color_str, NULL, NULL);
  else
    style_update(scheme, text, NULL, color_str, NULL);

  scheme_draw(scheme);
}

void
on_ok_button2_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* colorsel;
  GtkWidget* temp;
  static gdouble color[3];
  gpointer* pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  colorsel = GTK_COLOR_SELECTION_DIALOG(temp)->colorsel;
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }

  gtk_color_selection_get_color(GTK_COLOR_SELECTION(colorsel), color);

  gtk_widget_destroy(temp);
  
  switch ((int)pointer) {
  case 1:
    set_color(color, 1);
    break;
  case 2:
    set_color(color, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }
}


void
on_button100_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  scheme_t* scheme;

  temp = lookup_widget(global.options_win, "combo_entry15");
  
  scheme = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme == NULL) {
    g_warning("no temp colors found!");
    return;
  }

  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) < 0) return;

  if (scheme->name) free(scheme->name);
  scheme->name = strdup(text);
  scheme_save(scheme);
  
  //  scheme_load(global.colors, text, 0);
}

void set_font(char* font) {
  GtkWidget* temp;
  char* text;
  scheme_t* scheme;

  temp = lookup_widget(global.options_win, "combo_entry13");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (!scheme) {
    g_warning("no temp colors found");
    return;
  }

  if (font) style_update(scheme, text, NULL, NULL, font);
  else style_update(scheme, text, NULL, NULL, "NULL");

  scheme_draw(scheme);
}


void
on_ok_button3_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkWidget* fontsel;
  char* font;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  fontsel = GTK_FONT_SELECTION_DIALOG(temp)->fontsel;

  if (gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel))) {
    font = strdup(gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel)));
    set_font(font);
  }
  gtk_widget_destroy(temp);
}

void
on_button111_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(GTK_WIDGET(button), "clist4");
  gtk_clist_clear(GTK_CLIST(temp));

  temp = lookup_widget(GTK_WIDGET(button), "button111");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(GTK_WIDGET(button), "entry43");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  send_command(CMD_CLIENT_NAMES_LIST, text);
}


void
on_button114_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}

void
on_button_users_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}


void
on_entry45_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button122_clicked(NULL, NULL);
}


void
on_entry46_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button123_clicked(NULL, NULL);
}


void
on_checkbutton7_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton7");
  global.options.show_joins = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  setup_preferences(P_SHOW_JOIN);
}


void
on_button115_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  toggle_button_state(GTK_WIDGET(button));
}

void
on_spinbutton5_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  global.limit.max_downloads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_D_LIMIT);
}


void
on_spinbutton6_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  global.limit.max_uploads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_U_LIMIT);
}

void
on_button98_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  scheme_t* scheme1;
  scheme_t* scheme2;

  temp = lookup_widget(global.options_win, "combo_entry15");
  
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme1 = scheme_load(text);
  if (!scheme1) {
    free(text);
    return;
  }

  scheme2 = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  scheme_destroy(scheme2);
  gtk_object_set_data(GTK_OBJECT(global.options_win), "scheme",
		      scheme1);
  
  free(text);
  scheme_draw(scheme1);
}


void
on_button99_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(global.options_win, "combo_entry15");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  scheme_delete(text);
  free(text);
}


void
on_button122_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* pos;
  GtkEntry* temp;
  GtkWidget* temp2;

  temp = GTK_ENTRY(lookup_widget(global.win, "entry45"));
  pos = strdup(gtk_entry_get_text(temp));
  make_list_from_string(&global.highlight, pos, " ");
  free(pos);
  pos = make_string_from_list(global.highlight, " ");
  gtk_entry_set_text(temp, pos);
  temp2 = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp2, FALSE);

  setup_preferences(P_HIGHLIGHT);
}

void
on_button123_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* pos;
  GtkEntry* temp;
  GtkWidget* temp2;

  temp = GTK_ENTRY(lookup_widget(global.win, "entry46"));
  pos = strdup(gtk_entry_get_text(temp));
  delete_user_list(&global.frienduser);
  make_list_from_string(&global.frienduser, pos, " ");
  update_users(global.frienduser);
  free(pos);
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(temp, pos);
  temp2 = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp2, FALSE);

  setup_preferences(P_FRIENDS);
}


void
on_checkbutton9_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  
  temp = lookup_widget(global.win, "entry50");
  if (gtk_toggle_button_get_active(togglebutton)) {
    temp = lookup_widget(global.win, "button125");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "entry50");
    gtk_widget_set_sensitive(temp, TRUE);
    text = gtk_entry_get_text(GTK_ENTRY(temp));

    if (global.afk.message) free(global.afk.message);
    global.afk.message = strdup(text);
    time(&global.afk.since);
  } else {
    temp = lookup_widget(global.win, "entry50");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "button125");
    gtk_widget_set_sensitive(temp, FALSE);
    if (global.afk.message) {
      free(global.afk.message);
      global.afk.message = NULL;
    }
  }
  if (global.afk.message) client_message("AFK", global.afk.message);
  else client_message("AFK", _("deactivated"));
}


void
on_checkbutton10_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton10");
  global.options.public_ignore = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  setup_preferences(P_IGNORE);
}


void
on_entry50_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button125");
  gtk_widget_set_sensitive(temp, TRUE);
}


void
on_play_file2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  file_t* file = NULL;
  GtkCTreeNode* node;
  char* dir = NULL;

  ctree = GTK_CTREE(global.popup_list);
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  if (!node) return;

  if (GTK_CTREE_ROW (node)->is_leaf) {
    file = (file_t*)gtk_ctree_node_get_row_data(ctree, node);
  } else {
    dir = (char*)gtk_ctree_node_get_row_data(ctree, node);
  }

  if (file) {
    play_file(file->longname);
  } else {
    play_file(dir);
  }
}


void
on_play_file_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  transfer_t* transfer;
  socket_t* socket;

  list = GTK_CLIST(global.popup_list);
  
  socket = (socket_t*)gtk_clist_get_row_data(list, global.popup_row);
  transfer = (transfer_t*)(socket->data);
  if (transfer) {
    if (transfer->type == T_UPLOAD)
      play_file(transfer->longname);
    else {
      if (transfer->resume)
	play_file(transfer->resume->filename);
      else
	play_file(transfer->longname);
    }
  }
}

void
on_play_file3_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* list;
  file_t* file;

  list = GTK_CLIST(global.popup_list);
  file = (file_t*)gtk_clist_get_row_data(list, global.popup_row);
  play_file(file->longname);
}


void
on_cancel_button2_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  gtk_widget_destroy(temp);
}

void
on_NULL_button2_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  gpointer* pointer;

  // setting fore or background
  temp = lookup_widget(GTK_WIDGET(button), "colorselectiondialog1");
  pointer = gtk_object_get_data(GTK_OBJECT(temp), "foreground");
  if (pointer == NULL) {
    g_warning("shit color");
    return;
  }

  // color = NULL
  gtk_widget_destroy(temp);
  
  switch ((int)pointer) {
  case 1:
    set_color(NULL, 1);
    break;
  case 2:
    set_color(NULL, 0);
    break;
  default:
    g_warning("unknwon data");
    break;
  }

}


void
on_NULL_button1_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  set_font(NULL);

  gtk_widget_destroy(temp);

}


void
on_button124_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* pos;
  GtkEntry* temp;
  GtkWidget* temp2;

  temp = GTK_ENTRY(lookup_widget(global.win, "entry51"));
  pos = strdup(gtk_entry_get_text(temp));
  delete_user_list(&global.enemyuser);
  make_list_from_string(&global.enemyuser, pos, " ");
  update_users(global.enemyuser);
  free(pos);
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(temp, pos);

  temp2 = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp2, FALSE);

  setup_preferences(P_ENEMIES);
}


void
on_button125_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char* text;
  GtkWidget* temp;

  temp = lookup_widget(global.win, "button125");
  if (!GTK_WIDGET_IS_SENSITIVE(temp)) {
    return;
  }
  temp = lookup_widget(global.win, "entry50");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  set_afk(text);
  free(text);
}


void
on_entry51_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button124_clicked(NULL, NULL);
}


void
on_entry50_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  on_button125_clicked(NULL, NULL);
}


gboolean
on_entry49_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return 1;
}



void
on_entry45_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button122");
  gtk_widget_set_sensitive(temp, TRUE);
}


void
on_entry46_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button123");
  gtk_widget_set_sensitive(temp, TRUE);
}


void
on_entry51_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "button124");
  gtk_widget_set_sensitive(temp, TRUE);
}


gboolean
on_entry46_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkEntry* entry;
  char* text;
  char* text2;
  char t[1024];
  GList* c_list;
  int i1;
  static int cnt = 0;

  if (in_private()) return FALSE;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if ((event->type == GDK_KEY_PRESS) && (event->keyval == 65289)) {     // tab
    entry = GTK_ENTRY(widget);
    gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
    text = strdup(gtk_entry_get_text(entry));

    if (strlen(text) <= 0) return TRUE;
    text2 = strrchr(text, ' ');
    if (text2) text2++;
    else text2 = text;
    c_list = user_search(text2);
	
    switch (g_list_length(c_list)) {
    case 0:
      //	  client_message("Error", "no matching user found");
      break;
    case 1:
      text2[0] = 0;
      strcpy(t, text);
      strcat(t, c_list->data);
      gtk_entry_set_text(entry, t);
      break;
    default:
      cnt++;
      i1 = calc_list_prefix(c_list);
      text2[0] = 0;
      strcpy(t, text);
      strncat(t, c_list->data, i1);
      gtk_entry_set_text(entry, t);
      
      if (cnt > 1) {
	strcpy(t, _("******** Available Users:\n"));
	for (i1 = 0; i1 < g_list_length(c_list); i1++) {
	  if (i1 > 0) strcat(t, ", ");
	  strcat(t, g_list_nth(c_list, i1)->data);
	}
	chat_print_ln("message", t);
	cnt = 0;
      }
      break;
    }
  }

  return 1;
}


gboolean
on_entry51_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return 1;
}


void
on_delete_file_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;

  win = create_delete_win();
  temp = lookup_widget(win, "button170");

  gtk_signal_connect (GTK_OBJECT (temp), "clicked",
                      GTK_SIGNAL_FUNC (on_button170_clicked),
                      (gpointer)1);
  gtk_widget_show(win);
}

void
on_private_mode_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);

  if (chat_page_search(user, P_PRIVATE)) {
    client_message(_("Message"), _("User is already in private list"));
    return;
  }
  create_private_page(user);
}


void
on_checkbutton14_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton14");
  global.options.send_ignore = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  setup_preferences(P_SEND_IGNORE);
}


void
on_button127_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  int row;

  temp = lookup_widget(global.options_win, "combo_entry16");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  if (strlen(text) <= 0) return;
  strcpy(tstr[0], text);
  gtk_entry_set_text(GTK_ENTRY(temp), "");

  temp = lookup_widget(global.options_win, "clist6");
  row = gtk_clist_append(GTK_CLIST(temp), list);
}


void
on_button128_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  GList* row_list;
  int row;

  list = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "clist6"));

  while ((row_list = list->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_remove(list, row);
  }
}


void
on_button129_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  on_hidden1_activate(NULL, NULL);
}


void
on_button133_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* list;
  int i1;
  transfer_t* transfer;
  socket_t* socket;

  list = GTK_CLIST(lookup_widget(global.win, "transfer_down"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    socket = (socket_t*)gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t*)(socket->data);
    if (!transfer_is_active(transfer)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
  list = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  i1 = 0;
  while (1) {
    if (i1 >= list->rows) break;
    socket = (socket_t*)gtk_clist_get_row_data(list, i1);
    transfer = (transfer_t*)(socket->data);
    if ((!transfer_is_active(transfer)) || (transfer->status == S_QUEUED)) {
      gtk_clist_remove(list, i1);
    } else {
      i1++;
    }
  }
}


void
on_friend_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  toggle_friend(user);
}


void
on_enemy_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  toggle_enemy(user);
}


gboolean
on_entry55_key_press_event             (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  on_entry46_key_press_event(widget, event, user_data);
  return FALSE;
}


void
on_remove_subtree1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  lib_set_flag(FLAG_TO_REMOVE, node);

  if (global.status.building < 2)
    gtk_idle_add(lib_remove_idle, NULL);
  lib_set_modified();
}


void
on_delete_subtree1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;

  win = create_delete_win();
  temp = lookup_widget(win, "button170");

  gtk_signal_connect (GTK_OBJECT (temp), "clicked",
                      GTK_SIGNAL_FUNC (on_button170_clicked),
                      (gpointer)2);
  gtk_widget_show(win);
}


gboolean
on_lib_tree_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
    row = -1;
  
  global.popup_row = row;
  global.popup_list = widget;
  
  gtk_clist_get_pixtext (GTK_CLIST(widget), row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  
  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_play_file2_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    if (pixmap == NULL) {
      pop = create_lib_popup2();
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    } else {
      pop = create_lib_popup1();
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    }  
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


void
on_remove_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  file_t* file;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(clist, global.popup_row);
  file->flags |= FLAG_TO_REMOVE;

  lib_remove_file(file);
  lib_update_stats();
  lib_set_modified();
}


void
on_join_channel1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  char* text;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  gtk_clist_get_text(clist, global.popup_row, 0, &text);
  join_channel(text);
}

void
on_normal1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_clear(GTK_CLIST(temp));
  
  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 2, FALSE);
  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 3, FALSE);
  send_command(CMD_CLIENT_LIST_CHANNELS, "");
}

void
on_hidden1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_clear(GTK_CLIST(temp));
  
  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 2, TRUE);
  //  gtk_clist_set_column_visibility (GTK_CLIST(temp), 3, TRUE);
  send_command(CMD_CLIENT_FULL_CHANNEL_LIST, "");
}


gboolean
on_channel_list_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_join_channel1_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_channel_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


void
on_checkbutton21_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "checkbutton21");
  global.options.parse_color = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  setup_preferences(P_PARSE_COLOR);
}


gboolean
on_window_key_press_event              (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  //  printf("key: [%d][%d]\n", event->keyval, event->state);
  if (event->type == GDK_KEY_PRESS) {
    if ((event->keyval >= 49) &&      // 1-9
	(event->keyval <= 57) &&
	(event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval-49));
    } else if ((event->keyval >= 49) &&      // 1-9
	       (event->keyval <= 57) &&
	       (event->state == 4)) {        // STRG
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_set_page(GTK_NOTEBOOK(temp), (event->keyval-49));
    } else if ((event->keyval == 97) &&      // a
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 113) &&     // q
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_prev_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 115) &&     // s
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook3");
      gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    } else if ((event->keyval == 119) &&     // w
	       (event->state == 8)) {        // ALT
      temp = lookup_widget(global.win, "notebook1");
      gtk_notebook_next_page(GTK_NOTEBOOK(temp));
    }
  }
  return 1;
}

void
on_about_destroy                       (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = GTK_WIDGET(object);
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_button145_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = lookup_widget(GTK_WIDGET(button), "about_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkText* text_field;
  GdkColor color1;
  GdkColor color2;
  GdkFont* font1;
  char text[1024];

  win = create_about_win();
  text_field = GTK_TEXT(lookup_widget(win, "text13"));
  gtk_text_set_word_wrap(text_field, 1);
  gtk_widget_set_style(GTK_WIDGET(text_field), global.style[2]);  

  gdk_color_parse("#FF0000", &color1);
  font1 = gdk_font_load("-adobe-helvetica-bold-r-normal-*-*-240-*-*-p-*-iso8859-1");
  sprintf(text, "Lopster %s\n", VERSION);
  gtk_text_insert(text_field, font1, &color1, NULL, text, strlen(text));
  font1 = gdk_font_load("-adobe-helvetica-medium-r-normal-*-*-140-*-*-p-*-iso8859-1");

  gdk_color_parse("#FFFFFF", &color1);
  gdk_color_parse("#0066ee", &color2);
  gtk_text_insert(text_field, font1, &color1, NULL, 
		  "\nCopyright (C) 2000 ", strlen("\nCopyright (C) 2000 "));
  gtk_text_insert(text_field, font1, &color2, NULL, 
		  "Markus Lausser\n", strlen("Markus Lausser\n"));
  gtk_text_insert(text_field, font1, &color1, NULL, 
		  _("Author "), strlen(_("Author ")));
  gtk_text_insert(text_field, font1, &color2, NULL, 
		  "Markus Lausser (Sgop)\n", strlen("Markus Lausser (Sgop)\n"));
  gtk_text_insert(text_field, font1, &color1, NULL, 
		  "E-mail ", strlen("E-mail "));
  gtk_text_insert(text_field, font1, &color2, NULL, 
		  "Sgop@users.sourceforge.net\n", strlen("Sgop@users.sourceforge.net\n"));
  gtk_text_insert(text_field, font1, &color1, NULL, 
		  _("Home "), strlen(_("Home ")));
  gtk_text_insert(text_field, font1, &color2, NULL, 
		  "lopster.sourceforge.net\n", strlen("lopster.sourceforge.net\n"));
  gtk_text_insert(text_field, font1, &color1, NULL, 
		  _("Project "), strlen(_("Project ")));
  gtk_text_insert(text_field, font1, &color2, NULL, 
		  "sourceforge.net/projects/lopster\n", strlen("sourceforge.net/projects/lopster\n"));
  strcpy(text, _("English Translation "));
  if (strncmp(text, "English", 7)) {
    gtk_text_insert(text_field, font1, &color1, NULL, 
		    text, strlen(text));
    gtk_text_insert(text_field, font1, &color2, NULL, 
		    _("<translators name>\n"), strlen(_("<translators name>\n")));
  }
  gtk_widget_show(win);
}


void
on_transfer_resize_column              (GtkCList        *clist,
                                        gint             column,
                                        gint             width,
                                        gpointer         user_data)
{
  int i1;
  socket_t* socket;

  i1 = 0;
  while (1) {
    if (i1 >= clist->rows) break;
    socket = (socket_t*)gtk_clist_get_row_data(clist, i1);
    transfer_update(socket, 0);
    i1++;
  }

}


void
on_button146_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  send_search_request(TRUE);
}


void
on_spinbutton25_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton* spin1;
  GtkSpinButton* spin2;
  int val;

  spin1 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton25"));
  val = gtk_spin_button_get_value_as_int(spin1);
  if (val < 0) {
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton24"));
    val = gtk_spin_button_get_value_as_int(spin2);
    if (val > 0) {
      gtk_spin_button_set_value(spin1, (gfloat)59);
      gtk_spin_button_set_value(spin2, (gfloat)(val-1));
    } else {
      gtk_spin_button_set_value(spin1, (gfloat)0);
    }
  } else if (val > 59) {
    gtk_spin_button_set_value(spin1, (gfloat)0);
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton24"));
    val = gtk_spin_button_get_value_as_int(spin2);
    gtk_spin_button_set_value(spin2, (gfloat)(val+1));
  }
}

void
on_spinbutton27_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton* spin1;
  GtkSpinButton* spin2;
  int val;

  spin1 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton27"));
  val = gtk_spin_button_get_value_as_int(spin1);
  if (val < 0) {
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton26"));
    val = gtk_spin_button_get_value_as_int(spin2);
    if (val > 0) {
      gtk_spin_button_set_value(spin1, (gfloat)59);
      gtk_spin_button_set_value(spin2, (gfloat)(val-1));
    } else {
      gtk_spin_button_set_value(spin1, (gfloat)0);
    }
  } else if (val > 59) {
    gtk_spin_button_set_value(spin1, (gfloat)0);
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton26"));
    val = gtk_spin_button_get_value_as_int(spin2);
    gtk_spin_button_set_value(spin2, (gfloat)(val+1));
  }
}



void
on_spinbutton29_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton* spin1;
  GtkSpinButton* spin2;
  int val;

  spin1 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton29"));
  val = gtk_spin_button_get_value_as_int(spin1);
  if (val < 0) {
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton28"));
    val = gtk_spin_button_get_value_as_int(spin2);
    if (val > 0) {
      gtk_spin_button_set_value(spin1, (gfloat)1023);
      gtk_spin_button_set_value(spin2, (gfloat)(val-1));
    } else {
      gtk_spin_button_set_value(spin1, (gfloat)0);
    }
  } else if (val > 1023) {
    gtk_spin_button_set_value(spin1, (gfloat)0);
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton28"));
    val = gtk_spin_button_get_value_as_int(spin2);
    gtk_spin_button_set_value(spin2, (gfloat)(val+1));
  }
}

void
on_spinbutton31_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton* spin1;
  GtkSpinButton* spin2;
  int val;

  spin1 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton31"));
  val = gtk_spin_button_get_value_as_int(spin1);
  if (val < 0) {
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton30"));
    val = gtk_spin_button_get_value_as_int(spin2);
    if (val > 0) {
      gtk_spin_button_set_value(spin1, (gfloat)1023);
      gtk_spin_button_set_value(spin2, (gfloat)(val-1));
    } else {
      gtk_spin_button_set_value(spin1, (gfloat)0);
    }
  } else if (val > 1023) {
    gtk_spin_button_set_value(spin1, (gfloat)0);
    spin2 = GTK_SPIN_BUTTON(lookup_widget(global.win, "spinbutton30"));
    val = gtk_spin_button_get_value_as_int(spin2);
    gtk_spin_button_set_value(spin2, (gfloat)(val+1));
  }
}



void
on_clear_selected_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;
  file_t* file;
  search_t* search;
  
  clist = GTK_CLIST(global.popup_list);
  search = (search_t*)
    gtk_object_get_data(GTK_OBJECT(clist), "search");
  while ((row_list = clist->selection) != NULL) {
    row = (int)row_list->data;
    file = (file_t*)gtk_clist_get_row_data(clist, row);
    gtk_clist_remove(clist, row);
    if (search) {
      search->results = g_list_remove(search->results, file);
      destroy_file_row(file);
    }
  }
  search_update_stats(search);
}


void
on_clear_users_files_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  file_t* file;
  char* user;
  int i1;
  search_t* search;

  search = (search_t*)
    gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  clist = GTK_CLIST(global.popup_list);
  file = (file_t*)gtk_clist_get_row_data(clist, global.popup_row);
  user = strdup(file->user);

  i1 = 0;
  while (i1 < clist->rows) {
    file = (file_t*)gtk_clist_get_row_data(clist, i1);
    if (!strcmp(user, file->user)) {
      gtk_clist_remove(clist, i1);
      if (search) {
	search->results = g_list_remove(search->results, file);
	destroy_file_row(file);
      }
    } else {
      i1++;
    }
  }
  search_update_stats(search);
}


void
on_clear_all_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  search_t* search;

  search = (search_t*)
    gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  search_remove(search);
}

void
on_search_again_activate                  (GtkMenuItem     *menuitem,
					   gpointer         user_data)
{
  search_t* search;
  search_pattern_t* pattern;

  search = (search_t*)
    gtk_object_get_data(GTK_OBJECT(global.popup_list), "search");

  if (!search) return;
  pattern = search->pattern;
  search_clear(search);
  search_update_stats(search);
  
  if (pattern->destination == DEST_LIBRARY) {
    lib_search(pattern);
  } else if (pattern->destination == DEST_HOTLIST) {
    hotlist_search(pattern);
  } else if (pattern->destination == DEST_NAPSTER) {
    napster_search(pattern, 0);
  } else {
    printf("unknown search destination");
  }
}

void
on_client_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.client_win);
  gtk_widget_destroy(global.client_win);
  global.client_win = NULL;
}


void
on_button149_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GList* dlist;
  client_t* client;
  
  dlist = g_list_first(global.client_list);
  while (dlist) {
    client = (client_t*)(dlist->data);
    free(client->info);
    free(client);
    dlist = dlist->next;
  }
  g_list_free(global.client_list);
  global.client_list = NULL;

  temp = lookup_widget(global.client_win, "clist8");
  gtk_clist_freeze (GTK_CLIST(temp));
  gtk_clist_clear(GTK_CLIST(temp));
  gtk_clist_thaw(GTK_CLIST(temp));
  send_command(CMD_CLIENT_VERSION_STATS, "");
}


void
on_button150_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (global.client_win)
    gtk_widget_hide(global.client_win);
}


void
on_customize_list_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GtkWidget* win;

  clist = GTK_CLIST(global.popup_list);
  win = create_customize_win(clist);
  gtk_widget_show(win);
}


void
on_customize_win_destroy               (GtkObject       *object,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = GTK_WIDGET(object);
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_button1x_clicked                   (GtkButton       *button,
				       gpointer         user_data)
{
  int i1;
  GtkCList* clist;
  GtkWidget* win;
  GtkToggleButton* tbutton;
  char text[1024];

  win = lookup_widget(GTK_WIDGET(button), "customize_win");
  clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(win), "ref_clist"));

  for (i1 = 0; i1 < clist->columns; i1++) {
    sprintf(text, "check%d", i1);
    tbutton = GTK_TOGGLE_BUTTON(lookup_widget(win, text));
    if (gtk_toggle_button_get_active(tbutton))
      gtk_clist_set_column_visibility(clist, i1, TRUE);
    else
      gtk_clist_set_column_visibility(clist, i1, FALSE);
  }
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}


void
on_button2x_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = lookup_widget(GTK_WIDGET(button), "customize_win");
  gtk_widget_hide(win);
  gtk_widget_destroy(win);
}

void
on_banned_users_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_bans(NULL);
}


void
on_linked_servers_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  lopster_links("");
}


void
on_client_statistic_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_clients();
}


void
on_whois_user1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = create_add_user_win();
  gtk_window_set_title (GTK_WINDOW (win), _("Whois User"));
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void*)2);
  gtk_widget_show(win);
}


void
on_server1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "notebook1");
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), 0);
  temp = lookup_widget(global.win, "notebook3");
  gtk_notebook_set_page(GTK_NOTEBOOK(temp), 1);
  temp = lookup_widget(global.win, "server_ctree");
  
  if (GTK_CLIST(temp)->rows == 0) {
    napigator_get_list();
  }
}

void
on_refresh_activate                    (GtkMenuItem     *menuitem,
					 gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "server_ctree");
  gtk_clist_clear(GTK_CLIST(temp));
  
  napigator_get_list();
}

void
on_add_servers_activate                    (GtkMenuItem     *menuitem,
					    gpointer         user_data)
{
  GtkCTree* ctree;
  GList* row_list;
  GtkWidget* temp1;
  GtkCTreeNode* node;
  server_t* server;
  char t[1024];

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    server = create_server_from_napigator(ctree, node);
    if (!server) continue;
    if (!add_server_to_list(server)) {
      // already in list, do not insert
      sprintf(t, _("Server [%s] [%s] already in list\n"),
	      server->address, server->description);
      temp1 = lookup_widget(global.win, "text14");
      gtk_text_insert(GTK_TEXT(temp1), NULL, NULL, NULL, 
		      t, strlen(t));
      server_destroy(server);
    }
    row_list = row_list->next;
  }
}

void
on_button158_clicked                    (GtkButton       *button,
					 gpointer         user_data)
{
  add_server(0);
}

void
on_connect2_activate(GtkMenuItem     *menuitem,
		     gpointer         user_data)
{
  GtkWidget* temp;
  GtkCList* clist;
  server_t* server;
  char t[1024];
  
  on_connect_activate(NULL, NULL);
  
  clist = GTK_CLIST(global.popup_list);
  server = (server_t*)gtk_clist_get_row_data(clist, global.popup_row);
  
  temp = lookup_widget(global.connect_win, "combo_entry12");
  sprintf(t, "%s %d", server->description, server->port);
  gtk_entry_set_text(GTK_ENTRY(temp), t);

  on_connection_ok_clicked(NULL, NULL);
}

void
on_delete_selected_activate(GtkMenuItem     *menuitem,
			    gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;
  server_t* server;

  clist = GTK_CLIST(lookup_widget(global.win, "clist11"));

  while ((row_list = clist->selection) != NULL) {
    row = (int)row_list->data;
    server = (server_t*)gtk_clist_get_row_data(clist, row);
    gtk_clist_remove(clist, row);
    global.servers = g_list_remove(global.servers, server);
    // delete server, missing
  }
}

gboolean
on_clist11_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_connect2_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    if (row != -1)
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_server_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}



void
on_button159_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  add_server(1);
}


void
on_combo_entry12_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  server_t* server;

  temp = lookup_widget(global.connect_win, "combo_entry12");
  text = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  
  server = search_server(text);
  free(text);

  if (!server || !server->nick || !server->passwd || 
      strlen(server->nick) < 1 || strlen(server->passwd) < 1) {
    temp = lookup_widget(global.connect_win, "connection_name");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.username);
    temp = lookup_widget(global.connect_win, "connection_pass");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.password);
  } else {
    temp = lookup_widget(global.connect_win, "connection_name");
    gtk_entry_set_text(GTK_ENTRY(temp), server->nick);
    temp = lookup_widget(global.connect_win, "connection_pass");
    gtk_entry_set_text(GTK_ENTRY(temp), server->passwd);
  }
}


void
on_button162_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(GTK_WIDGET(button), "information_win");
  gtk_widget_destroy(temp);
}


gboolean
on_resume_tree_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    
    global.popup_row = row;
    global.popup_list = widget;

    if (row != -1) {
      gtk_clist_select_row (GTK_CLIST(widget), row, 0);
      pop = create_resume_popup();
      gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		     event->button, event->time);
    }
  }

  return TRUE;
}

void
on_resume_search_activate(GtkMenuItem     *menuitem,
			  gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;
  resume_t* resume;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  resume = (resume_t*)gtk_ctree_node_get_row_data(ctree, node);

  resume_search(resume);
}

void
on_resume_play_activate(GtkMenuItem     *menuitem,
			  gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;
  resume_t* resume;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  resume = (resume_t*)gtk_ctree_node_get_row_data(ctree, node);
  
  play_file(resume->filename);
}

void
on_resume_delete_activate(GtkMenuItem     *menuitem,
			  gpointer         user_data)
{
  GtkCTree* ctree;
  GList* row_list;
  GtkCTreeNode* node;
  resume_t* resume;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = (resume_t*)gtk_ctree_node_get_row_data(ctree, node);
      resume_list_remove(resume, TRUE);
    }
  }
}

void
on_refresh_list_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (!in_channel()) {
    g_warning("ops: not in channel!");
    return;
  }
  send_command(830, global.current_page->name);
}


gboolean
on_clist12_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    if (row == -1) return FALSE;
    
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_user_popup(M_GLOBAL);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  
  return FALSE;
}

void
on_global_users_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (global.user_win)
    gtk_widget_show(global.user_win);
  show_global_users(NULL, FALSE);
}


void
on_user_win_destroy                    (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_widget_destroy(global.user_win);
  global.user_win = NULL;
}


void
on_button164_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char args[1024] = "";
  GtkWidget* temp;
  char* text;
  int first = 1;

  temp = lookup_widget(global.user_win, "entry74");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) > 0) {
    sprintf(args, "%s", text);
    
    temp = lookup_widget(global.user_win, "checkbutton23");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      if (first) {strcat(args, " "); first = 0;}
      strcat(args, "e");
    }
    temp = lookup_widget(global.user_win, "checkbutton24");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      if (first) {strcat(args, " "); first = 0;}
      strcat(args, "a");
    }
    temp = lookup_widget(global.user_win, "checkbutton25");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      if (first) {strcat(args, " "); first = 0;}
      strcat(args, "m");
    }
    temp = lookup_widget(global.user_win, "checkbutton26");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      if (first) {strcat(args, " "); first = 0;}
      strcat(args, "l");
    }
    temp = lookup_widget(global.user_win, "checkbutton27");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      if (first) {strcat(args, " "); first = 0;}
      strcat(args, "z");
    }
    temp = lookup_widget(global.user_win, "checkbutton28");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      if (first) {strcat(args, " "); first = 0;}
      strcat(args, "c");
    }
  }
  show_global_users(args, TRUE);
}


void
on_button165_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(global.user_win);
}


void
on_entry74_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  int val;

  temp = lookup_widget(global.user_win, "entry74");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) > 0) val = TRUE;
  else val = FALSE;
  
  temp = lookup_widget(global.user_win, "checkbutton23");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton24");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton25");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton26");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton27");
  gtk_widget_set_sensitive(temp, val);
  temp = lookup_widget(global.user_win, "checkbutton28");
  gtk_widget_set_sensitive(temp, val);
}

void
on_transfer_down_select_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  transfer_t* transfer;
  GtkWidget* temp;
  socket_t* socket;

  socket = (socket_t*)gtk_clist_get_row_data(clist, row);
  transfer = (transfer_t*)(socket->data);
  if (transfer->user_info) {
    temp = lookup_widget(global.win, "label422");
    gtk_label_set_text(GTK_LABEL(temp), transfer->user);
    temp = lookup_widget(global.win, "spinbutton15");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat)(transfer->user_info->max));
  }
}


void
on_spinbutton15_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* user;
  int val;

  temp = lookup_widget(global.win, "label422");
  user = GTK_LABEL(temp)->label;
  temp = lookup_widget(global.win, "spinbutton15");
  val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  change_user_info(user, val);
}

void
on_online_save_clicked (GtkButton       *button,
			gpointer         user_data) {
  GtkCList* clist;
  GtkPaned* paned;
  int i1;
  char str[1024];

  sprintf(str, "%s_online", global.current_page->name);
  clist = GTK_CLIST(lookup_widget(global.win, str));
  for (i1 = 0; i1 < 3; i1++) {
    global.online_width[i1] = clist->column[i1].width;
    global.online_show[i1] = clist->column[i1].visible;
  }

  sprintf(str, "%s_channel", global.current_page->name);
  paned = GTK_PANED(lookup_widget(global.win, str));
  global.paned_pos = paned->child1_size;

  sprintf(str, "%s_channel2", global.current_page->name);
  paned = GTK_PANED(lookup_widget(global.win, str));
  global.paned_pos2 = paned->child1_size;
}

void
on_ctree2_tree_select_row              (GtkCTree        *ctree,
                                        GtkCTreeNode    *node,
                                        gint             column,
                                        gpointer         user_data)
{
  int row;
  GtkNotebook* notebook;

  if (!global.options_win) return;

  notebook = GTK_NOTEBOOK(lookup_widget(global.options_win, "notebook2"));
  row = (int)gtk_ctree_node_get_row_data(ctree, node)-1;
  if (gtk_notebook_get_current_page(notebook) != row) {
    gtk_notebook_set_page(notebook, row);
  }
}


void
on_notebook2_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;

  return;
  if (!global.options_win) return;

  page_num++;
  ctree = GTK_CTREE(lookup_widget(global.options_win, "ctree2"));
  node = gtk_ctree_find_by_row_data(ctree, NULL, (void*)(page_num));
  gtk_ctree_select(ctree, node);
}


void 
on_dir_select167(gchar* dir) {
  GtkWidget* temp;
  GtkWidget* entry;
  char* text;

  if (!global.options_win) return;
  temp = lookup_widget(global.options_win, "clist19");
  entry = lookup_widget(global.options_win, "entry81");
  text = gtk_entry_get_text(GTK_ENTRY(entry));

  if (dir && (strlen(dir) > 0)) {
    if (dir[strlen(dir)-1] == '/') dir[strlen(dir)-1] = 0;
    strcpy(tstr[0], text);
    strcpy(tstr[1], dir);
    gtk_clist_append(GTK_CLIST(temp), list);
  }
}


void
on_button167_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  
  win = create_dir_browser(_("Select Directory"), NULL, 
			   GTK_SELECTION_EXTENDED, on_dir_select167);
  gtk_widget_show(win);
}


void
on_button169_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist19"));
  while ((row_list = clist->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_remove(clist, row);
  }
}

void 
on_dir_select166(gchar* dir) {
  GtkWidget* temp;

  if (!global.options_win) return;
  temp = lookup_widget(global.options_win, "entry75");
  if (dir) {
    if (dir[strlen(dir)-1] == '/') dir[strlen(dir)-1] = 0;
    gtk_entry_set_text(GTK_ENTRY(temp), dir);
  }
}

void
on_button166_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = create_dir_browser(_("Select Directory"), NULL, 
			   GTK_SELECTION_SINGLE, on_dir_select166);
  gtk_widget_show(win);
}


void
on_button140_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  struct stat st;
  
  sprintf(command, "%s/.netscape/lock", getenv("HOME"));
  if (lstat(command, &st) < 0) {
    sprintf(command, "netscape \"http://lopster.sourceforge.net\"");
  } else {
    sprintf(command, "netscape -remote 'openURL(http://lopster.sourceforge.net, new-window)'");
  }
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}


void
on_button139_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  struct stat st;

  sprintf(command, "%s/.netscape/lock", getenv("HOME"));
  if (lstat(command, &st) < 0) {
    sprintf(command, "netscape \"http://sourceforge.net/project/showfiles.php?group_id=8472&release_id=14589, new-window\"");
  } else {
    sprintf(command, "netscape -remote 'openURL(http://sourceforge.net/project/showfiles.php?group_id=8472&release_id=14589, new-window)'");
  }
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}


void
on_button143_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  struct stat st;

  sprintf(command, "%s/.netscape/lock", getenv("HOME"));
  if (lstat(command, &st) < 0) {
    sprintf(command, "netscape \"http://sourceforge.net/mail/?group_id=8472, new-window\"");
  } else {
    sprintf(command, "netscape -remote 'openURL(http://sourceforge.net/mail/?group_id=8472, new-window)'");
  }
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}


void
on_button141_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  struct stat st;

  sprintf(command, "%s/.netscape/lock", getenv("HOME"));
  if (lstat(command, &st) < 0) {
    sprintf(command, "netscape \"http://sourceforge.net/projects/lopster, new-window\"");
  } else {
    sprintf(command, "netscape -remote 'openURL(http://sourceforge.net/projects/lopster, new-window)'");
  }
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}


void
on_button142_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  struct stat st;

  sprintf(command, "%s/.netscape/lock", getenv("HOME"));
  if (lstat(command, &st) < 0) {
    sprintf(command, "netscape \"http://sourceforge.net/forum/?group_id=8472, new-window\"");
  } else {
    sprintf(command, "netscape -remote 'openURL(http://sourceforge.net/forum/?group_id=8472, new-window)'");
  }
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}


void
on_button144_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  char command[1024];
  int i;
  gchar *argv[4];
  gint pid;
  struct stat st;

  sprintf(command, "%s/.netscape/lock", getenv("HOME"));
  if (lstat(command, &st) < 0) {
    sprintf(command, "netscape \"http://sourceforge.net/bugs/?group_id=8472, new-window\"");
  } else {
    sprintf(command, "netscape -remote 'openURL(http://sourceforge.net/bugs/?group_id=8472, new-window)'");
  }
  pid = fork();
  if(pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++) close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
}


void
on_delete_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
}


void delete_file(file_t* file) {

  file->flags |= FLAG_TO_DELETE;

  lib_remove_file(file);
  lib_update_stats();
  lib_set_modified();
}


void delete_subtree() {
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  lib_set_flag(FLAG_TO_DELETE, node);

  if (global.status.building < 2)
    gtk_idle_add(lib_remove_idle, NULL);
  lib_set_modified();
}

void
on_button170_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  file_t* file;

  if (global.popup_row == -1) return;
  clist = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(clist, global.popup_row);
  if (user_data == (gpointer)1) delete_file(file);
  else delete_subtree();

  on_button171_clicked(button, user_data);
}


void
on_button171_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(GTK_WIDGET(button), "delete_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_notebook1_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  if (page_num == 1) {
    temp = lookup_widget(global.win, "chat_entry");
    gtk_widget_grab_focus(temp);
  }
}


void
on_log_win_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
}


void
on_button172_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "clist15"));
  row_list = clist->selection;
  if (row_list) {
    row = (int)row_list->data;
    log_delete(GTK_WIDGET(button), row);
  }
}


void
on_button173_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(GTK_WIDGET(button), "log_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}


void
on_logfiles_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  log_show_init();
}


void
on_clist14_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  log_show_section(clist, row);
}


void
on_clist15_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  log_show_file(clist, row);
}


void
on_checkbutton30_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.client_win, "spinbutton19");
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

void
on_button175_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  search_pattern_delete();
}


void
on_button174_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  search_pattern_save_current();
}


void
on_combo_entry18_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  search_pattern_t* search;
  char* name;

  name = gtk_entry_get_text(GTK_ENTRY(editable));
  search = search_pattern_find(name);
  search_pattern_show(search);
}


void
on_combo_entry19_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  setup_sensitive(1);
}


void
on_checkbutton4_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.options_win, "spinbutton2");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);
}


void
on_checkbutton35_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  global.network.auto_resume = 
    gtk_toggle_button_get_active(togglebutton);

  setup_preferences(P_AUTORESUME);
}


void
on_checkbutton33_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.options_win, "spinbutton32");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

gboolean
on_ctree3_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  char *text;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  gtk_clist_get_pixtext (GTK_CLIST(widget), row, 0,
			 &text, &space,
			 &pixmap, &bitmap);
  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_download2_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row (GTK_CLIST(widget), global.popup_row, 0);
    pop = create_browse_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


void
on_clist16_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  user_t* userinfo;

  userinfo = gtk_clist_get_row_data(clist, row);
  browse_show(userinfo);
}


gboolean
on_clist16_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;
  
  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  global.popup_row = row;
  global.popup_list = widget;

  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_refresh_users_files_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row (GTK_CLIST(widget), global.popup_row, 0);
    pop = create_hotlist_popup();
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}


void
on_checkbutton36_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.win, "spinbutton33");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}


void
on_button176_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  on_entry79_activate(NULL, NULL);
}


void
on_entry79_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;
  int max = 0;

  temp = lookup_widget(global.win, "entry79");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  temp = lookup_widget(global.win, "checkbutton36");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(global.win, "spinbutton33");
    max = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  }

  if (strlen(text) > 0) browse_user_files(text, max);
}


void
on_entry79_changed                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkCList* clist;
  char* text;
  user_t* userinfo;
  int row;

  temp = lookup_widget(global.win, "entry79");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if ((userinfo = browse_list_search(text)) != NULL)
    browse_show(userinfo);
  else if ((row = is_user_in_hotlist(text)) >= 0) {
    clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
    userinfo = gtk_clist_get_row_data(clist, row);
    browse_show(userinfo);
  }
}


gboolean
on_entry79_focus_in_event              (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  return FALSE;
}


void
on_button177_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  
  win = create_add_user_win();
  gtk_window_set_title (GTK_WINDOW (win), _("Rename Pattern"));
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void*)3);
  gtk_widget_show(win);
}

void
on_browse_files_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);

  browse_user_files(user, 0);
}


void 
on_dir_select182(gchar* dir) {
  GtkCList* clist;
  GtkWidget* entry;
  char* mime;
  char* text;
  int i1;

  if (!global.options_win) return;
  clist = GTK_CLIST(lookup_widget(global.options_win, "clist18"));
  entry = lookup_widget(global.options_win, "combo_entry21");
  mime = gtk_entry_get_text(GTK_ENTRY(entry));
  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_text(clist, i1, 0, &text);
    if (!strcasecmp(text, mime)) break;
  }
  if (i1 == clist->rows) return;
  if (dir && (strlen(dir) > 0)) {
    if (dir[strlen(dir)-1] == '/') dir[strlen(dir)-1] = 0;
    gtk_clist_set_text(clist, i1, 1, dir);
  }
}

void
on_button182_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;

  win = create_dir_browser(_("Select Download Folder"), NULL, 
			   GTK_SELECTION_EXTENDED, on_dir_select182);
  gtk_widget_show(win);
}


void
on_button180_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GtkWidget* entry;
  char* suff;
  char* text;
  int i1;

  if (!global.options_win) return;
  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));
  entry = lookup_widget(global.options_win, "entry80");
  suff = gtk_entry_get_text(GTK_ENTRY(entry));
  if (strlen(suff) == 0) return;
  for (i1 = 0; i1 < clist->rows; i1++) {
    gtk_clist_get_text(clist, i1, 0, &text);
    if (!strcasecmp(text, suff)) break;
  }
  if (i1 == clist->rows) {
    strcpy(tstr[0], suff);
    entry = lookup_widget(global.options_win, "combo_entry20");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    strcpy(tstr[1], text);
    entry = lookup_widget(global.options_win, "entry82");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    strcpy(tstr[2], text);
    gtk_clist_append(clist, list);
  } else {
    entry = lookup_widget(global.options_win, "combo_entry20");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    gtk_clist_set_text(clist, i1, 1, text);
    entry = lookup_widget(global.options_win, "entry82");
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    gtk_clist_set_text(clist, i1, 2, text);
  }
}



void
on_clist17_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GtkWidget* entry;
  char* text;

  if (!global.options_win) return;
  gtk_clist_get_text(clist, row, 1, &text);
  entry = lookup_widget(global.options_win, "combo_entry20");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
  
  gtk_clist_get_text(clist, row, 0, &text);
  entry = lookup_widget(global.options_win, "entry80");
  gtk_entry_set_text(GTK_ENTRY(entry), text);

  gtk_clist_get_text(clist, row, 2, &text);
  entry = lookup_widget(global.options_win, "entry82");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
}

void
on_button183_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  GList* row_list;
  int row;

  clist = GTK_CLIST(lookup_widget(global.options_win, "clist17"));
  while ((row_list = clist->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_remove(clist, row);
  }
}


void
on_combo_entry17_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  setup_sensitive(2);
}

void
on_changes_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  changes_dialog(_("Changes since Lopster 0.9.7"));
}


void
on_clist18_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  GtkWidget* entry;
  char* text;

  if (!global.options_win) return;
  gtk_clist_get_text(clist, row, 0, &text);
  entry = lookup_widget(global.options_win, "combo_entry21");
  gtk_entry_set_text(GTK_ENTRY(entry), text);
}


gboolean
on_ctree4_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				    (int)event->x, (int)event->y,
				    &row, &column))
    row = -1;
  
  global.popup_row = row;
  global.popup_list = widget;
  
  if ((event->type == GDK_2BUTTON_PRESS) && (row >= 0)) {
    on_connect3_activate(NULL, NULL);
    return FALSE;
  }
  if (event->button == global.options.popup_create) {
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_napigator_popup(row);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }

  return FALSE;
}

void popup_position(GtkMenu *menu, gint *x,
		    gint *y, gpointer user_data) {
  GtkRequisition requisition;
  GtkWidget* widget;
  
  if (!user_data) return;
  
  widget = GTK_WIDGET(user_data);

  gdk_window_get_origin (GTK_WIDGET(widget)->window, x, y);
  *x -= 2;
  *y -= 2;

  gtk_widget_size_request (GTK_WIDGET(menu), &requisition);
  *y -= requisition.height;
}


void
on_button185_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  GtkWidget* temp;

  temp = lookup_widget(global.win, "frame119");

  pop = create_mode_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position,
		 button, 1, 0);
}


void toggle_mode(char* mode) {
  char* data;
  
  if ((data=is_string_in_list(global.usermode, mode)) != NULL) {
    global.usermode = g_list_remove(global.usermode, data);
    free(data);
  } else {
    global.usermode = g_list_append(global.usermode, strdup(mode));
  }
  send_command(CMD_CLIENT_USER_MODE, "NONE");
  data = make_string_from_list(global.usermode, " ");
  send_command(CMD_CLIENT_USER_MODE, data);
  client_message(NULL, _("User mode was set to [%s]"), data);
}


void
on_mode_activate                 (GtkMenuItem     *menuitem,
				  gpointer         user_data)
{
  int mode = (int)user_data;
  if (mode < 0) return;
  if (mode >= NO_MODES) return;

  toggle_mode(Mode[mode]);
}

void
on_button186_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList* clist;
  char* channel;
  GList* row_list;
  char* user;
  char* command;
  int row;

  if (!global.ban_win) return;
  clist = GTK_CLIST(lookup_widget(global.ban_win, "clist3"));
  channel = gtk_object_get_user_data(GTK_OBJECT(global.ban_win));
  
  while ((row_list = clist->selection) != NULL) {
    row = (int)row_list->data;
    gtk_clist_get_text(clist, row, 0, &user);
    
    if (channel) {
      command = g_strdup_printf("%s %s", channel, user);
      send_command(CMD_CLIENT_CHANNEL_UNBAN, command);
      g_free(command);
    } else {
      send_command(CMD_CLIENT_UNBAN, user);
    }
    gtk_clist_remove(clist, row);
  }
}


void
on_button187_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  GtkWidget* temp;

  temp = lookup_widget(global.win, "frame123");

  pop = create_server2_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position,
		 button , 1, 0);
}


void
on_button188_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  GtkWidget* temp;

  temp = lookup_widget(global.win, "frame110");

  pop = create_browse_user_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position,
		 button , 1, 0);
}

void
on_checkbutton39_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    log_show_type(GTK_WIDGET(togglebutton), LOG_CHANNEL);
  } else {
    log_hide_type(GTK_WIDGET(togglebutton), LOG_CHANNEL);
  }
}


void
on_checkbutton40_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    log_show_type(GTK_WIDGET(togglebutton), LOG_PRIVATE);
  } else {
    log_hide_type(GTK_WIDGET(togglebutton), LOG_PRIVATE);
  }
}


void
on_checkbutton41_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if (gtk_toggle_button_get_active(togglebutton)) {
    log_show_type(GTK_WIDGET(togglebutton), LOG_OTHER);
  } else {
    log_hide_type(GTK_WIDGET(togglebutton), LOG_OTHER);
  }
}


void
on_checkbutton16_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(global.options_win, "spinbutton34");
  if (gtk_toggle_button_get_active(togglebutton))
    gtk_widget_set_sensitive(temp, TRUE);
  else
    gtk_widget_set_sensitive(temp, FALSE);
}

void
on_kill_activate               (GtkMenuItem     *menuitem,
				gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  send_command(CMD_CLIENT_KILL, user);
}

void
on_ban_activate               (GtkMenuItem     *menuitem,
			       gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  send_command(CMD_CLIENT_BAN, user);
}

void
on_locate_activate               (GtkMenuItem     *menuitem,
				  gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  send_command(CMD_CLIENT_WHICH_SERVER, user);
}

void
on_nuke_activate               (GtkMenuItem     *menuitem,
				gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  send_command(CMD_CLIENT_NUKE, user);
}

void
on_muzzle_activate               (GtkMenuItem     *menuitem,
				  gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  
  user = get_popup_user(mode);
  send_command(CMD_CLIENT_MUZZLE, user);
}

void
on_chmuzzle_activate               (GtkMenuItem     *menuitem,
				    gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  char* command;

  user = get_popup_user(mode);
  command = g_strdup_printf("%s %s", global.current_page->name, user);
  send_command(CMD_CLIENT_CHANNEL_MUZZLE, command);
  g_free(command);
}

void
on_chban_activate               (GtkMenuItem     *menuitem,
				 gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  char* command;

  user = get_popup_user(mode);
  command = g_strdup_printf("%s %s", global.current_page->name, user);
  send_command(CMD_CLIENT_CHANNEL_BAN, command);
  g_free(command);
}

void
on_kick_activate               (GtkMenuItem     *menuitem,
				gpointer         user_data)
{
  char *user;
  int mode = (int)user_data;
  char* command;

  user = get_popup_user(mode);
  command = g_strdup_printf("%s %s", global.current_page->name, user);
  send_command(CMD_CLIENT_KICK, command);
  g_free(command);
}


void popup_position2(GtkMenu *menu, gint *x,
		    gint *y, gpointer user_data) {
  GtkWidget* widget;
  
  if (!user_data) return;
  
  widget = GTK_WIDGET(user_data);

  gdk_window_get_origin (GTK_WIDGET(widget)->window, x, y);

  *y += widget->allocation.height;
}

void
on_button189_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  global.popup_list = lookup_widget(global.whois_win, "label527");

  pop = create_user_popup(M_WHOIS);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position2,
		 button , 1, 0);
}


void
on_safe_exit_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  global.status.exiting = E_SAFE;
  if (global.limit.cur_uploads + global.limit.cur_downloads > 0) {
    lib_del_flag(FLAG_SHARED, NULL);
    send_command(CMD_CLIENT_UNSHARE_ALL, "");
    client_message(_("Safe exit"), _("Waiting for transfers to be finished"));
    client_message(_("Safe exit"), _("%d downloads, %d uploads"),
		   global.limit.cur_downloads,
		   global.limit.cur_uploads);
  }
}


gboolean
on_window_focus_in_event               (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  chat_page_t* page;
  
  page = (chat_page_t*)gtk_object_get_data(GTK_OBJECT(widget), 
					   "channel");
  global.current_page = page;
  return FALSE;
}


gboolean
on_window_focus_out_event              (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  chat_page_t* page;
  
  page = chat_page_get_current_main();
  if (!page) return FALSE;
  global.current_page = page;
  return FALSE;
}

void
on_chat_destroy (GtkWidget       *window,
		 gpointer         user_data) {
  chat_page_t* page;

  page = gtk_object_get_data(GTK_OBJECT(user_data), "channel");
  
  if (page) chat_page_attach_to_main(page);
}

void on_chat_leave_clicked(GtkButton       *button,
			   gpointer         user_data) {
  chat_page_t* page = (chat_page_t*)user_data;
  
  chat_page_leave(page);
}

void on_chat_attach_clicked(GtkButton       *button,
			    gpointer         user_data) {
  chat_page_t* page = (chat_page_t*)user_data;

  gtk_widget_destroy(page->window);
}

void
on_button191_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  chat_page_t* page;

  page = chat_page_get_current_main();
  if (!page) return;
  chat_page_attach_to_new(page);
}

GtkWidget* create_tab_label(int no) {
  GtkWidget* label;
  GtkWidget* hbox;
  GtkWidget* pixmap;
  GtkWidget* temp;

  hbox = gtk_hbox_new (FALSE, 0);
  switch (no) {
  case 0:
    pixmap = create_pixmap (global.win, "transfer.xpm");
    label = gtk_label_new (_("Server"));
    temp = lookup_widget(global.win, "detach_server");
    break;
  case 1:
    pixmap = create_pixmap (global.win, "chat.xpm");
    label = gtk_label_new(_("Chat"));
    temp = lookup_widget(global.win, "detach_chat");
    break;
  case 2:
    pixmap = create_pixmap (global.win, "folder.xpm");
    label = gtk_label_new(_("Library"));
    temp = lookup_widget(global.win, "detach_library");
    break;
  case 3:
    pixmap = create_pixmap (global.win, "kfind.xpm");
    label = gtk_label_new(_("Search"));
    temp = lookup_widget(global.win, "detach_search");
    break;
  case 4:
    pixmap = create_pixmap (global.win, "kfind.xpm");
    label = gtk_label_new(_("Hotlist"));
    temp = lookup_widget(global.win, "detach_hotlist");
    break;
  case 5:
    pixmap = create_pixmap (global.win, "transfer.xpm");
    label = gtk_label_new(_("Downloads"));
    temp = lookup_widget(global.win, "detach_downloads");
    break;
  case 6:
    pixmap = create_pixmap (global.win, "transfer.xpm");
    label = gtk_label_new(_("Uploads"));
    temp = lookup_widget(global.win, "detach_uploads");
    break;
  default:
    pixmap = create_pixmap (global.win, "transfer.xpm");
    label = gtk_label_new("?????");
    temp = NULL;
    break;
  }
  if (temp) gtk_widget_set_sensitive(temp, TRUE);

  gtk_widget_show (pixmap);
  gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, TRUE, 0);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 10);
  
  return hbox;
}

gboolean
on_extra_win_delete             (GtkWidget       *widget,
				 GdkEvent        *event,
				 gpointer         user_data) {
  GtkWidget* win;
  GtkWidget* temp;
  GtkWidget* tab_label;
  GtkNotebook* notebook;
  int no;
  int i1;
  int pos;

  win = widget;
  no = (int)user_data;

  // getting geometry
  if (win->window) {
    gdk_window_get_origin (win->window, 
			   &global.geometry[no].x, 
			   &global.geometry[no].y);
  }
  global.geometry[no].width = win->allocation.width;
  global.geometry[no].height = win->allocation.height;
  
  temp = GTK_BIN(win)->child;
  if (!temp) return FALSE;
  
  gtk_widget_ref(temp);
  gtk_container_remove(GTK_CONTAINER(win), temp);
  
  pos = 0;
  for (i1 = 0; i1 < no; i1++)
    if ((global.extra_win & (1<<i1)) == 0) pos++;
  global.extra_win &= (0xFF)^(1<<no);
  
  tab_label = create_tab_label(no);
  gtk_widget_show(tab_label);
  
  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook1"));
  gtk_notebook_insert_page(notebook, temp, tab_label, pos);
  gtk_widget_unref(temp);

  return FALSE;
}

gboolean
on_text_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  if (event->button == global.options.popup_create) {
    global.popup_row = GTK_TEXT(widget)->cursor_mark.index;
    if (!get_word(GTK_TEXT(widget), 0)) return FALSE;
    global.popup_list = widget;
    pop = create_user_popup(M_TEXT);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  return FALSE;
}


void
on_button203_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkLabel* label;

  label = GTK_LABEL(lookup_widget(GTK_WIDGET(button), "label529"));
  
  send_command(CMD_CLIENT_KILL_SERVER, label->label);
  on_button204_clicked(button, user_data);
}


void
on_button204_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  
  temp = lookup_widget(GTK_WIDGET(button), "shutdown_win");
  gtk_widget_hide(temp);
  gtk_widget_destroy(temp);
}

void
on_known_problems_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  problems_get();
}

void
on_spinbutton35_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  global.limit.default_downloads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_D_ULIMIT);
}


void
on_spinbutton36_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  global.limit.default_uploads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable));

  setup_preferences(P_U_ULIMIT);
}


gboolean
on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  draw_band_width(&global.down_width, 1);
  return TRUE;
}


gboolean
on_drawingarea2_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  draw_band_width(&global.up_width, 1);
  return TRUE;
}


void
on_button206_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (global.down_width.maxval >= (1<<30)) return;
  global.down_width.maxval *= 2;
  draw_band_width(&global.down_width, 1);
}


void
on_button207_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (global.down_width.maxval <= 1024) return;

  global.down_width.maxval /= 2;
  draw_band_width(&global.down_width, 1);
}


void
on_button208_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (global.up_width.maxval >= (1<<30)) return;
  global.up_width.maxval *= 2;
  draw_band_width(&global.up_width, 1);
}


void
on_button209_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (global.up_width.maxval <= 1024) return;

  global.up_width.maxval /= 2;
  draw_band_width(&global.up_width, 1);
}


gboolean
on_drawingarea1_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  int width = widget->allocation.width-16;
  int height = widget->allocation.height-19;
  int x = (int)event->x-8;
  int y = (int)event->y-17;

  if (x < 0) return FALSE;
  if (x > width) return FALSE;
  if (y < 0) return FALSE;
  if (y > height) return FALSE;
  global.down_width.limit = (int)((double)global.down_width.maxval/
				  (double)width*(double)x);
  draw_band_width(&global.down_width, 1);
  return FALSE;
}


gboolean
on_drawingarea2_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  int width = widget->allocation.width-16;
  int height = widget->allocation.height-19;
  int x = (int)event->x-8;
  int y = (int)event->y-17;

  if (x < 0) return FALSE;
  if (x > width) return FALSE;
  if (y < 0) return FALSE;
  if (y > height) return FALSE;
  global.up_width.limit = (int)((double)global.up_width.maxval/
				(double)width*(double)x);
  draw_band_width(&global.up_width, 1);

  return FALSE;
}

void
on_NULL_button3_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;

  temp = lookup_widget(global.win, "search_artist");
  //  temp->style->font = NULL;
  gtk_entry_set_text(GTK_ENTRY(temp), "");
  temp = lookup_widget(global.win, "entry69");
  //  temp->style->font = NULL;
  gtk_entry_set_text(GTK_ENTRY(temp), "");

  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  gtk_widget_destroy(temp);
}

void
on_ok_button4_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  GtkWidget* fontsel;
  char* font;
  GdkFont* gdkfont;
  
  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  fontsel = GTK_FONT_SELECTION_DIALOG(temp)->fontsel;

  if (gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel))) {
    font = strdup(gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel)));
    gdkfont = gdk_font_load(font);
    temp = lookup_widget(global.win, "search_artist");
    temp->style->font = gdkfont;
    gtk_entry_set_text(GTK_ENTRY(temp), "");
    temp = lookup_widget(global.win, "entry69");
    temp->style->font = gdkfont;
    gtk_entry_set_text(GTK_ENTRY(temp), "");
    free(font);
  }
  temp = lookup_widget(GTK_WIDGET(button), "fontselectiondialog1");
  gtk_widget_destroy(temp);
}


void
on_button210_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* fontsel;
  GtkWidget* temp;

  win = create_fontselectiondialog1();

  temp = lookup_widget(win, "NULL_button1");
  gtk_signal_connect (GTK_OBJECT (temp), "clicked",
                      GTK_SIGNAL_FUNC (on_NULL_button3_clicked),
                      NULL);
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Reset"));
  
  temp = lookup_widget(win, "cancel_button3");
  temp = GTK_BIN(temp)->child;
  gtk_label_set_text(GTK_LABEL(temp), _("Cancel"));

  temp = lookup_widget(win, "ok_button3");
  gtk_signal_connect (GTK_OBJECT (temp), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_button4_clicked),
                      NULL);

  // setting up font
  fontsel = GTK_FONT_SELECTION_DIALOG(win)->fontsel;
  //  gtk_font_selection_set_font_name(GTK_FONT_SELECTION(fontsel), style->n_font);

  gtk_widget_show(win);
}


void
on_button214_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  pop = create_dl_remove_popup(global.options.dl_autoremove);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position2,
		 button , 1, 0);
}


void
on_button215_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  pop = create_retry_popup(global.options.auto_retry);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position2,
		 button , 1, 0);
}


void
on_button216_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  pop = create_ul_remove_popup(global.options.ul_autoremove);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position2,
		 button , 1, 0);
}


gboolean
on_window_delete_event                 (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  global_exit();

  return FALSE;
}


void
on_show_sockets_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (global.socket_win) return;

  global.socket_win = create_socket_win();
  gtk_widget_show(global.socket_win);
}


gboolean
on_socket_win_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  global.socket_win = NULL;
  return FALSE;
}

void
on_notebook5_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  search_t* search;
  GtkObject* clist;
  GtkWidget* temp;

  clist = gtk_object_get_data(GTK_OBJECT(page->child), "clist");
  if (clist) {
    search = (search_t*)gtk_object_get_data(clist, "search");
    search_update_stats(search);
    temp = lookup_widget(global.win, "combo_entry18");
    gtk_entry_set_text(GTK_ENTRY(temp), search->pattern->name);
    search_pattern_show(search->pattern);
  }

  temp = lookup_widget(global.win, "button219");
  if (page_num == 0)
    gtk_widget_set_sensitive(temp, FALSE);
  else
    gtk_widget_set_sensitive(temp, TRUE);
}


void
on_button218_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  search_fields_detach();
}

gboolean
on_drawingarea1_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  int width = widget->allocation.width-16;
  int x = (int)event->x-8;
  
  if (x < 0) return FALSE;
  if (x > width) return FALSE;
  global.down_width.limit = (int)((double)global.down_width.maxval/
				  (double)width*(double)x);
  draw_band_width(&global.down_width, 1);
  return FALSE;
}


gboolean
on_drawingarea2_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  int width = widget->allocation.width-16;
  int x = (int)event->x-8;

  if (x < 0) return FALSE;
  if (x > width) return FALSE;
  global.up_width.limit = (int)((double)global.up_width.maxval/
				(double)width*(double)x);
  draw_band_width(&global.up_width, 1);

  return FALSE;
}


void
on_button219_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  int num;
  GtkWidget* temp;
  GtkCList* clist;

  temp = lookup_widget(global.win, "notebook5");
  num = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
  if (num <= 0) return;

  temp = gtk_notebook_get_nth_page(GTK_NOTEBOOK(temp), num);
  if (temp) {
    clist = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(temp), "clist"));
    if (clist) {
      global.search_width[0] = clist->column[0].width;
      global.search_show[0] = clist->column[0].visible;
      global.search_width[1] = clist->column[1].width;
      global.search_show[1] = clist->column[1].visible;
      global.search_width[2] = clist->column[2].width;
      global.search_show[2] = clist->column[2].visible;
      global.search_width[3] = clist->column[3].width;
      global.search_show[3] = clist->column[3].visible;
      global.search_width[4] = clist->column[4].width;
      global.search_show[4] = clist->column[4].visible;
      global.search_width[5] = clist->column[5].width;
      global.search_show[5] = clist->column[5].visible;
    }
  }
}


void
on_button217_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  if (global.socket_win) gtk_widget_destroy(global.socket_win);
}


void
on_socket_win_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
  global.socket_win = NULL;
}


void
on_clist20_select_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  socket_t* socket;

  socket = (socket_t*)gtk_clist_get_row_data(clist, row);
  socket_show_clist(socket);
}


void
on_window_destroy                      (GtkObject       *object,
                                        gpointer         user_data)
{

}


void
on_button220_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  pop = create_autodelete_popup(global.options.auto_delete);
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position2,
		 button , 1, 0);
}

void
on_detach_server_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(0);
}


void
on_detach_chat_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(1);
}


void
on_detach_library_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(2);
}


void
on_detach_search_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(3);
}


void
on_detach_hotlist_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(4);
}


void
on_detach_downloads_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(5);
}


void
on_detach_uploads_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  main_tab_detach(6);
}


void
on_button228_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;
  scheme_t* scheme;

  win = create_add_user_win();
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void*)4);
  gtk_window_set_title (GTK_WINDOW (win), _("Set Server Prefix"));

  scheme = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme) {
    temp = lookup_widget(win, "entry16");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->server_prefix);
  }

  gtk_widget_show(win);
}


void
on_button229_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* temp;
  scheme_t* scheme;

  win = create_add_user_win();
  gtk_object_set_data(GTK_OBJECT(win), "ref", (void*)5);
  gtk_window_set_title (GTK_WINDOW (win), _("Set Client Prefix"));

  scheme = 
    gtk_object_get_data(GTK_OBJECT(global.options_win), "scheme");
  if (scheme) {
    temp = lookup_widget(win, "entry16");
    gtk_entry_set_text(GTK_ENTRY(temp), scheme->client_prefix);
  }

  gtk_widget_show(win);
}


gboolean
on_ignore_list_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget* pop;
  int row, column;

  if (event->button == global.options.popup_create) {
    if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				      (int)event->x, (int)event->y,
				      &row, &column))
      row = -1;
    if (row == -1) return FALSE;
    
    global.popup_row = row;
    global.popup_list = widget;
    gtk_clist_select_row (GTK_CLIST(widget), row, 0);
    pop = create_user_popup(M_IGNORE);
    gtk_menu_popup(GTK_MENU(pop), NULL, NULL, NULL, NULL,
		   event->button, event->time);
  }
  
  return FALSE;
}


void
on_button232_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  lib_refresh();
}


void
on_checkbutton19_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  
}


void
on_button231_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* temp;
  char* text;

  temp = lookup_widget(global.win, "entry84");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strlen(text) <= 0) {
    temp = create_info_win(_("No filename specified!"));
    gtk_widget_show(temp);
    return;
  }
  lib_save(text);
}


void
on_button230_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* pop;

  pop = create_files_popup();
  gtk_menu_popup(GTK_MENU(pop), NULL, NULL,
		 (GtkMenuPositionFunc)popup_position,
		 button, 1, 0);
}


void
on_unshare_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList* clist;
  file_t* file;

  if (global.popup_row == -1) return;

  clist = GTK_CLIST(global.popup_list);
  
  file = (file_t*)gtk_clist_get_row_data(clist, global.popup_row);
  if (file->flags&FLAG_SHARED) {
    file->flags |= FLAG_TO_UNSHARE;
    lib_remove_file(file);
  } else {
    file->flags |= FLAG_TO_SHARE;
    lib_commit_file(file);
  }
  lib_update_stats();
}


void
on_unshare_subtree_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  lib_set_flag(FLAG_TO_UNSHARE, node);

  if (global.status.building < 2)
    gtk_idle_add(lib_remove_idle, NULL);
}


void
on_share_subtree_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCTree* ctree;
  GtkCTreeNode* node;

  if (global.popup_row == -1) return;

  ctree = GTK_CTREE(global.popup_list);
  
  node = gtk_ctree_node_nth(ctree, global.popup_row);
  lib_set_flag(FLAG_TO_SHARE, node);

  if (global.status.building < 2)
    gtk_idle_add(lib_remove_idle, NULL);
}

