#define S_INACTIVE      0
#define S_CONNECTING    1
#define S_INFO          2
#define S_DOWNLOADING   3
#define S_CANCELED      4
#define S_FINISHED      5
#define S_TIMEOUT       6
#define S_REJECT        7
#define S_INCOMPLETE    8
#define S_UPLOADING     9
#define S_INFO1        10
#define S_INFO2        11
#define S_INFO3        12
#define S_WAITING      13
#define S_FIREWALL     14
#define S_CONERROR     15
#define S_QUEUED       16
#define S_REMOTE       17
#define S_UNAVAILABLE  18
#define S_STOPPED      19
#define S_RESUME_ERR   20

#define T_UNKNOWN       0
#define T_DOWNLOAD      1
#define T_UPLOAD        2
#define T_RESUME        3

#define UPDATE_DELAY      1000
#define TRANSFER_HISTORY    60  // sec seconds average

typedef struct {
  char* longname;
  char* shortname;
  char* winname;
  char* localname;
  char* md5;
  char* user;
  int linespeed;

  long progress;
  double rate;
  int timeleft;
  time_t start_time;
  int status;
  long size;
  socket_t sock;
  FILE* file;
  int type;

  long history[TRANSFER_HISTORY];
  int hist_cnt;
  int hist_pos;

  char* resume_check;
  int check_length;
} transfer_t;

GtkWidget* create_download_popup_test (transfer_t* transfer);

transfer_t* transfer_new();
int transfer_is_active(transfer_t* transfer);

file_t* lib_search_transfer(transfer_t* transfer);

void download_start(transfer_t* transfer);
void download_file(file_t* file);
void cmd_download_ack(char* data);
void cmd_upload_request(char* data);
void cmd_alternate_ack(char* data);

transfer_t* transfer_is_in_download(char* user, char* winname);
transfer_t* transfer_is_in_upload(char* user, char* winname);
int transfer_update(transfer_t* transfer);

void transfer_insert_download(transfer_t *transfer);
void transfer_insert_upload(transfer_t *transfer);

int connect_to_user(transfer_t* transfer);
void cmd_get_error(char* data);
void cmd_remote_queued(char* data);
int download_inspector(gpointer data);
void cmd_linkspeed_response(char* data);

FILE* open_download_file(transfer_t* transfer);
FILE* open_upload_file(transfer_t* transfer);

void transfer_end(transfer_t* transfer, int mode);

gint outgoing_header(gpointer data, gint source,
		 GdkInputCondition condition);
gint incoming_header(gpointer data, gint source, 
		     GdkInputCondition condition);
gint upload_push_output(gpointer data, gint source, 
			GdkInputCondition condition);
gint download_get_input(gpointer data, gint source, 
			GdkInputCondition condition);

void destroy_transfer_row(gpointer data);
int transfer_timeout_cb(gpointer data);
int transfer_remote_timeout(gpointer data);
