#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include <gtk/gtk.h>

#include "support.h"
#include "commands.h"
#include "connection.h"
#include "global.h"
#include "chat.h"
#include "transfer.h"
#include "share.h"
#include "hotlist.h"
#include "search.h"
#include "log.h"
#include "scheme.h"
#include "handler.h"

char* getCommandName(int type) {
  static char ret[200];

  switch (type) {
  case   0: sprintf(ret, "error message [SERVER]");break;
  case   2: sprintf(ret, "client login message [CLIENT]");break;
  case   3: sprintf(ret, "login ack [SERVER]");break;
  case   4: sprintf(ret, "??? [CLIENT]");break;
  case   6: sprintf(ret, "alternate login format [CLIENT]");break;
  case   7: sprintf(ret, "client registration message [CLIENT]");break;
  case   8: sprintf(ret, "registration success [SERVER]");break;
  case   9: sprintf(ret, "nickname already registered [SERVER]");break;
  case  10: sprintf(ret, "invalid nickname [SERVER]");break;
  case  11: sprintf(ret, "??? [CLIENT]");break;
  case  14: sprintf(ret, "login options [CLIENT]");break;
  case 100: sprintf(ret, "client notification of shared file [CLIENT]");break;
  case 102: sprintf(ret, "remove file [CLIENT]");break;
  case 200: sprintf(ret, "client search request [CLIENT]");break;
  case 201: sprintf(ret, "search response [SERVER]");break;
  case 202: sprintf(ret, "end of search response from server [SERVER]");break;
  case 203: sprintf(ret, "download request [CLIENT]");break;
  case 204: sprintf(ret, "download ack [SERVER]");break;
  case 205: sprintf(ret, "private message to/from another user [CLIENT, SERVER]");break;
  case 206: sprintf(ret, "get error [SERVER]");break;
  case 207: sprintf(ret, "add hotlist entry [CLIENT]");break;
  case 208: sprintf(ret, "hotlist [CLIENT]");break;
  case 209: sprintf(ret, "user signon [SERVER]");break;
  case 210: sprintf(ret, "user signoff [SERVER]");break;
  case 211: sprintf(ret, "browse a user's files [CLIENT]");break;
  case 212: sprintf(ret, "browse response [SERVER]");break;
  case 213: sprintf(ret, "end of browse list [SERVER]");break;
  case 214: sprintf(ret, "server stats [CLIENT, SERVER]");break;
  case 215: sprintf(ret, "request resume [CLIENT]");break;
  case 216: sprintf(ret, "resume search response [SERVER]");break;
  case 217: sprintf(ret, "end of resume search list [SERVER]");break;
  case 218: sprintf(ret, "downloading file [CLIENT]");break;
  case 219: sprintf(ret, "download complete [CLIENT]");break;
  case 220: sprintf(ret, "uploading file [CLIENT]");break;
  case 221: sprintf(ret, "upload complete [CLIENT]");break;
  case 300: sprintf(ret, "optional ports [CLIENT]");break;
  case 301: sprintf(ret, "hotlist ack [SERVER]");break;
  case 302: sprintf(ret, "hotlist error [SERVER]");break;
  case 303: sprintf(ret, "remove user from hotlist [CLIENT]");break;
  case 320: sprintf(ret, "user ignore list [CLIENT, SERVER]");break;
  case 321: sprintf(ret, "user ignore list entry [SERVER]");break;
  case 322: sprintf(ret, "add user to ignore list [CLIENT, SERVER]");break;
  case 323: sprintf(ret, "remove user from ignore list [CLIENT]");break;
  case 324: sprintf(ret, "user is not ignored [SERVER]");break;
  case 325: sprintf(ret, "user is already ignored [SERVER]");break;
  case 326: sprintf(ret, "clear ignore list [CLIENT, SERVER]");break;
  case 400: sprintf(ret, "join channel [CLIENT]");break;
  case 401: sprintf(ret, "part channel [CLIENT]");break;
  case 402: sprintf(ret, "send public message [CLIENT]");break;
  case 403: sprintf(ret, "public message [SERVER]");break;
  case 404: sprintf(ret, "error message [SERVER]");break;
  case 405: sprintf(ret, "join acknowledge [SERVER]");break;
  case 406: sprintf(ret, "join message [SERVER]");break;
  case 407: sprintf(ret, "user parted channel [SERVER]");break;
  case 408: sprintf(ret, "channel user list entry [SERVER]");break;
  case 409: sprintf(ret, "end of channel user list [SERVER]");break;
  case 410: sprintf(ret, "channel topic [CLIENT, SERVER]");break;
  case 500: sprintf(ret, "alternate download request [CLIENT]");break;
  case 501: sprintf(ret, "alternate download ack [SERVER]");break;
  case 600: sprintf(ret, "request user's link speed [CLIENT]");break;
  case 601: sprintf(ret, "link speed response [SERVER]");break;
  case 603: sprintf(ret, "whois request [CLIENT]");break;
  case 604: sprintf(ret, "whois response [SERVER]");break;
  case 605: sprintf(ret, "whowas response [SERVER]");break;
  case 606: sprintf(ret, "change user level [CLIENT]");break;
  case 607: sprintf(ret, "upload request [CLIENT]");break;
  case 608: sprintf(ret, "accept upload request [CLIENT]");break;
  case 610: sprintf(ret, "kill (disconnect) a user [CLIENT]");break;
  case 611: sprintf(ret, "nuke a user [CLIENT]");break;
  case 612: sprintf(ret, "ban user [CLIENT]");break;
  case 613: sprintf(ret, "set data port for user [CLIENT, SERVER]");break;
  case 614: sprintf(ret, "unban user [CLIENT]");break;
  case 615: sprintf(ret, "show bans for server [CLIENT]");break;
  case 616: sprintf(ret, "ip ban notification [SERVER]");break;
  case 617: sprintf(ret, "list channels [CLIENT, SERVER]");break;
  case 618: sprintf(ret, "channel list entry [SERVER]");break;
  case 619: sprintf(ret, "queue limit [CLIENT]");break;
  case 620: sprintf(ret, "queue limit [SERVER]");break;
  case 621: sprintf(ret, "message of the day [CLIENT, SERVER]");break;
  case 622: sprintf(ret, "muzzle a user [CLIENT]");break;
  case 623: sprintf(ret, "unmuzzle a user [CLIENT]");break;
  case 624: sprintf(ret, "un-nuke a user [CLIENT]");break;
  case 625: sprintf(ret, "change a user's linespeed [CLIENT]");break;
  case 626: sprintf(ret, "data port error [CLIENT, SERVER]");break;
  case 627: sprintf(ret, "operator message [CLIENT, SERVER]");break;
  case 628: sprintf(ret, "global message [CLIENT, SERVER]");break;
  case 629: sprintf(ret, "banned users [SERVER]");break;
  case 700: sprintf(ret, "change link speed [CLIENT]");break;
  case 701: sprintf(ret, "change user password [CLIENT]");break;
  case 702: sprintf(ret, "change email address [CLIENT]");break;
  case 703: sprintf(ret, "change data port [CLIENT]");break;
  case 751: sprintf(ret, "ping user [CLIENT, SERVER]");break;
  case 752: sprintf(ret, "pong response [CLIENT, SERVER]");break;
  case 753: sprintf(ret, "???");break;
  case 800: sprintf(ret, "reload config [CLIENT]");break;
  case 801: sprintf(ret, "server version [CLIENT]");break;
  case 810: sprintf(ret, "set config [CLIENT]");break;
  case 820: sprintf(ret, "clear channel");break;
  case 821: sprintf(ret, "???");break;
  case 822: sprintf(ret, "???");break;
  case 823: sprintf(ret, "???");break;
  case 824: sprintf(ret, "emote [CLIENT, SERVER]");break;
  case 825: sprintf(ret, "user list entry [SERVER]");break;
  case 826: sprintf(ret, "???");break;
  case 827: sprintf(ret, "???");break;
  case 830: sprintf(ret, "list users in channel [CLIENT, SERVER]");break;
  default: sprintf(ret, "UNKNWON");break;
  }

  return ret;
}

static HANDLER_ENTRY Protocol[] = {
  {CMD_SERVER_ERROR,          cmd_server_error},           // 0
  {CMD_SERVER_EMAIL,          cmd_login_ack},              // 3
  {CMD_SERVER_REGISTER_OK,    cmd_do_nothing},             // 8
  {CMD_SERVER_REGISTER_FAIL,  cmd_register_fail},          // 9
  {CMD_SERVER_BAD_NICK,       cmd_bad_nick},               // 10
  {CMD_SERVER_SEARCH_RESULT,  cmd_search_response},        // 201
  {CMD_SERVER_SEARCH_END,     cmd_end_of_search},          // 202
  {CMD_SERVER_FILE_READY,     cmd_download_ack},           // 204
  {CMD_CLIENT_PRIVMSG,        cmd_private_message},        // 205
  {CMD_SERVER_SEND_ERROR,     cmd_get_error},              // 206
  {CMD_SERVER_USER_SIGNON,    cmd_user_sign_on},           // 209
  {CMD_SERVER_USER_SIGNOFF,   cmd_user_sign_off},          // 210
  {CMD_SERVER_BROWSE_RESPONSE,cmd_browse_response},        // 212
  {CMD_SERVER_BROWSE_END,     cmd_browse_end},             // 213
  {CMD_SERVER_STATS,          cmd_server_stats},           // 214
  {CMD_SERVER_RESUME_MATCH,   cmd_resume_match},           // 216
  {CMD_SERVER_RESUME_MATCH_END,cmd_do_nothing},            // 217
  {CMD_SERVER_HOTLIST_ACK,    cmd_hotlist_ack},            // 301
  {CMD_HOTLIST_ERROR,         cmd_hotlist_error},          // 302
  {CMD_SERVER_DISCONNECTING,  cmd_disconnecting},          // 316
  {CMD_CLIENT_IGNORE_LIST,    cmd_do_nothing},             // 320
  {CMD_SERVER_IGNORE_ENTRY,   cmd_ignore_entry},           // 321
  {CMD_CLIENT_IGNORE_USER,    cmd_ignore_user},            // 322
  {CMD_CLIENT_UNIGNORE_USER,  cmd_unignore_user},          // 323
  {CMD_SERVER_NOT_IGNORED,    cmd_do_nothing},             // 324
  {CMD_SERVER_ALREADY_IGNORED,cmd_do_nothing},             // 325
  {CMD_CLIENT_PART,           cmd_part_channel},           // 401
  {CMD_SERVER_PUBLIC,         cmd_public_message},         // 403
  {CMD_SERVER_NOSUCH,         cmd_error_message},          // 404
  {CMD_SERVER_JOIN_ACK,       cmd_create_channel},         // 405
  {CMD_SERVER_JOIN,           cmd_join_message},           // 406
  {CMD_SERVER_PART,           cmd_part_message},           // 407
  {CMD_SERVER_CHANNEL_USER_LIST, cmd_user_online},         // 408
  {CMD_SERVER_CHANNEL_USER_LIST_END,cmd_do_nothing},       // 409
  {CMD_SERVER_TOPIC,          cmd_channel_topic},          // 410
  {CMD_CLIENT_CHANNEL_BAN_LIST, cmd_do_nothing},           // 420
  {CMD_SERVER_CHANNEL_BAN_LIST, cmd_banlist_entry},        // 421
  {CMD_CHANNEL_ALT_TOPIC,     cmd_channel_alt_topic},      // 425
  {CMD_SERVER_UPLOAD_FIREWALL,cmd_alternate_ack},          // 501
  {CMD_SERVER_USER_SPEED,     cmd_linkspeed_response},     // 601
  {CMD_SERVER_WHOIS_RESPONSE, cmd_eval_whois},             // 604
  {CMD_SERVER_WHOWAS,         cmd_eval_whowas},            // 605
  {CMD_SERVER_UPLOAD_REQUEST, cmd_upload_request},         // 607
  {CMD_GET_ERROR,             cmd_get_error},              // 609
  {CMD_CLIENT_ALTER_PORT,     cmd_set_port},               // 613
  {CMD_CLIENT_BANLIST,        cmd_do_nothing},             // 615
  {CMD_SERVER_IP_BANLIST,     cmd_banlist_entry},          // 616
  {CMD_SERVER_CHANNEL_LIST_END, cmd_channel_list_end},     // 617
  {CMD_SERVER_CHANNEL_LIST,   cmd_channel_list},           // 618
  {CMD_SERVER_LIMIT,          cmd_remote_queued},          // 620
  {CMD_SERVER_MOTD,           cmd_motd},                   // 621
  {CMD_SERVER_WALLOP,         cmd_operator_message},       // 627
  {CMD_SERVER_ANNOUNCE,       cmd_global_message},         // 628
  {CMD_SERVER_NICK_BANLIST,   cmd_nick_banlist},           // 629
  {CMD_SERVER_GHOST,          cmd_ghost},                  // 748
  {CMD_CLIENT_PING_SERVER,    cmd_sping},                  // 750
  {CMD_SERVER_PING,           cmd_ping},                   // 751
  {CMD_SERVER_PONG,           cmd_pong},                   // 752
  {CMD_CLIENT_EMOTE,          cmd_emote},                  // 824
  {CMD_SERVER_NAMES_LIST,     cmd_list_user},              // 825
  {CMD_CLIENT_FULL_CHANNEL_LIST, cmd_channel_list_end},    // 827
  {CMD_SERVER_FULL_CHANNEL_INFO, cmd_channel_list_entry},  // 828
  {CMD_SERVER_NAMES_LIST_END, cmd_list_user_end},          // 830
  {CMD_SERVER_LINKS,          cmd_server_links},           // 10112
  {CMD_SERVER_USAGE_STATS,    cmd_usage_stats}             // 10115
};

static int Protocol_Size = sizeof (Protocol) / sizeof (HANDLER_ENTRY);


int search_handler(int code) {
  int i1;

  // for now do a linear search
  for (i1 = 0; i1 < Protocol_Size; i1++) {
    if (Protocol[i1].code == code) return i1;
  }
  return -1;
}

void handle_command(int type, char* data) {
  int i1;

  i1 = search_handler(type);
  if (i1 < 0) {
    not_implemented(type, data);
  } else {
    (Protocol[i1].handler)(data);
  }
}

void cmd_server_error(char* data) {
  GtkWidget* temp;

  temp = lookup_widget(global.win, "Console_text");
  cmd_error_message(data);
  if (global.status.connecting)
    connection_close(&(global.server), data);
}
void cmd_login_ack(char* data) {
  GtkNotebook* notebook;
  GtkWidget* temp;
  int i1;
  address_t* server;

  global.server.address.network = N_NAPSTER;
  global.user.level = L_USER;
  global.user.status = STATUS_ACTIVE;
  
  // clean up chat
  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  while ((temp = gtk_notebook_get_nth_page(notebook, 2)) != NULL) {
    gtk_notebook_remove_page(notebook, 2);
  }    
  temp = lookup_widget(global.win, "Console_text");
  gtk_editable_delete_text(GTK_EDITABLE(temp), 0,
			   gtk_text_get_length(GTK_TEXT(temp)));
  
  global.status.connecting = 0;
  global.status.connected = 1;
  gtk_widget_hide(global.connect_win);
  gtk_widget_destroy(global.connect_win);
  global.connect_win = NULL;
  
  server = search_server_in_glist(&global.server.address);
  if (server) server->no_connected++;
  
  log("protocol", "Connected to %s:%d\n", global.server.address.ip,
      global.server.address.port);
  
  chat_print("message", "Joining channels....\n");
  if (global.channels) {
    for (i1 = 0; i1 < g_list_length(global.channels); i1++) {
      join_channel(g_list_nth(global.channels, i1)->data);
    }
  }
  
  chat_print("message", "Adding Hotlist entries....\n");
  if (global.hotlist) {
    for (i1 = 0; i1 < g_list_length(global.hotlist); i1++) {
      send_command(CMD_CLIENT_ADD_HOTLIST_SEQ, g_list_nth(global.hotlist, i1)->data);
    }
  }
  
  chat_print("message", "Ignoring enemy users....\n");
  if (global.enemyuser) {
    for (i1 = 0; i1 < g_list_length(global.enemyuser); i1++) {
      send_command(CMD_CLIENT_IGNORE_USER, g_list_nth(global.enemyuser, i1)->data);
    }
  }
  
  if (!global.status.building) lib_commit();
  
  set_last_server(&(global.server.address));
  if (global.status.connected) {
    global.status.whois_hide++;
    send_command(CMD_CLIENT_WHOIS, global.user.username);
  }
}

void cmd_register_fail(char* data) {
  connection_close(&(global.server), "Nick already registered");
}

void cmd_bad_nick(char* data) {
  connection_close(&(global.server), "Invalid Nick");
}

void not_implemented(int type, char* data) {
  log("protocol", "** Unknown\n");
  client_message("error", 
		 "** not implemented yet: %d: [%s]\n[%s]", 
		 type, getCommandName(type), data);
}

void cmd_resume_match(char* data) {
  GtkWidget* temp;

  sscanf(data, "%s %*s %*s %s %*s %s %s",
	 tstr[1], tstr[0], tstr[2], tstr[3]);
  strcpy(tstr[3], LineSpeed[atoi(tstr[3])]);
  
  temp = lookup_widget(global.resume_win, "clist2");
  gtk_clist_append(GTK_CLIST(temp), list);
}
void cmd_disconnecting(char* data) {
  client_message("message", "You will be disconnected");
}

void cmd_channel_alt_topic(char* data) {
  chat_print("message", "%s\n", data);
}

void cmd_channel_list(char* data) {
  GtkWidget* temp;
  char* pos;

  pos = strchr(data, ' ');
  pos[0] = 0;
  strcpy(tstr[0], data);
  data = pos+1;
  pos = strchr(data, ' ');
  pos[0] = 0;
  strcpy(tstr[1], data);
  data = pos+1;
  
  strcpy(tstr[4], data);
  
  tstr[2][0] = tstr[3][0] = 0;
  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_append(GTK_CLIST(temp), list);
}

void cmd_motd(char* data) {
  GtkWidget* temp;
  style_t* style;

  if (!strncasecmp("VERSION opennap", data, 15))
    global.server.address.network = N_OPENNAP;
  update_user_stats();

  temp = lookup_widget(global.win, "Console_text");
  style = style_get(global.colors, "text");
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  data, strlen(data));
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  "\n", 1);
}

void cmd_nick_banlist(char* data) {
  GtkWidget* temp;

  if (!global.ban_win) return;
  temp = lookup_widget(global.ban_win, "clist3");
  strcpy(tstr[0], data);
  tstr[1][0] = 0;
  tstr[2][0] = 0;
  tstr[3][0] = 0;
  gtk_clist_append(GTK_CLIST(temp), list);
}

void cmd_ghost(char* data) {
  client_message("message", "Someone else tries to login with your Nick");
}

void cmd_channel_list_entry(char* data) {
  char* pos;
  GtkWidget* temp;

  pos = strchr(data, ' ');
  pos[0] = 0;
  strcpy(tstr[0], data);
  data = pos+1;
  pos = strchr(data, ' ');
  pos[0] = 0;
  strcpy(tstr[1], data);
  data = pos+1;
  
  data = strchr(data, ' ')+1;
  pos = strchr(data, ' ');
  pos[0] = 0;
  strcpy(tstr[3], data);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  strcpy(tstr[2], data);
  data = pos+2;
  
  pos = strrchr(data, '\"');
  pos[0] = 0;
  strcpy(tstr[4], data);
  
  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_append(GTK_CLIST(temp), list);
}

void cmd_server_links(char* data) {
  char t[1024];

  chat_print("message", "(Message) ");
  if (strlen(data) > 0) {
    sprintf(t, "%s Linked %s", global.current_room, data);
    log("Client", data);
  } else {
    sprintf(t, "%s Linked --End of linked server list--------------------",
	    global.current_room);
  }
  cmd_public_message_no_log(t);
}

void cmd_do_nothing(char* data) {
}

void cmd_channel_list_end(char* data) {
  set_options_channels();
}

void cmd_usage_stats(char* data) {
  char* pos;
  time_t stime;
  int t1;
  char str[1024];
  unsigned long gigs;

  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Local Clients: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;

  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Local Servers: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Users: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Files: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Gigs: ");
  gigs = strtoul(data, NULL, 10);
  chat_print("NULL", "%d\n", gigs/1024/1024);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Channels: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Time: ");
  sscanf(data, "%ld", &stime);
  chat_print("NULL", ctime(&stime));
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Uptime: ");
  t1 = strtoul(data, NULL, 10);
  sprintf(str, "%d days %d hours %d minutes %d seconds", 
	  t1/(60*60*24), 
	  (t1%(60*60*24))/(60*60),
	  (t1%(60*60))/60, 
	  t1%60);
  chat_print("NULL", "%s\n", str);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Memory: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;
  
  pos = strchr(data, ' ');
  pos[0] = 0;
  chat_print("message", "Registered Users: ");
  chat_print("NULL", "%s\n", data);
  data = pos+1;

  chat_print("message", "Unknown: ");
  chat_print("NULL", "%s\n", data);
}
