typedef struct {
  char* ip;
  unsigned long ip_long;
  int port;
  char* description;
  int no_connected;
  int network;
} address_t;

typedef struct {
  address_t address;
  int fd;
  int input;
  int timeout;
  int cnt;               // intern counter
  int max_cnt;           // max count for timeout
} socket_t;

void connection_close(socket_t* socket, 
		      char* reason);

int connect_napster();

int get_best_server();

int get_best_server_read(gpointer data, gint source, 
			 GdkInputCondition condition);

int connect_to_server();

int server_login(gpointer data, gint source, 
		 GdkInputCondition condition);

int connect_socket(socket_t* s);

int send_command(gint16 type, const char *fmt, ...);
  //int send_command(int sock, gint16 type, char *data);

gint16 receive_command(int sock, char* data);

void create_upload_port(int send);

gint server_get_input(gpointer data, gint source, GdkInputCondition condition);
