#include <string.h>
#include <stdio.h>
#include <sys/time.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "global.h"
#include "search.h"
#include "connection.h"

#include "support.h"


void cmd_search_response(char* data) {
  file_t* file;
  int i1;
  GtkWidget* temp;
  char t[1024];

  if (global.status.searching == 0) return;

  file = file_create_from_search_response(data);
  file_insert_search(file);
  temp = lookup_widget(global.win, "search_list");
  i1 = GTK_CLIST(temp)->rows;
  temp = lookup_widget(global.win, "search_entry");
  sprintf(t, "%d songs matched....searching...", i1);
  gtk_entry_set_text(GTK_ENTRY(temp), t);
}

void cmd_end_of_search() {
  int i1;
  GtkWidget* temp;
  char t[1024];

  if (global.status.searching == 0) return;

  temp = lookup_widget(global.win, "search_list");
  i1 = GTK_CLIST(temp)->rows;
  temp = lookup_widget(global.win, "search_entry");
  sprintf(t, "%d songs matched....search done", i1);
  gtk_entry_set_text(GTK_ENTRY(temp), t);
  global.status.searching = 0;
  temp = lookup_widget(global.win, "button126");
  gtk_widget_set_sensitive(temp, FALSE);
}

file_t* file_create_from_search_response(char* data) {
  file_t* new_file;
  char* pos1;
  char* pos2;

  new_file = (file_t*)malloc(sizeof(file_t));

  pos1 = strchr(data, '\"')+1;
  pos2 = strrchr(data, '\"');
  pos2[0] = '\0';
  new_file->winname = strdup(pos1);

  pos1 = pos2+2;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  new_file->md5 = strdup(pos1);

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%ld", &(new_file->size));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(new_file->bitrate));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(new_file->frequency));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%d", &(new_file->length));

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  new_file->user = strdup(pos1);

  pos1 = pos2+1;
  pos2 = strchr(pos1, ' ');
  pos2[0] = 0;
  sscanf(pos1, "%lu", &(new_file->ip));

  pos1 = pos2+1;
  sscanf(pos1, "%d", &(new_file->linespeed));
  
  new_file->longname = strdup(new_file->winname);
  convert_to_unix(new_file->longname);
  pos1 = extract_short_name(new_file->longname);
  new_file->shortname = strdup(pos1);

  new_file->ping = -1;
  new_file->flags = 0;

  return new_file;
}

void send_search_request() {
  GtkWidget* temp;
  char data[1024];
  char str[500];
  char str2[500];
  char str3[500];

  if (!global.status.connected) {
    g_warning("not connected!");
    return;
  }
  if (global.status.searching) {
    g_warning("search already running.");
    return;
  }

  global.status.searching = 1;
  temp = lookup_widget(global.win, "button126");
  gtk_widget_set_sensitive(temp, TRUE);

  temp = lookup_widget(global.win, "search_list");
  gtk_clist_clear(GTK_CLIST(temp));
  temp = lookup_widget(global.win, "search_entry");
  gtk_entry_set_text(GTK_ENTRY(temp), "...searching...");
  
  data[0] = 0;
  temp = lookup_widget(global.win, "search_artist");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    sprintf(str2, "FILENAME CONTAINS \"%s\" ", str);
    strcat(data, str2);
  }
  temp = lookup_widget(global.win, "search_results");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  sprintf(str2, "MAX_RESULTS %s", str);
  strcat(data, str2);
  
  temp = lookup_widget(global.win, "combo_speed");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "combo_speed2");
    strcpy(str2, gtk_entry_get_text(GTK_ENTRY(temp)));
    if (strlen(str2) > 0) {
      sprintf(str3, " LINESPEED \"%s\" %d", str, speed2int(str2));
      strcat(data, str3);
    }
  }

  temp = lookup_widget(global.win, "combo_bitrate");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "combo_bitrate2");
    strcpy(str2, gtk_entry_get_text(GTK_ENTRY(temp)));
    if (strlen(str2) > 0) {
      sprintf(str3, " BITRATE \"%s\" \"%s\"", str, str2);
      strcat(data, str3);
    }
  }

  temp = lookup_widget(global.win, "combo_freq");
  strcpy(str, gtk_entry_get_text(GTK_ENTRY(temp)));
  if (strlen(str) > 0) {
    temp = lookup_widget(global.win, "combo_freq2");
    strcpy(str2, gtk_entry_get_text(GTK_ENTRY(temp)));
    if (strlen(str2) > 0) {
      sprintf(str3, " FREQ \"%s\" \"%s\"", str, str2);
      strcat(data, str3);
    }
  }

  send_command(200, data);
}

void file_insert_search(file_t *file) {
  GtkWidget* temp;
  int row;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  
  temp = lookup_widget(global.win, "search_list");
  
  strcpy(tstr[0], file->shortname);
  sprintf(tstr[1], "%.2f MB", (double)(file->size)/1024/1024);
  sprintf(tstr[2], "%d", file->bitrate);
  sprintf(tstr[3], "%d:%s%d", file->length/60, 
	  (file->length%60)<10?"0":"", file->length%60);
  strcpy(tstr[4], file->user);
  strcpy(tstr[5], LineSpeed[file->linespeed]);
  strcpy(tstr[6], "unknown");

  row = gtk_clist_append(GTK_CLIST(temp), &list[0]);
  gtk_clist_set_row_data_full (GTK_CLIST(temp), row,
			       (gpointer)file,
			       (GtkDestroyNotify)destroy_file_row);

  if (file->linespeed > 10 || file->linespeed < 1) {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  } else if (file->linespeed <= 3) {
    pixmap = global.pix.sred;
    bitmap = global.pix.sredb;
  } else if (file->linespeed <= 6) {
    pixmap = global.pix.syellow;
    bitmap = global.pix.syellowb;
  } else if (file->linespeed <= 10) {
    pixmap = global.pix.sgreen;
    bitmap = global.pix.sgreenb;
  } else {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  }

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			 tstr[0], 5, pixmap, bitmap);
}

