#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <gtk/gtk.h>
#include "support.h"
#include "dirselect.h"
#include "global.h"

GtkWidget* tree_item_new(char* name, char* longname) {
  GtkWidget* item;
  GtkWidget* pixmap;
  GtkWidget* label;
  GtkWidget* hbox;

  item = gtk_tree_item_new();

  hbox = gtk_hbox_new(FALSE, 3);
  gtk_widget_show(hbox);
  gtk_container_add(GTK_CONTAINER(item), hbox);

  pixmap = create_pixmap (global.dir_select_win, "mini-folder.xpm");
  gtk_widget_ref (pixmap);
  gtk_widget_show (pixmap);
  gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, TRUE, 0);
  
  label = gtk_label_new(name);
  gtk_widget_show(label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);

  gtk_object_set_data(GTK_OBJECT(item), "path", strdup(longname));
  return item;
}

int count_no_subdirs(char* dirname) {
  DIR* dir;
  struct dirent* entry;
  struct stat buf;
  int cnt;
  char name[1024];

  if ((dir = opendir(dirname)) == NULL) {
    printf("could not open dir [%s]\n", dirname);
    return 0;
  }
  cnt = 0;
  while ((entry = readdir(dir)) != NULL) {
    if (!strncmp(entry->d_name, ".", 1)) continue;
    if (!strncmp(entry->d_name, "..", 2)) continue;
    
    strcpy(name, dirname);
    strcat(name, "/");
    strcat(name, entry->d_name);
    stat(name, &buf);
    if (S_ISDIR(buf.st_mode)) cnt++;
  }
  closedir(dir);

  return cnt;
}

int exist_subdirs(char* dirname) {
  DIR* dir;
  struct dirent* entry;
  struct stat buf;
  int cnt;
  char name[1024];

  if ((dir = opendir(dirname)) == NULL) {
    printf("could not open dir [%s]\n", dirname);
    return 0;
  }
  cnt = 0;
  while ((entry = readdir(dir)) != NULL) {
    if (!strncmp(entry->d_name, ".", 1)) continue;
    if (!strncmp(entry->d_name, "..", 2)) continue;
    
    strcpy(name, dirname);
    strcat(name, "/");
    strcat(name, entry->d_name);
    stat(name, &buf);
    if (S_ISDIR(buf.st_mode)) {
      closedir(dir);
      return 1;
    }
  }
  closedir(dir);

  return 0;
}

void
on_select_activate                    (GtkTree     *tree,
				       GtkWidget   *child,
				       gpointer    user_data) {
  GtkWidget* temp;
  char* longname;

  temp = lookup_widget(GTK_WIDGET(tree), "entry39");
  
  longname = gtk_object_get_data(GTK_OBJECT(child), "path");

  gtk_entry_set_text(GTK_ENTRY(temp), longname);
}

void expand_tree(GtkTreeItem* item) {
  GtkWidget* new_item;
  GtkWidget* new_tree;
  char* longname;
  GtkTree* tree;
  DIR* dir;
  char name[1024];
  struct dirent* entry;
  struct stat buf;
  int cnt;

  longname = gtk_object_get_data(GTK_OBJECT(item), "path");

  tree = GTK_TREE(item->subtree);
  if (g_list_length(tree->children) > 0) {
    return;
  }

  if ((dir = opendir(longname)) == NULL) {
    printf("could not open dir [%s]\n", longname);
    return;
  }
  while ((entry = readdir(dir)) != NULL) {
    if (!strncmp(entry->d_name, ".", 1)) continue;
    if (!strncmp(entry->d_name, "..", 2)) continue;
    
    strcpy(name, longname);
    if (name[strlen(name)-1] != '/') strcat(name, "/");
    strcat(name, entry->d_name);
    stat(name, &buf);
    if (S_ISDIR(buf.st_mode)) {
      new_item = tree_item_new(entry->d_name, name);
      gtk_widget_show(new_item);
      gtk_tree_append(GTK_TREE(tree), new_item);
      cnt = exist_subdirs(name);
      if (cnt > 0) {
	new_tree = gtk_tree_new();
	gtk_widget_show(new_tree);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(new_item), new_tree);
	gtk_signal_connect (GTK_OBJECT (new_item), "expand",
			    GTK_SIGNAL_FUNC (on_expand_activate),
			    NULL);
	gtk_signal_connect (GTK_OBJECT (new_tree), "select_child",
			    GTK_SIGNAL_FUNC (on_select_activate),
			    NULL);
      }
    }
  }
  closedir(dir);

}

void
on_expand_activate                    (GtkTreeItem     *treeitem,
				       gpointer         user_data) {
  expand_tree(treeitem);
}

void create_tree(GtkTree* tree, char* root) {
  GtkWidget* item;
  DIR* dir;
  int cnt;
  GtkWidget* new_tree;

  if ((dir = opendir(root)) == NULL) {
    printf("could not open dir [%s]", root);
    return ;
  }

  item = tree_item_new(root, root);
  gtk_widget_show(item);
  gtk_tree_append(tree, item);

  cnt = exist_subdirs(root);
  
  if (cnt > 0) {
    new_tree = gtk_tree_new();
    gtk_widget_show(new_tree);
    gtk_tree_item_set_subtree(GTK_TREE_ITEM(item), new_tree);
    gtk_signal_connect (GTK_OBJECT (item), "expand",
			GTK_SIGNAL_FUNC (on_expand_activate),
			NULL);
    gtk_signal_connect (GTK_OBJECT (new_tree), "select_child",
			GTK_SIGNAL_FUNC (on_select_activate),
			NULL);
    gtk_signal_connect (GTK_OBJECT (tree), "select_child",
			GTK_SIGNAL_FUNC (on_select_activate),
			NULL);
  }
  gtk_tree_item_expand(GTK_TREE_ITEM(item));

  closedir(dir);
}
