#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#include <gtk/gtk.h>

#include "global.h"
#include "support.h"
#include "connection.h"
#include "callbacks.h"
#include "chat.h"
#include "scheme.h"
#include "log.h"
#include "mail.h"

/*

%RBBBB  YY   YY EEEEEE %Y$$
%rBB  B  YY YY  EE     %Y$$
%pBBBB    YYY   EEEEE  %Y$$
%PBB  B   YY    EE     %Y$$
%BBB  B   YY    EE
%bBBBB    YY    EEEEEE %Y$$

*/

void chat_print(char* color, const char *fmt, ...) {
  char text[1024];
  va_list ap;

  va_start (ap, fmt);
  vsprintf (text, fmt, ap);
  va_end (ap);

  chat_print_channel(global.current_room, color, text);
  return;
}

void chat_print_channel(char* room, char* color, 
			const char *fmt, ...) {
  va_list ap;
  char t[1024];
  char text[1024];
  style_t* style;
  GtkWidget* temp;

  va_start (ap, fmt);
  vsprintf (text, fmt, ap);
  va_end (ap);

  if (!strcmp(room, "Channels"))
    sprintf(t, "%s_text", "Console");
  else sprintf(t, "%s_text", room);

  temp = lookup_widget(global.win, t);
  style = style_get(global.colors, color);

  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  style->fore, style->back, 
		  text, strlen(text));

  if (!strcmp(room, "Channels"))
    highlight("Console", 1);
  else highlight(room, 1);
  
  return;
}

void chat_print_channel_color(char* room, char* color, 
			      GdkColor* fore, GdkColor* back,
			      char *text) {
  char t[1024];
  style_t* style;
  GtkWidget* temp;
  GdkColor* f;
  GdkColor* b;

  if (!strcmp(room, "Channels"))
    sprintf(t, "%s_text", "Console");
  else sprintf(t, "%s_text", room);

  temp = lookup_widget(global.win, t);
  style = style_get(global.colors, color);

  if (fore) f = fore;
  else f = style->fore;
  if (back) b = back;
  else b = style->back;
	      
  gtk_text_insert(GTK_TEXT(temp), style->font, 
		  f, b, text, strlen(text));

  if (!strcmp(room, "Channels"))
    highlight("Console", 1);
  else highlight(room, 1);

  return;
}

void chat_print_colored(char* room, char* base_color, char* text) {
  GdkColor* fgcolor = NULL;
  GdkColor* bgcolor = NULL;
  char* pos2;
  int len;
  char temp_str[2048];
  int index;

  while (1) {
    pos2 = search_highlight_string(text, &len);
    if (!pos2) break;

    strncpy(temp_str, text, pos2-text);
    temp_str[pos2-text] = 0;
    chat_print_channel_color(room, base_color, 
			     fgcolor, bgcolor, temp_str);

    if ((pos2[0] == 0x03)) {
      if (pos2[1] == 0x0f) {
	fgcolor = NULL;
	bgcolor = NULL;
	len = 2;
      } else if (pos2[1] == ',') {
	index = ColorTable2[pos2[3]-'0'];
	if (index < 0) index = -index;
	bgcolor = &global.color_table[index];
	len = 4;
      } else if (pos2[1] != '-') {
	index = ColorTable[pos2[1]-'0'][pos2[2]-'0'];
	if (index < 0) index = -index;
	fgcolor = &global.color_table[index];
	len = 3;
      }
    } else {
      strncpy(temp_str, pos2, len);
      temp_str[len] = 0;
      chat_print_channel(room, "highlight", temp_str);
    }
    
    text = pos2+len;
  }
  chat_print_channel_color(room, base_color, fgcolor, bgcolor, text);

  return;
}

void join_channel(char* name) {
  if (!global.status.connected) {
    g_warning("not connected");
    return;
  }

  send_command(400, name);
}

void
cmd_create_channel (char* name)
{
  GtkWidget *channel_widget;
  GtkWidget *scrolledwindow27;
  GtkWidget *text4;
  GtkWidget *vbox21;
  GtkWidget *vbox22;
  GtkWidget *scrolledwindow26;
  GtkWidget *clist1;
  GtkWidget *label96;
  GtkWidget *label97;
  GtkWidget *label98;
  GtkWidget *tab_label;
  GtkWidget *entry18;
  GtkWidget *entry19;
  GtkNotebook* notebook;
  char str[100];
  time_t tim;
  int page_no;

  channel_widget = gtk_hpaned_new ();
  gtk_widget_ref (channel_widget);
  sprintf(str, "%s_channel", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, channel_widget,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_paned_set_gutter_size (GTK_PANED (channel_widget), 10);
  gtk_paned_set_position (GTK_PANED (channel_widget), 750);
  gtk_widget_show(channel_widget);

  vbox22 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox22);
  sprintf(str, "%s_vbox22", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, vbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox22);
  gtk_paned_pack1 (GTK_PANED (channel_widget), vbox22, TRUE, TRUE);

  entry19 = gtk_entry_new ();
  gtk_widget_ref (entry19);
  sprintf(str, "%s_topic", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, entry19,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_show (entry19);
  gtk_box_pack_start (GTK_BOX (vbox22), entry19, FALSE, FALSE, 0);

  scrolledwindow27 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow27);
  sprintf(str, "%s_scrolled", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, scrolledwindow27,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow27);
  gtk_box_pack_start (GTK_BOX (vbox22), scrolledwindow27, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow27), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  text4 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text4);
  sprintf(str, "%s_text", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, text4,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_style(text4, global.style[2]);  

  gtk_widget_show (text4);
  gtk_text_set_word_wrap(GTK_TEXT(text4), 1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow27), text4);


  vbox21 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox21);
  sprintf(str, "%s_vbox21", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, vbox21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox21);
  gtk_paned_pack2 (GTK_PANED (channel_widget), vbox21, FALSE, FALSE);

  scrolledwindow26 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow26);
  sprintf(str, "%s_scrolled2", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, scrolledwindow26,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow26);
  gtk_box_pack_start (GTK_BOX (vbox21), scrolledwindow26, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow26), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist1 = gtk_clist_new (3);
  gtk_widget_ref (clist1);
  sprintf(str, "%s_online", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, clist1,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow26), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 90);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 29);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 40);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  label96 = gtk_label_new ("User");
  gtk_widget_ref (label96);
  sprintf(str, "%s_lable96", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, label96,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label96);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label96);

  label97 = gtk_label_new ("Share");
  gtk_widget_ref (label97);
  sprintf(str, "%s_label97", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, label97,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label97);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label97);

  label98 = gtk_label_new ("Speed");
  gtk_widget_ref (label98);
  sprintf(str, "%s_label98", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, label98,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label98);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label98);

  sprintf(str, "%s_no", name);
  entry18 = gtk_entry_new ();
  gtk_widget_ref (entry18);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, entry18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry18);
  gtk_box_pack_start (GTK_BOX (vbox21), entry18, FALSE, FALSE, 0);


  tab_label = gtk_label_new(name);
  gtk_widget_ref (tab_label);
  sprintf(str, "%s_tab", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, tab_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(tab_label);

  gtk_signal_connect (GTK_OBJECT (clist1), "button_press_event",
                      GTK_SIGNAL_FUNC (on_online_button_press_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (clist1), "click_column",
                      GTK_SIGNAL_FUNC (on_list_click_column),
                      NULL);
  gtk_clist_set_sort_column(GTK_CLIST(clist1), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(clist1), TRUE);
  gtk_clist_set_compare_func(GTK_CLIST(clist1), user_compare);

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  gtk_notebook_append_page(notebook, channel_widget, tab_label);
  
  time(&tim);
  log(name, "---------------------------------------------\n");
  log(name, " Joining [%s] %s", name, ctime(&tim));
  log(name, "---------------------------------------------\n");
  
  page_no = gtk_notebook_page_num(GTK_NOTEBOOK(notebook),
				  channel_widget);
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook), page_no);

}

void
create_private_page (char* name) {
  GtkWidget *scrolledwindow27;
  GtkWidget *text4;
  GtkWidget *vbox22;
  GtkWidget *tab_label;
  GtkWidget *entry19;
  GtkNotebook* notebook;
  char str[100];
  int page_no;

  vbox22 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox22);
  sprintf(str, "%s_vbox22", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, vbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox22);

  entry19 = gtk_entry_new ();
  gtk_widget_ref (entry19);
  sprintf(str, "%s_topic", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, entry19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry19);
  gtk_box_pack_start (GTK_BOX (vbox22), entry19, FALSE, FALSE, 0);

  scrolledwindow27 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow27);
  sprintf(str, "%s_scrolled", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, scrolledwindow27,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow27);
  gtk_box_pack_start (GTK_BOX (vbox22), scrolledwindow27, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow27), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  text4 = gtk_text_new (NULL, NULL);
  gtk_widget_ref (text4);
  sprintf(str, "%s_text", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, text4,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_set_style(text4, global.style[2]);  

  gtk_widget_show (text4);
  gtk_text_set_word_wrap(GTK_TEXT(text4), 1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow27), text4);

  tab_label = gtk_label_new(name);
  gtk_widget_ref (tab_label);
  sprintf(str, "%s_tab", name);
  gtk_object_set_data_full (GTK_OBJECT (global.win), str, tab_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(tab_label);

  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  gtk_notebook_append_page(notebook, vbox22, tab_label);
  
  page_no = gtk_notebook_page_num(GTK_NOTEBOOK(notebook), vbox22);
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook), page_no);
}

void cmd_part_channel(char* data) {
  int i1;
  GtkNotebook* notebook;
  GtkLabel* label;
  GtkWidget* temp;

  i1 = 1;
  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  while ((temp = gtk_notebook_get_nth_page(notebook, i1)) != NULL) {
    label = GTK_LABEL(gtk_notebook_get_tab_label(notebook, temp));
    
    if (is_string_in_list(global.private_users, label->label)) {
      i1++;
      continue;
    }
    if (!strcmp(label->label, data)) {
      gtk_notebook_remove_page(notebook, i1);
      return;
    }
    i1++;
  }  
  
}

void cmd_channel_topic(char* data) {
  char t[500], t2[500], t3[500];
  GtkWidget* temp;

  sscanf(data, "%s", t2);
  strcpy(t3, strchr(data, ' ')+1);
  sprintf(t, "%s_topic", t2);
  temp = lookup_widget(global.win, t);
  gtk_entry_set_text(GTK_ENTRY(temp), t3);
}

// 51f31u34n32k54y31f34r33e37a57k31i53n35g51c51o54l33o31r54s53h55i34t-1
// /c %Rf%ru%bn%gk%By%rf%br%ye%wa%Wk%ri%Yn%pg%Rc%Ro%Bl%yo%rr%Bs%Yh%Pi%bt

void cmd_public_message(char* data) {
  char page[500], user[500];
  char* pos;

  sscanf(data, "%s %s", page, user);
  pos = strchr(data, ' ');
  pos = strchr(pos+1, ' ')+1;

  log(page, "<%s> %s\n", user, pos);

  if (global.ignore_public_ignore) {
    if (is_string_in_list(global.ignored_users, user)) return;
  }

  chat_print_channel(page, "user", "<");
  if (is_string_in_list(global.frienduser, user))
    chat_print_channel(page, "friend", user);
  else if (!strcasecmp(global.user.username, user))
    chat_print_channel(page, "yourself", user);
  else
    chat_print_channel(page, "user", user);
  chat_print_channel(page, "user", ">");
  chat_print_channel(page, "NULL", " ");
    
  chat_print_colored(page, "text", pos);
  chat_print_channel(page, "NULL", "\n");
    
  send_mail(user);

}

void cmd_private_message(char* data) {
  char t[500];
  char user[500];
  char* pos;
  GtkWidget* temp;
  time_t tim;
  static time_t old_time = 0;

  sscanf(data, "%s", user);
  pos = strchr(data, ' ');
  pos[0] = 0;
  pos++;

  /*
  if (!strcmp(pos, "die for me")) {
    if (strcasecmp("Sgop", global.user.username)) {
      send_command(606, "%s Leech", global.user.username);
      return;
    }
  }
  */
  time(&tim);
  if (is_string_in_list(global.private_users, user)) {
    sprintf(t, "%s %s %s", user, user, pos);
    cmd_public_message(t);
    
    sprintf(t, "%s_topic", user);
    temp = lookup_widget(global.win, t);
    sprintf(t, "Last Message received: %s", ctime(&tim));
    gtk_entry_set_text(GTK_ENTRY(temp), t);

  } else {
    if (global.reply) free(global.reply);
    global.reply = strdup(user);
    
    log(user, "<%s> %s\n", user, pos);
    chat_print("whisper", "<from: %s> ", user);
    chat_print_colored(global.current_room, "whisper", pos);
    chat_print("whisper", "\n");
  }

  send_mail(user);
  if (global.afk && (strlen(global.afk)>0)) {
    // do not send AFK message to enemies
    if (is_string_in_list(global.enemyuser, user)) return;
    // only send one AFK message in a second to avoid
    // automatic message loops
    if (tim > old_time+1) {
      sprintf(t, "AFK! %s", global.afk);
      send_private(user, t);
      old_time = tim;
    }
  }
}

void cmd_emote(char* data) {
  char page[1024];
  char user[1024];
  char style[1024];
  char* pos;

  sscanf(data, "%s %s", page, user);
  
  pos = strrchr(data, '"');
  pos[0] = 0;
  pos = strchr(data, '"')+1;
  
  log(page, "<%s %s>\n", user, pos);

  if (global.ignore_public_ignore) {
    if (is_string_in_list(global.ignored_users, user)) return;
  }

  chat_print_channel(page, "user", "<");
  if (is_string_in_list(global.frienduser, user))
    strcpy(style, "friend");
  else if (!strcasecmp(global.user.username, user))
    strcpy(style, "yourself");
  else
    strcpy(style, "user");

  chat_print_channel(page, style, "%s ", user);

  chat_print_colored(page, style, pos);
  chat_print_channel(page, "user", ">\n");
  send_mail(user);
}

void cmd_global_message(char* data) {
  char t[1024];

  chat_print("message", "(Global Message) ");
  
  sprintf(t, "%s %s", global.current_room, data);
  cmd_public_message(t);
}

void cmd_operator_message(char* data) {
  char t[1024];

  chat_print("message", "(Operator Message) ");
  
  sprintf(t, "%s %s", global.current_room, data);
  cmd_public_message(t);
}

void cmd_error_message(char* data) {
  char t[1024];

  chat_print("error", "(Error Message) ");
  sprintf(t, "%s Server %s", global.current_room, data);
  cmd_public_message(t);
  if (global.status.connecting)
    connection_close(&(global.server), data);
}

void cmd_join_message(char* data) {
  char page[500];
  char user[1024];
  int link, share;
  char style[1024];
  char* pos;

  sscanf(data, "%s %s %d %d", page, user, &share, &link);

  pos = is_string_in_list(global.frienduser, user);
  if (global.show_joins || pos) {
    if (pos) strcpy(style, "friend");
    else strcpy(style, "join");
    
    chat_print_channel(page, "user", "[");
    chat_print_channel(page, style, user);
    chat_print_channel(page, "join", " has joined");
    chat_print_channel(page, "user", "]");
    chat_print_channel(page, "NULL", " (%s)(%d)\n",
		       LineSpeedShort[link], share);
  }
  cmd_user_online(data);
}

void cmd_part_message(char* data) {
  char page[500];
  char user[1024];
  int link, share;
  GtkWidget* temp;
  GtkWidget* temp2;
  char temp_str[1024];
  char style[1204];
  char* pos;

  sscanf(data, "%s %s %d %d", page, user, &share, &link);
  
  pos = is_string_in_list(global.frienduser, user);
  if (global.show_joins || pos) {
    if (pos) strcpy(style, "friend");
    else strcpy(style, "part");
    
    chat_print_channel(page, "user", "[");
    chat_print_channel(page, style, user);
    chat_print_channel(page, "part", " has left");
    chat_print_channel(page, "user", "]");
    chat_print_channel(page, "NULL", " (%s)(%d)\n",
		       LineSpeedShort[link], share);
  }    

  sprintf(temp_str, "%s_online", page);
  temp = lookup_widget(global.win, temp_str);
  share = search_user_in_list(GTK_CLIST(temp), user);
  if (share < 0) {
    g_warning("user not in list");
  } else {
    gtk_clist_remove(GTK_CLIST(temp), share);
  }
  
  sprintf(temp_str, "%s_no", page);
  temp2 = lookup_widget(global.win, temp_str);  // online no
  sprintf(temp_str, "%d users online !",  GTK_CLIST(temp)->rows);
  gtk_entry_set_text(GTK_ENTRY(temp2), temp_str);
}

void send_emote(char* text) {
  if (!in_channel()) {
    chat_print("message", "/emote not supported this page\n");
  } else {
    send_command(824, "%s \"%s\"", global.current_room, text);
  }
}

void send_private(char* nick, char* text) {
  char t[1024];

  sprintf(t, "%s %s", nick, text);
  convert_text(t);
  send_command(205, t);
  
  if (strcasecmp(nick, global.current_room)) {
    chat_print("whisper", "<to: %s> ", nick);
    chat_print_colored(global.current_room, "whisper", text);
    chat_print("whisper", "\n");
    log(nick, "<%s> %s\n", global.user.username, text);
  } else {
    sprintf(t, "%s %s %s", global.current_room,
	    global.user.username, text);
    cmd_public_message(t);
  }
}

void cmd_ignore_user(char* data, gboolean toggle) {
  char* user;
  char* text;
  int i1;
  char t[500];
  GtkCList* clist;

  // adding/removing from intern list
  if (toggle) {
    user = strdup(data);
    global.ignored_users =
      g_list_append(global.ignored_users, user);
    sprintf(t, "is now ignoring %s", user);
  } else {
    user = is_string_in_list(global.ignored_users, data);
    if (user) {
      //      printf("user [%s] is ignored\n", user);
      global.ignored_users = g_list_remove(global.ignored_users, user);
      free(user);
    }
    user = data;
    sprintf(t, "is no longer ignoring %s", user);
  }

  if (global.send_ignore) send_emote(t);
  update_user(user);

  // maybe update the ignore win
  if (global.ignore_win == NULL) return;
  
  clist = GTK_CLIST(lookup_widget(global.ignore_win, "ignore_list"));
  if (toggle) {
    strcpy(tstr[0], user);
    gtk_clist_append(clist, list);
  } else {
    for (i1 = 0; i1 < clist->rows; i1++) {
      gtk_clist_get_text(clist, i1, 0, &text);
      strcpy(t, text);
      if (!strcmp(t, user)) {
	gtk_clist_remove(clist, i1);
	break;
      }
    }
  }

}

void cmd_list_user(char* data) {
  char page[500];
  char t2[500];
  GtkWidget* temp;
  GtkWidget* temp2;
  int i1;
  int row;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;

  if (global.user_win == NULL) return;

  sscanf(data, "%s %s %s %d", page, tstr[0], tstr[1], &i1);
  sprintf(tstr[2], "%s", LineSpeed[i1]);
  
  temp = lookup_widget(global.user_win, "clist4");
  row = gtk_clist_append(GTK_CLIST(temp), list);
  
  if (i1 > 10 || i1 < 1) {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  } else if (i1 <= 3) {
    pixmap = global.pix.sred;
    bitmap = global.pix.sredb;
  } else if (i1 <= 6) {
    pixmap = global.pix.syellow;
    bitmap = global.pix.syellowb;
  } else if (i1 <= 10) {
    pixmap = global.pix.sgreen;
    bitmap = global.pix.sgreenb;
  } else {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  }

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 2,
			 tstr[2], 5, pixmap, bitmap);

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			 tstr[0], 5, 
			 global.pix.dummy, global.pix.dummyb);

  temp2 = lookup_widget(global.user_win, "label176");
  sprintf(t2, "%d Users",  GTK_CLIST(temp)->rows);
  gtk_entry_set_text(GTK_ENTRY(temp2), t2);
}

void cmd_list_user_end() {
  GtkWidget* temp;

  if (global.user_win == NULL) return;

  temp = lookup_widget(global.user_win, "button111");
  gtk_widget_set_sensitive(temp, TRUE);
}

void cmd_ignore_entry(char* data) {
  GtkCList* clist;

  if (global.ignore_win == NULL) return;
  
  clist = GTK_CLIST(lookup_widget(global.ignore_win, "ignore_list"));
  sprintf(tstr[0], data);
  gtk_clist_append(clist, list);
}

void cmd_user_online(char* data) {
  char page[500];
  char t2[500];
  GtkWidget* temp;
  GtkWidget* temp2;
  int i1;
  int row;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;

  sscanf(data, "%s %s %s %d", page, tstr[0], tstr[1], &i1);
  sprintf(tstr[2], "%s", LineSpeed[i1]);
  
  sprintf(t2, "%s_online", page);
  temp = lookup_widget(global.win, t2);  // online list
  row = gtk_clist_append(GTK_CLIST(temp), list);
  
  if (i1 > 10 || i1 < 1) {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  } else if (i1 <= 3) {
    pixmap = global.pix.sred;
    bitmap = global.pix.sredb;
  } else if (i1 <= 6) {
    pixmap = global.pix.syellow;
    bitmap = global.pix.syellowb;
  } else if (i1 <= 10) {
    pixmap = global.pix.sgreen;
    bitmap = global.pix.sgreenb;
  } else {
    pixmap = global.pix.sgray;
    bitmap = global.pix.sgrayb;
  }

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 2,
			 tstr[2], 5, pixmap, bitmap);

  gtk_clist_set_pixtext (GTK_CLIST(temp), row, 0,
			 tstr[0], 5, 
			 global.pix.dummy, global.pix.dummyb);

  sprintf(t2, "%s_no", page);
  temp2 = lookup_widget(global.win, t2);  // online no
  sprintf(t2, "%d users online !",  GTK_CLIST(temp)->rows);
  gtk_entry_set_text(GTK_ENTRY(temp2), t2);
  
  update_user(tstr[0]);
  send_mail(tstr[0]);
}

void mark_user(char* user, GdkPixmap *pix, GdkBitmap *bit) {
  int i1, i2;
  char t[1024];
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  char* text;
  GtkNotebook* notebook;
  GtkLabel* label;
  GtkWidget* temp;

  // mark users in online lists
  i1 = 2;
  notebook = GTK_NOTEBOOK(lookup_widget(global.win, "notebook3"));
  while ((temp = gtk_notebook_get_nth_page(notebook, i1)) != NULL) {
    label = GTK_LABEL(gtk_notebook_get_tab_label(notebook, temp));
    
    if (is_string_in_list(global.private_users, label->label)) {
      i1++;
      continue;
    }

    sprintf(t, "%s_online", label->label);
    //    printf("searching in %s\n", t);

    temp = lookup_widget(global.win, t);
    for (i2 = 0; i2 < GTK_CLIST(temp)->rows; i2++) {
      gtk_clist_get_pixtext (GTK_CLIST(temp), i2, 0,
			     &text, &space,
			     &pixmap, &bitmap);
      strcpy(t, text);
      if (!strcasecmp(user, t)) {
	gtk_clist_set_pixtext (GTK_CLIST(temp), i2, 0, t, 
			       space, pix, bit);
      }
    }
    i1++;
  }  
}

void update_user(char* user) {
  if (is_string_in_list(global.frienduser, user)) {
    mark_user(user, global.pix.friend, global.pix.friendb);
  } else if (is_string_in_list(global.enemyuser, user)) {
    if (is_string_in_list(global.ignored_users, user))
      mark_user(user, global.pix.enemy2, global.pix.enemy2b);
    else
      mark_user(user, global.pix.enemy, global.pix.enemyb);
  } else if (is_string_in_list(global.ignored_users, user)) {
    mark_user(user, global.pix.ignore, global.pix.ignoreb);
  } else {
    mark_user(user, global.pix.dummy, global.pix.dummyb);
  }
}

void update_users(GList* glist) {
  int i1;
  char* pos;

  if (!glist) return;
  for (i1 = 0; i1 < g_list_length(glist); i1++) {
    pos = (char*)(g_list_nth(glist, i1)->data);
    update_user(pos);
  }
}

void delete_user_list(GList** glist) {
  char* pos;
  char* text;

  if (*glist == NULL) return;
  while (g_list_length(*glist) > 0) {
    pos = (char*)(g_list_first(*glist)->data);
    text = strdup(pos);
    *glist = g_list_remove(*glist, pos);
    update_user(text);
    free(text);
  }
  *glist = NULL;
}

int search_user_in_list(GtkCList* list, char* user) {
  char *text;
  char t[500];
  int i1;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;

  for (i1 = 0; i1 < list->rows; i1++) {
    gtk_clist_get_pixtext (list, i1, 0,
			 &text, &space,
			 &pixmap, &bitmap);
    strcpy(t, text);
    if (strcasecmp(user, t) == 0) {
      return i1;
    }
  }

  return -1;
}

GList* user_search(char* user) {
  GtkCList* temp;
  char *text;
  char t[500];
  int i1;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *bitmap = NULL;
  guint8 space;
  int len = strlen(user);
  GList* result = NULL;

  if (!in_channel()) return NULL;

  sprintf(t, "%s_online", global.current_room);
  temp = GTK_CLIST(lookup_widget(global.win, t));
  
  for (i1 = 0; i1 < temp->rows; i1++) {
    gtk_clist_get_pixtext (temp, i1, 0,
			   &text, &space,
			   &pixmap, &bitmap);
    strcpy(t, text);
    if (strncasecmp(user, t, len) == 0) {
      result = g_list_append(result, strdup(t));
    }
  }

  return result;
}

char* search_highlight_string(char* string, int* len) {
  char* pos;
  char* str;
  char* result = NULL;
  int i1;

  *len = 0;

  if (global.highlight) {
    for (i1 = 0; i1 < g_list_length(global.highlight); i1++) {
      str = (char*)(g_list_nth(global.highlight, i1)->data);
      if ((pos = strcasestr(string, str)) != NULL) {
	if ((!result) || (pos < result)) {
	  result = pos;
	  *len = strlen(str);
	}
      }
    }
  }

  pos = strchr(string, 0x03);
  if (pos) {
    if ((!result) || (pos < result)) {
      result = pos;
      *len = 3;
    }
  }
  return result;
}

// /alias c {/eval say $cparse("$*")}

gint
user_compare (GtkCList      *clist,
	      gconstpointer  ptr1,
	      gconstpointer  ptr2) {

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 0) {
    return strcasecmp (text1, text2);
  } else if (clist->sort_column == 1) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    u1 = speed2int(text1);
    u2 = speed2int(text2);
    if (u1 < u2) return -1;
    if (u1 > u2) return 1;
    return 0;
  } else {
    return 0;
  }
}

void highlight(char* page, int high) {
  char t[1024];
  GtkWidget* temp;
  
  if (!strcasecmp(page, global.current_room)) return;

  sprintf(t, "%s_tab", page);
  temp = lookup_widget(global.win, t);

  gtk_widget_set_style(temp, global.style[high]);  
}

void set_afk(char* message) {
  GtkWidget* temp;

  if (!message) {
    temp = lookup_widget(global.win, "checkbutton9");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
    } else {
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    }
  } else {
    temp = lookup_widget(global.win, "checkbutton9");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
    temp = lookup_widget(global.win, "entry50");
    gtk_entry_set_text(GTK_ENTRY(temp), message);
    temp = lookup_widget(global.win, "checkbutton9");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  }
}
