/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: util.h,v 1.18 2002/10/03 01:11:43 martine Exp $
 */

#ifndef util_h
#define util_h

#include <gtk/gtktable.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtkclist.h>

#include <stdio.h>
#include <time.h>
#include "conf.h" /* for the "geometry" struct */

/* i18n stuff. */
#include "gettext.h"
#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

typedef enum {
	LJ_MSG_INFO,
	LJ_MSG_WARNING
} MessageType;

/* converting to/from ljdate ("yyyy-mm-dd hh:mm:ss") and unix time */
char* tm_to_ljdate (struct tm *ptm);
gboolean ljdate_to_tm(const char *ljtime, struct tm *ptm);

/* hash table helpers. */
void hash_destroy(GHashTable* hash);

/* gtk helpers */
GtkWidget* lj_table_new(int rows, int cols);
GtkWidget* lj_table_label(GtkTable *table, int row, const char *text);
void       lj_table_content(GtkTable *table, int row, GtkWidget *content);
void       lj_table_label_content(GtkTable *table, int row, const char *text, GtkWidget *content);
void       lj_table_label_content_mne(GtkTable *table, int row, const char *text, GtkWidget *content, GtkWidget *mne);
void       lj_table_fillrow(GtkTable *table, int row, GtkWidget *content);

void       lj_dialog_init(GtkWidget *dlg, GtkWidget *parent, const gchar *title, int width, int height);
GtkWidget* lj_dialog_new(GtkWidget *parent, const gchar *title, int width, int height);
GtkWidget* lj_dialog_set_contents(GtkWidget *dlg, GtkWidget *vbox);
void       lj_dialog_add_button(GtkWidget *dlg, GtkWidget *button);
GtkWidget* lj_dialog_buttonbox_new(void);
void       lj_dialog_buttonbox_add(GtkWidget *box, GtkWidget *button);
GtkWidget* lj_dialog_buttonbox_button_with_label(GtkWidget *box, const char *label);
void       lj_dialog_set_contents_buttonbox(GtkWidget *dlg, GtkWidget *contents, GtkWidget *buttonbox);
void       lj_dialog_add_close(GtkWidget *dlg);
GtkWidget* lj_dialog_add_okcancel(GtkWidget *dlg, const char *okcaption);
int        lj_dialog_run(GtkWidget *dlg);
void       lj_dialog_show(GtkWidget *dlg);

int  lj_confirm(GtkWidget *parent, const char *title, const char *msg);
void lj_message(GtkWidget *parent, MessageType type, gboolean forgettable, const char *title, const char *message, ...);
void lj_messagebox(GtkWidget *parent, const char *title, const char *message);
void lj_warning(GtkWidget *parent, const char *msg, ...);

void lj_cli_note(const char *msg, ...);
/* field_strdup_printf("a %2 c %1", "d", "b") -> "a b c d" */
char* field_strdup_printf(char *fmt, char* fields[]);

void lj_win_set_icon(GtkWidget *win);

void string_replace(char **dest, const char *src);
void strtoupper(char *str);

/*
gdk_color_parse() does exactly this:
void hex_to_gdkcolor(const char *buf, GdkColor *c);
*/
void gdkcolor_to_hex(GdkColor *color, char* buf);

/* wrap this widget in a scrollarea */
GtkWidget* scroll_wrap(GtkWidget *w);

/* load/save this window's geometry */
void geometry_save(GtkWidget *win, Geometry *geom);
void geometry_load(GtkWidget *win, Geometry *geom);
/* tie a geometry struct to a window */
void geometry_tie (GtkWidget *win, GeometryType g);

unsigned char* urldecode(char *string);
char* urlencode(unsigned char *string);

const char* util_skipline(const char *text);
char* util_getline(const char *text);

#define unref_and_null(x) if (x) { g_object_unref(G_OBJECT(x)); x = NULL; }

int verify_dir(const char *path);

void md5_hash(const char *src, char *dest);

gint text_sort_func(GtkTreeModel *model, GtkTreeIter  *a, GtkTreeIter  *b, gpointer data);

void lj_widget_set_visible(GtkWidget *w, gboolean visible);

#endif /* util_h */
