/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: spawn.c,v 1.7 2002/11/10 08:30:12 martine Exp $
 */

#include "config.h"

#include <glib.h>
#include <stdio.h>

#ifndef G_OS_WIN32
#include <unistd.h>

#include <sys/types.h>
#include <sys/wait.h>
#endif
#include <signal.h>

#include "conf.h"
#include "util.h"
#include "spawn.h"

char *spawn_commands[] = {
	"mozilla -remote 'openURL(\"%s\", new-window)' || mozilla \"%s\"",
	"phoenix -remote 'openURL(\"%s\", new-window)' || phoenix \"%s\"",
	"gnome-moz-remote --newwin \"%s\"",
	"galeon \"%s\"", /* galeon is clearly the smartest one here,
						because it doesn't need shell trickery to DWIM. */
	"netscape -remote 'openURL(\"%s\", new-window)' || netscape \"%s\"",
	"opera -remote 'openURL(%s,new-window)' || opera %s", /* note no space */
	NULL
};

void
spawn_url(GtkWidget *parent, const char *url) {
	char cmd[2000]; /* XXX */
	GError *err = NULL;

	/* and now, another hack because I don't know how many %s's
	 * are in spawn_command. :( */
#define ARGS_HACK url,url,url,url,url,url
	g_snprintf(cmd, 2000, conf.spawn_command, ARGS_HACK);

	if (!g_spawn_command_line_async(cmd, &err)) {
		lj_warning(parent, _("Error spawning URL '%s': %s\n"),
				url, err->message);
		g_error_free(err);
	}
}
