/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: network.h,v 1.4 2002/10/03 01:11:43 martine Exp $
 */

#ifndef network_h
#define network_h

#include <gtk/gtkwidget.h>

typedef GHashTable NetRequest;
typedef GHashTable NetResult;

NetRequest* net_request_new(const char *mode);
NetResult* net_request_run_silent(NetRequest *request);
NetResult* net_request_run(GtkWidget *parent, const char *title, NetRequest *req);
NetResult* net_request_run_cli(NetRequest *request);
#define net_request_set(r, k, v) g_hash_table_insert(r, k, v)
#define net_request_seti(r, k, v) g_hash_table_insert(r, g_strdup(k), g_strdup_printf("%d", v))
#define net_request_sets(r, k, v) net_request_set(r, g_strdup(k), v)
#define net_request_copys(r, k, v) net_request_sets(r, k, g_strdup(v))
#define net_request_free(r) hash_destroy(r)

int net_result_succeeded(NetResult *result);
#define net_result_get(r, k) g_hash_table_lookup(r, k)
int net_result_geti(NetResult *result, const char *key);
char* net_result_getf(NetResult* result, const char *key, ...);
char* net_result_get_prefix(NetResult *result, const char *prefix, const char *key);
#define net_result_free(r) hash_destroy(r)

#endif /* network_h */
