/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: music.c,v 1.1 2002/11/26 04:26:42 martine Exp $
 */

#include "config.h"

#include <gtk/gtk.h>

#if XMMS_TYPE == XMMS_TYPE_LINK
#include <xmmsctrl.h>
#elif XMMS_TYPE == XMMS_TYPE_RUNTIME
#include <dlfcn.h> /* dlopen */
#elif XMMS_TYPE == XMMS_TYPE_ERROR
#error XMMS_TYPE is set incorrectly by configure.in.  This is a bug!  Report it!
#endif

#include "music.h"

GQuark
music_error_quark(void) {
	static GQuark quark = 0;
	if (quark == 0)
		quark = g_quark_from_static_string("music-error-quark");
	return quark;
}

typedef enum {
	MUSIC_DLOPEN_ERROR,
	MUSIC_DLSYM_ERROR
} MusicError;

#if XMMS_TYPE == XMMS_TYPE_RUNTIME
static void *xmms_dl = NULL; /* for dlopen(). */

gboolean
music_can_detect(GError **err) {
	if (xmms_dl == NULL) {
		const char *filename = "libxmms.so.1";
		xmms_dl = dlopen(filename, RTLD_LAZY);
		if (!xmms_dl) {
			g_set_error(err, MUSIC_ERROR, MUSIC_DLOPEN_ERROR,
					"error dlopen()ing %s: %s", filename, dlerror());
			return FALSE; /* no library; don't use xmms. */
		}
	}
	return TRUE;
}

/* FIXME
 * use GModule for this for better portability. */
char*
music_detect(GError **err) {
	gint pos;
	gchar *text;
	/*
	 * we do some wackyness here to avoid statically linking with XMMS.
gint xmms_remote_get_playlist_pos(gint session);
gchar *xmms_remote_get_playlist_title(gint session, gint pos);
	*/
	static gint (*xrgpp)(gint) = NULL;
	static gchar* (*xrgpt)(gint, gint) = NULL;

	if (xrgpp == NULL || xrgpt == NULL) {
		const char *xrgppname = "xmms_remote_get_playlist_pos";
		const char *xrgptname = "xmms_remote_get_playlist_title";

		xrgpp = dlsym(xmms_dl, "xmms_remote_get_playlist_pos");
		if (xrgpp == NULL) {
			g_set_error(err, MUSIC_ERROR, MUSIC_DLSYM_ERROR,
					"error dlsym()ing for %s: %s", xrgppname, dlerror());
			return NULL;
		}
		xrgpt = dlsym(xmms_dl, "xmms_remote_get_playlist_title");
		if (xrgpp == NULL) {
			g_set_error(err, MUSIC_ERROR, MUSIC_DLSYM_ERROR,
					"error dlsym()ing for %s: %s", xrgptname, dlerror());
			return NULL;
		}
	}
	
	pos = xrgpp(0);
	text = xrgpt(0, pos);

	return text;
}
/* XMMS_TYPE_RUNTIME */
#elif XMMS_TYPE == XMMS_TYPE_LINK
char*
music_detect(GError **err) {
	gint pos;
	gchar *text;

	pos = xmms_remote_get_playlist_pos(0);
	text = xmms_remote_get_playlist_title(0, pos);

	return text;
}

gboolean
music_can_detect(GError **err) {
	return TRUE;
}

#else

char*
music_detect(GError **err) {
	return NULL;
}
gboolean
music_can_detect(GError **err) {
	return FALSE;
}

#endif /* XMMS_TYPE */ 

