/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: lj.h,v 1.17 2002/10/29 03:59:59 martine Exp $
 */

#ifndef lj_h
#define lj_h

#include "ljtypes.h"
#include "checkfriends.h"

typedef struct {
	GtkWindow win; /* super class */

	/*        < 0: draft
	 * itemid = 0: unknown itemid
	 *        > 0: known itemid
	 */
	int itemid;
	gboolean isdirty; /* set when the user has changed the entry. */

	/* menu items. */
	GtkWidget *mjournal;
	GtkWidget *mweb, *mloginout, *msubmitsep, *msubmit, *msaveserver; 
	GtkWidget *musejournal, *musejournalsep, *musejournal_defaultjournal;
	GtkWidget *mconsole;

	GtkWidget *lstatus; /* status bar: shows current usejournal */
	GtkWidget *baction, *laction; /* "action" button and its label: 
	                                 submit / save changes */
	GtkWidget *bdelete; /* "delete" button */
	GtkWidget *eentry;

	GtkWidget *metamgr;
	CFMgr* cfmgr;
	CFIndicator *cfi_main, *cfi_float;
} LJWin;

void lj_font_set(GtkWidget *w, gchar *font_name);
void lj_run(Entry *entry);
void lj_do_loginout(LJWin *ljw, int autolog);
void lj_update_usejournal(LJWin *ljw);
void lj_load_entry(LJWin *ljw, Entry *entry);
void lj_clear_entry(LJWin *ljw);
void lj_insert_file(LJWin *ljw, const char *filename);
gboolean lj_confirm_lose_entry(LJWin *ljw);

void lj_open_entry(LJWin *ljw);
void lj_save_entry(LJWin *ljw);
void lj_submit_entry(LJWin *ljw);
void lj_save_entry_server(LJWin *ljw);
void lj_quit(LJWin *ljw);
void lj_autosave_init(LJWin *ljw);
void lj_autosave_stop(LJWin *ljw);

CFIndicator* make_cf_float(CFMgr *cfm, GtkWidget *parent);

#endif /* lj_h */


