/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: icons.c,v 1.5 2002/09/17 21:28:30 martine Exp $
 */

#include <gtk/gtkiconfactory.h>

#include "icons.h"
#include "../images/pixbufs.h"

static GdkPixbuf*
inline_to_listpixbuf(const guint8 *data) {
	GdkPixbuf *pb, *spb;
	gint width, height, sourcewidth, sourceheight;

	gtk_icon_size_lookup(GTK_ICON_SIZE_MENU, &width, &height);
	height -= 5; /* FIXME: slightly smaller looks good, but it shouldn't. */
	pb = gdk_pixbuf_new_from_inline(-1, data, FALSE, NULL);

	/* now adjust width to be proportionate to the height for this icon. */
	sourceheight = gdk_pixbuf_get_height(pb);
	sourcewidth = gdk_pixbuf_get_width(pb);
	width = sourcewidth * height / sourceheight;

	spb = gdk_pixbuf_scale_simple(pb, width, height, GDK_INTERP_BILINEAR);
	g_object_unref(pb);
	
	return spb;
}
GdkPixbuf*
icons_rarrow_pixbuf(void) {
	return inline_to_listpixbuf(logjam_rarrow);
}
GdkPixbuf*
icons_larrow_pixbuf(void) {
	return inline_to_listpixbuf(logjam_larrow);
}
GdkPixbuf*
icons_lrarrow_pixbuf(void) {
	return inline_to_listpixbuf(logjam_lrarrow);
}


static void
add(GtkIconFactory *factory,
		const guchar *inline_data,
		const gchar *stock_id) {
	GtkIconSet *set;
	GtkIconSource *source;
	GdkPixbuf *pixbuf;

	set = gtk_icon_set_new();
	source = gtk_icon_source_new();

	pixbuf = gdk_pixbuf_new_from_inline(-1, inline_data, FALSE, NULL);
	g_assert(pixbuf);
	gtk_icon_source_set_pixbuf(source, pixbuf);
	g_object_unref(G_OBJECT(pixbuf));

	gtk_icon_set_add_source(set, source);
	//gtk_icon_source_free(source);
	gtk_icon_factory_add(factory, stock_id, set);
	gtk_icon_set_unref(set);
}

void
icons_initialize(void) {
	GtkIconFactory *factory;

	factory = gtk_icon_factory_new();
	add(factory, logjam_goat, "logjam-goat");
	add(factory, logjam_pencil, "logjam-server");
	add(factory, logjam_userinfo, "logjam-user");
	add(factory, logjam_community, "logjam-community");
	add(factory, logjam_music, "logjam-music");
	add(factory, logjam_mood, "logjam-mood");
	add(factory, logjam_protected, "logjam-protected");
	add(factory, logjam_private, "logjam-private");
	add(factory, logjam_cfriends_on, "logjam-cfriends-on");
	add(factory, logjam_cfriends_off, "logjam-cfriends-off");
	add(factory, logjam_cfriends_new, "logjam-cfriends-new");
	gtk_icon_factory_add_default(factory);
}

void
icons_load_throbber(GdkPixbuf *pbs[]) {
	const guint8 *data;
	int i;
	GdkPixbuf *pb;
	gint w, h;

	gtk_icon_size_lookup(GTK_ICON_SIZE_DIALOG, &w, &h);

	for (i = 0; i < THROBBER_COUNT; i++) {
		switch (i) {
			case 0: data = logjam_throbber_1; break;
			case 1: data = logjam_throbber_2; break;
			case 2: data = logjam_throbber_3; break;
			case 3: data = logjam_throbber_4; break;
			case 4: data = logjam_throbber_5; break;
			case 5: data = logjam_throbber_6; break;
			case 6: data = logjam_throbber_7; break;
			case 7: data = logjam_throbber_8; break;
			default:
				g_warning("tried to load unknown throbber %d.", i);
				return;
		}
		pb = gdk_pixbuf_new_from_inline(-1, data, FALSE, NULL);
		pbs[i] = gdk_pixbuf_scale_simple(pb, w, h, GDK_INTERP_BILINEAR);
		g_object_unref(G_OBJECT(pb));
	}
}
