%define prefix          /usr
%define sysconfdir      /etc
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

%{?withgnome:Name: logjam}
%{!?withgnome:Name: logjam}
Version: 3.0.4
%{?withgnome:Summary: The GTK+-client for LiveJournal (with GNOME)}
%{!?withgnome:Summary: The GTK+-client for LiveJournal}
Release: %rel
Source: http://logjam.danga.com/download/logjam-%{version}.tar.gz
Prereq: curl >= 7.9
BuildRequires: curl-devel
URL: http://logjam.danga.com
Epoch: 1

Copyright: GPL
Group: X11/Applications
Vendor: Evan Martin <evan@livejournal.com>
Packager: Tom "spot" Callaway <tcallawa@redhat.com>
BuildRoot: %{_tmppath}/logjam-%{version}.root
Obsoletes: loserjabber

%description
This is the new GTK+ client for LiveJournal (http://www.livejournal.com).
%{?withgnome:This build has added support for GNOME.}

%prep
%setup  -n logjam-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" ; export CFLAGS
%{?withgnome:%configure --with-xmms=runtime --with-gnome}
%{!?withgnome:%configure --with-xmms=runtime --without-gnome}

%install
mkdir -p $RPM_BUILD_ROOT
%makeinstall

%files
%defattr(-,root,root)
%{_bindir}/logjam
%{_mandir}/man1/logjam.1.gz
%doc README AUTHORS COPYING ChangeLog INSTALL NEWS TODO 

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Mon Jan 07 2002 Tom "spot" Callaway <tcallawa@redhat.com>
 - 3.0.2 release, spec cleanups
* Mon Nov 12 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - 3.0.1 release, lots of new features/bugfixes. 
* Fri Sep 07 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Rebuild without ssl for compat. :~(
* Thu Sep 06 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Removed curl-devel from the Prereq: to BuildRequires:
* Sat Jul 14 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Point release, out of CVS finally
* Wed Jun 27 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Compilation fixes. Window geometry saving patch (decklin). Autologin
 - Check for libcurl in configure. Fixed GtkSpell and position of metadata.
* Mon Jun 11 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Timmay! Timmay! Gobbles! (Evan cleanups)
* Mon Jun 04 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Client renamed to logjam, this adds some prereqs and needs more spec fixes.
* Tue May 15 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Patch stripped. all livejournal.com urls removed in anticipation of rename
* Tue May 15 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Many fixes, specific patch to fix proxy.
* Sun Mar 25 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Added fix for James Manning, Web Links browser launch
* Tue Feb 13 2001 Tom "spot" Callaway <tcallawa@redhat.com>
 - Upgraded to add GNOME build option.
* Sun Oct 08 2000 Alexander Grfe <nachtfalke@retrogra.de>
 - inital version of the RPM.
