/* $Id: login_ldap.h,v 1.2 2007/10/25 11:43:32 merdely Exp $ */
#ifndef __login_ldap_h
#define __login_ldap_h

#include <sys/time.h>

/* login.conf strings */
#define CAP_LDAP_SERVER		"x-ldap-server"
#define CAP_LDAP_BASEDN		"x-ldap-basedn"
#define CAP_LDAP_FILTER		"x-ldap-filter"
#define CAP_LDAP_BINDDN		"x-ldap-binddn"
#define CAP_LDAP_BINDPW 	"x-ldap-bindpw"
#define CAP_LDAP_GROUPFILTER 	"x-ldap-groupfilter"
#define CAP_LDAP_GROUPDN	"x-ldap-groupdn"
#define CAP_LDAP_TIMEOUT	"x-ldap-timeout"
#define CAP_LDAP_USCOPE		"x-ldap-uscope"
#define CAP_LDAP_GSCOPE		"x-ldap-gscope"
#define CAP_LDAP_NOREFERRALS	"x-ldap-noreferrals" /* bool */
#define CAP_LDAP_CACERT		"x-ldap-cacert"
#define CAP_LDAP_CACERTDIR	"x-ldap-cacertdir"
#define CAP_LDAP_USERCERT	"x-ldap-usercert"
#define CAP_LDAP_USERKEY	"x-ldap-userkey"
#define CAP_LDAP_REFKEEPCREDS	"x-ldap-refkeepcreds"

#define DEFTIMEOUT	60 /* number of seconds to wait before a timeout */

/* servinfo modes */
#define MODE_CLEAR	0
#define MODE_STARTTLS	1
#define MODE_SSL	2

struct servinfo {
	char *host;
	int port;
	int mode;
	int version;
};

struct auth_ctx {
	login_cap_t	*lc; 	/* login_cap handle */
	char		*class; /* login class mainly used for debug info */
	char		*user; 	/* the user to authenticate */
	LDAP *		ld;	/* ldap server connection */
	struct servinfo	s;	/* info about the server */
	char		*basedn;/* base dn for search, may be null */
	char		*binddn;/* bind dn for search, may be null */
	char		*bindpw;/* bind password for search, may be null */
	char		*lasterr; /* error message of last error */
	char		*cacert; /* path to CA ssl certificate */
	char		*cacertdir;
	char		*usercert; /* path to user ssl certificate */
	char		*userkey; /* path to user key */
	char		*userdn; /* dn as returned from search */
	char		*ufilter;
	int		uscope;
	char 		*gfilter; 
	char		*groupdn;
	int		gscope;
	int		noref;
	int		keepcreds;
	struct	timeval	tv;
};

/* util.c */
void	dlog(int, char *, ...);
int	load_ssl_certs(struct auth_ctx *);
int	conn(struct auth_ctx *);
int	do_conn(struct auth_ctx *);
int	get_bind_defaults(struct auth_ctx *);
int	get_misc(struct auth_ctx *);
int	get_usearch_defaults(struct auth_ctx *);
int	get_gsearch_defaults(struct auth_ctx *);
char *	parse_filter(struct auth_ctx *, char *);
extern int debug;

/* bind.c */
int 	bind_password(struct auth_ctx *, char *, char *);
int	unbind(struct auth_ctx *);

/* search.c */
char * search(struct auth_ctx *, char *, char *, int);
#endif /* __login_ldap_h */
