/*
 * lxnetbus.c, part of the Linux NetBus Client, by noupe @ #hack.se/efnet
 *
 * Linux NetBus Client Version 0.4
 *
 * 
 * Greets to Creed, Happy-H, _preD, r1bbe, peltier, ppz
 * and everyone else on #hack.se/efnet
 *
 * To compile, just type make
 * 
 */

#include "lxnetbus.h"

char remoteHost[BUFSIZE];
char wingateproxy[BUFSIZE];
char statusMsg[BUFSIZE];
char netbusServer[BUFSIZE];
char disabledKeys[BUFSIZE];
char *dialogs[] = {
  INFO_O, INFO_OC, INFO_YNC, INFO_YN, INFO_RC,
  QUESTION_O, QUESTION_OC, QUESTION_YNC, QUESTION_YN, QUESTION_RC,
  WARN_O, WARN_OC, WARN_YNC, WARN_YN, WARN_RC 
  STOP_O, STOP_OC, STOP_YNC, STOP_YN, STOP_RC
};

int netbus_sock;
int usewingate;
int scanning;
int isConnected;
int cdromstatus;
int keyclick;
int mouse_state;
    

int main()
{
  int ret=MAINMENU;

  al_root = NULL;
  nbsighandler(-1);
  nbreset();
  while(ret)
  {
    CLEARSCREEN;
    printf("Linux NetBus Client v0.4, by noupe\n");
    printf("Connected    [ %s ]\n", ((isConnected)? "Yes": "No") );
    printf("Remote host  [ %s ]\n", ((isConnected)? remoteHost: "/dev/null"));
    printf("Status       [ %s ]\n\n", ((statusMsg[0])? statusMsg: "?"));
    ret = pMenu();
    switch(ret)
    {
      case MAINMENU:
        pMenu = mainmenu;
        break;

      case MISCMENU:
        pMenu = miscmenu;
        break;

      case MSGMENU:
        pMenu = msgmenu;
        break;

      case KEYMENU:
        pMenu = keymenu;
        break;

      case WINMENU:
        pMenu = winmenu;
        break;

      case FILEMENU:
        pMenu = filemenu;
        break;

      case EXITMENU:
        pMenu = exitmenu;
        break;

      case ADMINMENU:
        pMenu = adminmenu;
        break;

      default:
        break;
    }
  }

  return 1;
}
