/****************************************************************************
** $Id: main.cpp,v 1.2 1999/11/29 23:29:55 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <sys/time.h>
#include <unistd.h>

//----------------------------------------------------------------------------

#include <qapplication.h>
#include <qplatinumstyle.h>

//----------------------------------------------------------------------------

#include "lincvs.h"

//----------------------------------------------------------------------------

int timeZoneDiffInSecs;

int main( int argc, char ** argv ) 
{
   //get timezone...
   struct timeval timeVal;
   struct timezone timeZone;
   gettimeofday(&timeVal, &timeZone);
   timeZoneDiffInSecs = timeZone.tz_minuteswest * 60;

   QApplication::setStyle(new QPlatinumStyle());
   QApplication a( argc, argv );

   ApplicationWindow * mw = new ApplicationWindow();
   mw->setCaption( "LinCVS" );
   mw->show();
   a.setMainWidget(mw);
   a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
   return a.exec();
}
