/****************************************************************************
** $Id: lincvs.cpp,v 1.19 1999/12/14 02:17:18 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <unistd.h>
#include <stdlib.h>

//----------------------------------------------------------------------------

#include <qapplication.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qaccel.h>
#include <qsplitter.h>
#include <qfontdialog.h> 
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstringlist.h>

//----------------------------------------------------------------------------

//themes
#include <qwindowsstyle.h>
#include <qplatinumstyle.h>
#include <qmotifstyle.h>
#include <qcdestyle.h>

#include "wood.h"
#include "metal.h"

//----------------------------------------------------------------------------

#include "pix.h"

//----------------------------------------------------------------------------

#include "lincvs.h"
#include "directory.h"
#include "globals.h"
#include "dialogs.h"

//----------------------------------------------------------------------------

bool globalStopAction;
QStatusBar *globalStatusBar;
QString cvsRsh;

//----------------------------------------------------------------------------

ApplicationWindow::ApplicationWindow()
    : QMainWindow( 0, "LinCVS main window", WDestructiveClose )
{
   cvsRsh = getenv("CVS_RSH");
   
   m_uninterruptible = false;
   globalStopAction = false;
   m_showWarning = true;
   
   //init pixmaps
   m_pFurled = new QPixmap(folder_closed_xpm);
   m_pExpanded = new QPixmap(folder_open_xpm);
   
   globalStatusBar = statusBar();
   initMenuAndToolbar();
   initComponents();

   statusBar()->message( tr("Scan Project Directories"), 4000 );

   QTimer::singleShot(100, this, SLOT(initialDirScanning()));
}

//----------------------------------------------------------------------------

ApplicationWindow::~ApplicationWindow()
{
   delete m_pCommitDlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::initialDirScanning()
{
   readCfg();
   for(unsigned int i = 0; i < m_projectNameList.count(); i++) {
      if(globalStopAction){
         statusBar()->message( tr("Scanning aborted"), 4000 );
         QStringList tmpList;
         unsigned int j;
         for(j = i; j < m_projectNameList.count(); j++) {
            tmpList.append(m_projectNameList[j]);
         }
         for(j = 0; j < tmpList.count(); j++) {
            m_projectNameList.remove(tmpList[j]);
         }

         i = m_projectNameList.count();
      }
      else {
         addProject(m_projectNameList[i]);
      }
   }
   
   m_lastOpenedDir = getenv("HOME");
 
   statusBar()->message( tr("Ready"), 4000 );
   globalStopAction = false;
   writeCfg();
}

//----------------------------------------------------------------------------

void ApplicationWindow::initMenuAndToolbar()
{
   //menu
   QPopupMenu * file = new QPopupMenu( this );
   menuBar()->insertItem( tr("&File"), file );
   file->insertItem( tr("&Quit"), qApp, SLOT( closeAllWindows() ), CTRL+Key_Q );
   
   QPopupMenu * admin = new QPopupMenu( this );
   menuBar()->insertItem( tr("&Administration"), admin);
   admin->insertItem( tr("Checkout"), this, SLOT(checkOut()), Key_F3);
   admin->insertItem( tr("Import"), this, SLOT(import()), Key_F4);
   admin->insertSeparator();
   admin->insertItem( tr("Set Remote Shell"), this, SLOT(setCvsRsh()), Key_F7);
   
   QPopupMenu * workBench = new QPopupMenu( this );
   menuBar()->insertItem( tr("&Project-Explorer"), workBench );
   workBench->insertItem( tr("Add to Workbench"), this, SLOT(addProjectSlot()), Key_F5);

   QPopupMenu *options = new QPopupMenu(this);
   menuBar()->insertItem( tr("&Options"), options );
   options->insertItem( tr("Font"), this, SLOT(setFont()), CTRL+Key_F);
   
	QPopupMenu * style = new QPopupMenu( this );
	style->setCheckable( TRUE );
   options->insertItem( tr("&Style"), style);

   m_sMetal = style->insertItem( tr("&Metal"), this, SLOT( styleMetal() ) );
   m_sWood = style->insertItem( tr("&Norwegian Wood"), this, SLOT( styleWood() ) );
   m_sPlatinum = style->insertItem( tr("&Platinum") , this ,SLOT( stylePlatinum() ) );
   m_sWindows = style->insertItem( tr("&Windows"), this, SLOT( styleWindows() ) );
   m_sCDE = style->insertItem( tr("&CDE"), this, SLOT( styleCDE() ) );
   m_sMotif = style->insertItem( tr("M&otif"), this, SLOT( styleMotif() ) );


   //this one is the last menu!
   QPopupMenu * help = new QPopupMenu( this );
   menuBar()->insertSeparator();
   menuBar()->insertItem( tr("&Help"), help );

   help->insertItem( tr("&About"), this, SLOT(about()));
   help->insertItem( tr("Help"), this, SLOT(help()), Key_F1);
   help->insertSeparator();
   help->insertItem( tr("About&Qt"), this, SLOT(aboutQt()));

   
   //toolbar
   m_pTools = new QToolBar(this, "tools");
   QPixmap stopIcon = QPixmap(stop_xpm);
   m_pStopAction = new QToolButton( stopIcon, 
                                    tr("Stop Action"), QString::null,
                          			   this, SLOT(stopCurAction()), m_pTools, 
                                    "stop action" );
   m_pStopAction->setEnabled(false);
}

//----------------------------------------------------------------------------

void ApplicationWindow::initComponents()
{
   resize( 600, 400 );

   QSplitter *splitter = new QSplitter(QSplitter::Horizontal, this);

   //create menu for cvsdirlistview
   QPopupMenu *menu = new QPopupMenu(this);
   menu->insertItem(tr("Status"), this, SLOT(statusDir()));
   menu->insertItem(tr("Diffs"), this, SLOT(diffDir()));
   menu->insertItem(tr("Log"), this, SLOT(logDir()));
   menu->insertItem(tr("History"), this, SLOT(historyDir()));
   menu->insertSeparator();
   menu->insertItem(tr("Update"), this, SLOT(updateDir()));
   menu->insertItem(tr("Commit"), this, SLOT(commitDir()));
   menu->insertItem(tr("Tag"), this, SLOT(tagDir()));
   menu->insertSeparator();
   menu->insertItem(tr("Add File"), this, SLOT(addFiles()));
   menu->insertSeparator();
   menu->insertItem(tr("Login"), this, SLOT(loginDir()));
   menu->insertSeparator();
   menu->insertItem(tr("Reread Directory"), this, SLOT(rereadProject()));
   menu->insertItem(tr("Remove From Workbench"), this, SLOT(removeProjectSlot()));
   menu->insertSeparator();
   menu->insertItem(tr("Properties"), this, SLOT(showDirProperties()));
   menu->insertSeparator();
   QPopupMenu *revisionsMenu = new QPopupMenu(this);
   menu->insertItem(tr("Other Revisions"), revisionsMenu);
   revisionsMenu->insertItem(tr("Update"), this, SLOT(updateRevDir()));

   m_pWorkBenchTree = new CvsDirListView(menu, splitter);
   m_pWorkBenchTree->addColumn(tr("Work Bench"));
   m_pWorkBenchTree->setRootIsDecorated(true);
   
   splitter->setResizeMode(m_pWorkBenchTree, QSplitter::KeepSize );   
   QValueList <int> splitterPos;
   splitterPos.append(150);
   splitter->setSizes(splitterPos);
   setCentralWidget(splitter);

   QSplitter *splitter2 = new QSplitter(QSplitter::Vertical, splitter);
   QValueList <int> splitterPos2;
   splitterPos2.append(150);

   //create menu for cvsfilelistview
   menu = new QPopupMenu(this);
   menu->insertItem(tr("Status"), this, SLOT(statusFile()));
   menu->insertItem(tr("Diffs"), this, SLOT(diffFile()));
   menu->insertItem(tr("Log"), this, SLOT(logFile()));
   menu->insertItem(tr("History"), this, SLOT(historyFile()));
   menu->insertSeparator();
   menu->insertItem(tr("Update"), this, SLOT(updateFile()));
   menu->insertItem(tr("Commit"), this, SLOT(commitFile()));
   menu->insertItem(tr("Tag"), this, SLOT(tagFile()));
   menu->insertSeparator();
   menu->insertItem(tr("Remove"), this, SLOT(removeFile()));
   menu->insertSeparator();
   revisionsMenu = new QPopupMenu(this);
   menu->insertItem(tr("Other Revisions"), revisionsMenu);
   revisionsMenu->insertItem(tr("Update"), this, SLOT(updateRevFile()));
   
   m_pFileList = new CvsListView(menu, splitter2);
   m_pFileList->setMultiSelection(true);
   m_pFileList->addColumn(tr("Name"));
   m_pFileList->addColumn(tr("Rev."));
   m_pFileList->addColumn(tr("State"));
   m_pFileList->addColumn(tr("Committed"));
   m_pFileList->addColumn(tr("Modified (local)"));
   m_pFileList->addColumn(tr("Modified (UTC)"));
//   fileList->addColumn(tr("Letzter Bearbeiter"));
   splitter2->setResizeMode(m_pFileList, QSplitter::KeepSize );   
   splitter2->setSizes(splitterPos2);
   
   m_pMessages = new QMultiLineEdit( splitter2);
   m_pMessages->setReadOnly(true);
   
   //create commitDlg
   m_pCommitDlg = new QDialog(this, 0, true);   //modal
   m_pCommitDlg->setCaption(tr("Comment for Committing"));
   
   QBoxLayout *layer = new QVBoxLayout(m_pCommitDlg, 5);
   m_pComment = new QMultiLineEdit(m_pCommitDlg);
   m_pComment->setMinimumWidth(400);
   layer->addWidget(m_pComment);

   QWidget *backGround = new QWidget(m_pCommitDlg);
   layer->addWidget(backGround);

   QBoxLayout *buttonLayer = new QHBoxLayout(backGround, 3);
   buttonLayer->addStretch();
   
   QPushButton *ok = new QPushButton(backGround);
   ok->setText(tr("OK"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(backGround);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();
   
   connect(ok, SIGNAL(clicked()), m_pCommitDlg, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), m_pCommitDlg, SLOT(reject()));
   
   connect(&m_timer, SIGNAL(timeout()), this, SLOT(checkStatus()));
}

//----------------------------------------------------------------------------

void ApplicationWindow::checkOut()
{
   CheckOutAndImportDlg *dlg = new CheckOutAndImportDlg(&m_tagList, 
                                   false, tr("Checkout Module"), this);   //modal
   if(dlg->exec()){//ok
      QString command;
      QString cvsRoot;
      
      QDir localDir(dlg->localDir());
      if(!localDir.exists()) {
         if(!localDir.mkdir(dlg->localDir())) {
            QMessageBox::warning(0, tr("Warning"), tr("Couldnt create local dir ") 
                                 + dlg->localDir() + ".", 0);
            delete dlg;
            return;
         }
      }

      statusBar()->clear();

      QString localDirectory = localDir.absPath();
      
      command = "";   //initialize
      
      if(dlg->mode() == MODE_PSERVER){//password server
         //set CVSROOT for pserver mode
         cvsRoot = ":pserver:" + dlg->user() + "@" + dlg->server() + ":";

         if(!isInCvsPass(cvsRoot + dlg->repository())){
            login(cvsRoot + dlg->repository());
            qApp->processEvents(100);
            sleep(1);
            qApp->processEvents(100);
            
            if(!isInCvsPass(cvsRoot + dlg->repository())) {
               QMessageBox::warning(0, tr("Warning"), tr("Login failed."), 0);
               delete dlg;
               return;
            }
         }
      }
      else
      if(dlg->mode() == MODE_RSH) {//remote shell access
         cvsRsh = dlg->cvsRsh();
         if(dlg->rshMode() == RSH_EXT) {
            cvsRoot = ":ext:";
            command = "export CVS_RSH=" + cvsRsh + "&& ";
         }
         else cvsRoot = ":server:";
        
         cvsRoot += dlg->user() + "@" + dlg->server() + ":";
      }
         
      //set CVSROOT
      cvsRoot += dlg->repository();

      //spaeter noch evtl. slash am ende loeschen
 
      command += "cd ";
      command += localDirectory;
      command += " && cvs -d ";
      command += cvsRoot;
      command += " co -P ";
      if(!dlg->cvsParameter().isNull()) {
         command += dlg->cvsParameter() + " ";
      }
      command += dlg->module();
      command += " 2>&1";

      FILE* cvs = popen(command, "r");
      if(!cvs){
         //ordentliche fehlerbehandlung einbauen
         perror("popen");
         delete dlg;
         return;
      }

      centralWidget()->setCursor(waitCursor);
      m_pMessages->clear();
      
      char buf[512];
   
      while (fgets(buf, sizeof buf, cvs)) {
         QString str = buf;
         str.truncate(str.find("\n"));
         m_pMessages->append(str);
      }
   
      pclose(cvs);

      //cvs dir is already in workbench?
      bool isInWorkBench = false;
      Directory *myChild = (Directory*)(m_pWorkBenchTree->firstChild());
      while( myChild && !isInWorkBench) {
         if(localDirectory.find(myChild->fullName()) == 0) {
            isInWorkBench = true;
         }
         else {
            myChild = (Directory*)(myChild->nextSibling());
         }
      }
         
      if(isInWorkBench) {
         m_uninterruptible = true;
         m_pStopAction->setEnabled(true);
         menuBar()->setEnabled(false);
         myChild->addDir(localDirectory + "/" + dlg->module());
         myChild->setAllToUpToDate();
         m_pStopAction->setEnabled(false);
         if(globalStopAction){
            statusBar()->message( tr("Adding aborted"));
         }
         else {
            statusBar()->message( tr("Ready"));
         }
         globalStopAction = false;
         menuBar()->setEnabled(true);
         m_uninterruptible = false;
         
         m_timer.start(3000);
         QMessageBox::information (0, tr("Checkout Info"), tr("This project is now in workbench."), 0);
      }
      else {
         QDialog *dlgQuestion = new QDialog(0, 0, true);
         dlgQuestion->setCaption("Checkout Info");

         QBoxLayout *topLayer = new QVBoxLayout(dlgQuestion, 5);
         QLabel *label = new QLabel("Add this project to workbench?", dlgQuestion);
         topLayer->addWidget(label);
         topLayer->addSpacing(15);

         //create background widget and layer for "ok" and "cancel"
         QWidget *w = new QWidget(dlgQuestion);
         topLayer->addWidget(w);
         QBoxLayout *buttonLayer = new QHBoxLayout(w);
         buttonLayer->addStretch();
   
         //ok and cancel
         QPushButton *ok = new QPushButton(w);
         ok->setText(tr("Yes"));
         buttonLayer->addWidget(ok);
         buttonLayer->addStretch();
         QPushButton *cancel = new QPushButton(w);
         cancel->setText(tr("No"));
         buttonLayer->addWidget(cancel);
         buttonLayer->addStretch();

         connect(ok, SIGNAL(clicked()), dlgQuestion, SLOT(accept()));
         connect(cancel, SIGNAL(clicked()), dlgQuestion, SLOT(reject()));
         
         if(dlgQuestion->exec()) {
            m_uninterruptible = true;
            m_pStopAction->setEnabled(true);
            menuBar()->setEnabled(false);
            Directory * item = new Directory(m_pWorkBenchTree, localDirectory, m_pFileList);
            item->setAllToUpToDate();
            m_projectNameList.append(item->fullName());   //evtl. hier links aufloesen
            m_lastOpenedDir = item->fullName();
            m_lastOpenedDir.truncate(m_lastOpenedDir.findRev("/"));
            m_pStopAction->setEnabled(false);
            if(globalStopAction){
               statusBar()->message( tr("Adding aborted"));
            }
            else {
               statusBar()->message( tr("Ready"));
            }
            item->setOpen(true);
            globalStopAction = false;
            menuBar()->setEnabled(true);
            m_uninterruptible = false;
         
            m_timer.start(3000);
         }
      
         delete dlgQuestion;
      }
         

      centralWidget()->unsetCursor();
   }
   
   delete dlg;
   
   writeCfg();
}

//----------------------------------------------------------------------------

void ApplicationWindow::import()
{
   CheckOutAndImportDlg *dlg = new CheckOutAndImportDlg(&m_tagList, 
                                   true, tr("Import Module"), this);   //modal
   if(dlg->exec()){//ok
      QString command;
      QString cvsRoot;
      
      QDir localDir(dlg->localDir());
      if(!localDir.exists()) {
         QMessageBox::warning(0, tr("Warning"), tr("Directory ") + dlg->localDir() 
                              + tr(" doesnt exist."), 0, 1);
         delete dlg;
         return;
      }

      statusBar()->clear();

      QString localDirectory = localDir.absPath();

      command = "";   //initialize
      
      if(dlg->mode() == MODE_PSERVER){//password server
         //set CVSROOT for pserver mode
         cvsRoot = ":pserver:" + dlg->user() + "@" + dlg->server() + ":";
         
         if(!isInCvsPass(cvsRoot + dlg->repository())){
            login(cvsRoot + dlg->repository());
            qApp->processEvents(100);
            sleep(1);
            qApp->processEvents(100);
            
            if(!isInCvsPass(cvsRoot + dlg->repository())) {
               QMessageBox::warning(0, tr("Warning"), tr("Login failed."), 0);
               delete dlg;
               return;
            }
         }
      }   
      else
      if(dlg->mode() == MODE_RSH) {//remote shell access
         cvsRsh = dlg->cvsRsh();
         if(dlg->rshMode() == RSH_EXT) {
            cvsRoot = ":ext:";
            command = "export CVS_RSH=" + cvsRsh + "&& ";
         }
         else cvsRoot = ":server:";
        
         cvsRoot += dlg->user() + "@" + dlg->server() + ":";
      }
         
      //set CVSROOT
      cvsRoot += dlg->repository();

      //spaeter noch evtl. slash am ende loeschen
 
      command += "cd ";
      command += localDirectory;
      command += " && cvs -d ";
      command += cvsRoot;
      command += " import -m ";
      command += "\"" + dlg->comment() + "\" ";
      command += dlg->module() + " " + dlg->tag1() + " " + dlg->tag2();
      command += " 2>&1";

 
      FILE* cvs = popen(command, "r");
      if(!cvs){
         //ordentliche fehlerbehandlung einbauen
         perror("popen");
         delete dlg;
         return;
      }

      centralWidget()->setCursor(waitCursor);
      m_pMessages->clear();
      
      char buf[512];
   
      while (fgets(buf, sizeof buf, cvs)) {
         QString str = buf;
         str.truncate(str.find("\n"));
         m_pMessages->append(str);
      }
   
      pclose(cvs);
      centralWidget()->unsetCursor();
      statusBar()->message( tr("Ready"));
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::addProjectSlot()
{
   addProject();
}

//----------------------------------------------------------------------------

void ApplicationWindow::addProject(const char * fileName, bool expand)
{
   bool addNewProject = false;

   QString fn = fileName;
   if(fn.isEmpty()){//popup dialog
      addNewProject = true;
      fn = QFileDialog::getExistingDirectory(m_lastOpenedDir, this);
   }
   
   if ( !fn.isEmpty() ){
      if(addNewProject && m_projectNameList.findIndex(fn) > -1){
         QMessageBox::warning(0, tr("Warning"), tr("This project is already in workbench."), 0);
         statusBar()->message( tr("Adding aborted"), 4000 );
      }
      else {
         statusBar()->clear();
         m_uninterruptible = true;
         m_pStopAction->setEnabled(true);
         menuBar()->setEnabled(false);
         centralWidget()->setCursor(waitCursor);
         Directory * item = new Directory(m_pWorkBenchTree, fn, m_pFileList);
         if(addNewProject) m_projectNameList.append(item->fullName());   //evtl. hier links aufloesen
         m_lastOpenedDir = item->fullName();
         m_lastOpenedDir.truncate(m_lastOpenedDir.findRev("/"));
         centralWidget()->unsetCursor();
         m_pStopAction->setEnabled(false);
         if(addNewProject){
            if(globalStopAction){
               statusBar()->message( tr("Adding aborted"));
            }
            else {
               statusBar()->message( tr("Ready"));
            }
            globalStopAction = false;
            item->setOpen(true);
         }
         else {
            if(expand) item->setOpen(true);
         }
         menuBar()->setEnabled(true);
         m_uninterruptible = false;
         
         m_timer.start(3000);
      }
   }
   else
      statusBar()->message( tr("Adding aborted"));
      
   if(addNewProject) writeCfg();
}

//----------------------------------------------------------------------------

void ApplicationWindow::removeProjectSlot()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();

   if(!dir) return;

   bool dirRemoved = false;
   for(unsigned int i = 0; i < m_projectNameList.count(); i++) {
      if(m_projectNameList[i].compare(dir->fullName()) == 0) {
         m_projectNameList.remove(dir->fullName());
         delete dir;
         i = m_projectNameList.count();
         writeCfg();
         dirRemoved = true;
      }
   }
      
   if(!dirRemoved)
      QMessageBox::information(0, tr("Information"), tr("This Directory is not a top level dir."), 0);
}

//----------------------------------------------------------------------------

void ApplicationWindow::rereadProject()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();

   if(!dir) return;

   QString dirName = dir->fullName();

   bool dirRemoved = false;
   for(unsigned int i = 0; i < m_projectNameList.count(); i++) {
      if(m_projectNameList[i].compare(dirName) == 0) {
         m_projectNameList.remove(dirName);
         delete dir;
         i = m_projectNameList.count();
         writeCfg();
         dirRemoved = true;
      }
   }
      
   if(!dirRemoved)
      QMessageBox::information(0, tr("Information"), tr("This Directory is not a top level dir."), 0);
   else {
      statusBar()->clear();
      addProject(dirName, true);      
      m_projectNameList.append(dirName);
      writeCfg();
      statusBar()->message( tr("Ready"));
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::showDirProperties()
{
   Directory *item = (Directory *)m_pWorkBenchTree->currentItem();

   if(!item) return;

//dialog und update dem akt. dir ueberlassen oder properties auslesen und hier erledigen?  
   QMessageBox::information(this, tr("Properties"), 
                            tr("Local Directory:") + "\t\t\t\t" + item->fullName() + "\n" +
                            tr("Repository:") + "\t\t\t\t" + item->repository() + "\n" +
                            tr("Root Directory:") + "\t\t\t\t" + item->rootDir() + "\n" +
                            tr("User Name:") + "\t\t\t\t" + item->userName() + "\n" +
                            tr("Host:") + "\t\t\t\t" + item->host() + "\n" +
                            tr("Connect Method:") + "\t\t\t\t" + item->connectMethod() + "\n"
                            );
}

//----------------------------------------------------------------------------

void ApplicationWindow::checkStatus()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();

   if(!dir) return;

   if(dir->entriesFileModified()){
      dir->activateItem();
      return;
   }
   QListViewItem *myChild = m_pFileList->firstChild();
   while(myChild) {
      if(m_pFileList->itemRect(myChild).isValid()) {
         dir->checkStatus(myChild);   
      }
      myChild = myChild->nextSibling();
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::statusDir()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();

   if(!dir) return;

   dir->statusOfDir(m_pMessages);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::updateDir()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();

   if(!dir) return;

   dir->updateDir(m_pMessages);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::updateRevDir()
{
   statusBar()->clear();
   TagUpdateDlg *dlg = new TagUpdateDlg(&m_tagList, tr("Update Other Revision"),
                                        this);
                                             
   if(dlg->exec()) {
      Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
      if(!dir) return;
      dir->updateDir(m_pMessages, dlg->cvsParameter());
   }
     
   statusBar()->message( tr("Ready"));
   
   delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::commitDir()
{
   if(m_pCommitDlg->exec()) {//ok
      statusBar()->clear();
      Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
      if(!dir) return;
      dir->commitDir(m_pMessages, m_pComment->text());
      statusBar()->message( tr("Ready"));
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::tagDir()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   TagDlg *dlg = new TagDlg(&m_tagList, tr("Tag a Directory"), this);

   int result = dlg->exec();
   if(result == 1) {//tag
      if(m_tagList.isEmpty()){
         QMessageBox::warning(0, tr("Warning"), tr("You must input a Tag"), 0);
      }
      else {
         statusBar()->clear();
         QString command = "tag " + m_tagList[0];
         dir->anyCommandDir(m_pMessages, command);
         statusBar()->message( tr("Ready"), 10000);
      }
   }
   else
   if(result == 2) {//branchtag
      if(m_tagList.isEmpty()){
         QMessageBox::warning(0, tr("Warning"), tr("You must input a Tag"), 0);
      }
      else {
         statusBar()->clear();
         QString command = "tag -b " + m_tagList[0];
         dir->anyCommandDir(m_pMessages, command);
         statusBar()->message( tr("Ready"));
      }
   }
   
   delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::logDir()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   QString command = "log";
   dir->anyCommandDir(m_pMessages, command);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::historyDir()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   QString command = "history";
   dir->anyCommandDir(m_pMessages, command);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::diffDir()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   QString command = "diff";
   dir->anyCommandDir(m_pMessages, command);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::loginDir()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   dir->loginOk(true);
}

//----------------------------------------------------------------------------

void ApplicationWindow::addFiles()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

//bug in qt :-(((
//   QStringList s(QFileDialog::getOpenFileNames(QString::null, dir->fullName()));
   QStringList s;
   QString f = QFileDialog::getOpenFileName(dir->fullName(), QString::null, this);
   if (!f.isEmpty()) {
      s.append(f);
   }

   if(!s.isEmpty()){
      statusBar()->clear();
      dir->addFiles(m_pMessages, &s);
      statusBar()->message( tr("Ready"));
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::updateFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   dir->updateFile(m_pMessages);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::updateRevFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   TagUpdateDlg *dlg = new TagUpdateDlg(&m_tagList, tr("Update Other Revision"),
                                        this);
                                             
   if(dlg->exec()) {
      dir->updateFile(m_pMessages, dlg->cvsParameter());
   }
     
   statusBar()->message( tr("Ready"));
   
   delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::statusFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;
   dir->statusOfFile(m_pMessages);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::commitFile()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   if(m_pCommitDlg->exec()) {//ok
      statusBar()->clear();
      dir->commitFile(m_pMessages, m_pComment->text());
      statusBar()->message( tr("Ready"));
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::tagFile()
{
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   TagDlg *dlg = new TagDlg(&m_tagList, tr("Tag File(s)"), this);

   int result = dlg->exec();
   if(result == 1) {//tag
      if(m_tagList.isEmpty()){
         QMessageBox::warning(0, tr("Warning"), tr("You must input a Tag"), 0);
      }
      else {
         statusBar()->clear();
         QString command = "tag " + m_tagList[0];
         dir->anyCommandFile(m_pMessages, command);
         statusBar()->message( tr("Ready"));
      }
   }
   else
   if(result == 2) {//branchtag
      if(m_tagList.isEmpty()){
         QMessageBox::warning(0, tr("Warning"), tr("You must input a Tag"), 0);
      }
      else {
         statusBar()->clear();
         QString command = "tag -b " + m_tagList[0];
         dir->anyCommandFile(m_pMessages, command);
         statusBar()->message( tr("Ready"));
      }
   }
   
   delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::logFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   QString command = "log";
   dir->anyCommandFile(m_pMessages, command);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::historyFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   QString command = "history";
   dir->anyCommandFile(m_pMessages, command);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::diffFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   QString command = "diff";
   dir->anyCommandFile(m_pMessages, command);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::removeFile()
{
   statusBar()->clear();
   Directory *dir = (Directory *)m_pWorkBenchTree->currentItem();
   if(!dir) return;

   dir->removeFile(m_pMessages, m_showWarning);
   statusBar()->message( tr("Ready"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::stopCurAction()
{
   globalStopAction = true;
}

//----------------------------------------------------------------------------

void ApplicationWindow::setCvsRsh()
{//provisorium
   QDialog dlg(this, "", true);
   dlg.setCaption("Set the Remote Shell!");
   
   QBoxLayout *topLayer = new QVBoxLayout(&dlg, 5);
   QBoxLayout *inputLayer = new QHBoxLayout(topLayer, 5);
   topLayer->addSpacing(15);
   QBoxLayout *buttonLayer = new QHBoxLayout(topLayer, 5);

   QLabel *label = new QLabel(tr("Remote Shell:"), &dlg);
   inputLayer->addWidget(label);
   
   QLineEdit*m_pRsh = new QLineEdit(&dlg);
   m_pRsh->setText(cvsRsh);
   inputLayer->addWidget(m_pRsh, 10);

   QPushButton *clear = new QPushButton(&dlg);
   clear->setText(tr("Clear"));
   inputLayer->addWidget(clear);
   connect(clear, SIGNAL(clicked()), m_pRsh, SLOT(clear()));

   buttonLayer->addStretch();
   QPushButton *ok = new QPushButton(&dlg);
   ok->setText(tr("Ok"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(&dlg);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();
   
   //hier die connects zum tag-slot
   connect(ok, SIGNAL(clicked()), &dlg, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), &dlg, SLOT(reject()));
   
   dlg.setMaximumHeight(dlg.sizeHint().height());
   dlg.resize(dlg.sizeHint());

   if(dlg.exec())
      cvsRsh = m_pRsh->text();
}

//----------------------------------------------------------------------------

void ApplicationWindow::styleWood()
{
   qApp->setStyle( new NorwegianWoodStyle );
   selectStyleMenu( m_sWood );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::styleMetal()
{
   qApp->setStyle( new MetalStyle );
   selectStyleMenu( m_sMetal );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::stylePlatinum()
{
   qApp->setStyle( new QPlatinumStyle );
   selectStyleMenu( m_sPlatinum );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::styleWindows()
{
   qApp->setStyle( new QWindowsStyle );
   selectStyleMenu( m_sWindows );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::styleCDE()
{
   qApp->setStyle( new QCDEStyle( TRUE ) );
   selectStyleMenu( m_sCDE );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::styleMotif()
{
   qApp->setStyle( new QMotifStyle( TRUE ) );
   selectStyleMenu( m_sMotif );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::selectStyleMenu( int s )
{
   menuBar()->setItemChecked( m_sWood, FALSE );
   menuBar()->setItemChecked( m_sMetal, FALSE );
   menuBar()->setItemChecked( m_sPlatinum, FALSE );
   menuBar()->setItemChecked( m_sWindows, FALSE );
   menuBar()->setItemChecked( m_sCDE, FALSE );
   menuBar()->setItemChecked( m_sMotif, FALSE );
   menuBar()->setItemChecked( s, TRUE );
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::setFont()
{
   bool ok;
   QFont f = QFontDialog::getFont( &ok, QApplication::font(), this );
   if ( ok ) {
      // the user selected a valid font
      QApplication::setFont( f, true );
   } 
}

//-------------------------------------------------------------------------------------------

void ApplicationWindow::closeEvent( QCloseEvent* e )
{
#ifdef LINCVS_APP
   if(!m_uninterruptible){
      if ( QMessageBox::information( this, "LinCVS: " + tr("Question"), 
                                     tr("Help me, I'm being closed!"), 
                                     tr("Close"), tr("Cancel")
                                    ) == 0 )
      {
         e->accept();
      }
      else
      {
         e->ignore();
      }
   }
#else
   e->accept();
#endif
}

//----------------------------------------------------------------------------

void ApplicationWindow::readCfg()
{
   QFile f;
   QString line;

   //read .lincvsrc
   QString fileName = getenv("HOME");
   fileName += "/.lincvsrc";
   
   f.setName(fileName);
   if(f.open(IO_ReadOnly)) {//file is readable
      QTextStream textStream(&f); 

      while(!textStream.atEnd()) {
         line = textStream.readLine();
         m_projectNameList.append(line); 
      }
      f.close();
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::writeCfg()
{
   QFile f;

   //read .lincvsrc
   QString fileName = getenv("HOME");
   fileName += "/.lincvsrc";
   
   f.setName(fileName);
   if(f.open(IO_WriteOnly)) {//file is writable
      QTextStream textStream(&f); 

      for(unsigned int i = 0; i < m_projectNameList.count(); i++) {
         textStream << m_projectNameList[i] << "\n";
      }
      f.close();
   }
}

//----------------------------------------------------------------------------

void ApplicationWindow::about()
{
   QMessageBox::about( this, "LinCVS",
                       tr("A user friendly CVS frontend") + "\n" +
		       tr("Version 0.2.3") + "\n\n" +
                       "Copyright (C) 1999 Tilo Riemer\n" +
		       "email: riemer@ppprs1.phy.tu-dresden.de\n\n" +
             tr("With special thanks to:\n") +  //IRIX workaround --> better solution needed
                "Sven Trogisch\n" +
                "Jan Schmidt\n" +
                "Falk Brettschneider\n" +
                "Dave Knopp\n" +
                + "\n\n" + 
               
             tr("This program is free software;\n") +
             tr("you can redistribute it and/or modify it\n") +
             tr("under the terms of the GNU General Public License\n") +
             tr("as published by the\n") +
             tr("Free Software Foundation;\n") +
             tr("either version 2 of the License,\n") +
             tr("or (at your  option) any later version.\n") +
             tr("This program is distributed in the hope that\n") +
             tr("it will be useful, but WITHOUT ANY WARRANTY;\n") +
             tr("without even the implied  warranty of MERCHANTABILITY or\n") +
             tr("FITNESS FOR A PARTICULAR PURPOSE.\n") +
             tr("See the GNU General Public License for more details.\n"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::help()
{
   QDialog*dlg = new QDialog(this, 0, true);   //modal
   dlg->setCaption(tr("Help"));
   
   QBoxLayout *layer = new QVBoxLayout(dlg, 5);
   QMultiLineEdit*e = new QMultiLineEdit(dlg);
   e->setReadOnly(true);
   layer->addWidget(e);

   QWidget *backGround = new QWidget(dlg);
   layer->addWidget(backGround);

   QBoxLayout *buttonLayer = new QHBoxLayout(backGround, 3);
   buttonLayer->addStretch();
   
   QPushButton *ok = new QPushButton(backGround);
   ok->setText(tr("OK"));
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   
   connect(ok, SIGNAL(clicked()), dlg, SLOT(accept()));
   dlg->resize(600, 300);

//   e->setText(tr("
   e->setText("1. Introduction\n\n" +
tr("CVS (Concurrent Versions System) is a command-line program which\n") +   //tr only as workaround
"supports basic software configuration management of files and\n" +
"groups of files. The purpose of CVS is to provide file archival\n" +
"and support developer coordination over a range of typical\n" +
"software development projects. \n\n" +
"CVS is a freely available configuration management program based\n" +
"on a client/server model supporting both Unix and Windows\n" +
"environments over local and wide area networks. It is more\n" +
"powerful and capable than simple tools such as RCS or SCCS.\n" +
"However, it is not as rich in features as some commercial\n" +
"software configuration management products. One of the first\n" +
"difficulties in using CVS is becoming familiar with the command\n" +
"line syntax.\n\n" +
"LinCVS enhances the  ease-of-use' of CVS by providing a simple,\n" +
"intuitive graphic interface to CVS. With the GUI and mouse, you\n" +
"can quickly and easily review the CVS status of files or groups\n" +
"of files or of entire directory trees. You can also quickly\n" +
"initiate common CVS commands without the need for typing long\n" +
"command lines with many option flags.\n\n" +
"For example with one click of a mouse button, the LinCVS display\n" +
"will show you the CVS file status, log history, version\n" +
"differences, and more.  Because LinCVS organizes and displays\n" +
"configuration management data, it is instantly available when you\n" +
"need it. This allows you to focus more on your code development\n" +
"activity.\n\n" +
"LinCVS runs in a variety of Unix Environments including (Linux,...).\n\n" +
"LinCVS is released under the GPL (http://www.gnu.org/copyleft/gpl.html). \n" +
"It is available for download at\n" +
"http://www.iapp.de/~trogisch/linux/lincvsen.html\n" +
"\n\n" +
"2. CVS Overview\n\n" +
"Within the CVS configuration model, files are organized into\n" +
"modules' which correspond to typical software directory\n" +
"structures. CVS is a client/server style application. The archive\n" +
"copy of files is stored on a server and can be accessed by a CVS\n" +
"client on that same system or from clients on other systems\n" +
"(either Unix or Windows) via local or wide area networks.\n\n" +
"Key capabilities of CVS include:\n" +
"1) It provides an archive of software development (e.g. incremental\n" +
"changes, tracking release configurations of software, etc.);\n" +
"2) It provides mechanisms for multiple developers to coordinate their\n" +
"work on the same software modules and files;\n" +
"3) Supports a  branched task' development paradigm (e.g. for concurrent\n" +
"development work on multiple tasks by multiple developers).\n\n" +
"For CVS updates and additional information, refer to Cyclic\n" +
"Software at http://www.cyclic.com/ or Pascal Molli's CVS site at\n" +
"http://www.loria.fr/~molli/cvs-index.html\n\n\n" +
"3. LinCVS Overview\n\n" +
"In contrast with many other programs, LinCVS is _REALLY_ very\n" +
"easy to use. Literally, you can start using it to view CVS file\n" +
"status and module information within 30 seconds of starting the\n" +
"program.\n\n" +
"Upon opening a directory, LinCVS automatically finds all CVS\n" +
"projects contained within that directory and any subdirectories.\n\n" +
"Using the LinCVS  Project-Explorer' command you can easily\n" +
"navigate the CVS file and directory structure. LinCVS displays\n" +
"this information to you in a familiar file/directory tree format.\n\n" +
"All LinCVS features are readily available through pop-up/pull-\n" +
"down menus or by right clicking the mouse on the file name of\n" +
"interest.\n\n" +
"With the mouse, you can select single files, groups of files,\n" +
"directories or entire directory trees. Then quickly and easily\n" +
"apply a CVS command to your custom selection.\n\n\n" +
"4. LinCVS Commands\n\n" +
"The following CVS capabilities are available from the LinCVS main\n" +
"menu. Note that you should be generally familiar with CVS for the\n" +
"following to make sense to you. If you are new to CVS, refer to\n" +
"the references in the  CVS Overview' section.\n\n" +
"4.1 Administration/Checkout\n\n" +
"Initial download of a CVS-project from the CVS-server to the\n" +
"local directory.\n\n" +
"4.2 Administration/Import\n\n" +
"Add a new project to the repository on the CVS-server.\n\n" +
"4.3 Project-Explorer/Add to workbench\n\n" +
"Displays all directories and subdirectories containing\n" +
"CVS-projects.");

   dlg->exec();
   delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::aboutQt()
{
   QMessageBox::aboutQt( this, "Qt..." );
}

//----------------------------------------------------------------------------

