/****************************************************************************
** $Id: dialogs.cpp,v 1.6 1999/12/14 02:16:16 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <stdlib.h>

//----------------------------------------------------------------------------

#include <qfiledialog.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qgroupbox.h> 
#include <qcheckbox.h> 
#include <qtooltip.h> 

//----------------------------------------------------------------------------

#include "globals.h"
#include "dialogs.h"

//----------------------------------------------------------------------------

CheckOutAndImportDlg::CheckOutAndImportDlg(QStringList *tagList, 
   bool checkoutImport01, QString caption, QWidget *parent, 
   const char *name, bool modal, WFlags f)
: QDialog(parent, name, modal, f)
{
   setCaption(caption);
   
   m_pTagCtl = 0;
   
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);
   QGridLayout *gridLayer;

   if(checkoutImport01) {//import
      gridLayer = new QGridLayout(topLayer, 9, 2, 5);
   }
   else {
      gridLayer = new QGridLayout(topLayer, 6, 2, 5);
   }

   //create labels
   QLabel *label;
   label = new QLabel(tr("Method:"), this);   
   gridLayer->addWidget(label, 0, 0);
   label = new QLabel(tr("User:"), this);   
   gridLayer->addWidget(label, 1, 0);
   label = new QLabel(tr("CVS Module:"), this);   
   gridLayer->addWidget(label, 2, 0);
   label = new QLabel(tr("CVS Server:"), this);   
   gridLayer->addWidget(label, 3, 0);
   label = new QLabel(tr("CVS Repository:"), this);   
   gridLayer->addWidget(label, 4, 0);
   label = new QLabel(tr("Local Directory:"), this);   
   gridLayer->addWidget(label, 5, 0);

   //combo for mode
   QComboBox *mode = new QComboBox(false, this);
   mode->insertItem(tr("Password"));
   mode->insertItem(tr("Remote Shell"));
   mode->insertItem(tr("Local/NFS"));
   connect(mode, SIGNAL(activated(int)), this, SLOT(chooseMode(int)));
   gridLayer->addWidget(mode, 0, 1);

   m_mode = MODE_PSERVER;

   //create background widget and layer for "local dir"
   QWidget *w = new QWidget(this);
   gridLayer->addWidget(w, 5, 1);
   QBoxLayout *dirLayer = new QHBoxLayout(w);
   
   //create input fields
   m_pUser = new QLineEdit(this);
   m_pLineModule = new QLineEdit(this);
   m_pLineServer = new QLineEdit(this);
   m_pLineRepository = new QLineEdit(this);
   m_pLineLocalDir = new QLineEdit(w);
   m_pLineLocalDir->setMinimumWidth(250);
   gridLayer->addWidget(m_pUser, 1, 1);
   gridLayer->addWidget(m_pLineModule, 2, 1);
   gridLayer->addWidget(m_pLineServer, 3, 1);
   gridLayer->addWidget(m_pLineRepository, 4, 1);

   dirLayer->addWidget(m_pLineLocalDir);
   dirLayer->addSpacing(3);
   QPushButton *choiceDir = new QPushButton("...", w);
   dirLayer->addWidget(choiceDir);
   connect(choiceDir, SIGNAL(clicked()), this, SLOT(showDirOpenDlg()));

   //rsh-zusatzparameter-controls
   topLayer->addSpacing(10);

   m_pRshBox = new QButtonGroup(2, Vertical, this);
   m_pRshBox->setExclusive(true);
   topLayer->addWidget(m_pRshBox);

   QWidget *extBg = new QWidget(m_pRshBox);
   QBoxLayout *extLayer = new QHBoxLayout(extBg);
   
   m_pExt = new QRadioButton(tr("use external rsh program (default is rsh)"), extBg);
   extLayer->addWidget(m_pExt);
   m_pRshBox->insert(m_pExt);
   extLayer->addSpacing(15);
   m_pExt->setChecked(true);   //default
   connect(m_pExt, SIGNAL(toggled(bool)), this, SLOT(chooseRshMethod(bool)));

   m_pRshLine = new QLineEdit(extBg);
   extLayer->addWidget(m_pRshLine);
   m_pRshLine->setText(getenv("CVS_RSH"));
   m_pServer = new QRadioButton(
                   tr("use internal rsh client (supported only by some CVS ports)"), m_pRshBox);
   connect(m_pServer, SIGNAL(toggled(bool)), this, SLOT(chooseRshMethod(bool)));


   //analyze CVSROOT
   QString connectMethod;
   QString userName;
   QString host;
   QString rootDir;
   int result = analyzeCVSROOT(connectMethod, userName, host, rootDir);
   int res_3bits = (result & 7);   
   
   if(res_3bits == ACCESS_LOCAL) {//local
      mode->setCurrentItem(2);
      m_pUser->setText(userName);
      m_pLineServer->setText(host);
      m_pLineRepository->setText(rootDir);
      m_pLineServer->setEnabled(false);
      m_pUser->setEnabled(false);
      m_mode = MODE_LOCAL;
      m_pRshBox->hide();
   }
   else
   if(res_3bits == ACCESS_PSERVER) {//pserver
      mode->setCurrentItem(0);
      m_pUser->setText(userName);
      m_pLineServer->setText(host);
      m_pLineRepository->setText(rootDir);
      m_pLineServer->setEnabled(true);
      m_pUser->setEnabled(true);
      m_mode = MODE_PSERVER;
      m_pRshBox->hide();
   }
   else
   if(res_3bits == ACCESS_RSH) {//remote shell
      mode->setCurrentItem(1);
      m_pUser->setText(userName);
      m_pLineServer->setText(host);
      m_pLineRepository->setText(rootDir);
      m_pLineServer->setEnabled(true);
      m_pUser->setEnabled(true);
      m_mode = MODE_RSH;

      m_pRshBox->show();
      
      //jetzt rsh-zusatzparameter initialisieren und anzeigen, sonst verstecken
      if((result & ~7) == RSH_EXT) {//ext
         m_pExt->setChecked(true);
         m_pRshLine->setEnabled(true);
      }
      else {//server
         m_pServer->setChecked(true);
         m_pRshLine->setEnabled(false);
      }
   }

   
   if(checkoutImport01) {//import
      label = new QLabel(tr("Vendor Tag:"), this);   
      gridLayer->addWidget(label, 6, 0);
      label = new QLabel(tr("Release Tag:"), this);   
      gridLayer->addWidget(label, 7, 0);
      label = new QLabel(tr("Comment:"), this);   
      gridLayer->addWidget(label, 8, 0);
   
      m_pTag1 = new QLineEdit(this);
      m_pTag2 = new QLineEdit(this);
      m_pComment = new QMultiLineEdit(this);
      gridLayer->addWidget(m_pTag1, 6, 1);
      gridLayer->addWidget(m_pTag2, 7, 1);
      gridLayer->addWidget(m_pComment, 8, 1);
   }
   else {//Checkout
      topLayer->addSpacing(15);
      m_pTagCtl = new TagOperationControl(tagList, 
                      tr("use tag, revision or date"), this, false, false);
      topLayer->addWidget(m_pTagCtl);
   }

   topLayer->addSpacing(15);

   //create background widget and layer for "ok" and "cancel"
   w = new QWidget(this);
   topLayer->addWidget(w);
   QBoxLayout *buttonLayer = new QHBoxLayout(w);
   buttonLayer->addStretch();
   
   //ok and cancel
   QPushButton *ok = new QPushButton(w);
   ok->setText(tr("OK"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(w);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();

   connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));

   
   if(!checkoutImport01) {//checkout
      setMaximumHeight(20);
      resize(20, 20);
   }
   
 
   QToolTip::add(mode, tr("Choose the access mode") );
   QToolTip::add(m_pUser, tr("Enter your login name on CVS server") );
   QToolTip::add(m_pLineModule, tr("Enter module name, for instance LinCVS") );
   QToolTip::add(m_pLineServer, tr("Enter name or IP address of CVS server, for instance www.kde-devel.org") );
   QToolTip::add(m_pLineRepository, tr("Enter path to the repository on CVS server, for instance /usr/share/cvs/repository") );
   QToolTip::add(m_pLineLocalDir, tr("Enter directory for your local copy, for instance /home/anyuser/projects") );
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::chooseRshMethod(bool)
{
   if(m_pExt->isChecked())
      m_pRshLine->setEnabled(true);
   else
      m_pRshLine->setEnabled(false);
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::showDirOpenDlg()
{
   QString fn = QFileDialog::getExistingDirectory();
   if(!fn.isEmpty()){
      m_pLineLocalDir->setText(fn);
   }
}

//----------------------------------------------------------------------------

void CheckOutAndImportDlg::chooseMode(int m)
{
   switch(m)
   {
      case MODE_PSERVER:
         m_mode = MODE_PSERVER;
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
         m_pRshBox->hide();
         resize(20, 20);
         break;
      case MODE_RSH:
         m_mode = MODE_RSH;
         m_pLineServer->setEnabled(true);
         m_pUser->setEnabled(true);
         m_pRshBox->show();
         break;
      case MODE_LOCAL:
         m_mode = MODE_LOCAL;
         m_pLineServer->setEnabled(false);
         m_pUser->setEnabled(false);
         m_pRshBox->hide();
         resize(20, 20);
         break;
   }
}

//----------------------------------------------------------------------------

int CheckOutAndImportDlg::rshMode()
{
   if(m_pExt->isChecked())
      return RSH_EXT;
   else
      return RSH_SERVER;
}

//----------------------------------------------------------------------------

QString CheckOutAndImportDlg::cvsParameter()
{
   if(m_pTagCtl) {
      return m_pTagCtl->cvsParameter();
   }
   else return QString::null;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

TagDlg::TagDlg(QStringList *tagList, QString caption, QWidget *parent, 
   const char *name, bool modal, WFlags f)
: QDialog(parent, name, modal, f)
{
   m_pTagList = tagList;
   setCaption(caption);
   
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);
   QBoxLayout *inputLayer = new QHBoxLayout(topLayer, 5);
   topLayer->addSpacing(15);
   QBoxLayout *buttonLayer = new QHBoxLayout(topLayer, 5);

   QLabel *label = new QLabel(tr("Tag Name:"), this);
   inputLayer->addWidget(label);
   
   m_pTagChoice = new QComboBox( true, this);
   for(unsigned int i = 0; i < m_pTagList->count(); i++) {
      m_pTagChoice->insertItem((*m_pTagList)[i]);
   }
   inputLayer->addWidget(m_pTagChoice, 10);

   QPushButton *clear = new QPushButton(this);
   clear->setText(tr("Clear"));
   inputLayer->addWidget(clear);
   connect(clear, SIGNAL(clicked()), m_pTagChoice, SLOT(clearEdit()));

   buttonLayer->addStretch();
   QPushButton *tag = new QPushButton(this);
   tag->setText(tr("Tag"));
   tag->setDefault(true);
   buttonLayer->addWidget(tag);
   buttonLayer->addStretch();
   QPushButton *branchTag = new QPushButton(this);
   branchTag->setText(tr("Branch Tag"));
   buttonLayer->addWidget(branchTag);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(this);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();
   
   //hier die connects zum tag-slot
   connect(tag, SIGNAL(clicked()), this, SLOT(tagged()));
   connect(branchTag, SIGNAL(clicked()), this, SLOT(branchTagged()));
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
   
   this->setMaximumHeight(this->sizeHint().height());
   this->resize(this->sizeHint());
}

//----------------------------------------------------------------------------

void TagDlg::tagged() 
{
   adaptTagList();
   done(Tag);
}

//----------------------------------------------------------------------------

void TagDlg::branchTagged()
{
   adaptTagList();
   done(BranchTag);
}

//----------------------------------------------------------------------------

void TagDlg::adaptTagList()
{
   if(m_pTagList->findIndex(m_pTagChoice->currentText()) == -1) {//tag isnt in tagList
      m_pTagList->prepend(m_pTagChoice->currentText());
   }
   else 
   if(m_pTagList->findIndex(m_pTagChoice->currentText()) > 0) {//text isnt the first item in list
      m_pTagList->remove(m_pTagChoice->currentText());
      m_pTagList->prepend(m_pTagChoice->currentText());
   }
}  

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

TagUpdateDlg::TagUpdateDlg(QStringList *tagList, QString caption, QWidget *parent, 
   const char *name, bool modal, WFlags f)
: QDialog(parent, name, modal, f)
{
   setCaption(caption);
   
   QBoxLayout *topLayer = new QVBoxLayout(this, 5);

   m_pTagCtl = new TagOperationControl(tagList, 
                   tr("use tag, revision or date instead working copy"), this);
   topLayer->addWidget(m_pTagCtl);

   topLayer->addSpacing(15);
   QBoxLayout *buttonLayer = new QHBoxLayout(topLayer, 5);
   buttonLayer->addStretch();
   QPushButton *ok = new QPushButton(this);
   ok->setText(tr("Update"));
   ok->setDefault(true);
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   QPushButton *cancel = new QPushButton(this);
   cancel->setText(tr("Cancel"));
   buttonLayer->addWidget(cancel);
   buttonLayer->addStretch();
   
   //hier die connects zum tag-slot
   connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
   
   setMaximumSize(20000, sizeHint().height());
   resize(sizeHint());
}

//----------------------------------------------------------------------------

QString TagUpdateDlg::cvsParameter()
{
   return m_pTagCtl->cvsParameter();
}

//----------------------------------------------------------------------------
