/****************************************************************************
** $Id: cvslistview.cpp,v 1.3 1999/12/13 17:04:39 riemer Exp $
**
** copyright            : (C) 1999-2000 by Tilo Riemer
**
** email                :  riemer@ppprs1.phy.tu-dresden.de
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include <assert.h>

//----------------------------------------------------------------------------

#include "cvslistview.h"
#include "directory.h"

//----------------------------------------------------------------------------

CvsListView::CvsListView(QPopupMenu *menu, QWidget * parent, const char * name)
: QListView(parent, name)
{
   m_pMenu = menu;
}

//----------------------------------------------------------------------------

void CvsListView::viewportMousePressEvent(QMouseEvent * e)
{
   assert(m_pMenu);   //valid pointer

   QListViewItem* item;
      
   if(!hasFocus() && !viewport()->hasFocus())
      setFocus();

   QListView::viewportMousePressEvent( e );

   if((e->button() == RightButton) 
      && (item = itemAt(e->pos())))
   {   
      setSelected(item, true);
      setCurrentItem(item);
      QPoint offset(10, 5);
      m_pMenu->popup(mapToGlobal(e->pos()) + offset);
   }

   return;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

CvsDirListView::CvsDirListView(QPopupMenu *menu, QWidget * parent, const char * name)
: QListView(parent, name)
{
   m_pMenu = menu;
}

//----------------------------------------------------------------------------

void CvsDirListView::viewportMousePressEvent(QMouseEvent * e)
{
   assert(m_pMenu);   //valid pointer

   Directory* dirItem;
      
   if(!hasFocus() && !viewport()->hasFocus())
      setFocus();

   QListView::viewportMousePressEvent( e );

   if((e->button() == RightButton) 
      && (dirItem = (Directory*)itemAt(e->pos())))
   {   
      if(currentItem() != dirItem){
         dirItem->activateItem();
      }
      
      setSelected(dirItem, true);
      setCurrentItem(dirItem);
      QPoint offset(10, 5);
      m_pMenu->popup(mapToGlobal(e->pos()) + offset);
   }

   return;
}

//----------------------------------------------------------------------------
