/****************************************************************************
**
** $Id: getCvsMod.h,v 1.4 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef GETCVSMOD_H_20010626	// prevent multiple includes
#define GETCVSMOD_H_20010626



/*****************************************************************************
 *  Include Files
 *****************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qvbox.h>
#include <qdialog.h>

/*****************************************************************************
 *  Definitions, Macros
 *****************************************************************************/

/*****************************************************************************
 *  typedefs
 *****************************************************************************/

/*****************************************************************************
 *  global Variables
 *****************************************************************************/

/*****************************************************************************
 *  Prototypes / Classes
 *****************************************************************************/



class QWidget;
class QDropEvent;


class CvsRootDir : public QListViewItem
{
public:
    CvsRootDir( QListView * parent,
                const QString& filename );
    
    CvsRootDir( CvsRootDir * parent,
                const QString& filename );

    QString text( int column ) const;
    QString fullName();
    void setOpen( bool );
    void setup();

private:
    QFile        f;
    CvsRootDir  *pDir;
    bool         readable;

    QString cvsRootDir() { return "CVSROOT";};
    
    
};



class CvsRootDirView : public QListView
{
    Q_OBJECT

public:
    CvsRootDirView( QWidget *parent = 0,
                    const char *name = 0 );

    QString  dirName;
    bool     ckReadable( QString& path, bool addExt=TRUE );
    
    
signals:
    void folderSelected( const QString & );

protected slots:
    void slotFolderSelected( QListViewItem * );
    void openFolder();
    void itemHighLighted ( QListViewItem * );
    
    
protected:
    void contentsMouseMoveEvent( QMouseEvent * ){};//    does nothing, just to exist the function;

private:

    QString fullPath(QListViewItem* item);

    bool             dirsOnly;
    QListViewItem   *dropItem;

};


class getCvsModule : public QDialog
{
    Q_OBJECT

public :
 
    getCvsModule( const QString& pathname,
                  QWidget * parent = 0,
                  const char* name = 0);
  
    CvsRootDirView  *dirWin;
    QString          cvsRootPath;
    
signals :
    void cvsModuleSelected( const QString& str );

      
public slots :    
    void okButton();
    void cancelButton();

};



#endif	   //GETCVSMOD_H_20010626


/*--- END OF FILE ----------------------------------------------------------*/
