/****************************************************************************
**
** $Id: directory.h,v 1.8 2001/10/29 08:10:05 riemer Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef DIRECTORY_H_20010626
#define DIRECTORY_H_20010626

//----------------------------------------------------------------------------

#include "config.h"
#include "ac_system_defs.h"


#include <qlistview.h>
#include <qlist.h>
#include <qfileinfo.h>
class QMultiLineEdit;

//----------------------------------------------------------------------------

class CmdThread;
class Directory;
class NonCvsListView;
class CvsListView;

//----------------------------------------------------------------------------

enum EntryStates_E {
    ES_unknown                                    =  0,
    ES_probably_up_to_date                        =  1,
    ES_probably_up_to_date_and_timezone_incorrect =  2,
    ES_up_to_date                                 =  3,
    ES_modified                                   =  4,
    ES_needs_patch                                =  5,
    ES_needs_merge                                =  6,
    ES_needs_checkout                             =  7,
    ES_missing                                    =  8,
    ES_conflict                                   =  9,
    ES_added                                      = 10,
    ES_removed                                    = 11
};
typedef enum EntryStates_E EntryStates;

// ID's of entries in Directory popup menu

#define DP_Status                               1000
#define DP_Diffs                                1001
#define DP_Log                                  1002
#define DP_History                              1003
#define DP_Update                               1004
#define DP_Commit                               1005
#define DP_Tag                                  1006
#define DP_AddFile                              1007
#define DP_Login                                1008
#define DP_ReRead                               1010
#define DP_RemoveFromWB                         1011
#define DP_Disable                              1012
#define DP_Enable                               1013
#define DP_Properties                           1014
#define DP_RevisionUpdate                       1016
#define DP_RemoveDirectory                      1017
#define DP_QueryUpdate                          1018

//----------------------------------------------------------------------------

const int ACTIVATING_IS_NECESSARY    = 2;
const int COMMIT                     = 3;
const int STATUS                     = 4;
const int UPDATE_DIR                 = 5;
const int UPDATE_FILES               = 6;
const int ANNOTATE_GREP_LINE         = 7;
const int ANNOTATE_GREP_LINES        = 8;

//----------------------------------------------------------------------------

class Entry
{
public:
   Entry(const QString& fileName, EntryStates state, Directory * Dir ) 
   {
      m_fileName = fileName;
      m_state = ES_unknown;
      myDirectory = Dir;
      setState( state );
   }

   void setState( EntryStates s );
   Directory * getDirectory() { return myDirectory; }
   
   QString fileName() {return m_fileName;}
   EntryStates state() {return m_state;}
   
protected:
   QString m_fileName;
   Directory * myDirectory;
   EntryStates m_state;
};

//----------------------------------------------------------------------------

class Directory : public QListViewItem
{
public:
   Directory( 
     QListView * parent, 
     const QString& fileName, 
     CvsListView * CvsFileListView,
     NonCvsListView * NonCvsFileListView );
   Directory( 
     QListViewItem * parent, 
     const QString& fileName, 
     CvsListView * CvsFileListView,
     NonCvsListView * NonCvsFileListView );

   void readSubDirs();

   // set open this item and all items above it
   void setAllOpen( );
   
   QString fullName() {return m_fullName;}
   QString shortName();
   Directory * topDir();
   QString rootDir() {return m_rootDir;}
   QString repository() {return m_repository;}
   QString userName() {return m_userName;}
   QString host() {return m_host;}
   QString connectMethod() {return m_connectMethod;}

   bool haveCvsDir() {return m_haveCvsDir || m_subDirHasCvsDir;}
   bool analyzeDirs();
   void addDir(QString newDir);

   //start the cvs command thread
   bool startCvsCall(QString cvsCommand, QMultiLineEdit *output, 
                     int evaluateCommand = 0, QStringList *updateFileList = 0,
                     int synchronous = 0);
   bool checkCvsCallResult(QMultiLineEdit *output);
   void killCvsThread();   //cvs thread killen, wenn er noch laufen sollte
   void deleteThreadAndActivateIfNecessary();

   //setze alle in m_curCvsUpdateFileList enthaltenen files auf uptodate
   void setFilesToUpToDate(QStringList& updateFileList);   
   void fillFileListWithEntries(QStringList& fileList);
   
   void addFiles(QMultiLineEdit *output, QStringList *stringList, bool bAsBinary);
   void activateItem();
   void setAndAppendEntry(QString fileName, EntryStates stateId);
   void setAllToUpToDate();
   void checkStatus(QListViewItem *item = 0);   //0 --> for all entries
   bool getDisabled(QString filename);

   Directory* searchDirOfRepository(QString repository);
   Directory* searchDirOfPath(QString path);

   bool loginOk(bool showMessage = false);
   bool entriesFileModified();

   // state bubble up
   void setState( EntryStates State );
   void resetState( void );

   // check if this dir or any of its children contain CVS files
   void removeFromRep( void );
   void removeFromRepAndDisk( void );

   void SetAnnotateSearchLine(QString line, bool cs) {m_annotateGrepSearchLine = line; m_bSearchCaseSensitive = cs;}
   void SetAnnotateSearchLines(QStringList lines, bool cs) {m_annotateGrepSearchLines = lines; m_bSearchCaseSensitive = cs;}

protected:

   void doRemoveThis( int FromRep, int FromDisk );
   int isTreeEmpty( void );
   void doRemoveFromRepOrDisk( int FromRep, int FromDisk );
   void recResetState( void );

   void init(const QString& fileName, 
   	CvsListView * CvsFileListView,
   	NonCvsListView * NonCvsFileListView);

   bool checkCvsDir();
   static bool checkValidCvsDir( QString & path );
   void activate();
 
   bool setEntry(QString fileName, EntryStates stateId);
   EntryStates alignWithEntries(QString name, EntryStates stateId);
   QListViewItem * setStatusInFileListView(QListViewItem *item, QString line);
   virtual void paintCell( QPainter *p, const QColorGroup &cg,
                            int column, int width, int alignment );
  
   char * getUnchangedPix(QFileInfo & info);                                    
   
   QString     m_fullName;
   bool        m_readable;
   bool        m_haveCvsDir;
   bool        m_subDirHasCvsDir;
   CvsListView  *m_pCvsFileListView;
   NonCvsListView  *m_pNonCvsFileListView;
   int         m_evaluateCommand;   //auszuwertendes kommando
   bool        m_activatingIsNecessary;
   
   QString     m_rootDir;
   QString     m_repository;
   QString     m_userName;
   QString     m_host;
   QString     m_connectMethod;
   
   QList <Entry> m_entries;
   QString     m_modTimeOfEntries;
   
   CmdThread *m_pThread;
   QString m_curCvsFileName;
   QString m_curCvsFullPath;
   QString m_curCvsRepository;
   EntryStates m_curCvsState;
   Directory *m_pCurCvsDir;
   Directory *m_pCurCvsLastUpdateDir;   //letztes verzeichnis, in welchem update ausgefuehrt wurde (nur bei updatedir)
   QStringList m_curCvsUpdateFileList;

   QString m_annotateGrepSearchLine;    //if the current command is annotate/grep line, use this string for searching
   QStringList m_annotateGrepSearchLines;    //if the current command is annotate/grep lines, use this string list for searching
   bool m_bSearchCaseSensitive;
};

//----------------------------------------------------------------------------

#endif   //DIRECTORY_H_20010626

