/****************************************************************************
**
** $Id: cvstoolbar.h,v 1.8 2001/11/01 09:13:07 riemer Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef CVSTOOLBAR_H_20010626		// prevent multiple includes
#define CVSTOOLBAR_H_20010626

#include "config.h"
#include "ac_system_defs.h"


#ifdef KDE2
#include <ktoolbar.h>
#else
#include "config.h"
#include <dummyktoolbar.h>
#endif // KDE2

#include <qmainwindow.h>
#include <qtoolbutton.h>


class cvsToolbar : public KToolBar
{
   Q_OBJECT
public:
   cvsToolbar(QMainWindow *parent );
   ~cvsToolbar();

   typedef enum {      // the objects are defined here
     wBench,           // workbench
     cvsFile,          // cvs file tab
     nonCvsFile,       // non cvs file tab
     tabFileList,      // file tabs
     status            // status field
   }T_wtText;
   
   QToolButton          *m_pStopAction;

   
 public slots:
   
    void addWhatsThisText( void *ptr,  T_wtText textType );
    void setStatTimerEnable();
    void setStatTimerDisable();
    

 private:
   KToolBar             *tools;
   QToolButton          *tb_exit;
   QToolButton          *tb_addWb;
   QToolButton          *tb_info;
   QToolButton          *tb_imp;
   QToolButton          *tb_co;
   QToolButton          *tb_upd;
   QToolButton          *tb_cvsUpd;
   QToolButton          *tb_cvsMerge;
   QToolButton          *tb_com;
   QToolButton          *tb_clock;
   QToolButton          *tb_annotate;
   QToolButton          *tb_annotateGrepLine;
   QToolButton          *tb_annotateGrepLines;
   QToolButton          *tb_watchAdd;
   QToolButton          *tb_watchRemove;
   QToolButton          *tb_watchOn;
   QToolButton          *tb_watchOff;
   

   typedef enum {      // only toolbuttons defined here 
     add2Wb,           // workbench
     stopAction,       // stop Button
     exit,
     info,
     import,
     co,               // checkout Button
     upd,              // update Button
     updenable,        // enable/disable m_timer
     cvsupd,           // cvs update
     cvscom           // cvs commit
   }T_wtTextInt;       // whatsThisText internal functions 



  private slots :

    void addWhatsThisTextInt (QToolButton *tb, T_wtTextInt textType );
    void toggleStatusTimer();
  
};


#endif // CVSTOOLBAR_H_20010626
