/****************************************************************************
**
** $Id: cvslistview.cpp,v 1.21 2001/10/23 23:27:29 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include <assert.h>
#include <qpopupmenu.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "cvslistview.h"
#include "directory.h"

// static QPopupMenu * CvsListView::PopupMenu = 0;

//----------------------------------------------------------------------------

CvsListView::CvsListView(QPopupMenu *menu, QWidget * parent, const char * name)
: QListView(parent, name)
{
	/* Use extended selection mode.  When we click on this
	 * window we usually want to operate on a single file by using
	 * the menu unless the user uses the shift or control key.
	 * We don't want to use the standard multiple selection mode
	 * because the point in having a tree view is so we can perform
	 * the operation on the whole directory hierarchy in one go.
	 */
	setSelectionMode (QListView::Extended);

   setAllColumnsShowFocus(true);
   addColumn(tr("Name"));
   addColumn(tr("Revision"));
   addColumn(tr("Tag"));
   addColumn(tr("State"));
   addColumn(tr("Committed"));
   addColumn(tr("Modified (local)"));
   addColumn(tr("Modified (UTC)"));
   setColumnWidth(0,CVSLISTVIEW_TABWIDTH_NAME);
   setColumnWidth(1,CVSLISTVIEW_TABWIDTH_REV);
   setColumnWidth(2,CVSLISTVIEW_TABWIDTH_STICKY);
   setColumnWidth(3,CVSLISTVIEW_TABWIDTH_STATE);
   setColumnWidth(4,CVSLISTVIEW_TABWIDTH_COMMIT);
   setColumnWidth(5,CVSLISTVIEW_TABWIDTH_MODLOCAL);
   setColumnWidth(6,CVSLISTVIEW_TABWIDTH_MODUTC);

   connect (this, SIGNAL( doubleClicked( QListViewItem *) ),
        this, SLOT( selFile( QListViewItem *) ) );

   m_pMenu = menu;
}

//----------------------------------------------------------------------------

void CvsListView::viewportMousePressEvent(QMouseEvent * e)
{
   if (!globalListViewsEnabled) return;

   assert(m_pMenu);   //valid pointer
   QListViewItem* item;
  
   if(!hasFocus() && !viewport()->hasFocus())
      setFocus();

   QListView::viewportMousePressEvent( e );

   if((e->button() == RightButton) && (item = itemAt(e->pos() ))) {   
      setSelected(item, true);
      setCurrentItem(item);
      QPoint offset(10, 5);
      m_pMenu->popup(mapToGlobal(e->pos()) + offset);
   }

   return;
}

void CvsListView::selFile( QListViewItem * It ) {

        clearSelection();
        emit doubleClickedFile( It->text(0) );
}

//----------------------------------------------------------------------------

void CvsListView::keyPressEvent ( QKeyEvent * e ) 
{
   if (!globalListViewsEnabled) return;

   QListView::keyPressEvent( e );

   if(e->key() == Qt::Key_Return) 
   {   
      if (currentItem()) {
         setSelected(currentItem(), true);
         m_pMenu->popup(mapToGlobal(QPoint(60, 40)));
      }
   }
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

CvsDirListView::CvsDirListView(QPopupMenu *menu, QWidget * parent, const char * name)
: QListView(parent, name)
{
   m_pMenu = menu;
}

//----------------------------------------------------------------------------

void CvsDirListView::viewportMousePressEvent(QMouseEvent * e)
{
   if (!globalListViewsEnabled) return;

   assert(m_pMenu);   //valid pointer
   Directory* dirItem;
   
   if ( (dirItem = (Directory*)itemAt(e->pos())) == NULL ) return ;
   
   globalStatusBar->setText(dirItem->fullName());
      
   if(!hasFocus() && !viewport()->hasFocus())
      setFocus();

   QListView::viewportMousePressEvent( e );

   if (e->button() == RightButton){
      if(currentItem() != dirItem){
         dirItem->activateItem();
      }
      setSelected(dirItem, true);
      setCurrentItem(dirItem);
      QPoint offset(10, 5);
      if( dirItem->depth() ) {
        // non root item
        m_pMenu->setItemEnabled( DP_RemoveFromWB, FALSE );
        m_pMenu->setItemEnabled( DP_RemoveDirectory, TRUE );
      } else {
        // root item
        m_pMenu->setItemEnabled( DP_RemoveFromWB, TRUE );
        m_pMenu->setItemEnabled( DP_RemoveDirectory, FALSE );
      }
      m_pMenu->popup(mapToGlobal(e->pos()) + offset);
   }

   return;
}

//----------------------------------------------------------------------------

void CvsDirListView::keyPressEvent ( QKeyEvent * e ) 
{
   if (!globalListViewsEnabled) return;

   QListView::keyPressEvent( e );

   if(e->key() == Qt::Key_Return) 
   {   
      if (currentItem()) {
         setSelected(currentItem(), true);
         m_pMenu->popup(mapToGlobal(QPoint(60, 40)));
      }
   }
}

//----------------------------------------------------------------------------

void CvsDirListView::contentsMouseDoubleClickEvent ( QMouseEvent * e )
{
   if (!globalListViewsEnabled) return;

   QListView::contentsMouseDoubleClickEvent ( e );
}

//----------------------------------------------------------------------------

void CvsDirListView::contentsMouseMoveEvent ( QMouseEvent * e ) 
{
   if (!globalListViewsEnabled) return;
   Directory* dirItem;
  
   if ( e->state() == LeftButton ) {
     dirItem = (Directory*)itemAt(e->pos());
     if ( (dirItem != OldItem) && (dirItem!=0) && (dirItem != NULL)) {
       OldItem = dirItem;
       dirItem->activateItem();
     }
   }
   QListView::contentsMouseMoveEvent ( e );
}

//----------------------------------------------------------------------------

void CvsDirListView::contentsMousePressEvent ( QMouseEvent * e ) 
{
   if (!globalListViewsEnabled) return;

   QListView::contentsMousePressEvent ( e );
}

//----------------------------------------------------------------------------

void CvsDirListView::contentsMouseReleaseEvent ( QMouseEvent * e )
{
   if (!globalListViewsEnabled) return;

   QListView::contentsMouseReleaseEvent ( e );
}

//----------------------------------------------------------------------------

Directory * CvsDirListView::find( QString S ) {

        Directory * D2, *D = (Directory *)firstChild();
        while( D ) {
          if( ( D2 = D->searchDirOfPath( S ) ) ) 
            return D2;
          D = (Directory *)D->nextSibling();
        }
        return 0;
}


void CvsDirListView::resizeEvent (QResizeEvent *e)
{
        QListView::resizeEvent (e);

	/* Expand or shrink the only column in the
	 * list view so it always ocuppies the visible
	 * width of the widget.
	 */
	//!!! setColumnWidth (0, visibleWidth());
}
