/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/ProfilesDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/15 22:39:48 $
 *!!	$Revision: 1.1 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	    Tilo Riemer <riemer@lincvs.org>
 *!!	    Falk Brettschneider <gigafalk@yahoo.com>
 *!!	    Wim Delvaux <wim.delvaux@chello.be>
 *!!	    Jose Hernandez <joseh@tesco.net>
 *!!        Helmut Koll <HelmutKoll@web.de>
 *!!	    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/

#include <qcombobox.h>
#include <qmessagebox.h>
#include "ProfilesDialogImpl.h"
#include "cfg.h"

extern Config *conf;

/* 
 *  Constructs a ProfilesDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ProfilesDialogImpl::ProfilesDialogImpl(QStringList *userList, QStringList *serverList,
				       QStringList *repositoryList, QStringList *profileList,
				       QWidget* parent,  const char* name)
  : ProfilesDialog (parent, name, true, 0)
{
  p_userList = userList;
  p_serverList = serverList;
  p_repositoryList = repositoryList;
  p_profileList = profileList;
  
  if (!conf->list.isEmpty() )
    tmpList = conf->list; 
  
  delList.clear();
  updateComboList();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ProfilesDialogImpl::~ProfilesDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * protected slot
 */
void ProfilesDialogImpl::actNameItem(const QString& item)
{
  lincvsProfile *profile;

  QString tmp;
  pIndex = tmpList.first();

/*! search index in qlist */
  for ( profile=tmpList.first(); profile != 0; profile=tmpList.next() )
  {
    if (profile->name() == item )
    {
      pIndex = tmpList.current();
      break;
    }
  }
    

/*! search item in combobox name */
  int i;
  for (i=0; i<selName->count(); i++)
  {
    tmp=selName->text(i);
    if ( tmp==pIndex->name() )
    {
      selName->setCurrentItem(i);
      break;
    }
  }
  

/*! search item in combobox user */
  for (i=0; i<selUser->count(); i++)
  {
    tmp=selUser->text(i);
    if ( tmp==pIndex->user() )
    {
      selUser->setCurrentItem(i);
      break;
    }
  }

/*! search item in combobox server */
  for (i=0; i<selServer->count(); i++)
  {
    tmp=selServer->text(i);
    if ( tmp==pIndex->server() )
    {
      selServer->setCurrentItem(i);
      break;
    }
  }

/*! search item in combobox repository */
  for (i=0; i<selRepository->count(); i++)
  {
    tmp=selRepository->text(i);
    if ( tmp==pIndex->repository() )
    {
      selRepository->setCurrentItem(i);
      break;
    }
  }

/*! set item in combobox method */
  selMethod->setCurrentItem( pIndex->method() );
}


/* 
 * protected slot
 */
void ProfilesDialogImpl::addItem()
{
  lincvsProfile *profile;

  QString tmp;
  pIndex = 0;

// test if entry is acceptable
  QString item = selName->currentText();
  if (item.isEmpty())
  {
    QMessageBox::warning(0, tr("LinCVS Settings"), tr("No profile name specified.\n"), 0);
    return;
  }
  
// test if name already exists!!
/*! search index in qlist */
  for ( profile=tmpList.first(); profile != 0; profile=tmpList.next() )
  {
    if (profile->name() == item )
    {
      pIndex = tmpList.current();
      break;
    }
  }
    
  if (pIndex == 0)
  {
    tmpList.append(new lincvsProfile(selName->currentText(),
                                     getMethod(selMethod->currentText()),  
                                     selUser->currentText(),
                                     selServer->currentText(), 
                                     selRepository->currentText()) );
  }else
  {
    QMessageBox::warning(0, tr("LinCVS Settings"), 
                         tr("Profile already exists with this name.\n") 
                         + "Please select a new name", 0);
  }
  
  updateComboList();
}


void ProfilesDialogImpl::accept()
{
  apply();
  QDialog::accept();
}


/* 
 * protected slot
 */
void ProfilesDialogImpl::apply()
{
  lincvsProfile *profile;
  lincvsProfile *dprofile;

  conf->list.clear();
  if (!tmpList.isEmpty())
  {
    conf->list = tmpList;
  }
  
// ----- delete items in stringlists ------------------------------------

  for ( dprofile=delList.first(); dprofile != 0; dprofile=delList.next() )
  {
    deleteEntry(p_profileList,    dprofile->name());
    deleteEntry(p_userList,       dprofile->user());
    deleteEntry(p_serverList,     dprofile->server());
    deleteEntry(p_repositoryList, dprofile->repository());
  }

// ----- insert items in stringlists ------------------------------------

  for ( profile=conf->list.first(); profile != 0; profile=conf->list.next() )
  {
    conf->insertEntry(p_profileList,    profile->name().stripWhiteSpace() );
    conf->insertEntry(p_userList,       profile->user().stripWhiteSpace() );
    conf->insertEntry(p_serverList,     profile->server().stripWhiteSpace() );
    conf->insertEntry(p_repositoryList, profile->repository().stripWhiteSpace() );
  }
}


/* 
 * protected slot
 */
void ProfilesDialogImpl::deleteItem()
{
  if (tmpList.isEmpty()) return;

/*! store deleted items temp. in list */
  delList.append(new lincvsProfile(selName->currentText(),
                                   getMethod(selMethod->currentText()),  
                                   selUser->currentText(),
                                   selServer->currentText(), 
                                   selRepository->currentText()) );

  tmpList.remove(pIndex);
  updateComboList();
}


/* 
 * protected slot
 */
void ProfilesDialogImpl::modList()
{
  lincvsProfile *mdprofile;

  if (tmpList.isEmpty()) return;

/*! get current position */
  uint idx = tmpList.at();
  if (idx >= tmpList.count()) mdprofile = tmpList.at(0);
  else mdprofile = tmpList.at(idx);

/*! old value to delete */
  delList.append(new lincvsProfile(mdprofile->name(),
                                   mdprofile->method(),  
                                   mdprofile->user(),
                                   mdprofile->server(), 
                                   mdprofile->repository()) );
  tmpList.remove (idx);

/*! new value to insert */
  tmpList.insert(idx, new lincvsProfile(selName->currentText(),
                                        getMethod(selMethod->currentText()),  
                                        selUser->currentText(),
                                        selServer->currentText(), 
                                        selRepository->currentText()) );
  updateComboList();
}


/* 
 * protected slot
 */
void ProfilesDialogImpl::actItems(const QString&)
{
	addItem();
}


ProfilesDialogImpl::accessMethod ProfilesDialogImpl::getMethod(const QString& text)
{
  if (text == "password")
    return(Password);
  if (text == "remote shell")
    return(RemoteShell);
  if (text == "local/NFS")
    return(Local_NFS);

    return(Password);
}


void ProfilesDialogImpl::updateComboList()
{
  QString currProfile = selName->currentText();

  lincvsProfile *profile;

  selName->clear();
  selUser->clear();
  selServer->clear();
  selRepository->clear();
  
  if (tmpList.isEmpty()) 
    return;
  

  for ( profile=tmpList.first(); profile != 0; profile=tmpList.next() )
  {
    selName->insertItem(profile->name());
    selUser->insertItem(profile->user());
    selServer->insertItem(profile->server());
    selRepository->insertItem(profile->repository());
  }
  actNameItem(currProfile);
}


void ProfilesDialogImpl::deleteEntry(QStringList* list, const QString item)
{
  bool found;
  found = FALSE;
  
 /*! search the entire list for the item */
  for ( QStringList::Iterator it =  list->begin(); it != list->end(); ++it )
  {
    if (item.compare(*it) == 0) 
    {
      found = TRUE;
      break;
    }
  }
  
  if (found)
  {
    list->remove(item);
  }
}
