/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 5 "./configparser.y"

#include <assert.h>
#include <stdio.h>
#include <string.h>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "configfile.h"
#include "buffer.h"
#include "array.h"

static void configparser_push(config_t *ctx, data_config *dc, int isnew) {
  if (isnew) {
    dc->context_ndx = ctx->all_configs->used;
    assert(dc->context_ndx > ctx->current->context_ndx);
    array_insert_unique(ctx->all_configs, (data_unset *)dc);
    dc->parent = ctx->current;
    array_insert_unique(dc->parent->childs, (data_unset *)dc);
  }
  array_insert_unique(ctx->configs_stack, (data_unset *)ctx->current);
  ctx->current = dc;
}

static data_config *configparser_pop(config_t *ctx) {
  data_config *old = ctx->current;
  ctx->current = (data_config *) array_pop(ctx->configs_stack);
  return old;
}

/* return a copied variable */
static data_unset *configparser_get_variable(config_t *ctx, const buffer *key) {
  if (strncmp(key->ptr, "env.", sizeof("env.") - 1) == 0) {
    char *env;

    if (NULL != (env = getenv(key->ptr + 4))) {
      data_string *ds;
      ds = data_string_init();
      buffer_append_string(ds->value, env);
      return (data_unset *)ds;
    }

    fprintf(stderr, "Undefined env variable: %s\n", key->ptr + 4);
    ctx->ok = 0;

    return NULL;
  } else {
    data_unset *du;
    data_config *dc;

#if 0
    fprintf(stderr, "get var %s\n", key->ptr);
#endif
    for (dc = ctx->current; dc; dc = dc->parent) {
#if 0
      fprintf(stderr, "get var on block: %s\n", dc->key->ptr);
      array_print(dc->value, 0);
#endif
      if (NULL != (du = array_get_element(dc->value, key->ptr))) {
        return du->copy(du);
      }
    }
    fprintf(stderr, "Undefined config variable: %s\n", key->ptr);
    ctx->ok = 0;
    return NULL;
  }
}

/* op1 is to be eat/return by this function, op1->key is not cared
   op2 is left untouch, unreferenced
 */
data_unset *configparser_merge_data(data_unset *op1, const data_unset *op2) {
  /* type mismatch */
  if (op1->type != op2->type) {
    if (op1->type == TYPE_STRING && op2->type == TYPE_INTEGER) {
      data_string *ds = (data_string *)op1;
      buffer_append_long(ds->value, ((data_integer*)op2)->value);
      return op1;
    } else if (op1->type == TYPE_INTEGER && op2->type == TYPE_STRING) {
      data_string *ds = data_string_init();
      buffer_append_long(ds->value, ((data_integer*)op1)->value);
      buffer_append_string_buffer(ds->value, ((data_string*)op2)->value);
      op1->free(op1);
      return (data_unset *)ds;
    } else {
      fprintf(stderr, "data type mismatch, cannot be merge\n");
      op1->free(op1);
      return NULL;
    }
  }

  switch (op1->type) {
    case TYPE_STRING:
      buffer_append_string_buffer(((data_string *)op1)->value, ((data_string *)op2)->value);
      break;
    case TYPE_INTEGER:
      ((data_integer *)op1)->value += ((data_integer *)op2)->value;
      break;
    case TYPE_ARRAY: {
      array *dst = ((data_array *)op1)->value;
      array *src = ((data_array *)op2)->value;
      data_unset *du;
      size_t i;

      for (i = 0; i < src->used; i ++) {
        du = (data_unset *)src->data[i];
        if (du) {
          array_insert_unique(dst, du->copy(du));
        }
      }
      break;
    default:
      assert(0);
      break;
    }
  }
  return op1;
}


#line 128 "configparser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    configparserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is configparserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    configparserARG_SDECL     A static variable declaration for the %extra_argument
**    configparserARG_PDECL     A parameter declaration for the %extra_argument
**    configparserARG_STORE     Code to store %extra_argument into yypParser
**    configparserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 45
#define YYACTIONTYPE unsigned char
#define configparserTOKENTYPE buffer *
typedef union {
  configparserTOKENTYPE yy0;
  buffer * yy1;
  config_cond_t yy29;
  data_unset * yy43;
  data_config * yy74;
  array * yy78;
  int yy89;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define configparserARG_SDECL config_t *ctx;
#define configparserARG_PDECL ,config_t *ctx
#define configparserARG_FETCH config_t *ctx = yypParser->ctx
#define configparserARG_STORE yypParser->ctx = ctx
#define YYNSTATE 56
#define YYNRULE 36
#define YYERRORSYMBOL 25
#define YYERRSYMDT yy89
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */     2,    3,    4,   12,   13,   56,   14,    6,   38,   19,
 /*    10 */    79,   15,   27,   26,   35,    9,   28,   24,   21,   32,
 /*    20 */    40,   14,   93,    1,   19,   27,   26,   31,   52,   54,
 /*    30 */    24,   21,   32,    7,   39,   40,   48,   49,   50,   51,
 /*    40 */    27,   43,   18,   52,   54,   24,   21,   44,   27,   43,
 /*    50 */    84,   27,   43,   24,   21,   53,   24,   21,   55,   19,
 /*    60 */    40,   22,   23,   25,   27,   17,   27,   34,   33,   24,
 /*    70 */    21,   24,   21,    5,   27,   37,   10,   27,   47,   24,
 /*    80 */    21,   20,   24,   21,   80,    8,   24,   21,   16,   36,
 /*    90 */    18,   11,    9,   29,   30,   18,   89,   41,   45,   42,
 /*   100 */    46,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    28,   29,   30,   31,   32,    0,    1,   42,   36,    4,
 /*    10 */    12,   39,   33,   34,   35,   43,   37,   38,   39,   40,
 /*    20 */    15,    1,   26,   27,    4,   33,   34,   35,   23,   24,
 /*    30 */    38,   39,   40,   12,   14,   15,   19,   20,   21,   22,
 /*    40 */    33,   34,    5,   23,   24,   38,   39,   40,   33,   34,
 /*    50 */    13,   33,   34,   38,   39,   40,   38,   39,   40,    4,
 /*    60 */    15,    6,    7,    8,   33,   34,   33,   34,   11,   38,
 /*    70 */    39,   38,   39,    1,   33,   34,   13,   33,   34,   38,
 /*    80 */    39,   33,   38,   39,   12,   36,   38,   39,    2,    3,
 /*    90 */     5,   27,   43,    9,   10,    5,   11,   16,   18,   17,
 /*   100 */    41,
};
#define YY_SHIFT_USE_DFLT (-3)
static signed char yy_shift_ofst[] = {
 /*     0 */    -3,    5,   -3,   -3,   72,   -2,   21,   45,   -3,   63,
 /*    10 */    -3,   20,   -3,   -3,   -3,   86,   55,   90,   55,   -3,
 /*    20 */    -3,   -3,   -3,   -3,   -3,   55,   85,   -3,   84,   -3,
 /*    30 */    55,   -3,   57,   55,   90,   -3,   55,   90,   -3,   -3,
 /*    40 */    81,   82,   55,   90,   80,   17,   55,   37,   -3,   -3,
 /*    50 */    -3,   -3,   55,   -3,   55,   -3,
};
#define YY_REDUCE_USE_DFLT (-36)
static signed char yy_reduce_ofst[] = {
 /*     0 */    -4,  -28,  -36,  -36,  -35,  -36,  -36,   49,  -36,  -36,
 /*    10 */    64,  -28,  -36,  -36,  -36,  -36,   31,  -36,   48,  -36,
 /*    20 */   -36,  -36,  -36,  -36,  -36,  -21,  -36,  -36,  -36,  -36,
 /*    30 */    -8,  -36,  -36,   33,  -36,  -36,   41,  -36,  -36,  -36,
 /*    40 */   -36,  -36,    7,  -36,  -36,   59,   44,  -36,  -36,  -36,
 /*    50 */   -36,  -36,   15,  -36,   18,  -36,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */    58,   92,   57,   59,   92,   60,   92,   92,   81,   92,
 /*    10 */    58,   92,   61,   62,   63,   92,   92,   64,   92,   66,
 /*    20 */    67,   69,   70,   71,   72,   92,   77,   68,   92,   73,
 /*    30 */    75,   74,   92,   92,   78,   76,   92,   65,   82,   83,
 /*    40 */    92,   92,   92,   89,   92,   92,   92,   92,   85,   86,
 /*    50 */    87,   88,   92,   90,   92,   91,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  configparserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void configparserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "EOL",           "ASSIGN",        "APPEND",      
  "LKEY",          "PLUS",          "STRING",        "INTEGER",     
  "LPARAN",        "RPARAN",        "COMMA",         "ARRAY_ASSIGN",
  "ELSE",          "LCURLY",        "RCURLY",        "DOLLAR",      
  "SRVVARNAME",    "LBRACKET",      "RBRACKET",      "EQ",          
  "MATCH",         "NE",            "NOMATCH",       "INCLUDE",     
  "INCLUDE_SHELL",  "error",         "input",         "metalines",   
  "metaline",      "varline",       "condlines",     "include",     
  "include_shell",  "value",         "expression",    "aelement",    
  "condline",      "aelements",     "array",         "key",         
  "stringop",      "cond",          "eols",          "context",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= metalines",
 /*   1 */ "metalines ::= metalines metaline",
 /*   2 */ "metalines ::=",
 /*   3 */ "metaline ::= varline",
 /*   4 */ "metaline ::= condlines EOL",
 /*   5 */ "metaline ::= include",
 /*   6 */ "metaline ::= include_shell",
 /*   7 */ "metaline ::= EOL",
 /*   8 */ "varline ::= key ASSIGN expression",
 /*   9 */ "varline ::= key APPEND expression",
 /*  10 */ "key ::= LKEY",
 /*  11 */ "expression ::= expression PLUS value",
 /*  12 */ "expression ::= value",
 /*  13 */ "value ::= key",
 /*  14 */ "value ::= STRING",
 /*  15 */ "value ::= INTEGER",
 /*  16 */ "value ::= array",
 /*  17 */ "array ::= LPARAN aelements RPARAN",
 /*  18 */ "aelements ::= aelements COMMA aelement",
 /*  19 */ "aelements ::= aelements COMMA",
 /*  20 */ "aelements ::= aelement",
 /*  21 */ "aelement ::= expression",
 /*  22 */ "aelement ::= stringop ARRAY_ASSIGN expression",
 /*  23 */ "eols ::= EOL",
 /*  24 */ "eols ::=",
 /*  25 */ "condlines ::= condlines eols ELSE condline",
 /*  26 */ "condlines ::= condline",
 /*  27 */ "condline ::= context LCURLY metalines RCURLY",
 /*  28 */ "context ::= DOLLAR SRVVARNAME LBRACKET stringop RBRACKET cond expression",
 /*  29 */ "cond ::= EQ",
 /*  30 */ "cond ::= MATCH",
 /*  31 */ "cond ::= NE",
 /*  32 */ "cond ::= NOMATCH",
 /*  33 */ "stringop ::= expression",
 /*  34 */ "include ::= INCLUDE stringop",
 /*  35 */ "include_shell ::= INCLUDE_SHELL stringop",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *configparserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to configparser and configparserFree.
*/
void *configparserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
#line 159 "./configparser.y"
{ buffer_free((yypminor->yy0)); }
#line 523 "configparser.c"
      break;
    case 33:
#line 150 "./configparser.y"
{ (yypminor->yy43)->free((yypminor->yy43)); }
#line 528 "configparser.c"
      break;
    case 34:
#line 151 "./configparser.y"
{ (yypminor->yy43)->free((yypminor->yy43)); }
#line 533 "configparser.c"
      break;
    case 35:
#line 152 "./configparser.y"
{ (yypminor->yy43)->free((yypminor->yy43)); }
#line 538 "configparser.c"
      break;
    case 37:
#line 153 "./configparser.y"
{ array_free((yypminor->yy78)); }
#line 543 "configparser.c"
      break;
    case 38:
#line 154 "./configparser.y"
{ array_free((yypminor->yy78)); }
#line 548 "configparser.c"
      break;
    case 39:
#line 155 "./configparser.y"
{ buffer_free((yypminor->yy1)); }
#line 553 "configparser.c"
      break;
    case 40:
#line 156 "./configparser.y"
{ buffer_free((yypminor->yy1)); }
#line 558 "configparser.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from configparserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void configparserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     configparserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     configparserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 26, 1 },
  { 27, 2 },
  { 27, 0 },
  { 28, 1 },
  { 28, 2 },
  { 28, 1 },
  { 28, 1 },
  { 28, 1 },
  { 29, 3 },
  { 29, 3 },
  { 39, 1 },
  { 34, 3 },
  { 34, 1 },
  { 33, 1 },
  { 33, 1 },
  { 33, 1 },
  { 33, 1 },
  { 38, 3 },
  { 37, 3 },
  { 37, 2 },
  { 37, 1 },
  { 35, 1 },
  { 35, 3 },
  { 42, 1 },
  { 42, 0 },
  { 30, 4 },
  { 30, 1 },
  { 36, 4 },
  { 43, 7 },
  { 41, 1 },
  { 41, 1 },
  { 41, 1 },
  { 41, 1 },
  { 40, 1 },
  { 31, 2 },
  { 32, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  configparserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for metalines */
        break;
      case 1:
        /* No destructor defined for metalines */
        /* No destructor defined for metaline */
        break;
      case 2:
        break;
      case 3:
        /* No destructor defined for varline */
        break;
      case 4:
#line 133 "./configparser.y"
{ yymsp[-1].minor.yy74 = NULL; }
#line 821 "configparser.c"
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 5:
        /* No destructor defined for include */
        break;
      case 6:
        /* No destructor defined for include_shell */
        break;
      case 7:
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 8:
#line 161 "./configparser.y"
{
  buffer_copy_string_buffer(yymsp[0].minor.yy43->key, yymsp[-2].minor.yy1);
  if (NULL == array_get_element(ctx->current->value, yymsp[0].minor.yy43->key->ptr)) {
    array_insert_unique(ctx->current->value, yymsp[0].minor.yy43);
    yymsp[0].minor.yy43 = NULL;
  } else {
    fprintf(stderr, "Duplicate config variable in conditional %d %s: %s\n", 
            ctx->current->context_ndx,
            ctx->current->key->ptr, yymsp[0].minor.yy43->key->ptr);
    ctx->ok = 0;
    yymsp[0].minor.yy43->free(yymsp[0].minor.yy43);
    yymsp[0].minor.yy43 = NULL;
  }
  buffer_free(yymsp[-2].minor.yy1);
  yymsp[-2].minor.yy1 = NULL;
}
#line 851 "configparser.c"
  yy_destructor(2,&yymsp[-1].minor);
        break;
      case 9:
#line 178 "./configparser.y"
{
  array *vars = ctx->current->value;
  data_unset *du;

  if (NULL != (du = array_get_element(vars, yymsp[-2].minor.yy1->ptr))) {
    /* exists in current block */
    du = configparser_merge_data(du, yymsp[0].minor.yy43);
    if (NULL == du) {
      ctx->ok = 0;
    }
    else {
      buffer_copy_string_buffer(du->key, yymsp[-2].minor.yy1);
      array_replace(vars, du);
    }
  } else if (NULL != (du = configparser_get_variable(ctx, yymsp[-2].minor.yy1))) {
    du = configparser_merge_data(du, yymsp[0].minor.yy43);
    if (NULL == du) {
      ctx->ok = 0;
    }
    else {
      buffer_copy_string_buffer(du->key, yymsp[-2].minor.yy1);
      array_insert_unique(ctx->current->value, du);
    }
  } else {
    fprintf(stderr, "Undefined config variable in conditional %d %s: %s\n", 
            ctx->current->context_ndx,
            ctx->current->key->ptr, yymsp[-2].minor.yy1->ptr);
    ctx->ok = 0;
  }
  buffer_free(yymsp[-2].minor.yy1);
  yymsp[-2].minor.yy1 = NULL;
  yymsp[0].minor.yy43->free(yymsp[0].minor.yy43);
  yymsp[0].minor.yy43 = NULL;
}
#line 890 "configparser.c"
  yy_destructor(3,&yymsp[-1].minor);
        break;
      case 10:
#line 213 "./configparser.y"
{
  if (strchr(yymsp[0].minor.yy0->ptr, '.') == NULL) {
    yygotominor.yy1 = buffer_init_string("var.");
    buffer_append_string_buffer(yygotominor.yy1, yymsp[0].minor.yy0);
    buffer_free(yymsp[0].minor.yy0);
    yymsp[0].minor.yy0 = NULL;
  } else {
    yygotominor.yy1 = yymsp[0].minor.yy0;
    yymsp[0].minor.yy0 = NULL;
  }
}
#line 906 "configparser.c"
        break;
      case 11:
#line 225 "./configparser.y"
{
  yygotominor.yy43 = configparser_merge_data(yymsp[-2].minor.yy43, yymsp[0].minor.yy43);
  if (NULL == yygotominor.yy43) {
    ctx->ok = 0;
  }
  yymsp[-2].minor.yy43 = NULL;
  yymsp[0].minor.yy43->free(yymsp[0].minor.yy43);
  yymsp[0].minor.yy43 = NULL;
}
#line 919 "configparser.c"
  yy_destructor(5,&yymsp[-1].minor);
        break;
      case 12:
#line 235 "./configparser.y"
{
  yygotominor.yy43 = yymsp[0].minor.yy43;
  yymsp[0].minor.yy43 = NULL;
}
#line 928 "configparser.c"
        break;
      case 13:
#line 240 "./configparser.y"
{
  yygotominor.yy43 = configparser_get_variable(ctx, yymsp[0].minor.yy1);
  if (!yygotominor.yy43) {
    /* make a dummy so it won't crash */
    yygotominor.yy43 = (data_unset *)data_string_init();
  }
  buffer_free(yymsp[0].minor.yy1);
  yymsp[0].minor.yy1 = NULL;
}
#line 941 "configparser.c"
        break;
      case 14:
#line 250 "./configparser.y"
{
  yygotominor.yy43 = (data_unset *)data_string_init();
  buffer_copy_string_buffer(((data_string *)(yygotominor.yy43))->value, yymsp[0].minor.yy0);
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 951 "configparser.c"
        break;
      case 15:
#line 257 "./configparser.y"
{
  yygotominor.yy43 = (data_unset *)data_integer_init();
  ((data_integer *)(yygotominor.yy43))->value = strtol(yymsp[0].minor.yy0->ptr, NULL, 10);
  buffer_free(yymsp[0].minor.yy0);
  yymsp[0].minor.yy0 = NULL;
}
#line 961 "configparser.c"
        break;
      case 16:
#line 263 "./configparser.y"
{
  yygotominor.yy43 = (data_unset *)data_array_init();
  array_free(((data_array *)(yygotominor.yy43))->value);
  ((data_array *)(yygotominor.yy43))->value = yymsp[0].minor.yy78;
  yymsp[0].minor.yy78 = NULL;
}
#line 971 "configparser.c"
        break;
      case 17:
#line 269 "./configparser.y"
{
  yygotominor.yy78 = yymsp[-1].minor.yy78;
  yymsp[-1].minor.yy78 = NULL;
}
#line 979 "configparser.c"
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(9,&yymsp[0].minor);
        break;
      case 18:
#line 274 "./configparser.y"
{
  if (buffer_is_empty(yymsp[0].minor.yy43->key) ||
      NULL == array_get_element(yymsp[-2].minor.yy78, yymsp[0].minor.yy43->key->ptr)) {
    array_insert_unique(yymsp[-2].minor.yy78, yymsp[0].minor.yy43);
    yymsp[0].minor.yy43 = NULL;
  } else {
    fprintf(stderr, "Duplicate array-key: %s\n", 
            yymsp[0].minor.yy43->key->ptr);
    ctx->ok = 0;
    yymsp[0].minor.yy43->free(yymsp[0].minor.yy43);
    yymsp[0].minor.yy43 = NULL;
  }
  
  yygotominor.yy78 = yymsp[-2].minor.yy78;
  yymsp[-2].minor.yy78 = NULL;
}
#line 1001 "configparser.c"
  yy_destructor(10,&yymsp[-1].minor);
        break;
      case 19:
#line 291 "./configparser.y"
{
  yygotominor.yy78 = yymsp[-1].minor.yy78;
  yymsp[-1].minor.yy78 = NULL;
}
#line 1010 "configparser.c"
  yy_destructor(10,&yymsp[0].minor);
        break;
      case 20:
#line 296 "./configparser.y"
{
  yygotominor.yy78 = array_init();
  array_insert_unique(yygotominor.yy78, yymsp[0].minor.yy43);
  yymsp[0].minor.yy43 = NULL;
}
#line 1020 "configparser.c"
        break;
      case 21:
#line 302 "./configparser.y"
{
  yygotominor.yy43 = yymsp[0].minor.yy43;
  yymsp[0].minor.yy43 = NULL;
}
#line 1028 "configparser.c"
        break;
      case 22:
#line 306 "./configparser.y"
{
  buffer_copy_string_buffer(yymsp[0].minor.yy43->key, yymsp[-2].minor.yy1);
  buffer_free(yymsp[-2].minor.yy1);
  yymsp[-2].minor.yy1 = NULL;
  
  yygotominor.yy43 = yymsp[0].minor.yy43;
  yymsp[0].minor.yy43 = NULL;
}
#line 1040 "configparser.c"
  yy_destructor(11,&yymsp[-1].minor);
        break;
      case 23:
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 24:
        break;
      case 25:
#line 318 "./configparser.y"
{
  assert(yymsp[-3].minor.yy74->context_ndx < yymsp[0].minor.yy74->context_ndx);
  yymsp[0].minor.yy74->prev = yymsp[-3].minor.yy74;
  yymsp[-3].minor.yy74->next = yymsp[0].minor.yy74;
  yygotominor.yy74 = yymsp[0].minor.yy74;
  yymsp[-3].minor.yy74 = NULL;
  yymsp[0].minor.yy74 = NULL;
}
#line 1058 "configparser.c"
        /* No destructor defined for eols */
  yy_destructor(12,&yymsp[-1].minor);
        break;
      case 26:
#line 327 "./configparser.y"
{
  yygotominor.yy74 = yymsp[0].minor.yy74;
  yymsp[0].minor.yy74 = NULL;
}
#line 1068 "configparser.c"
        break;
      case 27:
#line 332 "./configparser.y"
{
  data_config *cur;
  
  cur = ctx->current;
  configparser_pop(ctx);

  assert(cur && ctx->current);

  yygotominor.yy74 = cur;
}
#line 1082 "configparser.c"
        /* No destructor defined for context */
  yy_destructor(13,&yymsp[-2].minor);
        /* No destructor defined for metalines */
  yy_destructor(14,&yymsp[0].minor);
        break;
      case 28:
#line 343 "./configparser.y"
{
  data_config *dc;
  buffer *b, *rvalue, *op;

  if (ctx->ok && yymsp[0].minor.yy43->type != TYPE_STRING) {
    fprintf(stderr, "rvalue must be string");
    ctx->ok = 0;
  }

  switch(yymsp[-1].minor.yy29) {
  case CONFIG_COND_NE:
    op = buffer_init_string("!=");
    break;
  case CONFIG_COND_EQ:
    op = buffer_init_string("==");
    break;
  case CONFIG_COND_NOMATCH:
    op = buffer_init_string("!~");
    break;
  case CONFIG_COND_MATCH:
    op = buffer_init_string("=~");
    break;
  default:
    assert(0);
    return;
  }

  b = buffer_init();
  buffer_copy_string_buffer(b, ctx->current->key);
  buffer_append_string(b, "/");
  buffer_append_string_buffer(b, yymsp[-5].minor.yy0);
  buffer_append_string_buffer(b, yymsp[-3].minor.yy1);
  buffer_append_string_buffer(b, op);
  rvalue = ((data_string*)yymsp[0].minor.yy43)->value;
  buffer_append_string_buffer(b, rvalue);
  
  if (NULL != (dc = (data_config *)array_get_element(ctx->all_configs, b->ptr))) {
    configparser_push(ctx, dc, 0);
  } else {
    struct {
      comp_key_t comp;
      char *comp_key;
      size_t len;
    } comps[] = {
      { COMP_SERVER_SOCKET,      CONST_STR_LEN("SERVER[\"socket\"]"   ) },
      { COMP_HTTP_URL,           CONST_STR_LEN("HTTP[\"url\"]"        ) },
      { COMP_HTTP_HOST,          CONST_STR_LEN("HTTP[\"host\"]"       ) },
      { COMP_HTTP_REFERER,       CONST_STR_LEN("HTTP[\"referer\"]"    ) },
      { COMP_HTTP_USERAGENT,     CONST_STR_LEN("HTTP[\"useragent\"]"  ) },
      { COMP_HTTP_COOKIE,        CONST_STR_LEN("HTTP[\"cookie\"]"     ) },
      { COMP_HTTP_REMOTEIP,      CONST_STR_LEN("HTTP[\"remoteip\"]"   ) },
      { COMP_UNSET, NULL, 0 },
    };
    size_t i;

    dc = data_config_init();
    
    buffer_copy_string_buffer(dc->key, b);
    buffer_copy_string_buffer(dc->op, op);
    buffer_copy_string_buffer(dc->comp_key, yymsp[-5].minor.yy0);
    buffer_append_string_len(dc->comp_key, CONST_STR_LEN("[\""));
    buffer_append_string_buffer(dc->comp_key, yymsp[-3].minor.yy1);
    buffer_append_string_len(dc->comp_key, CONST_STR_LEN("\"]"));
    dc->cond = yymsp[-1].minor.yy29;
    
    for (i = 0; comps[i].comp_key; i ++) {
      if (buffer_is_equal_string(
            dc->comp_key, comps[i].comp_key, comps[i].len)) {
        dc->comp = comps[i].comp;
        break;
      }
    }
    if (COMP_UNSET == dc->comp) {
      fprintf(stderr, "error comp_key %s", dc->comp_key->ptr);
      ctx->ok = 0;
    }

    switch(yymsp[-1].minor.yy29) {
    case CONFIG_COND_NE:
    case CONFIG_COND_EQ:
      dc->string = buffer_init_buffer(rvalue);
      break;
    case CONFIG_COND_NOMATCH:
    case CONFIG_COND_MATCH: {
#ifdef HAVE_PCRE_H
      const char *errptr;
      int erroff;
      
      if (NULL == (dc->regex = 
          pcre_compile(rvalue->ptr, 0, &errptr, &erroff, NULL))) {
        dc->string = buffer_init_string(errptr);
        dc->cond = CONFIG_COND_UNSET;

        fprintf(stderr, "parsing regex failed: %s -> %s at offset %d\n", 
            rvalue->ptr, errptr, erroff);

        ctx->ok = 0;
      } else if (NULL == (dc->regex_study =
          pcre_study(dc->regex, 0, &errptr)) &&  
                 errptr != NULL) {
        fprintf(stderr, "studying regex failed: %s -> %s\n", 
            rvalue->ptr, errptr);
        ctx->ok = 0;
      } else {
        dc->string = buffer_init_buffer(rvalue);
      }
#else
      fprintf(stderr, "regex conditionals are not allowed as pcre-support" \
                      "is missing: $%s[%s]\n", 
                      yymsp[-5].minor.yy0->ptr, yymsp[-3].minor.yy1->ptr);
      ctx->ok = 0;
#endif
      break;
    }

    default:
      fprintf(stderr, "unknown condition for $%s[%s]\n", 
                      yymsp[-5].minor.yy0->ptr, yymsp[-3].minor.yy1->ptr);
      ctx->ok = 0;
      break;
    }
    
    configparser_push(ctx, dc, 1);
  }

  buffer_free(b);
  buffer_free(op);
  buffer_free(yymsp[-5].minor.yy0);
  yymsp[-5].minor.yy0 = NULL;
  buffer_free(yymsp[-3].minor.yy1);
  yymsp[-3].minor.yy1 = NULL;
  yymsp[0].minor.yy43->free(yymsp[0].minor.yy43);
  yymsp[0].minor.yy43 = NULL;
}
#line 1224 "configparser.c"
  yy_destructor(15,&yymsp[-6].minor);
  yy_destructor(17,&yymsp[-4].minor);
  yy_destructor(18,&yymsp[-2].minor);
        break;
      case 29:
#line 477 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_EQ;
}
#line 1234 "configparser.c"
  yy_destructor(19,&yymsp[0].minor);
        break;
      case 30:
#line 480 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_MATCH;
}
#line 1242 "configparser.c"
  yy_destructor(20,&yymsp[0].minor);
        break;
      case 31:
#line 483 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_NE;
}
#line 1250 "configparser.c"
  yy_destructor(21,&yymsp[0].minor);
        break;
      case 32:
#line 486 "./configparser.y"
{
  yygotominor.yy29 = CONFIG_COND_NOMATCH;
}
#line 1258 "configparser.c"
  yy_destructor(22,&yymsp[0].minor);
        break;
      case 33:
#line 490 "./configparser.y"
{
  yygotominor.yy1 = NULL;
  if (ctx->ok) {
    if (yymsp[0].minor.yy43->type == TYPE_STRING) {
      yygotominor.yy1 = buffer_init_buffer(((data_string*)yymsp[0].minor.yy43)->value);
    } else if (yymsp[0].minor.yy43->type == TYPE_INTEGER) {
      yygotominor.yy1 = buffer_init();
      buffer_copy_long(yygotominor.yy1, ((data_integer *)yymsp[0].minor.yy43)->value);
    } else {
      fprintf(stderr, "operand must be string");
      ctx->ok = 0;
    }
  }
  yymsp[0].minor.yy43->free(yymsp[0].minor.yy43);
  yymsp[0].minor.yy43 = NULL;
}
#line 1279 "configparser.c"
        break;
      case 34:
#line 507 "./configparser.y"
{
  if (ctx->ok) {
    if (0 != config_parse_file(ctx->srv, ctx, yymsp[0].minor.yy1->ptr)) {
      ctx->ok = 0;
    }
    buffer_free(yymsp[0].minor.yy1);
    yymsp[0].minor.yy1 = NULL;
  }
}
#line 1292 "configparser.c"
  yy_destructor(23,&yymsp[-1].minor);
        break;
      case 35:
#line 517 "./configparser.y"
{
  if (ctx->ok) {
    if (0 != config_parse_cmd(ctx->srv, ctx, yymsp[0].minor.yy1->ptr)) {
      ctx->ok = 0;
    }
    buffer_free(yymsp[0].minor.yy1);
    yymsp[0].minor.yy1 = NULL;
  }
}
#line 1306 "configparser.c"
  yy_destructor(24,&yymsp[-1].minor);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  configparserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 125 "./configparser.y"

  ctx->ok = 0;

#line 1340 "configparser.c"
  configparserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  configparserARG_FETCH;
#define TOKEN (yyminor.yy0)
  configparserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  configparserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  configparserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "configparserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void configparser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  configparserTOKENTYPE yyminor       /* The value for the token */
  configparserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  configparserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
