// Surface.hh, Video class for SDL
// Copyright (c) 2003 Jesper Strandberg (skywarper@hotbrev.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef SURFACE_HH
#define SURFACE_HH

#include <string>
#include <SDL.h>

class Surface {
    SDL_Surface *mSurface;

    public:
        Surface() { mSurface = 0; }
        Surface(int width, int height, Uint32 flags);
        Surface(int width, int height, int bpp, Uint32 flags);
        explicit Surface(const std::string &filename);
        explicit Surface(SDL_Surface *surface) { mSurface = surface; }
        ~Surface();

        SDL_Surface *getSDLSurface() const { return mSurface; }

        void load(const std::string &filename);

        void blit(SDL_Rect *srcRect, SDL_Rect *dstRect, Surface *dstSurface);
        void blit(int x, int y, Surface *dstSurface);
        void blit(int x = 0, int y = 0);

        void setDisplayFormat();
        void setDisplayFormatAlpha();

        void setAlpha(Uint8 alpha, Uint32 flags = SDL_SRCALPHA);
        void setColorKey(Uint32 key, Uint32 flagskey = SDL_SRCCOLORKEY);

        void fill(Uint32 color, SDL_Rect *rect = 0);

        int getWidth() { return mSurface->w; }
        int getHeight() { return mSurface->h; }

        SDL_PixelFormat *getFormat() { return mSurface->format; }
};

#endif // SURFACE_HH

