// Error.hh, Game of Life
// Copyright (c) 2003 Jesper Strandberg (skywarper@hotbrev.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef ERROR_HH
#define ERROR_HH

#include <string>
#include <exception>

class Error : public std::exception {
    std::string e_msg;

    public:
        Error(const std::string &msg) throw () { e_msg = msg; }
        ~Error() throw () {}

        const char *what() const throw () { return e_msg.c_str(); }
};

#endif // ERROR_HH

