#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include "showawaymsgdlg.h"


ShowAwayMsgDlg::ShowAwayMsgDlg(ICQUser *_u, QWidget *parent = 0, const char *name = 0) 
  : QWidget(parent, name)
{
  u = _u;
  mleAwayMsg = new MLEditWrap(true, this);
  mleAwayMsg->setReadOnly(true);
  btnOk = new QPushButton("Ok", this);
  connect(btnOk, SIGNAL(clicked()), SLOT(ok()));
  chkShowAgain = new QCheckBox("Show Again", this);
  chkShowAgain->setChecked(u->ShowAwayMsg());
  
  char title[128];
  sprintf(title, "%s Message for %s", u->getStatusStr(), u->getAlias());
  setCaption(title);
  mleAwayMsg->setText(u->getAwayMessage());
  resize(300, 160);
  show();
}


void ShowAwayMsgDlg::resizeEvent (QResizeEvent *)
{
  mleAwayMsg->setGeometry(5, 5, width() - 10, height() - 80);
  chkShowAgain->setGeometry(10, height() - 70, width() - 10, 20);
  btnOk->setGeometry((width() >> 1) - 50, height() - 40, 100, 30 );
}

void ShowAwayMsgDlg::hide()
{
  QWidget::hide();
  delete this;
}


void ShowAwayMsgDlg::ok()
{
  u->setShowAwayMsg(chkShowAgain->isChecked());
  hide();
}
